/*
 * Decompiled with CFR 0.152.
 */
package rreil.tester.gdb;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayDeque;
import java.util.Queue;
import rreil.tester.gdb.GdbPacket;
import rreil.tester.gdb.Tuple;

public class GdbConnection
implements Runnable {
    private final InetAddress gdbAddress;
    private final int port;
    private Socket socket;
    private Thread worker;
    private final Queue<GdbPacket> messageQueue = new ArrayDeque<GdbPacket>();

    public GdbConnection(InetAddress gdbAddress, int port) {
        this.gdbAddress = gdbAddress;
        this.port = port;
    }

    public void connect() throws IOException {
        this.socket = new Socket(this.gdbAddress, this.port);
        this.worker = new Thread(this);
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            InputStreamReader iSR = new InputStreamReader(this.socket.getInputStream());
            BufferedReader bR = new BufferedReader(iSR);
            StringBuilder text = new StringBuilder();
            block5: while (true) {
                text.append((char)bR.read());
                while (true) {
                    Tuple<Boolean, Tuple<Integer, Integer>> match = GdbPacket.match(text);
                    if (!((Boolean)match.x).booleanValue()) continue block5;
                    System.out.println("<== " + text);
                    GdbPacket packet = new GdbPacket(text.substring((Integer)((Tuple)match.y).x + 1, (Integer)((Tuple)match.y).y), text.substring((Integer)((Tuple)match.y).y + 1, (Integer)((Tuple)match.y).y + 3));
                    Queue<GdbPacket> queue = this.messageQueue;
                    synchronized (queue) {
                        this.messageQueue.add(packet);
                        this.messageQueue.notify();
                    }
                    text.delete(0, (Integer)((Tuple)match.y).y + 3);
                }
                break;
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GdbPacket getNextPacket() throws InterruptedException {
        GdbPacket result;
        Queue<GdbPacket> queue = this.messageQueue;
        synchronized (queue) {
            while (this.messageQueue.isEmpty()) {
                this.messageQueue.wait();
            }
            result = this.messageQueue.poll();
        }
        return result;
    }

    public boolean acknowledgePacket(GdbPacket packet) throws IOException {
        boolean valid = packet.checksumValid();
        if (valid) {
            this.send("+");
        } else {
            this.send("-");
        }
        return valid;
    }

    private void send(String data) throws IOException {
        System.out.println("==> " + data);
        OutputStreamWriter oSW = new OutputStreamWriter(this.socket.getOutputStream());
        BufferedWriter bW = new BufferedWriter(oSW);
        bW.write(data);
        bW.flush();
    }

    public void send(GdbPacket packet) throws IOException {
        this.send(packet.toString());
    }
}

