/*
 * Decompiled with CFR 0.152.
 */
package rreil.tester;

import bindead.environment.platform.RReilPlatform;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteOrder;
import rreil.disassembler.translators.avr8.implementations.AvrImplementation;
import rreil.interpreter.InterpCtx;
import rreil.interpreter.MachineCtx;
import rreil.interpreter.MemoryModel;
import rreil.interpreter.RReilMachine;
import rreil.interpreter.avr.chipstate.AvrChipState;
import rreil.tester.gdb.GdbCommunicator;
import rreil.tester.gdb.responses.GdbMemoryResponse;
import rreil.tester.gdb.responses.IGdbResponse;

public class AvrGdbRReilSimGdbTester {
    private final GdbCommunicator communicator;
    private final int startAddress;
    private final int memRangelength;
    private final RReilPlatform avr8;
    private final RReilMachine machine;
    private MachineCtx machCtx;

    public AvrGdbRReilSimGdbTester(GdbCommunicator communicator, RReilPlatform avr8, int startAddress, int memRangelength) throws IOException, InterruptedException {
        this.communicator = communicator;
        this.startAddress = startAddress;
        this.memRangelength = memRangelength;
        this.avr8 = avr8;
        this.machine = new RReilMachine(avr8.getDisassembler());
        this.init();
    }

    private byte[] combineBytes(IGdbResponse[] responses, int size) {
        byte[] bytes = new byte[size];
        int offset = 0;
        for (int i = 0; i < responses.length; ++i) {
            for (int j = 0; j < ((GdbMemoryResponse)responses[i]).getBytes().length; ++j) {
                bytes[offset + j] = ((GdbMemoryResponse)responses[i]).getBytes()[j];
            }
            offset += ((GdbMemoryResponse)responses[i]).getBytes().length;
        }
        return bytes;
    }

    private void initGdb() throws IOException, InterruptedException {
        if (this.startAddress != 0) {
            this.communicator.insertBreakpoint(this.startAddress);
            this.communicator.continueGdb();
        }
    }

    private void initSimulator() throws IOException, InterruptedException {
        IGdbResponse[] responses = this.communicator.readMemory(GdbCommunicator.MemorySpace.Program, 0, this.memRangelength);
        byte[] bytes = this.combineBytes(responses, this.memRangelength);
        System.out.println("Program:");
        StringWriter sW = new StringWriter();
        PrintWriter pW = new PrintWriter(sW);
        pW.printf("{", new Object[0]);
        for (int i = 0; i < bytes.length; ++i) {
            pW.printf(" (byte)0x%02x", bytes[i]);
            if (i + 1 >= bytes.length) continue;
            pW.printf(",", new Object[0]);
        }
        pW.printf(" }", new Object[0]);
        System.out.println(sW.toString());
        InterpCtx ctx = new InterpCtx(this.avr8.defaultArchitectureSize(), null, new MemoryModel(ByteOrder.BIG_ENDIAN));
        this.machCtx = new MachineCtx(ctx, bytes, this.startAddress, this.startAddress);
        this.machine.initPc(this.machCtx);
        int memSize = AvrImplementation.$ATMEGA32L.getDataSpaceSize();
        IGdbResponse[] memoryResponses = this.communicator.readMemory(GdbCommunicator.MemorySpace.Data, 0, memSize);
        byte[] memBytes = this.combineBytes(memoryResponses, memSize);
        AvrChipState state = AvrChipState.fromGdbMemoryDump(memBytes, 0, memBytes.length);
        state.toAvrInterpCtx(ctx);
    }

    public void init() throws IOException, InterruptedException {
        this.initGdb();
        this.initSimulator();
    }

    public void step() throws IOException, InterruptedException {
        this.machine.step(this.machCtx);
        this.communicator.step();
    }

    public String diff() throws IOException, InterruptedException {
        int memSize = AvrImplementation.$ATMEGA32L.getDataSpaceSize();
        IGdbResponse[] memoryResponses = this.communicator.readMemory(GdbCommunicator.MemorySpace.Data, 0, memSize);
        byte[] memBytes = this.combineBytes(memoryResponses, memSize);
        AvrChipState gdbState = AvrChipState.fromGdbMemoryDump(memBytes, 0, memBytes.length);
        AvrChipState simState = AvrChipState.fromAvrInterpCtx(this.machCtx.getCtx());
        return gdbState.diff(simState);
    }

    public AvrChipState simulatorState() {
        AvrChipState simState = AvrChipState.fromAvrInterpCtx(this.machCtx.getCtx());
        return simState;
    }
}

