/*
 * Decompiled with CFR 0.152.
 */
package rreil.lang.lowlevel;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;

public class TranslationHelpers {
    static final LowLevelRReilFactory rreil = LowLevelRReilFactory.getInstance();
    public static final Map<String, OperandSize> architectures = new HashMap<String, OperandSize>();

    public static OperandSize getNextSize(OperandSize size) {
        switch (size) {
            case BYTE: {
                return OperandSize.WORD;
            }
            case WORD: {
                return OperandSize.DWORD;
            }
            case DWORD: {
                return OperandSize.QWORD;
            }
            case QWORD: {
                return OperandSize.OWORD;
            }
        }
        throw new IllegalArgumentException("Error: Invalid argument size");
    }

    public static int getNextSize(int size) {
        switch (size) {
            case 8: {
                return 16;
            }
            case 16: {
                return 32;
            }
            case 32: {
                return 64;
            }
            case 64: {
                return 128;
            }
        }
        throw new IllegalArgumentException("Error: Invalid argument size");
    }

    public static long getTruncateMask(OperandSize size) {
        switch (size) {
            case BYTE: {
                return 255L;
            }
            case WORD: {
                return 65535L;
            }
            case DWORD: {
                return 0xFFFFFFFFL;
            }
            case QWORD: {
                return -1L;
            }
        }
        throw new IllegalArgumentException("Error: Invalid argument size");
    }

    public static LowLevelRReilOpnd getMaxImmediate(int size) {
        return rreil.immediate(size, (Number)BigInteger.valueOf(2L).pow(size).subtract(BigInteger.ONE));
    }

    public static LowLevelRReilOpnd getMaxImmediateSigned(int size) {
        return rreil.immediate(size, (Number)BigInteger.valueOf(2L).pow(size - 1).subtract(BigInteger.ONE));
    }

    public static LowLevelRReilOpnd getMinImmediateSigned(int size) {
        return rreil.immediate(size, (Number)BigInteger.valueOf(2L).pow(size - 1).multiply(BigInteger.ZERO.subtract(BigInteger.ONE)));
    }

    public static OperandSize fromBitsOverapproximate(int bits) {
        if (bits == 1) {
            return TranslationHelpers.fromBits(1);
        }
        if (bits <= 8) {
            return TranslationHelpers.fromBits(8);
        }
        if (bits <= 16) {
            return TranslationHelpers.fromBits(16);
        }
        if (bits <= 32) {
            return TranslationHelpers.fromBits(32);
        }
        if (bits <= 64) {
            return TranslationHelpers.fromBits(64);
        }
        if (bits <= 128) {
            return TranslationHelpers.fromBits(128);
        }
        throw new IllegalStateException("Error: Invalid bitcount: '" + String.valueOf(bits) + "'");
    }

    public static OperandSize fromBits(int bits) {
        switch (bits) {
            case 1: {
                return OperandSize.BIT;
            }
            case 8: {
                return OperandSize.BYTE;
            }
            case 16: {
                return OperandSize.WORD;
            }
            case 32: {
                return OperandSize.DWORD;
            }
            case 64: {
                return OperandSize.QWORD;
            }
            case 128: {
                return OperandSize.OWORD;
            }
        }
        throw new IllegalStateException("Error: Invalid bitcount: '" + String.valueOf(bits) + "'");
    }

    static {
        architectures.put("X86-32", OperandSize.DWORD);
        architectures.put("X86-64", OperandSize.QWORD);
        architectures.put("ARM-32", OperandSize.DWORD);
        architectures.put("POWERPC-32", OperandSize.DWORD);
        architectures.put("REIL", OperandSize.DWORD);
        architectures.put("MIPS-32", OperandSize.DWORD);
        architectures.put("AVR", OperandSize.BYTE);
        architectures.put("AVR32", OperandSize.DWORD);
    }
}

