/*
 * Decompiled with CFR 0.152.
 */
package rreil.lang.lowlevel;

import javalx.numeric.Interval;
import rreil.disassembler.OperandPostorderIterator;
import rreil.disassembler.OperandTree;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;
import rreil.lang.lowlevel.OperandSize;
import rreil.lang.util.LowLevelToRReilTranslator;

public class LowLevelRReilOpnd
extends OperandTree {
    public static final String $OffsetOperatorSymbol = "/";
    public static final String $SubaddressOperatorSymbol = ".";

    public LowLevelRReilOpnd(OperandTree.Node root) {
        super(root);
    }

    public int size() {
        OperandTree.Node sizePrefix = this.getRoot();
        assert (sizePrefix.getType() == OperandTree.Type.Size);
        return ((Number)sizePrefix.getData()).intValue();
    }

    public LowLevelRReilOpnd withSize(int size) {
        if (this.size() == size) {
            return this;
        }
        OperandTree.NodeBuilder fresh = new OperandTree.NodeBuilder().type(OperandTree.Type.Size).data(size);
        for (OperandTree.Node n : this.getRoot().getChildren()) {
            fresh.link(n);
        }
        return new LowLevelRReilOpnd(fresh.build());
    }

    public LowLevelRReilOpnd withSize(OperandSize size) {
        return this.withSize(size.getBits());
    }

    public LowLevelRReilOpnd withOffset(int offset, int size) {
        if (offset == 0) {
            return this.withSize(size);
        }
        OperandTree.Node sym = this.getSymbolOrNull();
        int oldOffset = this.getOffsetOrZero();
        if (sym == null) {
            throw new UnsupportedOperationException("withOffset not applicable");
        }
        OperandTree.NodeBuilder offsetOp = new OperandTree.NodeBuilder().type(OperandTree.Type.Op).data($OffsetOperatorSymbol);
        OperandTree.Node offsetImm = new OperandTree.NodeBuilder().type(OperandTree.Type.Immi).data(oldOffset + offset).build();
        offsetOp.link(sym);
        offsetOp.link(offsetImm);
        OperandTree.Node fresh = new OperandTree.NodeBuilder().type(OperandTree.Type.Size).data(size).link(offsetOp.build()).build();
        return new LowLevelRReilOpnd(fresh);
    }

    public LowLevelRReilOpnd withOffset(int offset, OperandSize size) {
        return this.withOffset(offset, size.getBits());
    }

    public OperandTree.Node child() {
        return this.getRoot().getChildren().get(0);
    }

    private OperandTree.Node getSymbolOrNull() {
        OperandTree.Node child = this.child();
        if (child.getType() == OperandTree.Type.Sym) {
            return child;
        }
        if (child.getType() == OperandTree.Type.Op && $OffsetOperatorSymbol.equals(child.getData())) {
            OperandTree.Node sym = child.getChildren().get(0);
            assert (sym.getType() == OperandTree.Type.Sym);
            return sym;
        }
        return null;
    }

    public int getOffsetOrZero() {
        OperandTree.Node child = this.child();
        if (child.getType() == OperandTree.Type.Op && $OffsetOperatorSymbol.equals(child.getData())) {
            return ((Number)child.getChildren().get(1).getData()).intValue();
        }
        return 0;
    }

    public RReilAddr getRReilAddrOrNull() {
        OperandTree.Node child = this.child();
        if (child.getType() == OperandTree.Type.Op && $SubaddressOperatorSymbol.equals(child.getData())) {
            Number base = (Number)child.getChildren().get(0).getData();
            Number offset = (Number)child.getChildren().get(1).getData();
            return new RReilAddr(base.longValue(), offset.intValue());
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        OperandPostorderIterator it = new OperandPostorderIterator(this.getRoot());
        while (it.next()) {
            OperandTree.Node node = it.current();
            switch (node.getType()) {
                case Immf: 
                case Immi: {
                    builder.append(((Number)node.getData()).toString());
                    break;
                }
                case Immr: {
                    builder.append(((Interval)node.getData()).toString());
                    break;
                }
                case Sym: {
                    builder.append((String)node.getData());
                    break;
                }
                case Size: {
                    builder.append(':').append(node.getData());
                    break;
                }
                case Op: {
                    builder.append((String)node.getData());
                    break;
                }
                case Mem: {
                    builder.append('*').append(((Number)node.getData()).toString());
                }
            }
        }
        return builder.toString();
    }

    public Rhs.Rval toRReil() {
        return LowLevelToRReilTranslator.translateRval(this);
    }
}

