/*
 * Decompiled with CFR 0.152.
 */
package rreil.lang.lowlevel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.OperandTree;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.util.LowLevelToRReilTranslator;

public class LowLevelRReil
extends Instruction {
    public static final byte[] oneSizeOpcode = new byte[]{-1};

    public LowLevelRReil(RReilAddr address, String mnemonic, LowLevelRReilOpnd ... ops) {
        super(address, oneSizeOpcode, mnemonic, ops);
    }

    public RReil toRReil() {
        return LowLevelToRReilTranslator.translate(this);
    }

    public LowLevelRReilOpnd rreilOperand(int i) {
        return (LowLevelRReilOpnd)this.operand(i);
    }

    @Override
    public List<LowLevelRReil> toRReilInstructions() {
        return new ArrayList<LowLevelRReil>();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.mnemonic().equals("if")) {
            LowLevelRReilOpnd cond = this.rreilOperand(0);
            LowLevelRReilOpnd target = this.rreilOperand(1);
            builder.append("if ");
            builder.append(cond.toString());
            if (target.getOffsetOrZero() != 0) {
                builder.append(" goto rreil ");
            } else {
                builder.append(" goto native ");
            }
            builder.append(target);
        } else {
            builder.append(this.mnemonic());
            Iterator<OperandTree> it = this.operands().iterator();
            if (it.hasNext()) {
                builder.append(' ');
            }
            while (it.hasNext()) {
                builder.append(it.next());
                if (!it.hasNext()) continue;
                builder.append(", ");
            }
        }
        return builder.toString();
    }
}

