/*
 * Decompiled with CFR 0.152.
 */
package rreil.interpreter.avr8;

import javalx.numeric.BigInt;
import rreil.interpreter.RegisterModel;
import rreil.lang.Lhs;

public class Avr8RegisterModel
extends RegisterModel {
    private final int registerRamSize;

    public Avr8RegisterModel(int baseSize, int registerRamSize) {
        super(baseSize);
        this.registerRamSize = registerRamSize;
    }

    @Override
    public void set(Lhs lhs, BigInt unmaskedValue) {
        int offset = lhs.getOffset();
        assert (this.registerRamSize >= lhs.getSize() + offset) : "Invalid effective register access size (size + offset > baseSize)";
        BigInt baseValue = this.fetchFromPossiblyUndefined(lhs.getRegionId(), this.registerRamSize, BigInt.ZERO);
        BigInt value = this.wrap(unmaskedValue, lhs.getSize());
        int lowerSz = lhs.getSize() + offset;
        int upperSz = this.registerRamSize - lowerSz;
        BigInt lower = baseValue.and(this.sizeMask(offset));
        BigInt upper = baseValue.and(this.sizeMask(upperSz).shl(lowerSz));
        BigInt effectiveValue = upper.or(lower.or(value.shl(offset)));
        this.registers.put(lhs.getRegionId(), effectiveValue);
    }
}

