/*
 * Decompiled with CFR 0.152.
 */
package rreil.interpreter;

import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import rreil.interpreter.InterpCtx;
import rreil.interpreter.RReilMachineException;
import rreil.lang.Lhs;
import rreil.lang.MemVar;
import rreil.lang.RReil;
import rreil.lang.Rhs;
import rreil.lang.SignednessHint;
import rreil.lang.util.RReilVisitor;
import rreil.lang.util.RhsFactory;
import rreil.lang.util.RhsVisitor;

public final class RReilInterp
implements RReilVisitor<Void, InterpCtx> {
    private static final Eval eval = new Eval();

    public RReilInterp(Rhs.Rvar pc) {
    }

    public void run(RReil insn, InterpCtx ctx) {
        insn.accept(this, ctx);
    }

    @Override
    public Void visit(RReil.Assign stmt, InterpCtx ctx) {
        eval.signed = SignednessHint.DontCare;
        Lhs lhs = stmt.getLhs();
        BigInt value = stmt.getRhs().accept(eval, ctx);
        ctx.getRegisters().set(lhs, value);
        return null;
    }

    @Override
    public Void visit(RReil.Load stmt, InterpCtx ctx) {
        BigInt address = stmt.getReadAddress().accept(eval, ctx);
        BigInt value = ctx.getMemory().load(stmt.lhsSize(), address.longValue());
        ctx.getRegisters().set(stmt.getLhs(), value);
        return null;
    }

    @Override
    public Void visit(RReil.Store stmt, InterpCtx ctx) {
        BigInt address = stmt.getWriteAddress().accept(eval, ctx);
        ctx.store(stmt.rhsSize(), address.longValue(), stmt.getRhs().accept(eval, ctx));
        return null;
    }

    @Override
    public Void visit(RReil.Branch stmt, InterpCtx ctx) {
        Rhs.Rvar programPc = RhsFactory.getInstance().variable(8, 0, MemVar.getVarOrFresh("$pc"));
        ctx.getRegisters().set(programPc, stmt.getTarget().accept(eval, ctx).mul(2L));
        return null;
    }

    @Override
    public Void visit(RReil.BranchToNative stmt, InterpCtx ctx) {
        if (stmt.getCond().accept(eval, ctx).isOne()) {
            Rhs.Rvar programPc = RhsFactory.getInstance().variable(8, 0, MemVar.getVarOrFresh("$pc"));
            ctx.getRegisters().set(programPc, stmt.getTarget().accept(eval, ctx));
        }
        return null;
    }

    @Override
    public Void visit(RReil.BranchToRReil stmt, InterpCtx data) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Void visit(RReil.PrimOp stmt, InterpCtx data) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Void visit(RReil.Native stmt, InterpCtx data) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Void visit(RReil.Nop stmt, InterpCtx ctx) {
        return null;
    }

    @Override
    public Void visit(RReil.Assertion stmt, InterpCtx ctx) {
        return null;
    }

    @Override
    public Void visit(RReil.Throw stmt, InterpCtx data) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Void visit(RReil.Flop stmt, InterpCtx data) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static final class Eval
    implements RhsVisitor<BigInt, InterpCtx> {
        private SignednessHint signed;

        private Eval() {
        }

        @Override
        public BigInt visit(Rhs.Bin expr, InterpCtx ctx) {
            this.signed = expr.getOp().signedness();
            BigInt left = expr.getLeft().accept(this, ctx);
            BigInt right = expr.getRight().accept(this, ctx);
            switch (expr.getOp()) {
                case And: {
                    return left.and(right);
                }
                case Divu: {
                    return left.div(right);
                }
                case Divs: {
                    return left.div(right);
                }
                case Mod: {
                    return left.mod(right);
                }
                case Or: {
                    return left.or(right);
                }
                case Mul: {
                    return left.mul(right);
                }
                case Shl: {
                    return left.shl(right);
                }
                case Shr: 
                case Shrs: {
                    return left.shr(right);
                }
                case Xor: {
                    return left.xor(right);
                }
            }
            assert (false) : "Unhandled binary operation";
            return null;
        }

        @Override
        public BigInt visit(Rhs.LinBin expr, InterpCtx ctx) {
            this.signed = expr.getOp().signedness();
            BigInt left = expr.getLeft().accept(this, ctx);
            BigInt right = expr.getRight().accept(this, ctx);
            switch (expr.getOp()) {
                case Add: {
                    return left.add(right);
                }
                case Sub: {
                    return left.sub(right);
                }
            }
            assert (false) : "Unhandled binary operation";
            return null;
        }

        @Override
        public BigInt visit(Rhs.LinRval expr, InterpCtx ctx) {
            return expr.getRval().accept(this, ctx);
        }

        @Override
        public BigInt visit(Rhs.LinScale expr, InterpCtx ctx) {
            this.signed = SignednessHint.DontCare;
            BigInt opnd = expr.getOpnd().accept(this, ctx);
            return opnd.mul(expr.getConst());
        }

        @Override
        public BigInt visit(Rhs.Cmp expr, InterpCtx ctx) {
            this.signed = expr.getOp().signedness();
            BigInt left = expr.getLeft().accept(this, ctx);
            BigInt right = expr.getRight().accept(this, ctx);
            int cmp = left.compareTo(right);
            switch (expr.getOp()) {
                case Cmpeq: {
                    return cmp == 0 ? Bound.ONE : Bound.ZERO;
                }
                case Cmpneq: {
                    return cmp != 0 ? Bound.ONE : Bound.ZERO;
                }
                case Cmples: 
                case Cmpleu: {
                    return cmp <= 0 ? Bound.ONE : Bound.ZERO;
                }
                case Cmplts: 
                case Cmpltu: {
                    return cmp < 0 ? Bound.ONE : Bound.ZERO;
                }
            }
            assert (false) : "Unhandled comparision operation";
            return null;
        }

        @Override
        public BigInt visit(Rhs.SignExtend expr, InterpCtx ctx) {
            this.signed = SignednessHint.ForceSigned;
            return expr.getRhs().accept(this, ctx);
        }

        @Override
        public BigInt visit(Rhs.Convert expr, InterpCtx ctx) {
            this.signed = SignednessHint.ForceUnsigned;
            return expr.getRhs().accept(this, ctx);
        }

        @Override
        public BigInt visit(Rhs.Rvar variable, InterpCtx ctx) {
            return this.signed == SignednessHint.ForceSigned ? ctx.getRegisters().getSigned(variable) : ctx.getRegisters().get(variable);
        }

        @Override
        public BigInt visit(Rhs.Rlit literal, InterpCtx ctx) {
            if (this.signed == null) {
                return ctx.getRegisters().get(literal);
            }
            switch (this.signed) {
                case ForceSigned: {
                    return ctx.getRegisters().getSigned(literal);
                }
                case ForceUnsigned: {
                    return ctx.getRegisters().getUnsigned(literal);
                }
            }
            return ctx.getRegisters().get(literal);
        }

        @Override
        public BigInt visit(Rhs.RangeRhs range, InterpCtx ctx) {
            throw new RReilMachineException("Range values not allowed");
        }

        @Override
        public BigInt visit(Rhs.Address expr, InterpCtx data) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

