/*
 * Decompiled with CFR 0.152.
 */
package rreil.gdsl.builder;

import gdsl.rreil.expression.ICompare;
import rreil.gdsl.BuildingStateManager;
import rreil.gdsl.builder.BuildResult;
import rreil.gdsl.builder.Builder;
import rreil.gdsl.builder.linear.LinearBuilder;
import rreil.lang.ComparisonOp;
import rreil.lang.Rhs;
import rreil.lang.util.RhsFactory;

public class CompareBuilder
extends Builder<Rhs.Cmp>
implements ICompare {
    private LinearBuilder lhs;
    private LinearBuilder rhs;
    private ComparisonOp op;

    public CompareBuilder(BuildingStateManager manager, ComparisonOp op, LinearBuilder lhs, LinearBuilder rhs) {
        super(manager);
        this.op = op;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public CompareBuilder size(int size) {
        this.lhs.size(size);
        this.rhs.size(size);
        return this;
    }

    @Override
    public BuildResult<? extends Rhs.Cmp> build() {
        Rhs.Lin lhsLin = this.lhs.build().getResult();
        Rhs.Lin rhsLin = this.rhs.build().getResult();
        return CompareBuilder.result(RhsFactory.getInstance().comparison(lhsLin, this.op, rhsLin));
    }

    @Override
    public int getSize() {
        return 1;
    }
}

