/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.Arrays;
import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.OperandTree;
import rreil.disassembler.translators.common.InsnEmitter;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.common.TranslationState;
import rreil.disassembler.translators.x86.common.X86Helpers;
import rreil.disassembler.translators.x86.common.X86OperandTranslator;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;

public class X86RegTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();
    private final InsnEmitter emitter;

    public X86RegTranslator(InsnEmitter emitter) {
        this.emitter = emitter;
    }

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        env.setCurrentInstruction(instruction);
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        List<OperandTree> operands = instruction.operands();
        OperandTree targetOperand = operands.get(0);
        TranslationState opnd1 = X86OperandTranslator.translateOperand(env, targetOperand);
        instructions.addAll(opnd1.getInstructionStack());
        assert (opnd1.getOperandStack().size() == 1) : "Source/Destination operand must be a register";
        LowLevelRReilOpnd dst = opnd1.getOperandStack().pop();
        LowLevelRReilOpnd tmp = registerTranslator.temporaryRegister(env, dst.size());
        this.emitter.emit(env, tmp, dst, null, instructions);
        X86Helpers.emitWritebackAndMaybeZeroExtend(env, dst, tmp, instructions);
    }

    public static class BswapEmitter
    implements InsnEmitter {
        @Override
        public void emit(TranslationCtx env, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2, List<LowLevelRReil> instructions) {
            RegisterTranslator registerTranslator = env.getRegisterTranslator();
            if (dst.size() < 32) {
                instructions.add(factory.UNDEF(env.getNextReilAddress(), dst));
                return;
            }
            LowLevelRReilOpnd t = registerTranslator.temporaryRegister(env, dst.size());
            if (dst.size() == 32) {
                LowLevelRReilOpnd b1 = t.withOffset(0, OperandSize.BYTE);
                LowLevelRReilOpnd b2 = t.withOffset(8, OperandSize.BYTE);
                LowLevelRReilOpnd b3 = t.withOffset(16, OperandSize.BYTE);
                LowLevelRReilOpnd b4 = t.withOffset(24, OperandSize.BYTE);
                instructions.addAll(Arrays.asList(factory.MOV(env.getNextReilAddress(), b1, src1.withOffset(24, OperandSize.BYTE)), factory.MOV(env.getNextReilAddress(), b2, src1.withOffset(16, OperandSize.BYTE)), factory.MOV(env.getNextReilAddress(), b3, src1.withOffset(8, OperandSize.BYTE)), factory.MOV(env.getNextReilAddress(), b4, src1.withOffset(0, OperandSize.BYTE)), factory.MOV(env.getNextReilAddress(), dst, t)));
                return;
            }
            if (dst.size() == 64) {
                LowLevelRReilOpnd b1 = t.withOffset(0, OperandSize.BYTE);
                LowLevelRReilOpnd b2 = t.withOffset(8, OperandSize.BYTE);
                LowLevelRReilOpnd b3 = t.withOffset(16, OperandSize.BYTE);
                LowLevelRReilOpnd b4 = t.withOffset(24, OperandSize.BYTE);
                LowLevelRReilOpnd b5 = t.withOffset(32, OperandSize.BYTE);
                LowLevelRReilOpnd b6 = t.withOffset(40, OperandSize.BYTE);
                LowLevelRReilOpnd b7 = t.withOffset(48, OperandSize.BYTE);
                LowLevelRReilOpnd b8 = t.withOffset(56, OperandSize.BYTE);
                instructions.addAll(Arrays.asList(factory.MOV(env.getNextReilAddress(), b1, src1.withOffset(56, OperandSize.BYTE)), factory.MOV(env.getNextReilAddress(), b2, src1.withOffset(48, OperandSize.BYTE)), factory.MOV(env.getNextReilAddress(), b3, src1.withOffset(40, OperandSize.BYTE)), factory.MOV(env.getNextReilAddress(), b4, src1.withOffset(32, OperandSize.BYTE)), factory.MOV(env.getNextReilAddress(), b5, src1.withOffset(24, OperandSize.BYTE)), factory.MOV(env.getNextReilAddress(), b6, src1.withOffset(16, OperandSize.BYTE)), factory.MOV(env.getNextReilAddress(), b7, src1.withOffset(8, OperandSize.BYTE)), factory.MOV(env.getNextReilAddress(), b8, src1.withOffset(0, OperandSize.BYTE)), factory.MOV(env.getNextReilAddress(), dst, t)));
                return;
            }
            assert (false);
        }
    }
}

