/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.Arrays;
import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.translators.common.InsnEmitter;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.x86.common.X86Helpers;
import rreil.disassembler.translators.x86.common.X86RmRmTranslator;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;

public class ScasTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();
    private static final InsnEmitter emitter = new X86RmRmTranslator.SubEmitter();
    private final OperandSize elementSize;

    public ScasTranslator(OperandSize elementSize) {
        this.elementSize = elementSize;
    }

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        env.setCurrentInstruction(instruction);
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        LowLevelRReilOpnd di = registerTranslator.translateRegister("edi").withSize(env.getDefaultArchitectureSize());
        LowLevelRReilOpnd ax = registerTranslator.translateRegister("eax").withSize(this.elementSize);
        LowLevelRReilOpnd idx = factory.immediate(di.size(), (Number)this.elementSize.getSizeInBytes());
        LowLevelRReilOpnd src = registerTranslator.temporaryRegister(env, this.elementSize);
        LowLevelRReilOpnd tmp = registerTranslator.temporaryRegister(env, this.elementSize);
        instructions.add(factory.LOAD(env.getNextReilAddress(), src, di));
        emitter.emit(env, tmp, ax, src, instructions);
        long base = env.getBaseAddress();
        long reilBase = env.getCurrentReilOffset();
        long doDecrement = 3L + reilBase;
        long done = 1L + doDecrement;
        instructions.addAll(Arrays.asList(factory.IFGOTORREIL(env.getNextReilAddress(), X86Helpers.DIRECTION_FLAG_OPERAND, base, doDecrement), factory.ADD(env.getNextReilAddress(), di, di, idx), factory.GOTORREIL(env.getNextReilAddress(), base, done), factory.SUB(env.getNextReilAddress(), di, di, idx), factory.NOP(env.getNextReilAddress())));
    }
}

