/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.OperandTree;
import rreil.disassembler.translators.common.CondEmitter;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.common.TranslationState;
import rreil.disassembler.translators.x86.common.X86OperandTranslator;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;

public class JccTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();
    private final CondEmitter emitter;

    public JccTranslator(CondEmitter emitter) {
        this.emitter = emitter;
    }

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        env.setCurrentInstruction(instruction);
        List<OperandTree> operands = instruction.operands();
        OperandTree operand = operands.get(0);
        TranslationState opnd = X86OperandTranslator.translateOperand(env, operand);
        instructions.addAll(opnd.getInstructionStack());
        LowLevelRReilOpnd cond = this.emitter.emit(env, instructions);
        LowLevelRReilOpnd target = opnd.getOperandStack().pop();
        instructions.add(factory.IFGOTO(env.getNextReilAddress(), cond, target));
    }
}

