/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.avr8.common;

import java.util.Arrays;
import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.translators.avr8.common.AVR8OperandTranslator;
import rreil.disassembler.translators.avr8.common.AVR8SregMemTranslator;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.common.TranslationState;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;

public abstract class AVR8RegRegWordHWordHwordTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();
    private final LowLevelRReilOpnd dstHigh;
    private final LowLevelRReilOpnd dstLow;

    public AVR8RegRegWordHWordHwordTranslator(LowLevelRReilOpnd dstHigh, LowLevelRReilOpnd dstLow) {
        this.dstLow = dstLow;
        this.dstHigh = dstHigh;
    }

    public abstract void emit(TranslationCtx var1, LowLevelRReilOpnd var2, LowLevelRReilOpnd var3, LowLevelRReilOpnd var4, List<LowLevelRReil> var5);

    @Override
    public void translate(TranslationCtx ctx, Instruction insn, List<LowLevelRReil> instructions) {
        AVR8SregMemTranslator.loadSreg(ctx, instructions);
        TranslationState opndState1 = AVR8OperandTranslator.translateOperand(ctx, insn.operand(0));
        TranslationState opndState2 = AVR8OperandTranslator.translateOperand(ctx, insn.operand(1));
        assert (opndState1.getInstructionStack().isEmpty()) : "non-empty instruction stack for first operand";
        assert (opndState2.getInstructionStack().isEmpty()) : "non-empty instruction stack for second operand";
        LowLevelRReilOpnd op1 = opndState1.getOperandStack().pop();
        LowLevelRReilOpnd op2 = opndState2.getOperandStack().pop();
        LowLevelRReilOpnd tempdst = ctx.temporaryRegister(op1.size() * 2);
        this.emit(ctx, tempdst, op1, op2, instructions);
        instructions.addAll(Arrays.asList(factory.CONVERT(ctx.getNextReilAddress(), this.dstLow, tempdst)));
        instructions.addAll(Arrays.asList(factory.SHRS(ctx.getNextReilAddress(), tempdst, tempdst, factory.immediate(tempdst.size(), (Number)this.dstHigh.size()))));
        instructions.addAll(Arrays.asList(factory.CONVERT(ctx.getNextReilAddress(), this.dstHigh, tempdst)));
        AVR8SregMemTranslator.storeSreg(ctx, instructions);
    }
}

