/*
 * Decompiled with CFR 0.152.
 */
package javalx.persistentcollections.trie;

import javalx.data.Option;
import javalx.data.Unit;
import javalx.data.products.P2;
import javalx.fn.Effect;
import javalx.fn.Fn2;

public abstract class IntTrie<A> {
    private final Fn2<P2<Integer, A>, P2<Integer, A>, A> rightBiasedSelector = new Fn2<P2<Integer, A>, P2<Integer, A>, A>(){

        @Override
        public A apply(P2<Integer, A> a, P2<Integer, A> b) {
            return b._2();
        }
    };

    public static <A> IntTrie<A> empty() {
        return new Empty();
    }

    public final IntTrie<A> bind(int key, A value) {
        return this.bind(this.rightBiasedSelector, key, value);
    }

    public final IntTrie<A> bind(Fn2<P2<Integer, A>, P2<Integer, A>, A> f, int key, A value) {
        return this.insert(f, key, value);
    }

    public final boolean contains(int key) {
        return this.lookup(key).isSome();
    }

    public final Option<A> get(int key) {
        return this.lookup(key);
    }

    public final IntTrie<A> union(IntTrie<A> other) {
        return this.merge(this.rightBiasedSelector, other);
    }

    public final IntTrie<A> remove(int key) {
        return this.remove(Effect.ignoring(), Effect.ignoring(), key);
    }

    public final IntTrie<A> remove(Effect<P2<Integer, A>> runIfFound, Effect<Unit> runIfNotFound, int key) {
        return this.removeTree(runIfFound, runIfNotFound, key);
    }

    public abstract int size();

    public abstract int height();

    protected abstract Option<A> lookup(int var1);

    protected abstract IntTrie<A> removeTree(Effect<P2<Integer, A>> var1, Effect<Unit> var2, int var3);

    protected abstract IntTrie<A> insert(Fn2<P2<Integer, A>, P2<Integer, A>, A> var1, int var2, A var3);

    protected abstract IntTrie<A> merge(Fn2<P2<Integer, A>, P2<Integer, A>, A> var1, Branch<A> var2);

    protected abstract IntTrie<A> merge(Fn2<P2<Integer, A>, P2<Integer, A>, A> var1, Leaf<A> var2);

    protected final IntTrie<A> merge(Fn2<P2<Integer, A>, P2<Integer, A>, A> f, IntTrie<A> right) {
        if (right instanceof Branch) {
            return this.merge(f, (Branch)right);
        }
        if (right instanceof Leaf) {
            return this.merge(f, (Leaf)right);
        }
        return this;
    }

    public static <A> IntTrie<A> singleton(int key, A value) {
        return new Leaf<A>(key, value);
    }

    public abstract boolean isEmpty();

    protected final IntTrie<A> join(int p1, IntTrie<A> t1, int p2, IntTrie<A> t2) {
        int m = IntTrie.branchMask(p1, p2);
        int p = IntTrie.mask(p1, m);
        if (IntTrie.zero(p1, m)) {
            return new Branch<A>(p, m, t1, t2);
        }
        return new Branch<A>(p, m, t2, t1);
    }

    protected IntTrie<A> branch(int prefix, int mask, IntTrie<A> left, IntTrie<A> right) {
        if (right.isEmpty()) {
            return left;
        }
        if (left.isEmpty()) {
            return right;
        }
        return new Branch<A>(prefix, mask, left, right);
    }

    private static int mask(int k, int m) {
        return k & (~(m - 1) ^ m);
    }

    private static boolean match(int k, int p, int m) {
        return IntTrie.mask(k, m) == p;
    }

    private static boolean zero(int k, int m) {
        return (k & m) == 0;
    }

    private static int highestOneBit(int x) {
        int i = x;
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i - (i >>> 1);
    }

    private static int branchMask(int p1, int p2) {
        return IntTrie.highestOneBit(p1 ^ p2);
    }

    private static boolean unsignedLessThan(int i, int j) {
        return i < j ^ i < 0 ^ j < 0;
    }

    private static final class Branch<A>
    extends IntTrie<A> {
        final int largestCommonPrefix;
        final int branchingBit;
        final IntTrie<A> left;
        final IntTrie<A> right;

        public Branch(int largestCommonPrefix, int branchingBit, IntTrie<A> left, IntTrie<A> right) {
            this.largestCommonPrefix = largestCommonPrefix;
            this.branchingBit = branchingBit;
            this.left = left;
            this.right = right;
        }

        @Override
        protected Option<A> lookup(int key) {
            if (IntTrie.zero(key, this.branchingBit)) {
                return this.left.lookup(key);
            }
            return this.right.lookup(key);
        }

        @Override
        protected IntTrie<A> removeTree(Effect<P2<Integer, A>> runIfFound, Effect<Unit> runIfNotFound, int key) {
            if (IntTrie.match(key, this.largestCommonPrefix, this.branchingBit)) {
                if (IntTrie.zero(key, this.branchingBit)) {
                    return this.branch(this.largestCommonPrefix, this.branchingBit, this.left.remove(runIfFound, runIfNotFound, key), this.right);
                }
                return this.branch(this.largestCommonPrefix, this.branchingBit, this.left, this.right.remove(runIfFound, runIfNotFound, key));
            }
            return this;
        }

        @Override
        protected IntTrie<A> insert(Fn2<P2<Integer, A>, P2<Integer, A>, A> f, int key, A value) {
            if (IntTrie.match(key, this.largestCommonPrefix, this.branchingBit)) {
                if (IntTrie.zero(key, this.branchingBit)) {
                    return new Branch<A>(this.largestCommonPrefix, this.branchingBit, this.left.insert(f, key, value), this.right);
                }
                return new Branch<A>(this.largestCommonPrefix, this.branchingBit, this.left, this.right.insert(f, key, value));
            }
            return this.join(key, new Leaf<A>(key, value), this.largestCommonPrefix, this);
        }

        @Override
        public int size() {
            return this.left.size() + this.right.size();
        }

        @Override
        public int height() {
            return 1 + Math.max(this.left.height(), this.right.height());
        }

        @Override
        protected IntTrie<A> merge(Fn2<P2<Integer, A>, P2<Integer, A>, A> f, Branch<A> other) {
            if (IntTrie.unsignedLessThan(other.branchingBit, this.branchingBit)) {
                if (IntTrie.match(other.largestCommonPrefix, this.largestCommonPrefix, this.branchingBit)) {
                    if (IntTrie.zero(other.largestCommonPrefix, this.branchingBit)) {
                        return new Branch<A>(this.largestCommonPrefix, this.branchingBit, this.left.merge(f, other), this.right);
                    }
                    return new Branch<A>(this.largestCommonPrefix, this.branchingBit, this.left, this.right.merge(f, other));
                }
                return this.join(this.largestCommonPrefix, this, other.largestCommonPrefix, other);
            }
            if (IntTrie.unsignedLessThan(this.branchingBit, other.branchingBit)) {
                if (IntTrie.match(this.largestCommonPrefix, other.largestCommonPrefix, other.branchingBit)) {
                    if (IntTrie.zero(this.largestCommonPrefix, other.branchingBit)) {
                        return new Branch<A>(other.largestCommonPrefix, other.branchingBit, ((IntTrie)this).merge(f, other.left), other.right);
                    }
                    return new Branch<A>(other.largestCommonPrefix, other.branchingBit, other.left, ((IntTrie)this).merge(f, other.right));
                }
                return this.join(this.largestCommonPrefix, this, other.largestCommonPrefix, other);
            }
            if (this.largestCommonPrefix == other.largestCommonPrefix) {
                return new Branch<A>(this.largestCommonPrefix, this.branchingBit, this.left.merge(f, other.left), this.right.merge(f, other.right));
            }
            return this.join(this.largestCommonPrefix, this, other.largestCommonPrefix, other);
        }

        @Override
        protected IntTrie<A> merge(Fn2<P2<Integer, A>, P2<Integer, A>, A> f, Leaf<A> right) {
            return this.insert(f, right.key, right.value);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    private static final class Leaf<A>
    extends IntTrie<A> {
        final A value;
        final int key;

        public Leaf(int key, A value) {
            this.key = key;
            this.value = value;
        }

        @Override
        protected Option<A> lookup(int key) {
            if (this.key == key) {
                return Option.some(this.value);
            }
            return Option.none();
        }

        @Override
        protected IntTrie<A> removeTree(Effect<P2<Integer, A>> runIfFound, Effect<Unit> runIfNotFound, int key) {
            if (this.key == key) {
                runIfFound.observe(P2.tuple2(this.key, this.value));
                return Leaf.empty();
            }
            runIfNotFound.observe(Unit.unit());
            return this;
        }

        @Override
        protected IntTrie<A> insert(Fn2<P2<Integer, A>, P2<Integer, A>, A> f, int key, A value) {
            if (this.key == key) {
                return new Leaf<A>(key, f.apply(P2.tuple2(this.key, this.value), P2.tuple2(key, value)));
            }
            return this.join(key, new Leaf<A>(key, value), this.key, this);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public int height() {
            return 1;
        }

        @Override
        protected IntTrie<A> merge(Fn2<P2<Integer, A>, P2<Integer, A>, A> f, Branch<A> right) {
            return right.insert(f.flip(), this.key, this.value);
        }

        @Override
        protected IntTrie<A> merge(Fn2<P2<Integer, A>, P2<Integer, A>, A> f, Leaf<A> right) {
            return right.insert(f.flip(), this.key, this.value);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    private static final class Empty<A>
    extends IntTrie<A> {
        private Empty() {
        }

        @Override
        protected Option<A> lookup(int key) {
            return Option.none();
        }

        @Override
        protected IntTrie<A> insert(Fn2<P2<Integer, A>, P2<Integer, A>, A> _, int key, A value) {
            return new Leaf<A>(key, value);
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int height() {
            return 0;
        }

        @Override
        protected IntTrie<A> merge(Fn2<P2<Integer, A>, P2<Integer, A>, A> f, Branch<A> right) {
            return right;
        }

        @Override
        protected IntTrie<A> merge(Fn2<P2<Integer, A>, P2<Integer, A>, A> f, Leaf<A> right) {
            return right;
        }

        @Override
        protected IntTrie<A> removeTree(Effect<P2<Integer, A>> runIfFound, Effect<Unit> runIfNotFound, int key) {
            runIfNotFound.observe(Unit.unit());
            return this;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }
}

