/*
 * Decompiled with CFR 0.152.
 */
package javalx.persistentcollections;

import java.util.Iterator;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.fn.Fn;
import javalx.fn.Fn2;
import javalx.persistentcollections.IterableWrapper;
import javalx.persistentcollections.OrderedMap;
import javalx.persistentcollections.ThreeWaySplit;
import javalx.persistentcollections.tree.AVLTree;

public final class IntMap<V>
implements OrderedMap<Integer, V, IntMap<V>> {
    private final AVLTree<Integer, V> tree;
    private final Fn<AVLTree<Integer, V>, IntMap<V>> buildFn = new Fn<AVLTree<Integer, V>, IntMap<V>>(){

        @Override
        public IntMap<V> apply(AVLTree<Integer, V> tree) {
            return IntMap.build(tree);
        }
    };

    private IntMap(AVLTree<Integer, V> tree) {
        this.tree = tree;
    }

    private static <V> IntMap<V> build(AVLTree<Integer, V> tree) {
        return new IntMap<V>(tree);
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    @Override
    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    @Override
    public boolean contains(Integer key) {
        return this.tree.get(key).isSome();
    }

    public static <V> IntMap<V> empty() {
        return IntMap.build(AVLTree.empty());
    }

    @Override
    public IntMap<V> union(IntMap<V> other) {
        return IntMap.build(this.tree.union(other.tree));
    }

    @Override
    public IntMap<V> union(Fn2<V, V, V> selector, IntMap<V> other) {
        return IntMap.build(this.tree.union(selector, other.tree));
    }

    @Override
    public IntMap<V> difference(IntMap<V> other) {
        return IntMap.build(this.tree.difference(other.tree));
    }

    @Override
    public IntMap<V> intersection(IntMap<V> other) {
        return IntMap.build(this.tree.intersection(other.tree));
    }

    @Override
    public IntMap<V> intersection(Fn2<V, V, V> selector, IntMap<V> other) {
        return IntMap.build(this.tree.intersection(selector, other.tree));
    }

    @Override
    public Option<V> get(Integer key) {
        return this.tree.get(key);
    }

    @Override
    public IntMap<V> bind(Integer key, V value) {
        return IntMap.build(this.tree.bind((Object)key, value));
    }

    @Override
    public IntMap<V> remove(Integer key) {
        return IntMap.build(this.tree.remove((Object)key));
    }

    @Override
    public Option<P2<Integer, V>> getMax() {
        return this.tree.getMax();
    }

    @Override
    public Option<P2<Integer, V>> getMin() {
        return this.tree.getMin();
    }

    @Override
    public IntMap<V> removeMax() {
        return IntMap.build(this.tree.removeMax());
    }

    @Override
    public IntMap<V> removeMin() {
        return IntMap.build(this.tree.removeMin());
    }

    @Override
    public ThreeWaySplit<IntMap<V>> split(IntMap<V> other) {
        return ThreeWaySplit.map(this.tree.split(other.tree), this.buildFn);
    }

    @Override
    public Iterable<Integer> keys() {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return IterableWrapper.getKeysIterator(IntMap.this);
            }
        };
    }

    @Override
    public Iterable<V> values() {
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return IterableWrapper.getValuesIterator(IntMap.this);
            }
        };
    }

    @Override
    public Iterator<P2<Integer, V>> iterator() {
        return this.tree.iterator();
    }

    public String toString() {
        Iterator<P2<Integer, V>> iterator = this.iterator();
        if (!iterator.hasNext()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        while (iterator.hasNext()) {
            P2<Integer, V> element = iterator.next();
            Integer key = element._1();
            V value = element._2();
            builder.append(key);
            builder.append('=');
            builder.append((Object)(value == this ? "(this Map)" : value));
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append('}').toString();
    }

    @Override
    public String toString(Fn<Integer, String> keyRenderer) {
        Iterator<P2<Integer, V>> iterator = this.iterator();
        if (!iterator.hasNext()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        while (iterator.hasNext()) {
            P2<Integer, V> element = iterator.next();
            Integer key = element._1();
            V value = element._2();
            builder.append(keyRenderer.apply(key));
            builder.append('=');
            builder.append((Object)(value == this ? "(this Map)" : value));
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append('}').toString();
    }
}

