/*
 * Decompiled with CFR 0.152.
 */
package javalx.numeric;

import java.util.Iterator;
import java.util.LinkedList;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Congruence;
import javalx.numeric.Interval;
import javalx.numeric.IntervalSet;

public abstract class Range
implements Iterable<BigInt> {
    public static final Range ZERO = Range.from(0L);
    public static final Range TOP = Range.from(Interval.TOP);
    protected Congruence congruence;

    public static Range from(long value) {
        return Range.from(BigInt.of(value));
    }

    public static Range from(long lo, long hi) {
        return Range.from(Interval.of(lo, hi));
    }

    public static Range from(BigInt value) {
        return Range.from(Interval.of(value));
    }

    public static Range from(Interval value) {
        return new IntervalRange(value);
    }

    public static IntervalSetRange from(IntervalSet intervalSet) {
        return new IntervalSetRange(intervalSet);
    }

    public abstract Interval convexHull();

    public abstract IntervalSet asSet();

    public abstract boolean contains(BigInt var1);

    public Congruence getCongruence() {
        return this.congruence;
    }

    public abstract boolean isFinite();

    public abstract BigInt getMin();

    public abstract BigInt getMax();

    public abstract Range union(Range var1);

    public abstract BigInt numberOfDiscreteValues();

    public abstract int lowerZeroBits(int var1);

    public abstract int upperZeroBits(int var1);

    public abstract int upperOneBits(int var1);

    public abstract boolean isNonConvexApproximation();

    public abstract Range ensureCongruent(Congruence var1);

    public boolean isConstant() {
        return this.isFinite() && this.numberOfDiscreteValues().isOne();
    }

    public boolean isZero() {
        BigInt c = this.getConstantOrNull();
        if (c == null) {
            return false;
        }
        return c.isZero();
    }

    public boolean isOne() {
        BigInt c = this.getConstantOrNull();
        if (c == null) {
            return false;
        }
        return c.isOne();
    }

    public BigInt getConstantOrNull() {
        return this.isConstant() ? this.getMin() : null;
    }

    private boolean isFiniteInRange(Interval fullSignedRange) {
        return this.isFinite() && fullSignedRange.contains(this.convexHull());
    }

    public Range wrapUnsigned(int size) {
        return this.wrapToInterval(size, Interval.unsignedTop(size));
    }

    public Range wrapSigned(int size) {
        return this.wrapToInterval(size, Interval.signedTop(size));
    }

    private Range wrapToInterval(int size, Interval unSignedTop) {
        return this.isFiniteInRange(unSignedTop) ? this : this.wrap(size, unSignedTop);
    }

    private Range wrap(int size, Interval top) {
        BigInt max = BigInt.powerOfTwo(size);
        if (!this.isFinite()) {
            return Range.from(top);
        }
        BigInt bl = top.low().asInteger();
        Interval x = this.convexHull();
        BigInt l = x.low().asInteger();
        BigInt h = x.high().asInteger();
        BigInt[] divAndRem = l.sub(bl).divideAndRemainder(max);
        BigInt ql = divAndRem[1].isNegative() ? divAndRem[0].sub(Bound.ONE) : divAndRem[0];
        divAndRem = h.sub(bl).divideAndRemainder(max);
        BigInt qu = divAndRem[1].isNegative() ? divAndRem[0].sub(Bound.ONE) : divAndRem[0];
        BigInt k = qu.sub(ql);
        if (!Bound.ONE.isLessThan(k)) {
            Interval i = x.sub(Interval.of(max.mul(ql))).meet(top).get();
            BigInt q = ql.add(Bound.ONE);
            while (!qu.isLessThan(q)) {
                i = i.join(x.sub(Interval.of(max.mul(q))).meet(top).get());
                q = q.add(Bound.ONE);
            }
            return Range.from(i);
        }
        return Range.from(top);
    }

    public Range unsignedOr(Range other, int size) {
        Interval top = Interval.unsignedTop(size);
        Range fst = this.wrapUnsigned(size);
        Range snd = other.wrapUnsigned(size);
        Interval result = fst.convexHull().unsignedOr(snd.convexHull());
        return Range.from(result.meet(top).get());
    }

    public Range unsignedXor(Range other, int size) {
        Interval top = Interval.unsignedTop(size);
        Range fst = this.wrapUnsigned(size);
        Range snd = other.wrapUnsigned(size);
        Interval result = fst.convexHull().unsignedXor(snd.convexHull());
        return Range.from(result.meet(top).get());
    }

    public abstract Range add(Range var1);

    public abstract Range mul(Range var1);

    public abstract Range mul(BigInt var1);

    public abstract Range sub(BigInt var1);

    public abstract Range divRoundInvards(BigInt var1);

    public abstract String toString();

    public static Range top() {
        return Range.from(Interval.TOP);
    }

    private static final class IntervalSetRange
    extends Range {
        private final IntervalSet intervalSet;

        private IntervalSetRange(IntervalSet intervalSet) {
            this.intervalSet = intervalSet;
            this.congruence = Congruence.ONE;
        }

        private IntervalSetRange(IntervalSet intervalSet, Congruence congruence) {
            this.intervalSet = intervalSet;
            this.congruence = congruence;
        }

        @Override
        public Interval convexHull() {
            return this.intervalSet.convexHull();
        }

        @Override
        public IntervalSet asSet() {
            return this.intervalSet;
        }

        @Override
        public boolean contains(BigInt value) {
            return this.intervalSet.contains(value);
        }

        @Override
        public Range union(Range other) {
            if (other instanceof IntervalSetRange) {
                IntervalSetRange unionRange = IntervalSetRange.from(this.intervalSet.join(((IntervalSetRange)other).intervalSet));
                ((Range)unionRange).ensureCongruent(this.congruence.join(other.getCongruence()));
                return unionRange;
            }
            return other.union(this);
        }

        @Override
        public Range add(Range other) {
            if (other instanceof IntervalSetRange) {
                IntervalSetRange unionRange = IntervalSetRange.from(this.intervalSet.add(((IntervalSetRange)other).intervalSet));
                ((Range)unionRange).ensureCongruent(this.congruence.add(other.getCongruence()));
                return unionRange;
            }
            return other.add(this);
        }

        @Override
        public Range mul(Range other) {
            if (other instanceof IntervalSetRange) {
                IntervalSetRange unionRange = IntervalSetRange.from(this.intervalSet.mul(((IntervalSetRange)other).intervalSet));
                ((Range)unionRange).ensureCongruent(this.congruence.mul(other.getCongruence()));
                return unionRange;
            }
            return other.mul(this);
        }

        @Override
        public Range mul(BigInt c) {
            Congruence newCongruence = this.getCongruence().mul(c);
            return new IntervalSetRange(this.intervalSet.mul(c), newCongruence);
        }

        @Override
        public Range sub(BigInt c) {
            Congruence newCongruence = this.getCongruence().sub(c);
            return new IntervalSetRange(this.intervalSet.sub(c), newCongruence);
        }

        @Override
        public Range divRoundInvards(BigInt c) {
            Congruence newCongruence = this.getCongruence();
            IntervalSet newIntervalSet = this.intervalSet.divRoundInvards(c);
            if (newIntervalSet == null) {
                return null;
            }
            if (!newCongruence.isConstantOnly()) {
                newCongruence = newCongruence.div(c);
            }
            return new IntervalSetRange(newIntervalSet, newCongruence);
        }

        @Override
        public int lowerZeroBits(int noOfBits) {
            int res = noOfBits;
            for (Interval inv : this.intervalSet) {
                if (inv.isConstant()) {
                    long val = inv.getConstant().longValue();
                    int zeros = Long.numberOfTrailingZeros(val);
                    if (zeros < res) {
                        res = zeros;
                    }
                } else {
                    res = 0;
                }
                if (res != 0) continue;
                break;
            }
            if (res > 0) {
                return res;
            }
            return Math.min(noOfBits, this.congruence.lowerZeroBits());
        }

        @Override
        public int upperZeroBits(int noOfBits) {
            if (noOfBits < 1) {
                return 0;
            }
            int res = noOfBits;
            Interval enclosing = Interval.of(Bound.ZERO, BigInt.powerOfTwo(noOfBits - 1).sub(1L));
            for (Interval interval : this.intervalSet) {
                if (interval.hasNegativeValues()) {
                    return 0;
                }
                int resLocal = -1;
                while (enclosing.contains(interval) && resLocal < noOfBits) {
                    ++resLocal;
                    enclosing = enclosing.divRoundInvards(Bound.TWO);
                }
                if (resLocal <= 0) {
                    return 0;
                }
                if (resLocal >= res) continue;
                res = resLocal;
            }
            return res;
        }

        @Override
        public int upperOneBits(int noOfBits) {
            if (noOfBits < 1) {
                return 0;
            }
            int res = noOfBits;
            for (Interval interval : this.intervalSet) {
                if (interval.hasNegativeValues()) {
                    return 0;
                }
                int resLocal = -1;
                BigInt one = BigInt.powerOfTwo(noOfBits - 1);
                BigInt upper = one.sub(1L);
                BigInt lower = Bound.ZERO;
                do {
                    one = one.shr(1);
                    lower = lower.add(one);
                    ++resLocal;
                } while (Interval.of(lower, upper).contains(interval) && one.isPositive());
                if (resLocal < res) {
                    res = resLocal;
                }
                if (res != 0) continue;
                break;
            }
            return res;
        }

        @Override
        public BigInt numberOfDiscreteValues() {
            if (!this.intervalSet.low().isFinite() || !this.intervalSet.high().isFinite()) {
                throw new Error("requested bound of unbounded value");
            }
            if (this.congruence.getScale().isZero()) {
                return Bound.ONE;
            }
            BigInt result = Bound.ZERO;
            for (Interval interval : this.intervalSet) {
                BigInt valueCount = new IntervalRange(interval, this.getCongruence()).numberOfDiscreteValues();
                result = result.add(valueCount);
            }
            return result;
        }

        @Override
        public boolean isNonConvexApproximation() {
            for (Interval interval : this.intervalSet) {
                IntervalRange subRange = new IntervalRange(interval, this.getCongruence());
                if (subRange.isNonConvexApproximation()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isFinite() {
            return this.intervalSet.isFinite();
        }

        @Override
        public BigInt getMax() {
            if (!this.intervalSet.high().isFinite()) {
                throw new Error("requested bound of unbounded value");
            }
            return this.intervalSet.high().asInteger();
        }

        @Override
        public BigInt getMin() {
            if (!this.intervalSet.low().isFinite()) {
                throw new Error("requested bound of unbounded value");
            }
            return this.intervalSet.low().asInteger();
        }

        @Override
        public Range ensureCongruent(Congruence c) {
            if (c.isConstantOnly()) {
                if (this.intervalSet.meet(IntervalSet.valueOf(c.getOffset())).isNone()) {
                    throw new IllegalStateException();
                }
                return new IntervalSetRange(this.intervalSet, c);
            }
            LinkedList<Interval> result = new LinkedList<Interval>();
            for (Interval interval : this.intervalSet) {
                result.add(interval.applyCongruence(c));
            }
            return new IntervalSetRange(new IntervalSet(result), c);
        }

        @Override
        public Iterator<BigInt> iterator() {
            if (!this.isFinite()) {
                throw new UnsupportedOperationException("Can not interate over infinite intervals");
            }
            return this.intervalSet.iteratorIntWithStride(this.congruence.getScale());
        }

        @Override
        public String toString() {
            return this.intervalSet.toString();
        }
    }

    private static final class IntervalRange
    extends Range {
        private final Interval interval;

        private IntervalRange(Interval interval) {
            this.interval = interval;
            this.congruence = Congruence.ONE;
        }

        private IntervalRange(Interval interval, Congruence congruence) {
            this.interval = interval;
            this.congruence = congruence;
        }

        @Override
        public Interval convexHull() {
            return this.interval;
        }

        @Override
        public IntervalSet asSet() {
            return IntervalSet.valueOf(this.interval);
        }

        @Override
        public boolean contains(BigInt value) {
            return this.interval.contains(value);
        }

        @Override
        public Range union(Range other) {
            return IntervalRange.from(this.interval.join(other.convexHull())).ensureCongruent(this.congruence.join(other.congruence));
        }

        @Override
        public Range add(Range other) {
            return IntervalRange.from(this.interval.add(other.convexHull())).ensureCongruent(this.congruence.add(other.congruence));
        }

        @Override
        public Range mul(Range other) {
            return IntervalRange.from(this.interval.mul(other.convexHull())).ensureCongruent(this.congruence.mul(other.congruence));
        }

        @Override
        public Range mul(BigInt c) {
            return IntervalRange.from(this.interval.mul(c)).ensureCongruent(this.congruence.mul(c));
        }

        @Override
        public Range sub(BigInt c) {
            Congruence newCongruence = this.getCongruence().sub(c);
            return new IntervalRange(this.interval.sub(c), newCongruence);
        }

        @Override
        public Range divRoundInvards(BigInt c) {
            Congruence newCongruence = this.getCongruence();
            Interval newInterval = this.interval.divRoundInvards(c);
            if (newInterval == null) {
                return null;
            }
            if (!newCongruence.isConstantOnly()) {
                newCongruence = newCongruence.div(c);
            }
            return new IntervalRange(newInterval, newCongruence);
        }

        @Override
        public int lowerZeroBits(int noOfBits) {
            if (this.isConstant()) {
                long val = this.interval.getConstant().longValue();
                return Math.min(noOfBits, Long.numberOfTrailingZeros(val));
            }
            return Math.min(noOfBits, this.congruence.lowerZeroBits());
        }

        @Override
        public int upperZeroBits(int noOfBits) {
            if (this.interval.hasNegativeValues()) {
                return 0;
            }
            if (noOfBits < 1) {
                return 0;
            }
            int res = 0;
            Interval enclosing = Interval.of(Bound.ZERO, BigInt.powerOfTwo(noOfBits - 1).sub(1L));
            while (enclosing.contains(this.interval) && res < noOfBits) {
                ++res;
                enclosing = enclosing.divRoundInvards(Bound.TWO);
            }
            return res;
        }

        @Override
        public int upperOneBits(int noOfBits) {
            if (this.interval.hasNegativeValues()) {
                return 0;
            }
            if (noOfBits < 1) {
                return 0;
            }
            int res = -1;
            BigInt one = BigInt.powerOfTwo(noOfBits);
            BigInt upper = one.sub(1L);
            BigInt lower = Bound.ZERO;
            do {
                one = one.shr(1);
                lower = lower.add(one);
                ++res;
            } while (Interval.of(lower, upper).contains(this.interval) && one.isPositive());
            return res;
        }

        @Override
        public BigInt numberOfDiscreteValues() {
            if (this.congruence.getScale().isZero()) {
                return Bound.ONE;
            }
            return this.getMax().sub(this.getMin()).div(this.congruence.getScale()).add(Bound.ONE);
        }

        @Override
        public boolean isNonConvexApproximation() {
            BigInt r = this.numberOfDiscreteValues();
            return r.isLessThan(BigInt.of(3L));
        }

        @Override
        public boolean isFinite() {
            return this.interval.low().isFinite() && this.interval.high().isFinite();
        }

        @Override
        public BigInt getMin() {
            return this.interval.low().asInteger();
        }

        @Override
        public BigInt getMax() {
            return this.interval.high().asInteger();
        }

        @Override
        public Range ensureCongruent(Congruence c) {
            if (c.isConstantOnly()) {
                if (!this.interval.contains(c.getOffset())) {
                    throw new IllegalStateException();
                }
                return new IntervalRange(Interval.of(c.getOffset()), c);
            }
            return new IntervalRange(this.interval.applyCongruence(c), c);
        }

        @Override
        public Iterator<BigInt> iterator() {
            if (!this.isFinite()) {
                throw new UnsupportedOperationException("Can not interate over infinite intervals");
            }
            return this.interval.iteratorWithStride(this.congruence.getScale());
        }

        @Override
        public String toString() {
            return this.interval.toString();
        }
    }
}

