/*
 * Decompiled with CFR 0.152.
 */
package javalx.numeric;

import com.jamesmurty.utils.XMLBuilder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javalx.data.Option;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Congruence;
import javalx.xml.XmlPrintable;

public final class Interval
implements Comparable<Interval>,
Iterable<BigInt>,
XmlPrintable {
    public static final Interval TOP = new Interval(Bound.NEGINF, Bound.POSINF);
    public static final Interval ONE = Interval.of(Bound.ONE);
    public static final Interval MINUSONE = Interval.of(Bound.MINUSONE);
    public static final Interval ZERO = Interval.of(Bound.ZERO);
    public static final Interval BOOLEANTOP = ZERO.join(ONE);
    public static final Interval LESS_THAN_OR_EQUAL_TO_ZERO = new Interval(Bound.NEGINF, Bound.ZERO);
    public static final Interval GREATER_THAN_OR_EQUAL_TO_ZERO = new Interval(Bound.ZERO, Bound.POSINF);
    public static final Interval ZEROorONE = new Interval(Bound.ZERO, Bound.ONE);
    final Bound low;
    final Bound high;

    private Interval(Bound lo, Bound up) {
        this.low = lo;
        this.high = up;
        assert (Interval.isWellFormed(this.low, this.high)) : "Interval bounds are not well formed: [" + lo + ", " + up + "]";
    }

    public static Interval of(String interval) {
        return StringParser.parseInterval(interval);
    }

    public static Interval of(long c) {
        return Interval.of(BigInt.of(c));
    }

    public static Interval of(BigInt c) {
        BigInt bound = c;
        return new Interval(bound, bound);
    }

    public static Interval of(long lo, long up) {
        return Interval.of(BigInt.of(lo), BigInt.of(up));
    }

    public static Interval of(BigInt lo, BigInt up) {
        return Interval.of((Bound)lo, (Bound)up);
    }

    public static Interval of(Bound lo, Bound up) {
        return new Interval(lo, up);
    }

    public static Interval downFrom(long upperBound) {
        return Interval.downFrom(BigInt.of(upperBound));
    }

    public static Interval downFrom(BigInt upperBound) {
        return Interval.downFrom((Bound)upperBound);
    }

    public static Interval downFrom(Bound upperBound) {
        return new Interval(Bound.NEGINF, upperBound);
    }

    public static Interval upFrom(long lowerBound) {
        return Interval.upFrom(BigInt.of(lowerBound));
    }

    public static Interval upFrom(BigInt lowerBound) {
        return new Interval(lowerBound, Bound.POSINF);
    }

    private static boolean isWellFormed(Bound lower, Bound higher) {
        if (!lower.isFinite() && !higher.isFinite()) {
            return lower.isLessThan(higher);
        }
        if (lower.isFinite() && higher.isFinite()) {
            return lower.asInteger().isLessThanOrEqualTo(higher.asInteger());
        }
        return true;
    }

    public static Interval top() {
        return TOP;
    }

    public static Interval signedTop(int size) {
        BigInt base = BigInt.powerOfTwo(size - 1);
        BigInt upperBound = base.sub(BigInt.of(1L));
        BigInt lowerBound = base.mul(BigInt.of(-1L));
        return Interval.of(lowerBound, upperBound);
    }

    public static Interval unsignedTop(int size) {
        BigInt upperBound = BigInt.powerOfTwo(size).sub(BigInt.of(1L));
        BigInt lowerBound = Bound.ZERO;
        return Interval.of(lowerBound, upperBound);
    }

    public Interval wrap(Interval range) {
        if (!this.isFinite()) {
            return range;
        }
        BigInt max = range.high().asInteger().sub(range.low().asInteger()).add(Bound.ONE);
        BigInt bl = range.low().asInteger();
        BigInt l = this.low().asInteger();
        BigInt h = this.high().asInteger();
        BigInt[] divAndRem = l.sub(bl).divideAndRemainder(max);
        BigInt ql = divAndRem[1].isNegative() ? divAndRem[0].sub(Bound.ONE) : divAndRem[0];
        divAndRem = h.sub(bl).divideAndRemainder(max);
        BigInt qu = divAndRem[1].isNegative() ? divAndRem[0].sub(Bound.ONE) : divAndRem[0];
        BigInt k = qu.sub(ql);
        if (!Bound.ONE.isLessThan(k)) {
            Interval x = this.sub(Interval.of(max.mul(ql))).meet(range).get();
            BigInt q = ql.add(Bound.ONE);
            while (!qu.isLessThan(q)) {
                x = x.join(this.sub(Interval.of(max.mul(q))).meet(range).get());
                q = q.add(Bound.ONE);
            }
            return x;
        }
        return range;
    }

    public Bound low() {
        return this.low;
    }

    public Bound high() {
        return this.high;
    }

    @Override
    public int compareTo(Interval b) {
        int cmp1 = this.low.compareTo(b.low);
        return cmp1 == 0 ? this.high.compareTo(b.high) : cmp1;
    }

    public boolean overlaps(Interval other) {
        return this.low.isLessThanOrEqualTo(other.high) && other.low.isLessThanOrEqualTo(this.high);
    }

    public boolean isAdjacent(Interval other) {
        boolean thisLowIsOneMore;
        boolean thisHighIsOneLess;
        if (this.high().isFinite() && other.low().isFinite()) {
            BigInt thisHighPlusOne = this.high().asInteger().add(Bound.ONE);
            thisHighIsOneLess = thisHighPlusOne.isEqualTo(other.low().asInteger());
        } else {
            thisHighIsOneLess = false;
        }
        if (this.low().isFinite() && other.high().isFinite()) {
            BigInt thisLowMinusOne = this.low().asInteger().sub(Bound.ONE);
            thisLowIsOneMore = thisLowMinusOne.isEqualTo(other.high().asInteger());
        } else {
            thisLowIsOneMore = false;
        }
        return thisHighIsOneLess || thisLowIsOneMore;
    }

    public boolean contains(Interval other) {
        return this.low.isLessThanOrEqualTo(other.low) && other.high.isLessThanOrEqualTo(this.high);
    }

    public boolean contains(BigInt value) {
        return this.low.isLessThanOrEqualTo(value) && value.isLessThanOrEqualTo(this.high);
    }

    public Interval join(Interval other) {
        return new Interval(this.low.min(other.low), this.high.max(other.high));
    }

    public Interval widen(Interval other) {
        Bound lo = other.low.isLessThan(this.low) ? Bound.NEGINF : this.low;
        Bound up = this.high.isLessThan(other.high) ? Bound.POSINF : this.high;
        return new Interval(lo, up);
    }

    public Option<Interval> meet(Interval other) {
        return Interval.wellFormedOrNone(this.low.max(other.low), this.high.min(other.high));
    }

    private static Option<Interval> wellFormedOrNone(Bound lower, Bound higher) {
        return Interval.isWellFormed(lower, higher) ? Option.some(new Interval(lower, higher)) : Option.none();
    }

    public boolean subsetOrEqual(Interval other) {
        return other.low.isLessThanOrEqualTo(this.low) && this.high.isLessThanOrEqualTo(other.high);
    }

    public boolean equals(Object o) {
        return o instanceof Interval && this.isEqualTo((Interval)o);
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + this.low.hashCode();
        hash = 23 * hash + this.high.hashCode();
        return hash;
    }

    public boolean isEqualTo(Interval other) {
        return this.low.isEqualTo(other.low) && this.high.isEqualTo(other.high);
    }

    public boolean isLessThanZero() {
        return this.low.isNegative() && this.high.isNegative();
    }

    public boolean hasNegativeValues() {
        return this.low.isNegative();
    }

    public boolean isConstant() {
        return this.isFinite() && this.low.asInteger().isEqualTo(this.high.asInteger());
    }

    public boolean isFinite() {
        return this.low.isFinite() && this.high.isFinite();
    }

    public BigInt getSpan() {
        if (this.isFinite()) {
            return this.high.asInteger().sub(this.low.asInteger()).add(Bound.ONE);
        }
        return null;
    }

    public BigInt getConstant() {
        if (this.isConstant()) {
            return this.low.asInteger();
        }
        return null;
    }

    public Interval evalLessThanOrEqualToZero() {
        if (this.low.isPositive()) {
            return ZERO;
        }
        if (this.high.isPositive()) {
            return BOOLEANTOP;
        }
        return ONE;
    }

    public Interval evalLessThanZero() {
        if (this.low.isNegative()) {
            if (this.high.isNegative()) {
                return ONE;
            }
            return BOOLEANTOP;
        }
        return ZERO;
    }

    public Interval evalEqualToZero() {
        return this.equals(ZERO) ? ONE : (ZERO.subsetOrEqual(this) ? BOOLEANTOP : ZERO);
    }

    public Interval evalNotEqualToZero() {
        return this.equals(ZERO) ? ZERO : (ZERO.subsetOrEqual(this) ? BOOLEANTOP : ONE);
    }

    public Interval add(Interval other) {
        return new Interval(this.low.add(other.low), this.high.add(other.high));
    }

    public Interval add(BigInt scalar) {
        return this.add(Interval.of(scalar));
    }

    public Interval sub(Interval other) {
        return new Interval(this.low.sub(other.high), this.high.sub(other.low));
    }

    public Interval sub(BigInt scalar) {
        return this.sub(Interval.of(scalar));
    }

    public Interval mul(Interval other) {
        Bound w = this.low.mul(other.low);
        Bound x = this.low.mul(other.high);
        Bound y = this.high.mul(other.low);
        Bound z = this.high.mul(other.high);
        return new Interval(w.min(x.min(y.min(z))), w.max(x.max(y.max(z))));
    }

    public Interval mul(BigInt scalar) {
        return this.mul(Interval.of(scalar));
    }

    public Interval divRoundInvards(BigInt scalar) {
        if (scalar.isZero()) {
            return ZERO;
        }
        BigInt divisor = scalar;
        Interval interval = this;
        if (divisor.isNegative()) {
            interval = interval.negate();
            divisor = divisor.negate();
        }
        Bound newLow = interval.low.divRoundUp(divisor);
        Bound newHigh = interval.high.divRoundDown(divisor);
        if (newHigh.isLessThan(newLow)) {
            return null;
        }
        return new Interval(newLow, newHigh);
    }

    public Interval divRoundZero(Interval divisor) {
        Interval dividend = this;
        Option<Interval> rightOfZero = divisor.meet(Interval.upFrom(1L));
        Option<Interval> leftOfZero = divisor.meet(Interval.downFrom(-1L));
        Option<Interval> result = Option.none();
        if (leftOfZero.isSome()) {
            result = Interval.join(result, dividend.negate().divRoundDown(leftOfZero.get().negate()));
        }
        if (rightOfZero.isSome()) {
            result = Interval.join(result, dividend.divRoundDown(rightOfZero.get()));
        }
        if (divisor.contains(Bound.ZERO)) {
            result = Interval.join(result, ZERO);
        }
        return result.get();
    }

    private static Option<Interval> join(Option<Interval> first, Interval second) {
        if (first.isNone()) {
            return Option.some(second);
        }
        return Option.some(first.get().join(second));
    }

    private Interval divRoundDown(Interval other) {
        assert (!other.hasNegativeValues());
        Interval newLow = this.divRoundDown(other.low);
        Interval newHigh = this.divRoundDown(other.high);
        return newLow.join(newHigh);
    }

    private Interval divRoundDown(Bound scalar) {
        Bound lower = this.low.divRoundDown(scalar);
        Bound upper = this.high.divRoundDown(scalar);
        return Interval.of(lower, upper);
    }

    public Interval shl(Interval other) {
        Bound w = this.low.shl(other.low);
        Bound x = this.low.shl(other.high);
        Bound y = this.high.shl(other.low);
        Bound z = this.high.shl(other.high);
        return new Interval(w.min(x.min(y.min(z))), w.max(x.max(y.max(z))));
    }

    public Interval shr(Interval other) {
        BigInt highest = BigInt.of(Integer.MAX_VALUE);
        int hDiv = other.high.min((Bound)highest).asInteger().intValue();
        assert (!other.hasNegativeValues());
        BigInt lowest = Bound.ZERO;
        int lDiv = other.low.max((Bound)lowest).asInteger().intValue();
        Interval divisor = Interval.of(BigInt.powerOfTwo(lDiv), BigInt.powerOfTwo(hDiv));
        return this.divRoundDown(divisor);
    }

    public Interval negate() {
        return new Interval(this.high.negate(), this.low.negate());
    }

    public Interval slowUnsignedOr(Interval other) {
        if (!this.isFinite() || this.hasNegativeValues()) {
            return GREATER_THAN_OR_EQUAL_TO_ZERO;
        }
        BigInt min = this.high.add(other.high).asInteger();
        BigInt max = Bound.ZERO;
        for (BigInt x : this) {
            for (BigInt y : other) {
                BigInt t = x.or(y);
                if (t.isLessThan(min)) {
                    min = t;
                }
                if (!max.isLessThan(t)) continue;
                max = t;
            }
        }
        return Interval.of(min, max);
    }

    public Interval slowUnsignedAnd(Interval other) {
        if (!this.isFinite() || this.hasNegativeValues()) {
            return GREATER_THAN_OR_EQUAL_TO_ZERO;
        }
        BigInt min = this.high.add(other.high).asInteger();
        BigInt max = Bound.ZERO;
        for (BigInt x : this) {
            for (BigInt y : other) {
                BigInt t = x.and(y);
                if (t.isLessThan(min)) {
                    min = t;
                }
                if (!max.isLessThan(t)) continue;
                max = t;
            }
        }
        return Interval.of(min, max);
    }

    public Interval slowUnsignedXor(Interval other) {
        if (!this.isFinite() || this.hasNegativeValues()) {
            return GREATER_THAN_OR_EQUAL_TO_ZERO;
        }
        BigInt min = this.high.add(other.high).asInteger();
        BigInt max = Bound.ZERO;
        for (BigInt x : this) {
            for (BigInt y : other) {
                BigInt t = x.xor(y);
                if (t.isLessThan(min)) {
                    min = t;
                }
                if (!max.isLessThan(t)) continue;
                max = t;
            }
        }
        return Interval.of(min, max);
    }

    public Interval unsignedOr(Interval other) {
        if (!this.isFinite() || this.hasNegativeValues()) {
            return GREATER_THAN_OR_EQUAL_TO_ZERO;
        }
        BigInt a = this.low.asInteger();
        BigInt b = this.high.asInteger();
        BigInt c = other.low.asInteger();
        BigInt d = other.high.asInteger();
        BigInt minOr = BigInt.minOr(a, b, c, d);
        BigInt maxOr = BigInt.maxOr(a, b, c, d);
        return Interval.of(minOr, maxOr);
    }

    public Interval unsignedAnd(Interval other) {
        if (!this.isFinite() || this.hasNegativeValues()) {
            return GREATER_THAN_OR_EQUAL_TO_ZERO;
        }
        BigInt a = this.low.asInteger();
        BigInt b = this.high.asInteger();
        BigInt c = other.low.asInteger();
        BigInt d = other.high.asInteger();
        BigInt minAnd = BigInt.minAnd(a, b, c, d);
        BigInt maxAnd = BigInt.maxAnd(a, b, c, d);
        return Interval.of(minAnd, maxAnd);
    }

    public Interval unsignedXor(Interval other) {
        if (!this.isFinite() || this.hasNegativeValues()) {
            return GREATER_THAN_OR_EQUAL_TO_ZERO;
        }
        BigInt a = this.low.asInteger();
        BigInt b = this.high.asInteger();
        BigInt c = other.low.asInteger();
        BigInt d = other.high.asInteger();
        BigInt minXor = BigInt.minXor(a, b, c, d);
        BigInt maxXor = BigInt.maxXor(a, b, c, d);
        return Interval.of(minXor, maxXor);
    }

    @Override
    public Iterator<BigInt> iterator() throws UnsupportedOperationException {
        if (!this.isFinite()) {
            throw new UnsupportedOperationException("Can not interate over infinite intervals");
        }
        return new IntervalIterator(this.low.asInteger(), this.high.asInteger());
    }

    public Iterator<BigInt> iteratorWithStride(BigInt stride) {
        if (!this.isFinite()) {
            throw new UnsupportedOperationException("Can not interate over infinite intervals");
        }
        return new IntervalIterator(this.low.asInteger(), this.high.asInteger(), stride);
    }

    @Override
    public XMLBuilder toXML(XMLBuilder builder) {
        return builder.e("Interval").t(this.toString()).up();
    }

    public String toString() {
        if (this.isConstant()) {
            String fmt = "[%s]";
            return String.format(fmt, this.low);
        }
        String fmt = "[%s, %s]";
        return String.format(fmt, this.low, this.high);
    }

    public void toStringDotted(StringBuilder builder) {
        if (!this.isConstant()) {
            builder.append('[');
        }
        builder.append(this.low.toString());
        if (this.isConstant()) {
            return;
        }
        builder.append("..");
        builder.append(this.high.toString());
        builder.append(']');
    }

    public boolean isTop() {
        return !this.low.isFinite() && !this.high.isFinite();
    }

    public int intervalSize() {
        assert (this.isFinite());
        int offset = this.low().asInteger().intValue();
        int size = this.high().asInteger().intValue() - offset + 1;
        return size;
    }

    public Interval applyCongruence(Congruence c) {
        BigInt offset = c.getOffset();
        BigInt scale = c.getScale();
        Bound lo = this.low.isFinite() ? this.low.asInteger().sub(offset).divRoundUp(scale).mul(scale).add(offset) : this.low;
        Bound hi = this.high.isFinite() ? this.high.asInteger().sub(offset).divRoundDown(scale).mul(scale).add(offset) : this.high;
        return Interval.of(lo, hi);
    }

    private static class IntervalIterator
    implements Iterator<BigInt> {
        private BigInt low;
        private final BigInt high;
        private final BigInt stride;

        private IntervalIterator(BigInt low, BigInt high, BigInt stride) {
            this.low = low;
            this.high = high;
            assert (!stride.isNegative());
            if (stride.isZero()) {
                assert (low.isEqualTo(high));
                this.stride = BigInt.ONE;
            } else {
                this.stride = stride;
            }
        }

        private IntervalIterator(BigInt low, BigInt high) {
            this(low, high, Bound.ONE);
        }

        @Override
        public boolean hasNext() {
            return !this.high.isLessThan(this.low);
        }

        @Override
        public BigInt next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BigInt next = this.low;
            this.low = this.low.add(this.stride);
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class StringParser {
        private StringParser() {
        }

        public static Interval parseInterval(String interval) {
            String[] split = (interval = StringParser.removeBraces(interval)).split(",");
            if (split.length == 1) {
                return Interval.of(StringParser.parseNumber(split[0].trim()));
            }
            String left = split[0].trim();
            String right = split[1].trim();
            boolean leftIsInfinity = left.equals(Bound.NEGINF.toString());
            boolean rightIsInfinity = right.equals(Bound.POSINF.toString());
            if (leftIsInfinity && rightIsInfinity) {
                return Interval.top();
            }
            if (leftIsInfinity) {
                return Interval.downFrom(StringParser.parseNumber(right));
            }
            if (rightIsInfinity) {
                return Interval.upFrom(StringParser.parseNumber(left));
            }
            return Interval.of(StringParser.parseNumber(left), StringParser.parseNumber(right));
        }

        private static long parseNumber(String number) {
            int radix = 10;
            if (number.toLowerCase().startsWith("0x")) {
                radix = 16;
                number = number.substring(2);
            }
            return Long.parseLong(number, radix);
        }

        private static String removeBraces(String interval) {
            boolean hasClosingBrace;
            boolean hasOpeningBrace = interval.startsWith("[");
            if (hasOpeningBrace != (hasClosingBrace = interval.endsWith("]"))) {
                throw new NumberFormatException("\"" + interval + "\" needs to either be enclosed by braces or not have braces at all.");
            }
            if (hasOpeningBrace) {
                return interval.substring(1, interval.length() - 1);
            }
            return interval;
        }
    }
}

