/*
 * Decompiled with CFR 0.152.
 */
package gdsl.arch;

import gdsl.Frontend;
import gdsl.IFrontendConfig;
import gdsl.arch.ArchId;
import gdsl.arch.IConfigFlag;

public abstract class ArchBinder
implements IFrontendConfig {
    private Frontend frontend;
    private long configVector = 0L;

    public Frontend getFrontend() {
        return this.frontend;
    }

    protected ArchBinder(Frontend frontend) {
        this.frontend = frontend;
        this.frontend.setConfig(this);
    }

    protected static boolean checkFrontend(ArchId archId, Frontend frontend) {
        return frontend.getName().equalsIgnoreCase(archId.libName());
    }

    protected static Frontend specific(Frontend[] frontendArray, ArchId archId) {
        for (Frontend frontend : frontendArray) {
            if (!ArchBinder.checkFrontend(archId, frontend)) continue;
            return frontend;
        }
        throw new IllegalArgumentException("Unable to find frontend " + archId.toString() + "...");
    }

    public ArchBinder setConfigFlag(IConfigFlag iConfigFlag) {
        this.configVector |= iConfigFlag.getFlag();
        return this;
    }

    public ArchBinder resetConfigFlag(IConfigFlag iConfigFlag) {
        this.configVector &= iConfigFlag.getFlag() ^ 0xFFFFFFFFFFFFFFFFL;
        return this;
    }

    public ArchBinder resetConfig() {
        this.configVector = 0L;
        return this;
    }

    @Override
    public long vector() {
        return this.configVector;
    }
}

