/*
 * Decompiled with CFR 0.152.
 */
package bindis.x86.x64;

import bindis.x86.common.X86RegOpnd;

public class AMD64FloatRegisters {
    public static final X86RegOpnd XMM0 = AMD64FloatRegisters.mk(0);
    public static final X86RegOpnd XMM1 = AMD64FloatRegisters.mk(1);
    public static final X86RegOpnd XMM2 = AMD64FloatRegisters.mk(2);
    public static final X86RegOpnd XMM3 = AMD64FloatRegisters.mk(3);
    public static final X86RegOpnd XMM4 = AMD64FloatRegisters.mk(4);
    public static final X86RegOpnd XMM5 = AMD64FloatRegisters.mk(5);
    public static final X86RegOpnd XMM6 = AMD64FloatRegisters.mk(6);
    public static final X86RegOpnd XMM7 = AMD64FloatRegisters.mk(7);
    public static final X86RegOpnd XMM8 = AMD64FloatRegisters.mk(8);
    public static final X86RegOpnd XMM9 = AMD64FloatRegisters.mk(9);
    public static final X86RegOpnd XMM10 = AMD64FloatRegisters.mk(10);
    public static final X86RegOpnd XMM11 = AMD64FloatRegisters.mk(11);
    public static final X86RegOpnd XMM12 = AMD64FloatRegisters.mk(12);
    public static final X86RegOpnd XMM13 = AMD64FloatRegisters.mk(13);
    public static final X86RegOpnd XMM14 = AMD64FloatRegisters.mk(14);
    public static final X86RegOpnd XMM15 = AMD64FloatRegisters.mk(15);
    public static final int NUM_REGIXMMERS = 16;
    private static final X86RegOpnd[] registers = new X86RegOpnd[]{XMM0, XMM1, XMM2, XMM3, XMM4, XMM5, XMM6, XMM7, XMM8, XMM9, XMM10, XMM11, XMM12, XMM13, XMM14, XMM15};

    public static int getNumRegisters() {
        return 16;
    }

    public static X86RegOpnd getRegister(int regNum) {
        assert (regNum > -1 && regNum < 16) : "invalid float register number";
        return registers[regNum];
    }

    public static String getRegisterName(int i) {
        return "XMM(" + i + ")";
    }

    private static X86RegOpnd mk(int num) {
        return new X86RegOpnd(String.format("xmm%d", num), 128);
    }
}

