/*
 * Decompiled with CFR 0.152.
 */
package bindis.x86.common;

import bindis.DecodeStream;

public final class X86Sib {
    public static final int Sib_INDEX_OFFSET = 3;
    public static final int Sib_INDEX_MASK = 7;
    public static final int Sib_BASE_MASK = 7;
    public static final int Sib_SCALE_OFFSET = 6;
    public static final int Sib_SCALE_MASK = 3;
    private final int sib;

    public X86Sib(int sib) {
        this.sib = sib;
    }

    public int getIndex() {
        return this.sib >> 3 & 7;
    }

    public int getBase() {
        return this.sib & 7;
    }

    public int getScale() {
        return 1 << (this.sib >> 6 & 3);
    }

    public static X86Sib decode(DecodeStream in) {
        return new X86Sib(in.read8());
    }
}

