/*
 * Decompiled with CFR 0.152.
 */
package bindis.x86.common;

import bindis.x86.common.X86RegOpnd;

public class X86MMXRegisters {
    public static final int NUM_MMX_REGISTERS = 8;
    public static final X86RegOpnd MM0 = new X86RegOpnd("mm0", 64);
    public static final X86RegOpnd MM1 = new X86RegOpnd("mm1", 64);
    public static final X86RegOpnd MM2 = new X86RegOpnd("mm2", 64);
    public static final X86RegOpnd MM3 = new X86RegOpnd("mm3", 64);
    public static final X86RegOpnd MM4 = new X86RegOpnd("mm4", 64);
    public static final X86RegOpnd MM5 = new X86RegOpnd("mm5", 64);
    public static final X86RegOpnd MM6 = new X86RegOpnd("mm6", 64);
    public static final X86RegOpnd MM7 = new X86RegOpnd("mm7", 64);
    private static X86RegOpnd[] mmxRegisters = new X86RegOpnd[]{MM0, MM1, MM2, MM3, MM4, MM5, MM6, MM7};

    public static int getNumberOfRegisters() {
        return 8;
    }

    public static String getRegisterName(int regNum) {
        assert (regNum > -1 && regNum < 8) : "invalid MMX register number";
        return mmxRegisters[regNum].toString();
    }

    public static X86RegOpnd getRegister(int regNum) {
        assert (regNum > -1 && regNum < 8) : "invalid MMX register number";
        return mmxRegisters[regNum];
    }
}

