/*
 * Decompiled with CFR 0.152.
 */
package bindis.x86.common;

import bindis.NativeInstruction;
import bindis.x86.common.X86DecodeCtx;
import bindis.x86.common.X86Operand;
import bindis.x86.common.X86OperandDecoders;

public abstract class X86InstructionDecoder {
    protected String name;
    protected final X86OperandDecoders.AddrMode addrMode1;
    protected final int operandType1;
    protected final X86OperandDecoders.AddrMode addrMode2;
    protected final int operandType2;
    protected final X86OperandDecoders.AddrMode addrMode3;
    protected final int operandType3;

    public X86InstructionDecoder(String name) {
        this(name, null, -1, null, -1, null, -1);
    }

    public X86InstructionDecoder(String name, X86OperandDecoders.AddrMode addrMode1, int operandType1) {
        this(name, addrMode1, operandType1, null, -1, null, -1);
    }

    public X86InstructionDecoder(String name, X86OperandDecoders.AddrMode addrMode1, int operandType1, X86OperandDecoders.AddrMode addrMode2, int operandType2) {
        this(name, addrMode1, operandType1, addrMode2, operandType2, null, -1);
    }

    public X86InstructionDecoder(String name, X86OperandDecoders.AddrMode addrMode1, int operandType1, X86OperandDecoders.AddrMode addrMode2, int operandType2, X86OperandDecoders.AddrMode addrMode3, int operandType3) {
        this.name = name;
        this.operandType1 = operandType1;
        this.operandType2 = operandType2;
        this.operandType3 = operandType3;
        this.addrMode1 = addrMode1;
        this.addrMode2 = addrMode2;
        this.addrMode3 = addrMode3;
    }

    public NativeInstruction decode(X86DecodeCtx ctx) {
        X86InstructionDecoder decoder = this.lookupDecoder(ctx);
        if (decoder != null) {
            return decoder.decodeInstruction(ctx);
        }
        return null;
    }

    protected abstract NativeInstruction decodeInstruction(X86DecodeCtx var1);

    protected X86InstructionDecoder lookupDecoder(X86DecodeCtx ctx) {
        return this;
    }

    protected final X86Operand decodeOpnd1(X86DecodeCtx ctx) {
        if (this.addrMode1 != null && this.operandType1 != -1) {
            return this.addrMode1.decode(ctx, this.operandType1);
        }
        return null;
    }

    protected final X86Operand decodeOpnd2(X86DecodeCtx ctx) {
        if (this.addrMode2 != null && this.operandType2 != -1) {
            return this.addrMode2.decode(ctx, this.operandType2);
        }
        return null;
    }

    protected final X86Operand decodeOpnd3(X86DecodeCtx ctx) {
        if (this.addrMode3 != null && this.operandType3 != -1) {
            return this.addrMode3.decode(ctx, this.operandType3);
        }
        return null;
    }
}

