/*
 * Decompiled with CFR 0.152.
 */
package bindis.x86.common;

import bindis.x86.common.X86RegOpnd;

public class X86ControlRegisters {
    public static final int NUM_MMX_REGISTERS = 8;
    public static final X86RegOpnd CR0 = new X86RegOpnd("cr0", 32);
    public static final X86RegOpnd CR1 = new X86RegOpnd("cr1", 32);
    public static final X86RegOpnd CR2 = new X86RegOpnd("cr2", 32);
    public static final X86RegOpnd CR3 = new X86RegOpnd("cr3", 32);
    public static final X86RegOpnd CR4 = new X86RegOpnd("cr4", 32);
    public static final X86RegOpnd CR5 = new X86RegOpnd("cr5", 32);
    public static final X86RegOpnd CR6 = new X86RegOpnd("cr6", 32);
    public static final X86RegOpnd CR7 = new X86RegOpnd("cr7", 32);
    private static X86RegOpnd[] controlRegisters = new X86RegOpnd[]{CR0, CR1, CR2, CR3, CR4, CR5, CR6, CR7};

    public static int getNumberOfRegisters() {
        return 8;
    }

    public static String getRegisterName(int regNum) {
        assert (regNum > -1 && regNum < 8) : "invalid control register number";
        return controlRegisters[regNum].toString();
    }

    public static X86RegOpnd getRegister(int regNum) {
        assert (regNum > -1 && regNum < 8) : "invalid control register number";
        return controlRegisters[regNum];
    }
}

