/*
 * Decompiled with CFR 0.152.
 */
package bindis.avr8;

import bindis.avr8.AVRImmOpnd;
import bindis.avr8.AVRInsn;
import bindis.avr8.AVRMemOpnd;
import bindis.avr8.AVROpnd;
import bindis.avr8.AVRRegOpnd;
import bindis.avr8.OpndVisitor;
import java.util.LinkedList;
import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.OperandTree;
import rreil.disassembler.translators.common.TranslationException;
import rreil.lang.lowlevel.LowLevelRReil;

public final class AVRTreeTranslator
implements OpndVisitor<OperandTree.NodeBuilder, OperandTree.NodeBuilder> {
    private static final AVRInstructionFactory factory = new AVRInstructionFactory();
    public static final AVRTreeTranslator $ = new AVRTreeTranslator();
    public final String $PostIncrementOperator = "++";
    public final String $PreDecrementOperator = "--";

    private AVRTreeTranslator() {
    }

    public Instruction translate(AVRInsn insn) {
        String mnemonic = insn.mnemonic();
        LinkedList<OperandTree> opnds = new LinkedList<OperandTree>();
        for (int i = 0; i < insn.numberOfOperands(); ++i) {
            opnds.add(new OperandTree(this.translate((AVROpnd)insn.operand(i))));
        }
        return new Instruction.InstructionBuilder(factory).address(insn.address()).mnemonic(mnemonic).link(opnds).opcode(insn.opcode()).build();
    }

    public OperandTree.Node translate(AVROpnd opnd) {
        OperandTree.NodeBuilder root = new OperandTree.NodeBuilder();
        OperandTree.Node child = opnd.accept(this, new OperandTree.NodeBuilder()).build();
        return root.type(OperandTree.Type.Size).data(opnd.size()).link(child).build();
    }

    @Override
    public OperandTree.NodeBuilder visit(AVRRegOpnd opnd, OperandTree.NodeBuilder root) {
        return root.type(OperandTree.Type.Sym).data(opnd.name());
    }

    @Override
    public OperandTree.NodeBuilder visit(AVRImmOpnd opnd, OperandTree.NodeBuilder root) {
        return root.type(OperandTree.Type.Immi).data(opnd.getValue());
    }

    @Override
    public OperandTree.NodeBuilder visit(AVRMemOpnd opnd, OperandTree.NodeBuilder root) {
        root.type(OperandTree.Type.Mem).data(opnd.ptrSize());
        OperandTree.Node reg = null;
        if (opnd.getMemReg() != null) {
            OperandTree.Node node = opnd.getMemReg().accept(new AVRTreeTranslator(), new OperandTree.NodeBuilder()).build();
            switch (opnd.getAltType()) {
                case None: {
                    reg = node;
                    break;
                }
                case PostIncrement: {
                    reg = new OperandTree.NodeBuilder().type(OperandTree.Type.Op).data("++").link(node).build();
                    break;
                }
                case PreDecrement: {
                    reg = new OperandTree.NodeBuilder().type(OperandTree.Type.Op).data("--").link(node).build();
                }
            }
        }
        OperandTree.Node imm = null;
        if (opnd.getDisplacement() != null) {
            imm = opnd.getDisplacement().accept(this, new OperandTree.NodeBuilder()).build();
        }
        if (reg != null && imm != null) {
            OperandTree.NodeBuilder addressTree = new OperandTree.NodeBuilder().type(OperandTree.Type.Op).data("+").link(reg).link(imm);
            return root.link(addressTree.build());
        }
        if (reg != null) {
            return root.link(reg);
        }
        return root.link(imm);
    }

    private static class AVRInstruction
    extends Instruction {
        public AVRInstruction(long address, byte[] opcode, String mnemonic, List<OperandTree> opnds) {
            super(address, opcode, mnemonic, opnds);
        }

        @Override
        public List<LowLevelRReil> toRReilInstructions() throws TranslationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class AVRInstructionFactory
    implements Instruction.InstructionFactory {
        private AVRInstructionFactory() {
        }

        @Override
        public Instruction build(long address, byte[] opcode, String mnemonic, List<OperandTree> opnds) {
            return new AVRInstruction(address, opcode, mnemonic, opnds);
        }
    }
}

