/*
 * Decompiled with CFR 0.152.
 */
package bindead.environment.platform;

import bindead.analyses.Bootstrap;
import bindead.domainnetwork.interfaces.RootDomain;
import bindis.Disassembler;
import rreil.lang.MemVar;
import rreil.lang.Rhs;

public abstract class Platform {
    private final Disassembler disassembler;
    private final String platformName;

    public Platform(Disassembler disassembler) {
        this.disassembler = disassembler;
        this.platformName = disassembler.getArchitectureName();
    }

    public String getName() {
        return this.platformName;
    }

    public abstract Bootstrap forwardAnalysisBootstrap();

    public abstract String getStackPointer();

    public abstract String getInstructionPointer();

    @Deprecated
    public abstract MemVar getStackRegion();

    public int defaultArchitectureSize() {
        return this.disassembler.defaultArchitectureSize();
    }

    public Disassembler getDisassembler() {
        return this.disassembler;
    }

    public Rhs.Rvar getRegisterAsVariable(String name) {
        return (Rhs.Rvar)this.disassembler.translateIdentifier(name).toRReil();
    }

    protected <D extends RootDomain<D>> D initializeStackPointer(D state) {
        state = (RootDomain)state.eval(String.format("prim addRegisters (%s.%d)", this.getStackPointer(), this.defaultArchitectureSize()));
        state = (RootDomain)state.eval(String.format("prim (%s.%d) = currentStackFrameAddress ()", this.getStackPointer(), this.defaultArchitectureSize()));
        return (D)state;
    }

    protected <D extends RootDomain<D>> D initializeInstructionPointer(D state, long initialPC) {
        state = (RootDomain)state.eval(String.format("prim addRegisters (%s.%d)", this.getInstructionPointer(), this.defaultArchitectureSize()));
        state = (RootDomain)state.eval(String.format("mov.%d %s, %d", this.defaultArchitectureSize(), this.getInstructionPointer(), initialPC));
        return (D)state;
    }
}

