/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.segments.heap;

import bindead.domains.segments.heap.HeapRegion;
import bindead.domains.segments.heap.PathString;
import javalx.numeric.Range;
import rreil.lang.MemVar;

public class ConnectorId
implements Comparable<ConnectorId> {
    public final MemVar src;
    public final PathString pathString;
    public final MemVar tgt;

    public ConnectorId(MemVar src, PathString pathString, MemVar tgt) {
        this.src = src;
        this.pathString = pathString;
        this.tgt = tgt;
    }

    @Override
    public int compareTo(ConnectorId other) {
        int c1 = this.src.compareTo(other.src);
        if (c1 != 0) {
            return c1;
        }
        int c2 = this.tgt.compareTo(other.tgt);
        if (c2 != 0) {
            return c2;
        }
        int c3 = this.pathString.compareTo(other.pathString);
        return c3;
    }

    public boolean attachedTo(MemVar node) {
        return this.src.equals(node) || this.tgt.equals(node);
    }

    boolean comesFrom(MemVar from, Range ofs) {
        return from.equals(this.src) && this.pathString.is(ofs);
    }

    public boolean isSelfLoop() {
        return this.src.equals(this.tgt);
    }

    ConnectorId renameEdgeNodeConnections(MemVar to, MemVar from) {
        MemVar sa = this.src.equals(from) ? to : this.src;
        MemVar ta = this.tgt.equals(from) ? to : this.tgt;
        return new ConnectorId(sa, this.pathString, ta);
    }

    public String toString() {
        return this.src + "--" + this.pathString.prefix + "-->" + this.tgt;
    }

    public boolean spans(MemVar perm, MemVar eph) {
        return this.spansFrom(perm) && this.spansTo(eph);
    }

    public boolean spansFrom(HeapRegion node) {
        return this.spansFrom(node.memId);
    }

    public boolean spansFrom(MemVar mv) {
        return this.src.equals(mv);
    }

    public boolean spansTo(HeapRegion node) {
        return this.spansTo(node.memId);
    }

    public boolean spansTo(MemVar mv) {
        return this.tgt.equals(mv);
    }

    ConnectorId bendSrcTo(HeapRegion src) {
        return new ConnectorId(src.memId, this.pathString, this.tgt);
    }

    ConnectorId bendTgtTo(HeapRegion tgt) {
        return new ConnectorId(this.src, this.pathString, tgt.memId);
    }

    public boolean attachedTo(MemVar region, Range offsetRange) {
        return this.attachedTo(region) && this.pathString.is(offsetRange);
    }

    public ConnectorId moveConnector(MemVar from, MemVar to) {
        MemVar newSrc = this.spansFrom(from) ? to : this.src;
        MemVar newtgt = this.spansTo(from) ? to : this.tgt;
        return new ConnectorId(newSrc, this.pathString, newtgt);
    }

    public boolean spansFrom(MemVar region, PathString pathString2) {
        return this.spansFrom(region) && this.pathString.is(pathString2);
    }
}

