/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.predicates.finite;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteFactory;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.interfaces.FiniteDomain;
import bindead.domains.predicates.finite.PredicatesState;
import bindead.domains.predicates.finite.PredicatesStateBuilder;
import bindead.exceptions.Unreachable;
import javalx.data.products.P2;
import javalx.numeric.BigInt;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.AVLSet;
import javalx.persistentcollections.FiniteMap;

class Entailment {
    private static final FiniteFactory finite = FiniteFactory.getInstance();

    Entailment() {
    }

    public static AVLSet<Finite.Test> equalitiesToTests(SetOfEquations equalities) {
        AVLSet<Finite.Test> result = AVLSet.empty();
        for (Linear equality : equalities) {
            Finite.Test test = finite.equalToZero(finite.linear(0, equality));
            result = result.add(test);
        }
        return result;
    }

    public static AVLSet<Finite.Test> getSyntacticallyEntailed(Finite.Test test, PredicatesStateBuilder builder) {
        AVLSet<Finite.Test> result = AVLSet.empty();
        AVLSet<PredicatesState.Flag> flags = Entailment.getSyntacticallyForwardEntailed(test, builder);
        for (PredicatesState.Flag flag : flags) {
            result = result.union(builder.getPredicates(flag));
        }
        return result;
    }

    private static AVLSet<PredicatesState.Flag> getSyntacticallyForwardEntailed(Finite.Test test, PredicatesStateBuilder builder) {
        AVLSet<PredicatesState.Flag> empty = AVLSet.empty();
        Linear linear = test.toLinear();
        if (!linear.isSingleTerm()) {
            return empty;
        }
        NumVar variable = linear.getKey();
        if (!builder.isFlag(variable)) {
            return empty;
        }
        boolean flagValuation = true;
        BigInt constant = linear.getConstant().negate();
        switch (test.getOperator()) {
            case Equal: {
                if (constant.isZero()) {
                    flagValuation = false;
                    break;
                }
                if (constant.isOne()) {
                    flagValuation = true;
                    break;
                }
                return empty;
            }
            case NotEqual: {
                if (constant.isZero()) {
                    flagValuation = true;
                    break;
                }
                if (constant.isOne()) {
                    flagValuation = false;
                    break;
                }
                return empty;
            }
            default: {
                return empty;
            }
        }
        return AVLSet.singleton(PredicatesState.Flag.toFlag(variable, flagValuation));
    }

    public static <D extends FiniteDomain<D>> AVLSet<Finite.Test> getSemanticallyEntailed(D childState, VarSet modifiedVars, PredicatesStateBuilder builder) {
        AVLSet<Finite.Test> result = AVLSet.empty();
        AVLSet<PredicatesState.Flag> flags = Entailment.getSemanticallyForwardEntailed(childState, modifiedVars, builder);
        for (PredicatesState.Flag flag : flags) {
            result = result.union(builder.getPredicates(flag));
        }
        flags = Entailment.getSemanticallyBackwardEntailed(childState, modifiedVars, builder);
        for (PredicatesState.Flag flag : flags) {
            result = result.add(flag.asTest());
        }
        return result;
    }

    private static <D extends FiniteDomain<D>> AVLSet<PredicatesState.Flag> getSemanticallyForwardEntailed(D childState, VarSet modifiedVars, PredicatesStateBuilder builder) {
        AVLSet<PredicatesState.Flag> result = AVLSet.empty();
        AVLSet<PredicatesState.Flag> occurrences = builder.getFlagsFromVars(modifiedVars);
        for (PredicatesState.Flag flag : occurrences) {
            Finite.Test flagTest = flag.asTest();
            if (!Entailment.isSemanticallyEntailedIn(flagTest, childState)) continue;
            result = result.add(flag);
        }
        return result;
    }

    private static <D extends FiniteDomain<D>> AVLSet<PredicatesState.Flag> getSemanticallyBackwardEntailed(D childState, VarSet modifiedVars, PredicatesStateBuilder builder) {
        AVLSet<PredicatesState.Flag> result = AVLSet.empty();
        AVLSet<PredicatesState.Flag> occurrences = builder.getOccurrencesOf(modifiedVars);
        for (PredicatesState.Flag flag : occurrences) {
            boolean negatedFlagInferred = false;
            AVLSet<Finite.Test> predicates = builder.getPredicates(flag);
            for (Finite.Test predicate : predicates) {
                if (!predicate.getVars().containsAny(modifiedVars) || !Entailment.isNegationSemanticallyEntailedIn(predicate, childState)) continue;
                negatedFlagInferred = true;
                break;
            }
            if (!negatedFlagInferred) continue;
            result = result.add(flag.negate());
        }
        return result;
    }

    private static <D extends FiniteDomain<D>> boolean isSemanticallyEntailedIn(Finite.Test test, D childState) {
        return Entailment.isNegationSemanticallyEntailedIn(test.not(), childState);
    }

    private static <D extends FiniteDomain<D>> boolean isNegationSemanticallyEntailedIn(Finite.Test test, D childState) {
        try {
            childState.eval(test);
        }
        catch (Unreachable _) {
            return true;
        }
        return false;
    }

    public static <D extends FiniteDomain<D>> boolean areAllImplicationsSemanticallyEntailed(AVLMap<PredicatesState.Flag, AVLSet<Finite.Test>> implications, D childState) {
        D newChildState = childState;
        for (P2<PredicatesState.Flag, AVLSet<Finite.Test>> p2 : implications) {
            PredicatesState.Flag premise = p2._1();
            try {
                newChildState = childState.eval(premise.asTest());
            }
            catch (Unreachable _) {
                continue;
            }
            AVLSet<Finite.Test> consequences = p2._2();
            for (Finite.Test consequence : consequences) {
                if (Entailment.isSemanticallyEntailedIn(consequence, newChildState)) continue;
                return false;
            }
        }
        return true;
    }

    public static <D extends FiniteDomain<D>> AVLMap<PredicatesState.Flag, AVLSet<Finite.Test>> getAllSemanticallyEntailedImplications(AVLMap<PredicatesState.Flag, AVLSet<Finite.Test>> implications, D childState) {
        FiniteMap result = AVLMap.empty();
        D newChildState = childState;
        for (P2<PredicatesState.Flag, AVLSet<Finite.Test>> p2 : implications) {
            PredicatesState.Flag premise = p2._1();
            AVLSet<Finite.Test> consequences = p2._2();
            try {
                newChildState = childState.eval(premise.asTest());
            }
            catch (Unreachable _) {
                result = ((AVLMap)result).bind(premise, consequences);
                continue;
            }
            for (Finite.Test consequence : consequences) {
                if (!Entailment.isSemanticallyEntailedIn(consequence, newChildState)) continue;
                AVLSet<Finite.Test> entailedConsequences = ((AVLMap)result).get(premise).getOrElse(AVLSet.empty());
                entailedConsequences = entailedConsequences.add(consequence);
                result = ((AVLMap)result).bind(premise, entailedConsequences);
            }
        }
        return result;
    }
}

