/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.pointsto;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteFactory;
import bindead.data.Linear;
import bindead.data.ListVarPair;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.debug.PrettyDomain;
import bindead.domainnetwork.channels.DebugChannel;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.channels.SynthChannel;
import bindead.domainnetwork.combinators.FiniteFunctor;
import bindead.domainnetwork.interfaces.FiniteDomain;
import bindead.domains.pointsto.HyperPointsToSet;
import bindead.domains.pointsto.MakeCompatibleWorker;
import bindead.domains.pointsto.PointsToProperties;
import bindead.domains.pointsto.PointsToSet;
import bindead.domains.pointsto.PointsToState;
import bindead.domains.pointsto.PointsToStateBuilder;
import bindead.domains.pointsto.RhsTranslator;
import bindead.domains.pointsto.TestTranslator;
import bindead.domains.segments.warnings.IllegalPointerArithmetics;
import bindead.exceptions.Unreachable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.data.products.P3;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Interval;
import javalx.numeric.Range;
import javalx.persistentcollections.AVLSet;
import rreil.lang.util.Type;

public final class PointsTo<D extends FiniteDomain<D>>
extends FiniteFunctor<PointsToState, D, PointsTo<D>> {
    protected final boolean DEBUGOTHER;
    public static final String NAME = "POINTSTO";
    private static final FiniteFactory fin = FiniteFactory.getInstance();
    private static final boolean checkSupport = false;

    public PointsTo(D child) {
        super(NAME, PointsToState.EMPTY, child);
        this.DEBUGOTHER = PointsToProperties.INSTANCE.debugOther.isTrue();
    }

    private PointsTo(PointsToState state, D childState) {
        super(NAME, state, childState);
        this.DEBUGOTHER = PointsToProperties.INSTANCE.debugOther.isTrue();
    }

    protected void msg(String msg) {
        if (this.DEBUGOTHER) {
            System.out.println("\n" + this.name + ": " + msg);
        }
    }

    @Override
    public P3<PointsToState, D, D> makeCompatible(PointsTo<D> other, boolean isWideningPoint) {
        MakeCompatibleWorker<FiniteDomain> worker = new MakeCompatibleWorker<FiniteDomain>((PointsToState)this.state, (PointsToState)other.state);
        return worker.makeCompatible((FiniteDomain)this.childState, (FiniteDomain)other.childState);
    }

    private D assumeConst(NumVar numVar, D childDomain, BigInt val) {
        return childDomain.eval(fin.equalTo(0, Linear.linear(numVar), Linear.linear(val)));
    }

    private D assumePtsIsNull(PointsToSet targets, D newChildState) {
        if (!targets.sumOfFlags.isConstantZero()) {
            this.assumeConst(targets.sumOfFlags.numVar, newChildState, Bound.ZERO);
        }
        for (PointsToSet.PointsToEntry p : targets) {
            newChildState = this.assumeConst(p.flag, newChildState, Bound.ZERO);
        }
        return newChildState;
    }

    @Override
    public PointsTo<D> build(PointsToState s, D cs) {
        PointsTo.checkSupportSet(s, cs);
        VarSet zeros = VarSet.empty();
        for (Linear x : this.getSynthChannel().getEquations()) {
            if (!x.isSingleTerm() || !x.getConstant().isZero()) continue;
            zeros = zeros.add(x.getKey());
        }
        for (PointsToSet pts : s.getPointsToMap()) {
            for (P2<NumVar.AddrVar, PointsToSet.PointsToEntry> p2 : pts.entryMap) {
                NumVar flag = p2._2().flag;
                boolean isZero = zeros.contains(flag) || cs.queryRange(flag).isZero();
                if (!isZero) continue;
                cs = cs.project(flag);
                s = s.removePtsEntry(pts.var, p2._1());
            }
        }
        return new PointsTo<D>(s, cs);
    }

    private static <D extends FiniteDomain<D>> void checkSupportSet(PointsToState s, D cs) {
    }

    private PointsTo<D> build(PointsToStateBuilder<D> builder) {
        FiniteDomain child = builder.applyChildOps((FiniteDomain)this.childState);
        return this.build(builder, (D)child);
    }

    @Override
    private PointsTo<D> build(PointsToStateBuilder<D> builder, D cs) {
        return this.build(builder.build(), cs);
    }

    @Override
    public PointsTo<D> copyAndPaste(VarSet vars, PointsTo<D> from) {
        PointsToStateBuilder<D> builder = new PointsToStateBuilder<D>((PointsToState)this.state);
        builder.copyAndPaste(vars, from);
        return this.build(builder);
    }

    @Override
    public P2<AVLSet<NumVar.AddrVar>, PointsTo<D>> deref(Finite.Rlin ptr) throws Unreachable {
        FiniteDomain cs = (FiniteDomain)this.childState;
        HyperPointsToSet hyperPtr = new RhsTranslator(0, (PointsToState)this.state, this.getContext().getWarningsChannel()).run(ptr);
        Linear toRestrict = hyperPtr.sumOfFlags;
        String msg = hyperPtr.toString();
        cs = this.restrictToZeroOneInterval(cs, toRestrict, msg);
        for (Object object : hyperPtr) {
        }
        AVLSet targets = AVLSet.empty();
        for (P2 p2 : hyperPtr.getTerms()) {
            targets = targets.add(p2._1());
        }
        return new P2<AVLSet<NumVar.AddrVar>, PointsTo<D>>(targets, this.build((PointsToState)this.state, (D)cs));
    }

    private D restrictToZeroOneInterval(D cs, Linear toRestrict, String msg) {
        Finite.Test t;
        Range sumRange = cs.queryRange(toRestrict);
        if (!sumRange.isFinite() || sumRange.getMax().isGreaterThan(BigInt.ONE)) {
            this.getContext().addWarning(new IllegalPointerArithmetics(msg));
            t = fin.unsignedLessThanOrEqualTo(0, toRestrict, Linear.ONE);
            cs = cs.eval(t);
        }
        if (!sumRange.isFinite() || sumRange.getMin().isLessThan(BigInt.ZERO)) {
            this.getContext().addWarning(new IllegalPointerArithmetics(msg));
            t = fin.unsignedLessThanOrEqualTo(0, Linear.ZERO, toRestrict);
            cs = cs.eval(t);
        }
        return cs;
    }

    @Override
    @Deprecated
    public List<P2<NumVar.AddrVar, PointsTo<D>>> deprecatedDeref(Finite.Rlin ptr, VarSet summaries) throws Unreachable {
        LinkedList<P2<NumVar.AddrVar, PointsTo<D>>> res = new LinkedList<P2<NumVar.AddrVar, PointsTo<D>>>();
        try {
            res.add(this.derefNullAlternative(ptr));
        }
        catch (Unreachable unreachable) {
            // empty catch block
        }
        HyperPointsToSet hyperPtr = new RhsTranslator(0, (PointsToState)this.state, this.getContext().getWarningsChannel()).run(ptr);
        Finite.Test testSumOfFlags = fin.equalTo(0, hyperPtr.sumOfFlags, Linear.ONE);
        for (P2<NumVar.AddrVar, Linear> p2 : hyperPtr.getTerms()) {
            try {
                Linear flagCoeff = p2._2();
                PointsToStateBuilder<FiniteDomain> altBuilder = new PointsToStateBuilder<FiniteDomain>((PointsToState)this.state);
                NumVar.AddrVar targetAddress = p2._1();
                PointsTo<FiniteDomain> altState = this.build(altBuilder.build(), (D)altBuilder.applyChildOps((FiniteDomain)this.childState));
                res.add(new P2<NumVar.AddrVar, PointsTo<FiniteDomain>>(targetAddress, altState));
                altBuilder.getChildOps().addTest(testSumOfFlags);
                if (summaries.contains(targetAddress)) continue;
                Finite.Test test = fin.equalTo(0, flagCoeff, Linear.ONE);
                altBuilder.getChildOps().addTest(test);
            }
            catch (Unreachable unreachable) {}
        }
        return res;
    }

    private P2<NumVar.AddrVar, PointsTo<D>> derefNullAlternative(Finite.Rlin ptr) {
        Linear.Term[] terms;
        FiniteDomain newChildState = (FiniteDomain)this.childState;
        for (Linear.Term term : terms = ptr.getLinearTerm().getTerms()) {
            NumVar varId = term.getId();
            PointsToSet targets = ((PointsToState)this.state).getPts(varId);
            newChildState = this.assumePtsIsNull(targets, newChildState);
        }
        PointsTo<FiniteDomain> dom = this.build((PointsToState)this.state, (D)newChildState);
        return new P2<Object, PointsTo<FiniteDomain>>(null, dom);
    }

    @Override
    public PointsTo<D> eval(Finite.Assign assign) {
        PointsToStateBuilder builder = new PointsToStateBuilder((PointsToState)this.state);
        int size = assign.getLhs().getSize();
        NumVar lhsVar = assign.getLhs().getId();
        Finite.Rhs rhs = assign.getRhs();
        assert (!lhsVar.isAddress());
        HyperPointsToSet hyperRhs = ((PointsToState)this.state).translate(assign.getLhs().getSize(), rhs, ((FiniteDomain)this.childState).getContext().getWarningsChannel());
        builder.evalAssign(size, lhsVar, hyperRhs);
        return this.build(builder);
    }

    @Override
    public PointsTo<D> eval(Finite.Test test) {
        this.msg("test " + test);
        PointsToStateBuilder builder = new PointsToStateBuilder((PointsToState)this.state);
        TestTranslator<FiniteDomain> testTranslator = new TestTranslator<FiniteDomain>(builder, ((FiniteDomain)this.childState).getContext().getWarningsChannel());
        Finite.Rlin le = fin.linear(test.getSize(), test.getLeftExpr());
        Finite.Rlin re = fin.linear(test.getSize(), test.getRightExpr());
        HyperPointsToSet left = ((PointsToState)this.state).translate(test.getSize(), le, this.getContext().getWarningsChannel());
        HyperPointsToSet right = ((PointsToState)this.state).translate(test.getSize(), re, this.getContext().getWarningsChannel());
        FiniteDomain cs = testTranslator.run((FiniteDomain)this.childState, test, left, right);
        assert (builder.getChildOps().isEmpty());
        if (cs == null) {
            throw new Unreachable();
        }
        return this.build(builder, (D)cs);
    }

    @Override
    public VarSet localSubset(VarSet vars) {
        VarSet res = VarSet.empty();
        for (NumVar var : vars) {
            if (!((PointsToState)this.state).isLocal(var)) continue;
            res.add(var);
        }
        return res;
    }

    @Override
    public PointsTo<D> introduce(NumVar variable, Type type, Option<BigInt> value) {
        PointsToStateBuilder builder = new PointsToStateBuilder((PointsToState)this.state);
        builder.introduce(variable, type);
        PointsTo res = this.build(builder.build(), ((FiniteDomain)this.childState).introduce(variable, type, value));
        return res;
    }

    @Override
    public PointsTo<D> project(NumVar var) {
        PointsToStateBuilder builder = new PointsToStateBuilder((PointsToState)this.state);
        builder.project(var, (QueryChannel)((Object)this.childState));
        return this.build(builder);
    }

    @Override
    public SetOfEquations queryEqualities(NumVar variable) {
        if (!((PointsToState)this.state).isScalar(variable)) {
            return SetOfEquations.empty();
        }
        VarSet toFilter = ((PointsToState)this.state).varsNotExportingEqualities().union(((PointsToState)this.state).getNonScalars());
        SetOfEquations eqs = ((FiniteDomain)this.childState).queryEqualities(variable);
        eqs = eqs.removeVariables(toFilter);
        return eqs;
    }

    @Override
    public SynthChannel getSynthChannel() {
        SynthChannel channel = ((FiniteDomain)this.childState).getSynthChannel();
        VarSet toFilter = this.localSubset(channel.getVariables()).union(((PointsToState)this.state).getNonScalars());
        return channel.removeVariables(toFilter);
    }

    @Override
    public DebugChannel getDebugChannel() {
        return new DebugChannel(((FiniteDomain)this.childState).getDebugChannel()){

            @Override
            public PointsToSet queryPointsToSet(NumVar variable) {
                return PointsTo.this.queryPts(variable);
            }
        };
    }

    PointsToSet queryPts(NumVar var) {
        return ((PointsToState)this.state).getPts(var);
    }

    @Override
    public Range queryRange(Linear lin) {
        HyperPointsToSet hpts = new HyperPointsToSet(0);
        Linear newLin = Linear.ZERO;
        if (((PointsToState)this.state).isScalar(lin)) {
            return ((FiniteDomain)this.childState).queryRange(lin);
        }
        for (Linear.Term term : lin) {
            BigInt coefficient = term.getCoeff();
            NumVar termVar = term.getId();
            for (PointsToSet.PointsToEntry p : ((PointsToState)this.state).getPts(termVar)) {
                hpts.addCoefficient(p.address, Linear.linear(coefficient, p.flag));
            }
            if (termVar.isAddress()) {
                hpts.addCoefficient((NumVar.AddrVar)termVar, Linear.linear(coefficient));
                continue;
            }
            newLin = newLin.add(Linear.linear(coefficient, termVar));
        }
        for (P2 p2 : hpts.getTerms()) {
            BigInt coeff = ((FiniteDomain)this.childState).queryRange((Linear)p2._2()).getConstantOrNull();
            if (coeff != null) {
                newLin = newLin.addTerm(coeff, (NumVar)p2._1());
                continue;
            }
            return Range.from(Interval.TOP);
        }
        newLin = newLin.add(lin.getConstant());
        Range r = ((FiniteDomain)this.childState).queryRange(newLin);
        return r;
    }

    @Override
    public PointsTo<D> substitute(NumVar x, NumVar y) {
        PointsToStateBuilder builder = new PointsToStateBuilder((PointsToState)this.state);
        builder.substitute(x, y);
        return this.build(builder);
    }

    @Override
    public PointsTo<D> assumeConcrete(NumVar var) {
        PointsToStateBuilder builder = new PointsToStateBuilder((PointsToState)this.state);
        builder.assumeConcrete(var);
        return this.build(builder);
    }

    @Override
    public PointsTo<D> assumePointsToAndConcretize(Finite.Rlin pointerVar, NumVar.AddrVar target, VarSet contents) {
        PointsToStateBuilder builder = new PointsToStateBuilder((PointsToState)this.state);
        HyperPointsToSet hyperRhs = ((PointsToState)this.state).translate(pointerVar.getSize(), pointerVar, ((FiniteDomain)this.childState).getContext().getWarningsChannel());
        builder.assumePointsTo(hyperRhs, target, contents);
        return this.build(builder);
    }

    @Override
    public Collection<NumVar.AddrVar> findPossiblePointerTargets(NumVar id) throws Unreachable {
        return ((PointsToState)this.state).findAllPossibleEdges(id);
    }

    @Override
    public void varToCompactString(StringBuilder builder, NumVar var) {
        PointsToSet pts = ((PointsToState)this.state).getPts(var);
        pts.appendInfo(builder, (PrettyDomain)((Object)this.childState));
    }

    @Override
    public Range queryEdgeFlag(NumVar src, NumVar.AddrVar tgt) {
        PointsToSet.PointsToEntry en = ((PointsToState)this.state).getPts(src).getEntry(tgt);
        if (en == null) {
            return Range.from(0L);
        }
        return ((FiniteDomain)this.childState).queryRange(en.flag);
    }

    @Override
    public PointsTo<D> assumeEdgeFlag(NumVar src, NumVar.AddrVar tgt, BigInt value) {
        PointsToSet.PointsToEntry en = ((PointsToState)this.state).getPts(src).getEntry(tgt);
        if (en == null) {
            if (value.isZero()) {
                return this;
            }
            throw new Unreachable();
        }
        Object cs = ((FiniteDomain)this.childState).eval(fin.equalTo(0, Linear.linear(en.flag), Linear.linear(value)));
        if (value.isZero()) {
            PointsToState s2 = ((PointsToState)this.state).removePtsEntry(src, tgt);
            cs = cs.project(en.flag);
            return this.build(s2, cs);
        }
        return this.build((PointsToState)this.state, cs);
    }

    @Override
    public PointsTo<D> copyVariable(NumVar to, NumVar from) {
        assert (!to.isAddress());
        assert (!from.isAddress());
        assert (((PointsToState)this.state).hasPts(from));
        PointsToStateBuilder builder = new PointsToStateBuilder((PointsToState)this.state);
        PointsToSet fromPts = ((PointsToState)this.state).getPts(from);
        PointsToSet targetPts = PointsToSet.empty(to);
        if (fromPts.hasGhostNode()) {
            NumVar newGhost = NumVar.fresh();
            targetPts = targetPts.withGhostNode(newGhost);
            builder.getChildOps().addHardcopy(newGhost, fromPts.outFlagOfGhostNode);
        }
        if (!fromPts.sumOfFlags.isConstantZero()) {
            NumVar newSumFlag = NumVar.fresh();
            targetPts = targetPts.withSumVar(newSumFlag);
            builder.getChildOps().addHardcopy(newSumFlag, fromPts.sumOfFlags.numVar);
        }
        for (PointsToSet.PointsToEntry entry : fromPts) {
            NumVar newFlag = NumVar.fresh();
            builder.getChildOps().addHardcopy(newFlag, entry.flag);
            targetPts = targetPts.bind(entry.address, newFlag);
        }
        builder.bindPts(targetPts);
        builder.getChildOps().addHardcopy(to, from);
        return this.build(builder);
    }

    @Override
    public PointsTo<D> assumeEdgeNG(Finite.Rlin pointerVar, NumVar.AddrVar targetAddr) {
        PointsToStateBuilder builder = new PointsToStateBuilder((PointsToState)this.state);
        HyperPointsToSet hyperRhs = ((PointsToState)this.state).translate(pointerVar.getSize(), pointerVar, ((FiniteDomain)this.childState).getContext().getWarningsChannel());
        builder.assumePointsTo(hyperRhs, targetAddr);
        return this.build(builder);
    }

    @Override
    public PointsTo<D> expandNG(ListVarPair nvps) {
        PointsToStateBuilder builder = new PointsToStateBuilder((PointsToState)this.state);
        builder.expandNG(nvps);
        return this.build(builder);
    }

    @Override
    public PointsTo<D> expandNG(NumVar.AddrVar summary, NumVar.AddrVar concrete, ListVarPair nvps) {
        PointsToStateBuilder builder = new PointsToStateBuilder((PointsToState)this.state);
        builder.expandNG(summary, concrete, nvps);
        return this.build(builder);
    }

    @Override
    public PointsTo<D> concretizeAndDisconnectNG(NumVar.AddrVar s, VarSet cs) {
        PointsToStateBuilder builder = new PointsToStateBuilder((PointsToState)this.state);
        builder.concretizeAndDisconnectNG(s, cs);
        return this.build(builder);
    }

    @Override
    public PointsTo<D> bendBackGhostEdgesNG(NumVar.AddrVar s, NumVar.AddrVar c, VarSet svs, VarSet cvs, VarSet pts, VarSet ptc) {
        PointsToStateBuilder builder = new PointsToStateBuilder((PointsToState)this.state);
        builder.bendBackGhostEdgesNG(s, c, svs, cvs, pts, ptc);
        return this.build(builder);
    }

    @Override
    public PointsTo<D> bendGhostEdgesNG(NumVar.AddrVar summary, NumVar.AddrVar concrete, VarSet svs, VarSet cvs, VarSet pts, VarSet ptc) {
        PointsToStateBuilder builder = new PointsToStateBuilder((PointsToState)this.state);
        builder.bendGhostEdgesNG(summary, concrete, svs, cvs, pts, ptc);
        return this.build(builder);
    }

    @Override
    public PointsTo<D> foldNG(NumVar.AddrVar p, NumVar.AddrVar e, ListVarPair nvps) {
        PointsToStateBuilder builder = new PointsToStateBuilder((PointsToState)this.state);
        builder.foldNG(p, e, nvps);
        return this.build(builder);
    }

    @Override
    public PointsTo<D> foldNG(ListVarPair nvps) {
        PointsToStateBuilder builder = new PointsToStateBuilder((PointsToState)this.state);
        builder.foldNG(nvps);
        return this.build(builder);
    }

    @Override
    public PointsTo<D> assumeVarsAreEqual(int size, NumVar fst, NumVar snd) {
        PointsToSet left = ((PointsToState)this.state).getPts(fst);
        PointsToSet right = ((PointsToState)this.state).getPts(snd);
        FiniteDomain cs = PointsTo.assumeSumsOfFlagsAreEqual(left, right, (FiniteDomain)this.childState);
        cs = PointsTo.assumeGhostFlagsAreEqual(left, right, cs);
        for (PointsToSet.PointsToEntry le : left) {
            PointsToSet.PointsToEntry re = right.getEntry(le.address);
            if (re == null) {
                cs = cs.eval(fin.equalToZero(0, le.flag));
                continue;
            }
            cs = cs.assumeVarsAreEqual(0, le.flag, re.flag);
        }
        for (PointsToSet.PointsToEntry re : right) {
            PointsToSet.PointsToEntry le = right.getEntry(re.address);
            if (le != null) continue;
            cs = cs.eval(fin.equalToZero(0, re.flag));
        }
        cs = cs.assumeVarsAreEqual(size, fst, snd);
        return this.build((PointsToState)this.state, (D)cs);
    }

    private static <D extends FiniteDomain<D>> D assumeSumsOfFlagsAreEqual(PointsToSet left, PointsToSet right, D cs) {
        if (left.sumOfFlags.isConstantZero() && !right.sumOfFlags.isConstantZero()) {
            cs = cs.eval(fin.equalToZero(0, right.sumOfFlags.numVar));
        } else if (!left.sumOfFlags.isConstantZero() && right.sumOfFlags.isConstantZero()) {
            cs = cs.eval(fin.equalToZero(0, left.sumOfFlags.numVar));
        } else if (!left.sumOfFlags.isConstantZero() && !right.sumOfFlags.isConstantZero()) {
            cs = cs.assumeVarsAreEqual(0, left.sumOfFlags.numVar, right.sumOfFlags.numVar);
        }
        return cs;
    }

    private static <D extends FiniteDomain<D>> D assumeGhostFlagsAreEqual(PointsToSet left, PointsToSet right, D cs) {
        if (!left.hasGhostNode() && right.hasGhostNode()) {
            cs = cs.eval(fin.equalToZero(0, right.outFlagOfGhostNode));
        } else if (left.hasGhostNode() && !right.hasGhostNode()) {
            cs = cs.eval(fin.equalToZero(0, left.outFlagOfGhostNode));
        } else if (left.hasGhostNode() && right.hasGhostNode()) {
            cs = cs.assumeVarsAreEqual(0, left.outFlagOfGhostNode, right.outFlagOfGhostNode);
        }
        return cs;
    }
}

