/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.pointsto;

import bindead.data.NumVar;
import bindead.domainnetwork.combinators.FiniteSequence;
import bindead.domainnetwork.interfaces.FiniteDomain;
import bindead.domains.pointsto.NumVarOrZero;
import bindead.domains.pointsto.PointsToMap;
import bindead.domains.pointsto.PointsToSet;
import bindead.domains.pointsto.PointsToState;
import bindead.domains.pointsto.PointsToStateBuilder;
import bindead.exceptions.DomainStateException;
import javalx.data.products.P3;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.ThreeWaySplit;

public class MakeCompatibleWorker<D extends FiniteDomain<D>> {
    final PointsToStateBuilder<D> builder1;
    final PointsToStateBuilder<D> builder2;

    public MakeCompatibleWorker(PointsToState state1, PointsToState state2) {
        this.builder1 = new PointsToStateBuilder(state1);
        this.builder2 = new PointsToStateBuilder(state2);
    }

    P3<PointsToState, D, D> makeCompatible(D cs1, D cs2) {
        this.level1_supportset();
        D fstchildState = this.builder1.applyChildOps(cs1);
        D sndchildState = this.builder2.applyChildOps(cs2);
        return new P3<PointsToState, D, D>(this.builder1.build(), fstchildState, sndchildState);
    }

    private void level1_supportset() {
        ThreeWaySplit<PointsToMap> split = this.builder1.pointsToMap.split(this.builder2.pointsToMap);
        if (!split.onlyInFirst().isEmpty()) {
            throw new DomainStateException.VariableSupportSetException("only in first: " + split.onlyInFirst().getSupport());
        }
        if (!split.onlyInSecond().isEmpty()) {
            throw new DomainStateException.VariableSupportSetException("only in second: " + split.onlyInSecond().getSupport());
        }
        for (PointsToSet fstPts : split.inBothButDiffering()) {
            this.level2_pointstoSet(fstPts);
        }
    }

    private void level2_pointstoSet(PointsToSet fst) {
        PointsToSet snd = this.builder2.getPts(fst.var);
        fst = this.level3a_sumFlags(fst, snd);
        fst = this.level3b_ghostEdges(fst, snd);
        fst = this.level3c_pointsToEntries(fst, snd);
        this.builder1.bindPts(fst);
    }

    private PointsToSet level3a_sumFlags(PointsToSet fst, PointsToSet snd) {
        NumVarOrZero fstSum = fst.sumOfFlags;
        NumVarOrZero sndSum = snd.sumOfFlags;
        boolean zeroSum = fstSum.isConstantZero();
        boolean zeroOtherSum = sndSum.isConstantZero();
        if (zeroSum && !zeroOtherSum) {
            this.builder1.getChildOps().addIntroZero(sndSum.numVar);
            fst = fst.withSumVar(sndSum.numVar);
        } else if (!zeroSum && zeroOtherSum) {
            this.builder2.getChildOps().addIntroZero(fstSum.numVar);
        } else if (!(zeroSum || zeroOtherSum || fstSum.equals(sndSum))) {
            this.builder2.getChildOps().addSubst(sndSum.numVar, fstSum.numVar);
        }
        return fst;
    }

    private PointsToSet level3b_ghostEdges(PointsToSet fst, PointsToSet snd) {
        FiniteSequence otherChildOps = this.builder2.getChildOps();
        boolean hasGhost = fst.hasGhostNode();
        boolean hasSndGhost = snd.hasGhostNode();
        if (!hasGhost && hasSndGhost) {
            this.builder1.getChildOps().addIntroZero(snd.outFlagOfGhostNode);
            fst = fst.withGhostNode(snd.outFlagOfGhostNode);
        } else if (hasGhost && !hasSndGhost) {
            otherChildOps.addIntroZero(fst.outFlagOfGhostNode);
        } else if (hasGhost && hasSndGhost && !fst.outFlagOfGhostNode.equalTo(snd.outFlagOfGhostNode)) {
            otherChildOps.addSubst(snd.outFlagOfGhostNode, fst.outFlagOfGhostNode);
        }
        return fst;
    }

    PointsToSet level3c_pointsToEntries(PointsToSet fst, PointsToSet snd) {
        ThreeWaySplit<AVLMap<NumVar.AddrVar, PointsToSet.PointsToEntry>> tws = fst.splitPts(snd);
        for (NumVar.AddrVar addrVar : tws.inBothButDiffering().keys()) {
            NumVar leftFlag = fst.getEntry((NumVar.AddrVar)addrVar).flag;
            NumVar rightFlag = snd.getEntry((NumVar.AddrVar)addrVar).flag;
            if (leftFlag == rightFlag) continue;
            assert (leftFlag != rightFlag) : "left " + leftFlag + " right " + rightFlag;
            this.builder2.getChildOps().addSubst(rightFlag, leftFlag);
        }
        for (PointsToSet.PointsToEntry pointsToEntry : tws.onlyInSecond().values()) {
            fst = fst.bind(pointsToEntry.address, pointsToEntry.flag);
            this.builder1.getChildOps().addIntroZero(pointsToEntry.flag);
        }
        for (PointsToSet.PointsToEntry pointsToEntry : tws.onlyInFirst().values()) {
            this.builder2.getChildOps().addIntroZero(pointsToEntry.flag);
        }
        return fst;
    }
}

