/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.intervals;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.ZenoFactory;
import bindead.abstractsyntax.zeno.util.ZenoTestHelper;
import bindead.data.Linear;
import bindead.data.NumVar;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Interval;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.FiniteMap;
import javalx.persistentcollections.MultiMap;

class SynthesizedPredicatesBuilder {
    private static final ZenoFactory zeno = ZenoFactory.getInstance();

    SynthesizedPredicatesBuilder() {
    }

    public static MultiMap<Zeno.Test, Zeno.Test> generateImplications(AVLMap<NumVar, Interval> differingFromThis, AVLMap<NumVar, Interval> allFromOther) {
        MultiMap<Zeno.Test, Zeno.Test> implications = MultiMap.empty();
        if (differingFromThis.isEmpty()) {
            return implications;
        }
        LinkedList<NumVar> predicateVariablesList = new LinkedList<NumVar>();
        FiniteMap boundsPredicatesInThis = AVLMap.empty();
        FiniteMap boundsPredicatesInOther = AVLMap.empty();
        for (NumVar variable : differingFromThis.keys()) {
            Interval valueInOther;
            Interval valueInThis = differingFromThis.getOrNull(variable);
            if (valueInThis.contains(valueInOther = allFromOther.getOrNull(variable)) || valueInOther.contains(valueInThis)) continue;
            Zeno.Test lostBoundsPredicateInThis = SynthesizedPredicatesBuilder.createOutsideLostBoundsPredicates(variable, valueInThis, valueInOther);
            Zeno.Test lostBoundsPredicateInOther = SynthesizedPredicatesBuilder.createInsideLostBoundsPredicates(variable, valueInOther, valueInThis);
            assert (lostBoundsPredicateInThis != null);
            assert (lostBoundsPredicateInOther != null);
            boundsPredicatesInThis = boundsPredicatesInThis.bind(variable, lostBoundsPredicateInThis);
            boundsPredicatesInOther = boundsPredicatesInOther.bind(variable, lostBoundsPredicateInOther);
            predicateVariablesList.add(variable);
        }
        if (predicateVariablesList.isEmpty()) {
            return implications;
        }
        implications = SynthesizedPredicatesBuilder.circularShiftedZip(implications, predicateVariablesList, boundsPredicatesInThis, boundsPredicatesInOther);
        return implications;
    }

    private static MultiMap<Zeno.Test, Zeno.Test> circularShiftedZip(MultiMap<Zeno.Test, Zeno.Test> implications, List<NumVar> predicateVariablesList, AVLMap<NumVar, Zeno.Test> boundsPredicatesInThis, AVLMap<NumVar, Zeno.Test> boundsPredicatesInOther) {
        ListIterator<NumVar> iterator = predicateVariablesList.listIterator();
        NumVar firstVariable = iterator.next();
        while (iterator.hasNext()) {
            NumVar currentVariable = iterator.previous();
            iterator.next();
            NumVar nextVariable = iterator.next();
            Zeno.Test premise = boundsPredicatesInThis.get(currentVariable).get();
            Zeno.Test consequence = boundsPredicatesInOther.get(nextVariable).get();
            if (ZenoTestHelper.isSyntacticallyEntailedBy(consequence, premise)) continue;
            implications = implications.add(premise, consequence);
        }
        NumVar lastVariable = iterator.previous();
        Zeno.Test premise = boundsPredicatesInThis.get(lastVariable).get();
        Zeno.Test consequence = boundsPredicatesInOther.get(firstVariable).get();
        if (!ZenoTestHelper.isSyntacticallyEntailedBy(consequence, premise)) {
            implications = implications.add(premise, consequence);
        }
        return implications;
    }

    private static Zeno.Test createInsideLostBoundsPredicates(NumVar var, Interval valueInThis, Interval valueInOther) {
        Zeno.Test predicate = SynthesizedPredicatesBuilder.createOutsideLostBoundsPredicates(var, valueInThis, valueInOther);
        return predicate.not();
    }

    private static Zeno.Test createOutsideLostBoundsPredicates(NumVar var, Interval valueInThis, Interval valueInOther) {
        Zeno.Test lowerBoundPredicate = SynthesizedPredicatesBuilder.createLowerBoundPredicate(var, valueInThis, valueInOther);
        if (lowerBoundPredicate != null) {
            return lowerBoundPredicate;
        }
        Zeno.Test upperBoundPredicate = SynthesizedPredicatesBuilder.createUpperBoundPredicate(var, valueInThis, valueInOther);
        if (upperBoundPredicate != null) {
            return upperBoundPredicate;
        }
        return null;
    }

    private static Zeno.Test createLowerBoundPredicate(NumVar var, Interval valueInThis, Interval valueInOther) {
        Bound thisLow = valueInThis.low();
        Bound otherLow = valueInOther.low();
        if (otherLow.isLessThan(thisLow) && thisLow.isFinite()) {
            BigInt lostBound = thisLow.asInteger();
            Linear linear = Linear.linear(var).sub(lostBound).sub(BigInt.MINUSONE);
            Zeno.Test predicate = zeno.comparison(linear, Zeno.ZenoTestOp.LessThanOrEqualToZero);
            return predicate;
        }
        return null;
    }

    private static Zeno.Test createUpperBoundPredicate(NumVar var, Interval valueInThis, Interval valueInOther) {
        Bound otherHigh;
        Bound thisHigh = valueInThis.high();
        if (thisHigh.isLessThan(otherHigh = valueInOther.high()) && thisHigh.isFinite()) {
            BigInt lostBound = thisHigh.asInteger();
            Linear linear = Linear.linear(lostBound).sub(var).add(BigInt.ONE);
            Zeno.Test predicate = zeno.comparison(linear, Zeno.ZenoTestOp.LessThanOrEqualToZero);
            return predicate;
        }
        return null;
    }
}

