/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.fields;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteFactory;
import bindead.data.FoldMap;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.debug.PrettyDomain;
import bindead.domainnetwork.combinators.FiniteSequence;
import bindead.domainnetwork.interfaces.RegionCtx;
import bindead.domains.fields.VariableCtx;
import bindead.domains.pointsto.PointsToProperties;
import java.util.Iterator;
import javalx.data.products.P2;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.FiniteRange;
import javalx.persistentcollections.ThreeWaySplit;
import javalx.persistentcollections.tree.FiniteRangeTree;
import rreil.lang.Field;
import rreil.lang.MemVar;

class Region {
    final FiniteRangeTree<VariableCtx> fields;
    final RegionCtx context;
    private final boolean DEBUG;

    private void msg(String s) {
        if (this.DEBUG) {
            System.out.println("fields.Region: " + s + "\n");
        }
    }

    Region(FiniteRangeTree<VariableCtx> fields, RegionCtx ctx) {
        this.DEBUG = PointsToProperties.INSTANCE.debugOther.isTrue();
        this.fields = fields;
        this.context = ctx;
    }

    static Region empty(RegionCtx ctx) {
        return new Region(FiniteRangeTree.empty(), ctx);
    }

    Region addField(Field field, NumVar fieldVar) {
        FiniteRange interval = field.finiteRangeKey();
        return new Region(this.fields.bind(interval, new VariableCtx(field.getSize(), fieldVar)), this.context);
    }

    Region addField(FiniteRange interval, NumVar en) {
        int size = interval.getSpan().intValue();
        assert (size > 0);
        return new Region(this.fields.bind(interval, new VariableCtx(size, en)), this.context);
    }

    Region remove(FiniteRange field) {
        return new Region(this.fields.remove(field), this.context);
    }

    private RegionCtx mergeContexts(Region snd) {
        return this.context;
    }

    private void makeCompatible(Region snd, FiniteSequence oco, FiniteRangeTree<VariableCtx> inBothButDiffering) {
        for (P2<FiniteRange, VariableCtx> p2 : inBothButDiffering) {
            NumVar fromSnd;
            NumVar fromFst = this.fields.get(p2._1()).get().getVariable();
            if (fromFst.equalTo(fromSnd = snd.fields.get(p2._1()).get().getVariable())) continue;
            oco.addSubst(fromSnd, fromFst);
        }
    }

    Region mergeRegions(Region snd, FiniteSequence co, FiniteSequence oco) {
        NumVar variable;
        ThreeWaySplit<FiniteRangeTree<VariableCtx>> split = this.fields.split(snd.fields);
        for (P2<FiniteRange, VariableCtx> p2 : split.onlyInFirst()) {
            variable = p2._2().getVariable();
            oco.addIntro(variable);
        }
        for (P2<FiniteRange, VariableCtx> p2 : split.onlyInSecond()) {
            variable = p2._2().getVariable();
            co.addIntro(variable);
        }
        this.makeCompatible(snd, oco, split.inBothButDiffering());
        return new Region(this.fields.union(split.onlyInSecond()), this.mergeContexts(snd));
    }

    ThreeWaySplit<FiniteRangeTree<VariableCtx>> splitFields(Region eph) {
        return this.fields.split(eph.fields);
    }

    Region unfoldCopy(FoldMap varsToExpand, MemVar region) {
        FiniteRangeTree<VariableCtx> copiedFields = FiniteRangeTree.empty();
        for (P2<FiniteRange, VariableCtx> p2 : this.fields) {
            VariableCtx ctx = p2._2();
            NumVar nv = NumVar.fresh();
            if (region != null) {
                BigInt low = p2._1().low();
                int intValue = low.isFinite() ? ((Bound)low).asInteger().intValue() : 0;
                nv.setRegionName(region, intValue);
            }
            VariableCtx newCtx = new VariableCtx(ctx.getSize(), nv);
            copiedFields = copiedFields.bind(p2._1(), newCtx);
            varsToExpand.add(ctx.getVariable(), nv);
        }
        return new Region(copiedFields, this.context);
    }

    public VarSet containedNumVars() {
        VarSet vs = VarSet.empty();
        for (P2<FiniteRange, VariableCtx> p2 : this.fields) {
            NumVar v = p2._2().getVariable();
            vs = vs.add(v);
        }
        return vs;
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public void testEqual(Region r2, FiniteSequence childOps) {
        ThreeWaySplit<FiniteRangeTree<VariableCtx>> split = this.fields.split(r2.fields);
        for (P2<FiniteRange, VariableCtx> p2 : split.inBothButDiffering()) {
            FiniteRange interval = p2._1();
            VariableCtx variableCtx1 = this.fields.get(interval).get();
            NumVar fromFst = variableCtx1.getVariable();
            VariableCtx variableCtx2 = r2.fields.get(interval).get();
            NumVar fromSnd = variableCtx2.getVariable();
            int size = variableCtx1.getSize();
            if (size != variableCtx2.getSize()) continue;
            Finite.Test test = FiniteFactory.getInstance().equalTo(size, fromFst, fromSnd);
            childOps.addTest(test);
        }
    }

    public void appendInfo(StringBuilder builder, PrettyDomain childDomain) {
        builder.append('{');
        Iterator<P2<FiniteRange, VariableCtx>> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            P2<FiniteRange, VariableCtx> element = iterator.next();
            FiniteRange key = element._1();
            VariableCtx value = element._2();
            builder.append(key);
            builder.append('=');
            childDomain.varToCompactString(builder, value.getVariable());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        builder.append("}");
    }

    public String toString() {
        String result;
        Iterator<P2<FiniteRange, VariableCtx>> iterator = this.fields.iterator();
        if (!iterator.hasNext()) {
            result = "{}";
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append('{');
            while (iterator.hasNext()) {
                P2<FiniteRange, VariableCtx> element = iterator.next();
                FiniteRange key = element._1();
                VariableCtx value = element._2();
                builder.append(key.toString());
                builder.append('=');
                builder.append(value.getVariable());
                if (!iterator.hasNext()) continue;
                builder.append(", ");
            }
            result = builder.append('}').toString();
        }
        return result;
    }
}

