/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.fields;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteFactory;
import bindead.data.FoldMap;
import bindead.data.Linear;
import bindead.data.ListVarPair;
import bindead.data.MemVarPair;
import bindead.data.MemVarSet;
import bindead.data.NumVar;
import bindead.data.VarPair;
import bindead.data.VarSet;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.combinators.FiniteStateBuilder;
import bindead.domainnetwork.interfaces.ContentCtx;
import bindead.domainnetwork.interfaces.FiniteDomain;
import bindead.domainnetwork.interfaces.RegionCtx;
import bindead.domains.fields.ClobberedMap;
import bindead.domains.fields.FieldGraph;
import bindead.domains.fields.FieldState;
import bindead.domains.fields.FieldVisitor;
import bindead.domains.fields.Fields;
import bindead.domains.fields.Region;
import bindead.domains.fields.RegionMap;
import bindead.domains.fields.VariableCtx;
import bindead.domains.pointsto.PointsToProperties;
import bindead.exceptions.DomainStateException;
import binparse.Endianness;
import java.util.LinkedList;
import java.util.List;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.FiniteRange;
import javalx.numeric.Interval;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.AVLSet;
import javalx.persistentcollections.ThreeWaySplit;
import javalx.persistentcollections.tree.FiniteRangeTree;
import javalx.persistentcollections.tree.OverlappingRanges;
import rreil.lang.Field;
import rreil.lang.Lhs;
import rreil.lang.MemVar;
import rreil.lang.Rhs;
import rreil.lang.Test;

class FieldStateBuilder<D extends FiniteDomain<D>>
extends FiniteStateBuilder {
    private static final FiniteFactory fin = FiniteFactory.getInstance();
    RegionMap regions;
    private AVLMap<MemVar, ClobberedMap> clobbered;
    private final List<NumVar> tempVars;
    private final boolean DEBUG;

    private void msg(String s) {
        if (this.DEBUG) {
            System.out.println("FieldStateBuilder: " + s + "\n");
        }
    }

    FieldStateBuilder(FieldState state) {
        this.DEBUG = PointsToProperties.INSTANCE.debugOther.isTrue();
        this.regions = state.regions;
        this.clobbered = state.clobbered;
        this.tempVars = new LinkedList<NumVar>();
    }

    FieldState build() {
        return new FieldState(this.regions, this.clobbered);
    }

    private ClobberedMap getClobberedMap(MemVar varId) {
        return this.clobbered.get(varId).getOrElse(ClobberedMap.empty());
    }

    Finite.Lhs resolveLhs(Lhs lhs) {
        MemVar regionId = lhs.getRegionId();
        FiniteRange range = lhs.bitRange();
        this.markClobbered(regionId, range);
        Option<VariableCtx> matching = this.regions.get(regionId, range);
        OverlappingRanges<VariableCtx> overlaps = this.regions.searchOverlaps(regionId, range.toInterval());
        for (P2<FiniteRange, VariableCtx> p2 : overlaps) {
            if (!matching.isNone() && p2._1().isEqualTo(range)) continue;
            this.removeOverlappedField(regionId, p2);
        }
        NumVar variable = matching.isSome() ? matching.get().getVariable() : this.introduceAndResolve(Field.field(lhs));
        return fin.variable(lhs.getSize(), variable);
    }

    private void removeOverlappedField(MemVar regionId, P2<FiniteRange, VariableCtx> ctx) {
        this.regions = this.regions.remove(regionId, ctx._1());
        this.getChildOps().addKill(ctx._2().getVariable());
    }

    private Finite.Rlin resolve(Field field) {
        FiniteRange range;
        MemVar varId = field.getRegion();
        Option<VariableCtx> matching = this.regions.get(varId, range = field.finiteRangeKey());
        if (matching.isSome()) {
            return fin.linear(matching.get());
        }
        OverlappingRanges<VariableCtx> overlapping = this.regions.searchOverlaps(varId, range.toInterval());
        if (overlapping.isEmpty()) {
            NumVar fieldVar = this.allocate(field);
            return fin.linear(field.getSize(), fieldVar);
        }
        return this.resolveFromOverlapping(overlapping, field);
    }

    private NumVar allocate(Field field) {
        Finite.Rhs rhs;
        MemVar regionId = field.getRegion();
        Option<Region> optionalRegion = this.regions.map.get(regionId);
        if (optionalRegion.isNone()) {
            String string = "field " + field + " refers to unintroduced region " + field.getRegion();
            throw new DomainStateException.InvariantViolationException(string);
        }
        NumVar fieldVar = this.introduceAndResolve(field);
        int size = field.getSize();
        MemVar varId = field.getRegion();
        FiniteRange intervalKey = field.finiteRangeKey();
        int bitOffset = field.getOffset();
        Option<ContentCtx> ctx = this.regions.getSegment(varId);
        if (ctx.isSome() && !this.isClobbered(varId, intervalKey)) {
            FieldStateBuilder.assertByteAlignment(size, bitOffset);
            BigInt value = ctx.get().read(bitOffset / 8, size / 8, Endianness.LITTLE);
            rhs = fin.literal(size, value);
        } else {
            rhs = fin.range(size, Interval.unsignedTop(size));
        }
        Finite.Lhs lhs = fin.variable(size, fieldVar);
        this.getChildOps().addAssignment(lhs, rhs);
        return fieldVar;
    }

    private static void assertByteAlignment(int size, int bitOffset) {
        if (size % 8 != 0 || bitOffset % 8 != 0) {
            throw new DomainStateException.InvariantViolationException();
        }
    }

    private boolean isClobbered(MemVar varId, FiniteRange range) {
        return this.getClobberedMap(varId).isClobbered(range);
    }

    private void markClobbered(MemVar varId, FiniteRange range) {
        ClobberedMap clobberdInRegion = this.getClobberedMap(varId);
        this.clobbered = this.clobbered.bind((Object)varId, (Object)clobberdInRegion.markClobbered(range));
    }

    private NumVar introduceAndResolve(Field field) {
        NumVar variable = field.finiteRangeKey().isEqualTo(Field.finiteRangeKey(0, 1)) ? NumVar.freshFlag() : NumVar.fresh();
        variable.setRegionName(field.getRegion(), field.getOffset());
        MemVar regionId = field.getRegion();
        Option<Region> optionalRegion = this.regions.map.get(regionId);
        Region region = optionalRegion.get();
        this.regions = this.regions.bind(regionId, region.addField(field, variable));
        this.getChildOps().addIntro(variable);
        return variable;
    }

    private Finite.Rlin resolveFromOverlapping(OverlappingRanges<VariableCtx> overlapping, Field field) {
        overlapping.sortByFiniteRangeKey();
        if (FieldStateBuilder.isConvertible(overlapping, field)) {
            return this.downcastConversion(overlapping, field);
        }
        Finite.Rlin rhs = this.tryLinearization(overlapping, field.finiteRangeKey());
        if (rhs != null) {
            return rhs;
        }
        if (!this.isClobbered(overlapping, field)) {
            NumVar fieldVar = this.allocate(field);
            return fin.linear(field.getSize(), fieldVar);
        }
        return null;
    }

    private boolean isClobbered(OverlappingRanges<VariableCtx> overlapping, Field field) {
        for (P2<FiniteRange, VariableCtx> p2 : overlapping) {
            if (!this.isClobbered(field.getRegion(), p2._1())) continue;
            return true;
        }
        return false;
    }

    private Finite.Rlin downcastConversion(OverlappingRanges<VariableCtx> overlapping, Field field) {
        NumVar fieldVar = this.introduceAndResolve(field);
        int size = field.getSize();
        Finite.Rlin rhs = fin.linear(overlapping.getFirst()._2());
        this.getChildOps().addAssignment(fin.variable(size, fieldVar), fin.convert(rhs));
        return fin.linear(size, fieldVar);
    }

    private static boolean isConvertible(OverlappingRanges<VariableCtx> overlapping, Field field) {
        if (overlapping.size() == 1) {
            FiniteRange existing = overlapping.getFirst()._1();
            FiniteRange key = field.finiteRangeKey();
            if (FieldStateBuilder.lowAlignedAndContainedFinite(key, existing)) {
                return true;
            }
        }
        return false;
    }

    private static boolean lowAlignedAndContainedFinite(FiniteRange key, FiniteRange existing) {
        if (key.low().isFinite() && key.high().isFinite()) {
            return key.low().asInteger().isEqualTo(existing.low().asInteger()) && key.high().compareTo(existing.high()) <= 0;
        }
        return false;
    }

    private Finite.Rlin tryLinearization(OverlappingRanges<VariableCtx> overlapping, FiniteRange key) {
        FieldGraph g = FieldGraph.build(overlapping);
        FieldGraph.Partitioning path = g.findPartitioning(key.low(), key.high());
        Option<FiniteRange> span = path.span();
        if (span.isNone() || !key.isEqualTo(span.get())) {
            return null;
        }
        return this.linearize(path, key.getSpan().intValue());
    }

    private Finite.Rlin linearize(FieldGraph.Partitioning path, int size) {
        Linear lin = Linear.ZERO;
        int baseOffset = ((FiniteRange)((P2)path.get(0))._1()).low().asInteger().intValue();
        for (int i = 0; i < path.size() - 1; ++i) {
            P2 ctx = (P2)path.get(i);
            FiniteRange intervalKey = (FiniteRange)ctx._1();
            NumVar sourceVar = ((VariableCtx)ctx._2()).getVariable();
            int currentOffset = intervalKey.low().asInteger().intValue();
            int span = intervalKey.getSpan().intValue();
            BigInt coeff = BigInt.powerOfTwo(currentOffset - baseOffset);
            Finite.Convert converted = fin.convert(fin.linear(span, sourceVar));
            NumVar tempVar = this.makeConvertedVar(size, converted);
            lin = lin.addTerm(coeff, tempVar);
        }
        P2 ctx = (P2)path.get(path.size() - 1);
        FiniteRange intervalKey = (FiniteRange)ctx._1();
        int currentOffset = intervalKey.low().asInteger().intValue();
        BigInt coeff = BigInt.powerOfTwo(currentOffset - baseOffset);
        lin = lin.addTerm(coeff, ((VariableCtx)ctx._2()).getVariable());
        return fin.linear(size, lin);
    }

    private NumVar makeConvertedVar(int size, Finite.Rhs converted) {
        NumVar tempVar = NumVar.fresh();
        this.getChildOps().addIntro(tempVar);
        this.getChildOps().addAssignment(fin.variable(size, tempVar), converted);
        this.tempVars.add(tempVar);
        return tempVar;
    }

    void introduce(MemVar varId, RegionCtx regionCtx) throws DomainStateException {
        if (this.regions.contains(varId)) {
            throw new DomainStateException.VariableSupportSetException("tried to introduce MemVar " + varId + " that already exists");
        }
        this.regions = this.regions.bind(varId, Region.empty(regionCtx));
    }

    void rename(MemVar from, MemVar to) {
        Region region = this.regions.get(from);
        FoldMap toRename = new FoldMap();
        region = region.unfoldCopy(toRename, to);
        for (VarPair vp : toRename) {
            this.getChildOps().addSubst((NumVar)vp.getPermanent(), (NumVar)vp.getEphemeral());
        }
        this.regions = this.regions.remove(from).bind(to, region);
        Option<ClobberedMap> clob = this.clobbered.get(from);
        if (clob.isSome()) {
            this.clobbered = ((AVLMap)this.clobbered.remove((Object)from)).bind(to, clob.get());
        }
    }

    void makeCompatible(FieldStateBuilder<D> other) {
        ThreeWaySplit<RegionMap> split = this.regions.split(other.regions);
        assert (split.onlyInFirst().isEmpty()) : "this region-map contains regions not in other: " + split.onlyInFirst();
        assert (split.onlyInSecond().isEmpty()) : "other region-map contains regions not in this: " + split.onlyInSecond();
        RegionMap differing = split.inBothButDiffering();
        for (P2<MemVar, Region> p2 : differing.map) {
            MemVar varId = p2._1();
            Region fst = p2._2();
            Region snd = other.regions.get(varId);
            Region intervalTree = fst.mergeRegions(snd, this.getChildOps(), other.getChildOps());
            this.regions = this.regions.bind(varId, intervalTree);
        }
        this.mergeClobbered(other);
    }

    private void mergeClobbered(FieldStateBuilder<D> other) {
        ThreeWaySplit<AVLMap<MemVar, ClobberedMap>> split = this.clobbered.split(other.clobbered);
        for (P2<MemVar, ClobberedMap> p2 : split.onlyInSecond()) {
            this.clobbered = this.clobbered.bind((Object)p2._1(), (Object)p2._2());
        }
        for (P2<MemVar, ClobberedMap> p2 : split.inBothButDiffering()) {
            MemVar r = p2._1();
            ClobberedMap fromFst = p2._2();
            ClobberedMap fromSnd = other.clobbered.get(r).get();
            this.clobbered = this.clobbered.bind((Object)r, (Object)fromFst.union(fromSnd));
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Childops: " + this.getChildOps());
        builder.append("\n");
        builder.append(this.build());
        return builder.toString();
    }

    void removeOverlapping(MemVar varId, Interval range) {
        OverlappingRanges<VariableCtx> overlapping = this.regions.searchOverlaps(varId, range);
        for (P2<FiniteRange, VariableCtx> p2 : overlapping) {
            this.getChildOps().addKill(p2._2().getVariable());
            this.regions = this.regions.remove(varId, p2._1());
        }
    }

    <D2 extends FiniteDomain<D2>> D2 applyDelayedKillOps(D2 state) {
        for (NumVar v : this.tempVars) {
            state = state.project(v);
        }
        return state;
    }

    void projectRegion(MemVar regionId) {
        Region region = this.regions.get(regionId);
        this.removeClobbered(regionId);
        this.regions = this.regions.remove(regionId);
        for (P2<FiniteRange, VariableCtx> p2 : region.fields) {
            VariableCtx vc = p2._2();
            this.getChildOps().addKill(vc.getVariable());
        }
    }

    void removeClobbered(MemVar regionId) {
        this.clobbered = this.clobbered.remove((Object)regionId);
    }

    void runAssign(QueryChannel channel, Lhs lhs, Rhs rhs) {
        Finite.Lhs flhs = this.resolveLhs(lhs);
        Finite.Rhs frhs = this.resolveRhs(rhs);
        if (frhs == null) {
            frhs = fin.range(lhs.getSize(), Interval.unsignedTop(lhs.getSize()));
        }
        this.getChildOps().addAssignment(flhs, frhs);
    }

    Finite.Rhs resolveRhs(Rhs rhs) {
        FieldVisitor visitor = new FieldVisitor(this);
        return rhs.accept(visitor, null);
    }

    Finite.Rlin resolveRval(Rhs.Rval rhs) {
        FieldVisitor visitor = new FieldVisitor(this);
        return (Finite.Rlin)rhs.accept(visitor, null);
    }

    @Deprecated
    Finite.Rlin resolve(Rhs.Rval value) {
        if (value instanceof Rhs.Rlit) {
            return fin.literal(value.getSize(), ((Rhs.Rlit)value).getValue());
        }
        Rhs.Rvar rvar = (Rhs.Rvar)value;
        Field field = Field.field(rvar);
        return this.resolve(field);
    }

    private Option<Finite.Rlin> resolve(Rhs.Lin value) {
        Finite.Rhs resolved = this.resolveRhs(value);
        if (resolved instanceof Finite.Rlin) {
            return Option.some((Finite.Rlin)resolved);
        }
        return Option.none();
    }

    void runTest(QueryChannel channel, Test test) {
        Finite.Rhs cmp = this.resolveRhs(test.getComparison());
        assert (cmp != null);
        assert (cmp instanceof Finite.Cmp);
        this.getChildOps().addTest(fin.test((Finite.Cmp)cmp));
    }

    D applyReorderedChildOps(D cs) {
        D cs1 = this.applyChildOps(cs);
        D cs2 = this.applyDelayedKillOps((FiniteDomain)cs1);
        return cs2;
    }

    boolean hasNoTempVars() {
        return this.tempVars.isEmpty();
    }

    void assumePointsTo(Rhs.Lin pointerValue, NumVar.AddrVar target, MemVar region) {
        Option<Finite.Rlin> resolved = this.resolve(pointerValue);
        if (resolved.isSome()) {
            Finite.Rlin pointerNumVar = resolved.get();
            VarSet contents = VarSet.empty();
            if (region != null) {
                Region reg = this.regions.get(region);
                for (P2<FiniteRange, VariableCtx> p2 : reg.fields) {
                    contents = contents.add(p2._2().getVariable());
                }
            }
            this.getChildOps().addDerefTarget(pointerNumVar, target, contents);
        }
    }

    public void copyMemRegion(MemVar fromAdr, MemVar toAdr) {
        Region from = this.regions.get(fromAdr);
        Region to = Region.empty(from.context);
        for (P2<FiniteRange, VariableCtx> p2 : from.fields) {
            VariableCtx ctx = p2._2();
            NumVar newVar = NumVar.fresh();
            this.getChildOps().addHardcopy(newVar, ctx.getVariable());
            to = to.addField(p2._1(), newVar);
        }
        this.regions = this.regions.bind(toAdr, to);
    }

    void copyAndPaste(MemVarSet memvars, Fields<D> other) {
        VarSet cnpVars = VarSet.empty();
        for (MemVar mv : memvars) {
            Region r = ((FieldState)other.state).regions.get(mv);
            cnpVars = cnpVars.union(r.containedNumVars());
            this.regions = this.regions.bind(mv, r);
        }
        this.getChildOps().addCopyAndPaste(cnpVars, (FiniteDomain)other.childState);
    }

    public void testmemvarsEqual(MemVar m1, MemVar m2) {
        this.regions.get(m1).testEqual(this.regions.get(m2), this.getChildOps());
    }

    public void assumeEdgeNG(Rhs.Lin fieldThatPoints, NumVar.AddrVar address) {
        Option<Finite.Rlin> resolved = this.resolve(fieldThatPoints);
        if (resolved.isSome()) {
            Finite.Rlin pointerNumVar = resolved.get();
            assert (pointerNumVar != null);
            this.getChildOps().addAssumeEdgeNG(pointerNumVar, address);
        }
    }

    void unfoldClobbered(MemVar permanent, MemVar ephemeral) {
        ClobberedMap orNull = this.clobbered.getOrNull(permanent);
        if (orNull == null) {
            return;
        }
        this.clobbered = this.clobbered.bind((Object)ephemeral, (Object)orNull);
    }

    public void expandNG(List<MemVarPair> mvps) {
        ListVarPair numVars = this.collectExpandVars(mvps);
        this.getChildOps().addExpandNG(numVars);
    }

    void expandNG(NumVar.AddrVar address, NumVar.AddrVar address2, List<MemVarPair> mvps) {
        ListVarPair numVars = this.collectExpandVars(mvps);
        this.getChildOps().addExpandNG(address, address2, numVars);
    }

    public void foldNG(NumVar.AddrVar address, NumVar.AddrVar address2, List<MemVarPair> mvps) {
        ListVarPair numVars = this.collectFoldVars(mvps);
        for (MemVarPair mvp : mvps) {
            this.regions = this.regions.remove((MemVar)mvp.getEphemeral());
        }
        this.getChildOps().addFoldNG(address, address2, numVars);
    }

    public void foldNG(List<MemVarPair> mvps) {
        ListVarPair numVars = this.collectFoldVars(mvps);
        for (MemVarPair mvp : mvps) {
            this.regions = this.regions.remove((MemVar)mvp.getEphemeral());
        }
        this.getChildOps().addFoldNG(numVars);
    }

    private ListVarPair collectFoldVars(List<MemVarPair> mvps) {
        ListVarPair numVars = new ListVarPair();
        for (MemVarPair mvp : mvps) {
            NumVar v;
            MemVar permanent = (MemVar)mvp.getPermanent();
            MemVar ephemeral = (MemVar)mvp.getEphemeral();
            Region summary = this.regions.get(permanent);
            Region concrete = this.regions.get(ephemeral);
            ThreeWaySplit<FiniteRangeTree<VariableCtx>> split = summary.fields.split(concrete.fields);
            for (P2<FiniteRange, VariableCtx> p2 : split.onlyInFirst()) {
                v = NumVar.fresh();
                this.getChildOps().addIntro(v);
                numVars.add(p2._2().getVariable(), v);
            }
            for (P2<FiniteRange, VariableCtx> p2 : split.onlyInSecond()) {
                v = NumVar.fresh();
                this.getChildOps().addIntro(v);
                numVars.add(v, p2._2().getVariable());
                summary = summary.addField(p2._1(), v);
                this.regions = this.regions.bind(permanent, summary);
            }
            for (P2<FiniteRange, VariableCtx> p2 : split.inBothButDiffering()) {
                FiniteRange r = p2._1();
                VariableCtx sv = p2._2();
                VariableCtx cv = concrete.fields.getOrNull(r);
                assert (cv != null);
                numVars.add(new VarPair(sv.getVariable(), cv.getVariable()));
            }
        }
        return numVars;
    }

    private ListVarPair collectExpandVars(List<MemVarPair> mvps) {
        ListVarPair numVars = new ListVarPair();
        for (MemVarPair mvp : mvps) {
            MemVar permanent = (MemVar)mvp.getPermanent();
            MemVar ephemeral = (MemVar)mvp.getEphemeral();
            Region r1 = this.regions.get(permanent);
            FiniteRangeTree<VariableCtx> copiedFields = FiniteRangeTree.empty();
            for (P2<FiniteRange, VariableCtx> p2 : r1.fields) {
                VariableCtx ctx = p2._2();
                NumVar nv = NumVar.fresh();
                FiniteRange range = p2._1();
                this.setFieldVarName(ephemeral, nv, range);
                VariableCtx newCtx = new VariableCtx(ctx.getSize(), nv);
                copiedFields = copiedFields.bind(range, newCtx);
                numVars.add(new VarPair(ctx.getVariable(), nv));
            }
            Region fields2 = new Region(copiedFields, r1.context);
            this.regions = this.regions.bind(ephemeral, fields2);
            this.unfoldClobbered(permanent, ephemeral);
        }
        return numVars;
    }

    void setFieldVarName(MemVar ephemeral, NumVar nv, FiniteRange range) {
        if (ephemeral != null) {
            BigInt low = range.low();
            int intValue = low.isFinite() ? ((Bound)low).asInteger().intValue() : 0;
            nv.setRegionName(ephemeral, intValue);
        }
    }

    public void concretizeAndDisconnectNG(NumVar.AddrVar summary, AVLSet<MemVar> concreteNodes) {
        VarSet vs = VarSet.empty();
        for (MemVar m : concreteNodes) {
            vs = vs.union(this.regions.get(m).containedNumVars());
        }
        this.getChildOps().addConcretiseAndDisconnectNG(summary, vs);
    }

    public void bendBackGhostEdgesNG(NumVar.AddrVar concrete, NumVar.AddrVar summary, MemVarSet sContents, MemVarSet cContents, MemVarSet pointingToSummary, MemVarSet pointingToConcrete) {
        VarSet svs = this.collectContents(sContents);
        VarSet cvs = this.collectContents(cContents);
        VarSet pts = this.collectContents(pointingToSummary);
        VarSet ptc = this.collectContents(pointingToConcrete);
        this.getChildOps().addBendBackGhostEdgesNG(summary, concrete, svs, cvs, pts, ptc);
    }

    public void bendGhostEdgesNG(NumVar.AddrVar concrete, NumVar.AddrVar summary, MemVarSet sContents, MemVarSet cContents, MemVarSet pointingToSummary, MemVarSet pointingToConcrete) {
        VarSet svs = this.collectContents(sContents);
        VarSet cvs = this.collectContents(cContents);
        VarSet pts = this.collectContents(pointingToSummary);
        VarSet ptc = this.collectContents(pointingToConcrete);
        this.getChildOps().addBendGhostEdgesNG(summary, concrete, svs, cvs, pts, ptc);
    }

    private VarSet collectContents(MemVarSet sContents) {
        VarSet svs = VarSet.empty();
        for (MemVar v : sContents) {
            svs = svs.union(this.regions.contentVars(v));
        }
        return svs;
    }
}

