/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.apron;

import apron.Coeff;
import apron.DoubleScalar;
import apron.Environment;
import apron.Linexpr1;
import apron.Linterm1;
import apron.MpfrScalar;
import apron.MpqScalar;
import apron.Scalar;
import apron.Texpr1BinNode;
import apron.Texpr1CstNode;
import apron.Texpr1Intern;
import apron.Texpr1Node;
import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.ZenoRhsVisitorSkeleton;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.exceptions.DomainStateException;
import bindead.exceptions.Unreachable;
import gmp.Mpfr;
import gmp.Mpq;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import javalx.data.Option;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Interval;
import javalx.numeric.Range;
import javalx.persistentcollections.BiMap;

class Marshaller {
    private static final ScalarMarshaller scalarMarshaller = new DoubleMarshaller();

    Marshaller() {
    }

    public static BigInt fromApronScalarNoRounding(Scalar value) {
        return scalarMarshaller.fromApronScalarNoRounding(value);
    }

    public static BigInt fromApronScalarRoundDown(Scalar cst) {
        return scalarMarshaller.fromApronScalarRoundDown(cst);
    }

    public static apron.Interval toApronInterval(Interval interval) {
        apron.Interval apronInterval = new apron.Interval(0, 0);
        if (!interval.low().isFinite() && !interval.high().isFinite()) {
            apronInterval.setTop();
            return apronInterval;
        }
        if (!interval.low().isFinite()) {
            BigInteger upper = interval.high().asInteger().bigIntegerValue();
            Scalar lowerBound = scalarMarshaller.makeScalar();
            lowerBound.setInfty(-1);
            apronInterval.setInf(lowerBound);
            Scalar upperBound = scalarMarshaller.makeScalar(upper);
            apronInterval.setSup(upperBound);
            return apronInterval;
        }
        if (!interval.high().isFinite()) {
            BigInteger lower = interval.low().asInteger().bigIntegerValue();
            Scalar lowerBound = scalarMarshaller.makeScalar(lower);
            apronInterval.setInf(lowerBound);
            Scalar upperBound = scalarMarshaller.makeScalar();
            upperBound.setInfty(1);
            apronInterval.setSup(upperBound);
            return apronInterval;
        }
        BigInteger lower = interval.low().asInteger().bigIntegerValue();
        Scalar lowerBound = scalarMarshaller.makeScalar(lower);
        BigInteger upper = interval.high().asInteger().bigIntegerValue();
        Scalar upperBound = scalarMarshaller.makeScalar(upper);
        apronInterval.setInf(lowerBound);
        apronInterval.setSup(upperBound);
        return apronInterval;
    }

    public static Interval fromApronInterval(apron.Interval interval) {
        BigInt upperBound;
        if (interval.isBottom()) {
            throw new Unreachable();
        }
        if (interval.isTop()) {
            return Interval.TOP;
        }
        if (interval.inf().isInfty() == -1) {
            BigInt upperBound2 = scalarMarshaller.fromApronScalarRoundDown(interval.sup());
            return Interval.downFrom(upperBound2);
        }
        if (interval.sup().isInfty() == 1) {
            BigInt lowerBound = scalarMarshaller.fromApronScalarRoundUp(interval.inf());
            return Interval.upFrom(lowerBound);
        }
        BigInt lowerBound = scalarMarshaller.fromApronScalarRoundUp(interval.inf());
        if (lowerBound.isGreaterThan(upperBound = scalarMarshaller.fromApronScalarRoundDown(interval.sup()))) {
            throw new Unreachable();
        }
        return Interval.of(lowerBound, upperBound);
    }

    public static Scalar toApronScalar(BigInt value) {
        BigInteger bigIntegerValue = value.bigIntegerValue();
        return scalarMarshaller.makeScalar(bigIntegerValue);
    }

    public static Linexpr1 toApronLinear(Linear expr, Environment env, BiMap<NumVar, String> variablesMapping) {
        ArrayList<Linterm1> terms = new ArrayList<Linterm1>();
        for (Linear.Term term : expr) {
            Scalar coefficient = Marshaller.toApronScalar(term.getCoeff());
            Option<String> variable = variablesMapping.get(term.getId());
            if (variable.isNone()) {
                throw new DomainStateException.VariableSupportSetException();
            }
            terms.add(new Linterm1(variable.get(), coefficient));
        }
        Scalar constant = Marshaller.toApronScalar(expr.getConstant());
        return new Linexpr1(env, terms.toArray(new Linterm1[0]), (Coeff)constant);
    }

    public static Linear fromApronLinear(Linexpr1 expr, BiMap<NumVar, String> variablesMapping) {
        ArrayList<Linear.Term> terms = new ArrayList<Linear.Term>();
        for (Linterm1 term : expr.getLinterms()) {
            Option<NumVar> variable = variablesMapping.getKey(term.var);
            if (variable.isNone()) {
                throw new DomainStateException.VariableSupportSetException();
            }
            if (!term.coeff.isScalar()) {
                throw new IllegalArgumentException("The coefficient " + term.coeff + " is not a scalar value and can thus not be represented with our linear coefficients.");
            }
            BigInt coefficient = scalarMarshaller.fromApronScalarNoRounding(term.coeff.inf());
            terms.add(Linear.term(coefficient, variable.get()));
        }
        if (!expr.getCst().isScalar()) {
            throw new IllegalArgumentException("The constant coefficient " + expr.getCst() + " is not a scalar value and can thus not be represented with our linear coefficients.");
        }
        BigInt constant = scalarMarshaller.fromApronScalarNoRounding(expr.getCst().inf());
        return Linear.linear(terms.toArray(new Linear.Term[terms.size()])).add(constant);
    }

    public static Texpr1Intern toApronExpr(Zeno.Rhs expr, Environment env, BiMap<NumVar, String> variablesMapping, QueryChannel domain) {
        ToApronRhsTranslator rhsTranslator = new ToApronRhsTranslator(env, variablesMapping, domain);
        return expr.accept(rhsTranslator, null);
    }

    public static Texpr1Intern toApronExpr(Zeno.Rlin expr, Environment env, BiMap<NumVar, String> variablesMapping) {
        Texpr1Node apronExpr;
        Linexpr1 linear = Marshaller.toApronLinear(expr.getLinearTerm(), env, variablesMapping);
        if (expr.getDivisor().isOne()) {
            apronExpr = Texpr1Node.fromLinexpr1(linear);
        } else {
            Texpr1CstNode divisor = new Texpr1CstNode(Marshaller.toApronScalar(expr.getDivisor()));
            apronExpr = new Texpr1BinNode(3, 0, 1, Texpr1Node.fromLinexpr1(linear), divisor);
        }
        return new Texpr1Intern(env, apronExpr);
    }

    private static class ToApronRhsTranslator
    extends ZenoRhsVisitorSkeleton<Texpr1Intern, Void> {
        private final Environment env;
        private final BiMap<NumVar, String> variablesMapping;
        private final QueryChannel domain;

        public ToApronRhsTranslator(Environment env, BiMap<NumVar, String> variablesMapping, QueryChannel domain) {
            this.env = env;
            this.variablesMapping = variablesMapping;
            this.domain = domain;
        }

        @Override
        public Texpr1Intern visit(Zeno.Bin expr, Void data) {
            Texpr1Node apronExpr = null;
            Texpr1Node left = Marshaller.toApronExpr(expr.getLeft(), this.env, this.variablesMapping).toTexpr1Node();
            Texpr1Node right = Marshaller.toApronExpr(expr.getRight(), this.env, this.variablesMapping).toTexpr1Node();
            switch (expr.getOp()) {
                case Mul: {
                    apronExpr = new Texpr1BinNode(2, left, right);
                    break;
                }
                case Div: {
                    Range divisor = this.domain.queryRange(expr.getRight().getLinearTerm());
                    if (divisor.isZero()) {
                        apronExpr = new Texpr1CstNode(Marshaller.toApronScalar(Bound.ZERO));
                        break;
                    }
                    if (divisor.contains(Bound.ZERO)) {
                        throw new DomainStateException.UnimplementedMethodException();
                    }
                    apronExpr = new Texpr1BinNode(3, 1, 1, left, right);
                    break;
                }
                case Mod: {
                    apronExpr = new Texpr1BinNode(4, 1, 1, left, right);
                    break;
                }
                case Shl: {
                    Texpr1BinNode shiftAmount = new Texpr1BinNode(5, new Texpr1CstNode(Marshaller.toApronScalar(Bound.TWO)), right);
                    apronExpr = new Texpr1BinNode(2, left, shiftAmount);
                    break;
                }
                case Shr: {
                    Texpr1BinNode shiftAmount = new Texpr1BinNode(5, new Texpr1CstNode(Marshaller.toApronScalar(Bound.TWO)), right);
                    apronExpr = new Texpr1BinNode(3, 1, 3, left, shiftAmount);
                    break;
                }
                default: {
                    throw new DomainStateException.InvariantViolationException();
                }
            }
            return new Texpr1Intern(this.env, apronExpr);
        }

        @Override
        public Texpr1Intern visit(Zeno.Rlin expr, Void data) {
            return Marshaller.toApronExpr(expr, this.env, this.variablesMapping);
        }

        @Override
        public Texpr1Intern visit(Zeno.RangeRhs expr, Void data) {
            apron.Interval interval = Marshaller.toApronInterval(expr.getRange().convexHull());
            return new Texpr1Intern(this.env, new Texpr1CstNode(interval));
        }
    }

    static class DoubleMarshaller
    extends ScalarMarshaller {
        DoubleMarshaller() {
        }

        @Override
        Scalar makeScalar() {
            return new DoubleScalar();
        }

        @Override
        Scalar makeScalar(BigInteger bigIntegerValue) {
            return new DoubleScalar(bigIntegerValue.doubleValue());
        }

        @Override
        BigInt fromApronScalarNoRounding(Scalar value) {
            double[] mpd = new double[1];
            int rounded = value.toDouble(mpd, 0);
            if (rounded != 0) {
                throw new DomainStateException.InvariantViolationException("no fractions allowed here");
            }
            double doubleValue = mpd[0];
            double roundedValue = Math.ceil(doubleValue);
            if (roundedValue > doubleValue) {
                throw new DomainStateException.InvariantViolationException("no fractions allowed here");
            }
            return BigInt.of(BigDecimal.valueOf(roundedValue).toBigInteger());
        }

        @Override
        BigInt fromApronScalarRoundUp(Scalar value) {
            double[] mpd = new double[1];
            value.toDouble(mpd, 2);
            double doubleValue = mpd[0];
            double roundedValue = Math.ceil(doubleValue);
            return BigInt.of(BigDecimal.valueOf(roundedValue).toBigInteger());
        }

        @Override
        BigInt fromApronScalarRoundDown(Scalar value) {
            double[] mpd = new double[1];
            value.toDouble(mpd, 3);
            double doubleValue = mpd[0];
            double roundedValue = Math.floor(doubleValue);
            return BigInt.of(BigDecimal.valueOf(roundedValue).toBigInteger());
        }
    }

    static class FastDoubleMarshaller
    extends ScalarMarshaller {
        FastDoubleMarshaller() {
        }

        @Override
        Scalar makeScalar() {
            return new DoubleScalar();
        }

        @Override
        Scalar makeScalar(BigInteger bigIntegerValue) {
            return new DoubleScalar(bigIntegerValue.doubleValue());
        }

        @Override
        BigInt fromApronScalarNoRounding(Scalar rawValue) {
            DoubleScalar value = (DoubleScalar)rawValue;
            double doubleValue = value.val;
            double roundedValue = Math.ceil(doubleValue);
            if (roundedValue > doubleValue) {
                throw new DomainStateException.InvariantViolationException("no fractions allowed here");
            }
            return BigInt.of(BigDecimal.valueOf(roundedValue).toBigInteger());
        }

        @Override
        BigInt fromApronScalarRoundUp(Scalar rawValue) {
            DoubleScalar value = (DoubleScalar)rawValue;
            double doubleValue = value.val;
            double roundedValue = Math.ceil(doubleValue);
            return BigInt.of(BigDecimal.valueOf(roundedValue).toBigInteger());
        }

        @Override
        BigInt fromApronScalarRoundDown(Scalar rawValue) {
            DoubleScalar value = (DoubleScalar)rawValue;
            double doubleValue = value.val;
            double roundedValue = Math.floor(doubleValue);
            return BigInt.of(BigDecimal.valueOf(roundedValue).toBigInteger());
        }
    }

    static class MpfrMarshaller
    extends ScalarMarshaller {
        MpfrMarshaller() {
        }

        @Override
        Scalar makeScalar() {
            return new MpfrScalar();
        }

        @Override
        Scalar makeScalar(BigInteger bigIntegerValue) {
            return new MpfrScalar(bigIntegerValue.intValue());
        }

        @Override
        BigInt fromApronScalarNoRounding(Scalar value) {
            Mpfr mpfr = this.toMpfr(value);
            if (mpfr.isInteger()) {
                throw new DomainStateException.InvariantViolationException("no fractions allowed here");
            }
            return BigInt.of(mpfr.MpzValue(0).bigIntegerValue());
        }

        @Override
        BigInt fromApronScalarRoundUp(Scalar value) {
            Mpfr mpfr = this.toMpfr(value);
            return BigInt.of(mpfr.MpzValue(2).bigIntegerValue());
        }

        @Override
        BigInt fromApronScalarRoundDown(Scalar value) {
            Mpfr mpfr = this.toMpfr(value);
            return BigInt.of(mpfr.MpzValue(3).bigIntegerValue());
        }

        private Mpfr toMpfr(Scalar value) {
            Mpfr mpfr = new Mpfr();
            if (value.isInfty() != 0) {
                throw new IllegalArgumentException("Value is infinity: " + value);
            }
            if (value.toMpfr(mpfr, 0) != 0) {
                throw new DomainStateException.InvariantViolationException();
            }
            return mpfr;
        }
    }

    static class MpqMarshaller
    extends ScalarMarshaller {
        MpqMarshaller() {
        }

        @Override
        Scalar makeScalar() {
            return new MpqScalar();
        }

        @Override
        Scalar makeScalar(BigInteger bigIntegerValue) {
            return new MpqScalar(bigIntegerValue);
        }

        @Override
        BigInt fromApronScalarNoRounding(Scalar value) {
            Mpq mpq = this.toMpq(value);
            if (!mpq.getDen().bigIntegerValue().equals(BigInteger.ONE)) {
                throw new DomainStateException.InvariantViolationException("no fractions allowed here");
            }
            return BigInt.of(mpq.getNum().bigIntegerValue());
        }

        @Override
        BigInt fromApronScalarRoundUp(Scalar value) {
            Mpq mpq = this.toMpq(value);
            if (mpq.getDen().bigIntegerValue().equals(BigInteger.ONE)) {
                return BigInt.of(mpq.getNum().bigIntegerValue());
            }
            BigInt numerator = BigInt.of(mpq.getNum().bigIntegerValue());
            BigInt denominator = BigInt.of(mpq.getDen().bigIntegerValue());
            return numerator.divRoundUp(denominator);
        }

        @Override
        BigInt fromApronScalarRoundDown(Scalar value) {
            Mpq mpq = this.toMpq(value);
            if (mpq.getDen().bigIntegerValue().equals(BigInteger.ONE)) {
                return BigInt.of(mpq.getNum().bigIntegerValue());
            }
            BigInt numerator = BigInt.of(mpq.getNum().bigIntegerValue());
            BigInt denominator = BigInt.of(mpq.getDen().bigIntegerValue());
            return numerator.divRoundDown(denominator);
        }

        private Mpq toMpq(Scalar value) {
            Mpq mpq = new Mpq();
            if (value.isInfty() != 0) {
                throw new IllegalArgumentException("Value is infinity: " + value);
            }
            if (value.toMpq(mpq, 0) != 0) {
                throw new DomainStateException.InvariantViolationException();
            }
            return mpq;
        }
    }

    private static abstract class ScalarMarshaller {
        private ScalarMarshaller() {
        }

        abstract Scalar makeScalar();

        abstract Scalar makeScalar(BigInteger var1);

        abstract BigInt fromApronScalarNoRounding(Scalar var1);

        abstract BigInt fromApronScalarRoundUp(Scalar var1);

        abstract BigInt fromApronScalarRoundDown(Scalar var1);
    }
}

