/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.apron;

import apron.Abstract1;
import apron.ApronException;
import apron.Manager;
import apron.Octagon;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.debug.StringHelpers;
import bindead.domainnetwork.channels.SynthChannel;
import bindead.domainnetwork.interfaces.AnalysisCtx;
import bindead.domains.apron.Apron;
import bindead.domains.apron.PrettyPrinters;
import javalx.numeric.Range;
import javalx.persistentcollections.BiMap;

public class ApronOctagons
extends Apron {
    public static final String NAME = "APRON(Octagons)";

    public ApronOctagons() {
    }

    private ApronOctagons(Abstract1 state, BiMap<NumVar, String> variablesMapping, SynthChannel synth, AnalysisCtx ctx) {
        super(state, variablesMapping, synth, ctx);
    }

    @Override
    protected Manager getDomainManager() {
        return new Octagon();
    }

    @Override
    protected Apron build(Abstract1 state, BiMap<NumVar, String> variablesMapping, SynthChannel synth, AnalysisCtx ctx) {
        return new ApronOctagons(state, variablesMapping, synth, ctx);
    }

    @Override
    protected String printDomainValues() {
        return PrettyPrinters.compactOctagons(this.state, this.variablesMapping);
    }

    @Override
    VarSet getVarsWithTransitiveRelations(VarSet vars) throws ApronException {
        return VarSet.from(this.variablesMapping.keys(), this.variablesMapping.size());
    }

    @Override
    public void toCompactString(StringBuilder builder) {
        String domainValues = PrettyPrinters.asIntervals(this.state, this.variablesMapping, false) + "\n" + this.printDomainValues();
        String string = StringHelpers.indentMultiline("APRON(Octagons): #" + this.variablesMapping.size() + " ", domainValues);
        builder.append(string);
    }

    @Override
    public void varToCompactString(StringBuilder builder, NumVar var) {
        Range range = this.queryRange(Linear.linear(var));
        if (range.isConstant()) {
            builder.append(range.getMin());
        } else {
            builder.append(var);
        }
    }
}

