/*
 * Decompiled with CFR 0.152.
 */
package bindead.domainnetwork.combinators;

import bindead.data.NumVar;
import bindead.domainnetwork.interfaces.MemoryDomain;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.RegionCtx;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javalx.data.Option;
import rreil.lang.Lhs;
import rreil.lang.MemVar;
import rreil.lang.Rhs;
import rreil.lang.util.Type;

public abstract class MemoryChildOp {
    public abstract <D extends MemoryDomain<D>> D apply(D var1);

    public static class Sequence
    implements Iterable<MemoryChildOp> {
        private final List<MemoryChildOp> childTrans = new ArrayList<MemoryChildOp>(6);

        @Override
        public Iterator<MemoryChildOp> iterator() {
            return this.childTrans.iterator();
        }

        public void addAssignment(Lhs lhs, Rhs rhs, Option<ProgramPoint> point) {
            this.childTrans.add(new Assignment(lhs, rhs, point));
        }

        public void addRegionIntro(MemVar region, RegionCtx ctx) {
            this.childTrans.add(new RegionIntroduction(region, ctx));
        }

        public void addIntro(NumVar variable, Type type) {
            this.childTrans.add(new Introduction(variable, type));
        }

        public <D extends MemoryDomain<D>> D apply(D state) {
            for (MemoryChildOp action : this.childTrans) {
                state = action.apply(state);
            }
            return state;
        }

        public String toString() {
            String res = "";
            String sep = "";
            for (MemoryChildOp ct : this.childTrans) {
                res = res + sep + ct.toString();
                sep = "; ";
            }
            return res;
        }
    }

    private static class Assignment
    extends MemoryChildOp {
        private final Lhs lhs;
        private final Rhs rhs;
        private final Option<ProgramPoint> point;

        protected Assignment(Lhs lhs, Rhs rhs, Option<ProgramPoint> point) {
            this.lhs = lhs;
            this.rhs = rhs;
            this.point = point;
        }

        public String toString() {
            return this.lhs + " := " + this.rhs + " @ " + this.point;
        }

        @Override
        public <D extends MemoryDomain<D>> D apply(D state) {
            return state.evalAssign(this.lhs, this.rhs);
        }
    }

    private static class Introduction
    extends MemoryChildOp {
        private final NumVar variable;
        private final Type type;

        protected Introduction(NumVar variable, Type type) {
            this.variable = variable;
            this.type = type;
        }

        public String toString() {
            return "intro " + this.variable.toString();
        }

        @Override
        public <D extends MemoryDomain<D>> D apply(D state) {
            return state.introduce(this.variable, this.type, Option.none());
        }
    }

    private static class RegionIntroduction
    extends MemoryChildOp {
        private final MemVar region;
        private final RegionCtx ctx;

        protected RegionIntroduction(MemVar region, RegionCtx ctx) {
            this.region = region;
            this.ctx = ctx;
        }

        public String toString() {
            return "intro " + this.region + ": " + this.ctx;
        }

        @Override
        public <D extends MemoryDomain<D>> D apply(D state) {
            return state.introduceRegion(this.region, this.ctx);
        }
    }
}

