/*
 * Decompiled with CFR 0.152.
 */
package bindead.data.properties;

import bindead.data.properties.BoolProperty;

public class DebugProperties {
    static final String keyFmtDebug = "domains.%s.debug.%s";
    static final String keyFmtOption = "domains.%s.option.%s";
    public final BoolProperty debugSummary;
    public final BoolProperty debugAssignments;
    public final BoolProperty debugTests;
    public final BoolProperty debugBinaryOperations;
    public final BoolProperty debugWidening;
    public final BoolProperty debugSubsetOrEqual;
    public final BoolProperty debugQueries;
    public final BoolProperty debugOther;
    public final BoolProperty checkState;

    public DebugProperties(String name) {
        this.debugSummary = DebugProperties.makeDebugProperty(name, "summary");
        this.debugAssignments = DebugProperties.makeDebugProperty(name, "assignments");
        this.debugTests = DebugProperties.makeDebugProperty(name, "tests");
        this.debugBinaryOperations = DebugProperties.makeDebugProperty(name, "binaryoperations");
        this.debugSubsetOrEqual = DebugProperties.makeDebugProperty(name, "subsetorequal");
        this.debugWidening = DebugProperties.makeDebugProperty(name, "widening");
        this.debugQueries = DebugProperties.makeDebugProperty(name, "queries");
        this.debugOther = DebugProperties.makeDebugProperty(name, "other");
        this.checkState = DebugProperties.makeDebugProperty(name, "checkstate");
    }

    public void enableAllDebugSwitches() {
        this.debugAssignments.setValue(true);
        this.debugTests.setValue(true);
        this.debugBinaryOperations.setValue(true);
        this.debugWidening.setValue(true);
        this.debugSubsetOrEqual.setValue(true);
        this.debugQueries.setValue(true);
        this.debugOther.setValue(true);
    }

    public void disableAllDebugSwitches() {
        this.debugAssignments.setValue(false);
        this.debugTests.setValue(false);
        this.debugBinaryOperations.setValue(false);
        this.debugWidening.setValue(false);
        this.debugSubsetOrEqual.setValue(false);
        this.debugQueries.setValue(false);
        this.debugOther.setValue(false);
    }

    protected static BoolProperty makeDebugProperty(String name, String assignments) {
        return new BoolProperty(String.format(keyFmtDebug, name.toLowerCase(), assignments));
    }

    protected static BoolProperty makeOptionProperty(String name, String assignments) {
        return new BoolProperty(String.format(keyFmtOption, name.toLowerCase(), assignments));
    }
}

