/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.systems;

import bindead.analyses.systems.GenericSystemModel;
import bindead.analyses.systems.LinuxX86Model;
import bindead.analyses.systems.RReilSystemModel;
import bindead.analyses.systems.SystemModel;
import bindead.environment.abi.ABI;
import bindead.environment.abi.RReilABI;
import bindead.environment.abi.X32SysVAbi;
import bindead.environment.abi.X64SysVAbi;
import bindead.environment.platform.Platform;
import bindead.environment.platform.PlatformsRegistry;
import binparse.Binary;
import java.util.HashMap;
import java.util.Map;

public class SystemModelRegistry {
    private static final Map<SystemModel.ESystemType, Ctor> map = new HashMap<SystemModel.ESystemType, Ctor>();

    private static SystemModel getModel(SystemModel.ESystemType type, Binary binary) {
        Ctor systemCtor = map.get((Object)type);
        Platform platform = PlatformsRegistry.get(binary);
        return systemCtor.buildFor(platform, binary);
    }

    public static GenericSystemModel getLinuxModel(Binary file) {
        if (file.getArchitectureName().equals("rreil-vm")) {
            return SystemModelRegistry.getRReilModel(file);
        }
        return (LinuxX86Model)SystemModelRegistry.getModel(SystemModel.ESystemType.LINUX, file);
    }

    public static GenericSystemModel getRReilModel(Binary binary) {
        Platform platform = PlatformsRegistry.get(binary);
        String platformName = platform.getName();
        assert (platformName.equals("rreil-vm"));
        return new RReilSystemModel(new RReilABI(platform));
    }

    static {
        map.put(SystemModel.ESystemType.LINUX, new LinuxCtor());
    }

    private static class LinuxCtor
    implements Ctor {
        private LinuxCtor() {
        }

        @Override
        public SystemModel buildFor(Platform platform, Binary binary) {
            ABI abi;
            String platformName = platform.getName();
            if (platformName.toLowerCase().startsWith("x86-32")) {
                abi = new X32SysVAbi(platform);
            } else if (platformName.toLowerCase().startsWith("x86-64")) {
                abi = new X64SysVAbi(platform);
            } else {
                throw new IllegalArgumentException("No linux model for platform: " + platformName);
            }
            return new LinuxX86Model(abi, binary);
        }
    }

    private static interface Ctor {
        public SystemModel buildFor(Platform var1, Binary var2);
    }
}

