/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.systems;

import bindead.analyses.systems.INativeFunctionHandler;
import bindead.analyses.systems.INativeHandler;
import bindead.analyses.systems.SystemModel;
import bindead.analyses.systems.natives.DefinitionId;
import bindead.analyses.systems.natives.FunctionDefinition;
import bindead.analyses.systems.natives.IDefinitionProvider;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.environment.abi.ABI;
import binparse.Symbol;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javalx.data.Option;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;

public abstract class GenericSystemModel
extends SystemModel {
    private final Map<String, INativeHandler> nativesMap = new HashMap<String, INativeHandler>();
    private final Map<RReilAddr, INativeFunctionHandler> functionMap = new HashMap<RReilAddr, INativeFunctionHandler>();

    protected GenericSystemModel(SystemModel.ESystemType type, ABI abi) {
        super(type, abi);
    }

    @Override
    public <D extends RootDomain<D>> List<Option<FunctionDefinition>> handleNative(RReil.Native stmt, D state, ProgramPoint ctx) {
        String name = stmt.getName();
        INativeHandler handler = this.nativesMap.get(name);
        if (handler != null) {
            try {
                return handler.handleNative(stmt, state, ctx);
            }
            catch (Exception err) {
                System.err.println("Error while fetching native function:");
                err.printStackTrace();
            }
        }
        return this.defaultReaction(stmt, state, ctx);
    }

    protected void registerNativeHandler(String key, INativeHandler handler) {
        this.nativesMap.put(key, handler);
    }

    protected <D extends RootDomain<D>> List<Option<FunctionDefinition>> defaultReaction(RReil.Native stmt, D state, ProgramPoint programPoint) {
        return Arrays.asList(Option.none());
    }

    @Override
    public <D extends RootDomain<D>> Option<FunctionDefinition> handleNativeFunction(RReilAddr addr, RReil stmt, D state) {
        INativeFunctionHandler functionHandler = this.functionMap.get(addr);
        if (functionHandler == null) {
            return this.defaultReaction(addr, stmt, state);
        }
        return functionHandler.handleNativeFunction(addr, stmt, state);
    }

    protected void registerFunctionHandler(RReilAddr callAddr, INativeFunctionHandler handler) {
        this.functionMap.put(callAddr, handler);
    }

    <D extends RootDomain<D>> Option<FunctionDefinition> defaultReaction(RReilAddr addr, RReil stmt, D state) {
        return Option.none();
    }

    static abstract class ANativeFunctionHandler
    implements INativeFunctionHandler {
        private final RReilAddr addr;
        private final Symbol symbol;
        protected final DefinitionId defId;
        protected final IDefinitionProvider defProvider;

        ANativeFunctionHandler(RReilAddr addr, Symbol symbol, IDefinitionProvider defProvider) {
            this.addr = addr;
            this.symbol = symbol;
            this.defId = DefinitionId.valueOf(symbol.getName().get());
            this.defProvider = defProvider;
        }

        public RReilAddr getAddr() {
            return this.addr;
        }

        public Symbol getSymbol() {
            return this.symbol;
        }

        public DefinitionId getDefinitionId() {
            return this.defId;
        }
    }
}

