/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.algorithms.data;

import bindead.analyses.algorithms.data.CallString;
import bindead.analyses.algorithms.data.ProgramCtx;
import bindead.domainnetwork.interfaces.ProgramPoint;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import rreil.lang.RReilAddr;

public class TransitionSystem {
    private final Map<CallString, ProceduralTransitions> procedures = new HashMap<CallString, ProceduralTransitions>();
    private final Multimap<RReilAddr, CallString> callstringsForProcedure = HashMultimap.create();
    private final Multimap<RReilAddr, RReilAddr> callsites = HashMultimap.create();
    private final Multimap<RReilAddr, RReilAddr> returnsites = HashMultimap.create();
    private final Multimap<RReilAddr, RReilAddr> flatSuccessors = HashMultimap.create();

    private ProceduralTransitions getProcedureOrFresh(CallString procedure) {
        ProceduralTransitions intraProceduralTransitions = this.procedures.get(procedure);
        if (intraProceduralTransitions == null) {
            intraProceduralTransitions = new ProceduralTransitions();
            this.procedures.put(procedure, intraProceduralTransitions);
            if (!procedure.isRoot()) {
                CallString.Transition lastCall = procedure.peek();
                this.callstringsForProcedure.put(lastCall.getTarget(), procedure);
            }
        }
        return intraProceduralTransitions;
    }

    public Map<CallString, ProceduralTransitions> getAllProcedures() {
        return this.procedures;
    }

    public Collection<CallString> getCallstringsForProcedure(RReilAddr procedureEntry) {
        return this.callstringsForProcedure.get(procedureEntry);
    }

    public Collection<RReilAddr> getCallSitesForProcedure(RReilAddr procedureEntry) {
        return this.callsites.get(procedureEntry);
    }

    public Collection<RReilAddr> getPotentialReturnSitesForProcedure(RReilAddr procedureEntry) {
        return this.returnsites.get(procedureEntry);
    }

    public Multimap<RReilAddr, RReilAddr> getAllPossibleTransitions() {
        return this.flatSuccessors;
    }

    public ProceduralTransitions getTransitionsFor(CallString procedure) {
        return this.getProcedureOrFresh(procedure);
    }

    public void addLocalTransition(CallString procedure, ProgramPoint from, ProgramPoint to) {
        ProceduralTransitions procedureTransitions = this.getProcedureOrFresh(procedure);
        procedureTransitions.addLocalTransition(from, to);
        this.flatSuccessors.put(from.getAddress(), to.getAddress());
    }

    public void addCallTransition(ProgramCtx from, ProgramCtx to) {
        ProceduralTransitions procedureTransitions = this.getProcedureOrFresh(from.getCallString());
        procedureTransitions.addCall(from, to);
        this.callsites.put(to.getAddress(), from.getAddress());
        this.flatSuccessors.put(from.getAddress(), to.getAddress());
    }

    public void addCallTransition(ProgramCtx from, ProgramCtx to, RReilAddr fallThroughAddress) {
        this.addCallTransition(from, to);
        this.returnsites.put(to.getAddress(), fallThroughAddress);
    }

    public void addReturnTransition(ProgramCtx from, ProgramCtx to) {
        ProceduralTransitions fromProcedureTransitions = this.getProcedureOrFresh(from.getCallString());
        fromProcedureTransitions.addReturn(from, to);
        this.flatSuccessors.put(from.getAddress(), to.getAddress());
    }

    public static class ProceduralTransitions {
        private final Multimap<ProgramPoint, ProgramPoint> localTransitions = HashMultimap.create();
        private final Multimap<ProgramPoint, ProgramCtx> calls = HashMultimap.create();
        private final Multimap<ProgramPoint, ProgramCtx> returns = HashMultimap.create();

        public void addLocalTransition(ProgramPoint from, ProgramPoint to) {
            this.localTransitions.put(from, to);
        }

        public void addCall(ProgramCtx from, ProgramCtx to) {
            this.calls.put(from, to);
        }

        public void addReturn(ProgramCtx from, ProgramCtx to) {
            this.returns.put(from, to);
        }

        public Multimap<ProgramPoint, ProgramPoint> getLocalTransitions() {
            return this.localTransitions;
        }

        public Multimap<ProgramPoint, ProgramCtx> getCalls() {
            return this.calls;
        }

        public Multimap<ProgramPoint, ProgramCtx> getReturns() {
            return this.returns;
        }
    }
}

