/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.algorithms;

import bindead.analyses.algorithms.data.Flows;
import bindead.analyses.warnings.WarningsMap;
import bindead.domainnetwork.channels.WarningMessage;
import bindead.domainnetwork.channels.WarningsContainer;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.exceptions.Unreachable;
import javalx.data.products.P2;
import javalx.numeric.BigInt;
import rreil.RReilGrammarException;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;
import rreil.lang.util.RReilVisitor;

public class RecursiveDisassemblerEvaluator<D extends RootDomain<D>>
implements RReilVisitor<Flows<D>, P2<ProgramPoint, RReilAddr>> {
    private WarningsMap warnings;

    public RecursiveDisassemblerEvaluator(WarningsMap warnings) {
        this.warnings = warnings;
    }

    @Override
    public Flows<D> visit(RReil.Assign stmt, P2<ProgramPoint, RReilAddr> ctx) {
        return this.fallThroughSuccessor(ctx);
    }

    @Override
    public Flows<D> visit(RReil.Load stmt, P2<ProgramPoint, RReilAddr> ctx) {
        return this.fallThroughSuccessor(ctx);
    }

    @Override
    public Flows<D> visit(RReil.Store stmt, P2<ProgramPoint, RReilAddr> ctx) {
        return this.fallThroughSuccessor(ctx);
    }

    @Override
    public Flows<D> visit(RReil.Nop stmt, P2<ProgramPoint, RReilAddr> ctx) {
        return this.fallThroughSuccessor(ctx);
    }

    @Override
    public Flows<D> visit(RReil.BranchToRReil stmt, P2<ProgramPoint, RReilAddr> ctx) {
        throw new RReilGrammarException();
    }

    @Override
    public Flows<D> visit(RReil.BranchToNative stmt, P2<ProgramPoint, RReilAddr> ctx) {
        BigInt conditionValue2;
        Flows flow = new Flows();
        Rhs.SimpleExpression se = stmt.getCond();
        if (!(se instanceof Rhs.LinRval)) {
            throw new RReilGrammarException();
        }
        Rhs.Rval condition = ((Rhs.LinRval)se).getRval();
        try {
            if (condition instanceof Rhs.Rlit) {
                conditionValue2 = ((Rhs.Rlit)condition).getValue();
                if (!conditionValue2.isZero()) {
                    throw new Unreachable();
                }
                flow.addNext(ctx._2(), null);
            }
        }
        catch (Unreachable conditionValue2) {
            // empty catch block
        }
        try {
            if (condition instanceof Rhs.Rlit) {
                conditionValue2 = ((Rhs.Rlit)condition).getValue();
                if (!conditionValue2.isOne()) {
                    throw new Unreachable();
                }
                throw new RReilGrammarException();
            }
        }
        catch (Unreachable unreachable) {
            // empty catch block
        }
        if (flow.isEmpty()) {
            flow.addNext(ctx._2(), null);
            throw new RReilGrammarException();
        }
        return flow;
    }

    @Override
    public Flows<D> visit(RReil.Branch stmt, P2<ProgramPoint, RReilAddr> ctx) {
        Flows flow = new Flows();
        throw new RReilGrammarException();
    }

    @Override
    public Flows<D> visit(RReil.PrimOp primOp, P2<ProgramPoint, RReilAddr> ctx) {
        if (primOp.is("halt", 0, 0)) {
            return Flows.halt(null);
        }
        return this.fallThroughSuccessor(ctx);
    }

    @Override
    public Flows<D> visit(RReil.Native stmt, P2<ProgramPoint, RReilAddr> ctx) {
        return this.fallThroughSuccessor(ctx);
    }

    @Override
    public Flows<D> visit(RReil.Assertion stmt, P2<ProgramPoint, RReilAddr> ctx) {
        return this.fallThroughSuccessor(ctx);
    }

    @Override
    public Flows<D> visit(RReil.Throw stmt, P2<ProgramPoint, RReilAddr> ctx) {
        return this.fallThroughSuccessor(ctx);
    }

    @Override
    public Flows<D> visit(RReil.Flop stmt, P2<ProgramPoint, RReilAddr> ctx) {
        return this.fallThroughSuccessor(ctx);
    }

    private Flows<D> fallThroughSuccessor(P2<ProgramPoint, RReilAddr> ctx) {
        RReilAddr nextInstructionaddress = ctx._2();
        return Flows.next(nextInstructionaddress, null);
    }

    private void addWarning(ProgramPoint location, WarningMessage warning) {
        WarningsContainer warningsHere = this.warnings.get(location);
        warningsHere.addWarning(warning);
        this.warnings.put(location, 0, warningsHere);
    }
}

