/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.algorithms;

import bindead.analyses.Analysis;
import bindead.analyses.BinaryCodeCache;
import bindead.analyses.ProgressReporter;
import bindead.analyses.RReilCodeCache;
import bindead.analyses.algorithms.AnalysisProperties;
import bindead.analyses.algorithms.FixpointAnalysisEvaluator;
import bindead.analyses.algorithms.data.CallString;
import bindead.analyses.algorithms.data.Flows;
import bindead.analyses.algorithms.data.ProgramCtx;
import bindead.analyses.algorithms.data.StateSpace;
import bindead.analyses.algorithms.data.TransitionSystem;
import bindead.analyses.algorithms.data.Worklist;
import bindead.analyses.warnings.WarningsMap;
import bindead.debug.AnalysisDebugger;
import bindead.domainnetwork.interfaces.AnalysisCtx;
import bindead.domainnetwork.interfaces.ContentCtx;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.RegionCtx;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.environment.AnalysisEnvironment;
import bindead.environment.abi.ABI;
import bindead.exceptions.AnalysisException;
import bindead.exceptions.CallStringAnalysisException;
import bindead.exceptions.DomainStateException;
import binparse.Binary;
import binparse.Segment;
import java.util.ArrayList;
import java.util.List;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.data.products.P3;
import javalx.mutablecollections.CollectionHelpers;
import javalx.numeric.BigInt;
import rreil.disassembler.BlockOfInstructions;
import rreil.disassembler.Instruction;
import rreil.lang.MemVar;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.lowlevel.LowLevelRReil;

public class FixpointAnalysis<D extends RootDomain<D>>
extends Analysis<D> {
    private final D initialState;
    protected final StateSpace<D> states;
    private final TransitionSystem transitions;
    private final BinaryCodeCache binaryCode;
    private final RReilCodeCache rreilCode;
    private FixpointAnalysisEvaluator<D> evaluator;
    private long analysisStartCanary;
    private final boolean DEBUGWARNINGS;
    private final boolean DEBUGEVAL;
    private final boolean DEBUGOTHER;
    private final boolean DISASSEMBLEBLOCKS;
    private final AnalysisDebugger debugger;
    private final ProgressReporter progressReporter;

    public FixpointAnalysis(AnalysisEnvironment environment, Binary binary, D initialState) {
        super(environment);
        this.DEBUGWARNINGS = AnalysisProperties.INSTANCE.debugWarnings.isTrue();
        this.DEBUGEVAL = AnalysisProperties.INSTANCE.debugAssignments.isTrue();
        this.DEBUGOTHER = AnalysisProperties.INSTANCE.debugOther.isTrue();
        this.DISASSEMBLEBLOCKS = AnalysisProperties.INSTANCE.disassembleBlockWise.isTrue();
        this.states = new StateSpace();
        this.transitions = new TransitionSystem();
        this.initialState = (RootDomain)initialState.setContext(new AnalysisCtx(environment));
        this.binaryCode = new BinaryCodeCache(binary, this.getPlatform().getDisassembler(), this.getWarnings());
        this.rreilCode = new RReilCodeCache(binary);
        this.debugger = new AnalysisDebugger(this.binaryCode, this.rreilCode);
        this.progressReporter = new ProgressReporter(this.getWarnings());
    }

    @Override
    public BinaryCodeCache getBinaryCode() {
        return this.binaryCode;
    }

    @Override
    public RReilCodeCache getRReilCode() {
        return this.rreilCode;
    }

    @Override
    public TransitionSystem getTransitionSystem() {
        return this.transitions;
    }

    @Override
    public Option<D> getState(CallString callString, RReilAddr address) {
        return this.states.get(new ProgramCtx(callString, address));
    }

    @Override
    public WarningsMap getWarnings() {
        return this.states.getWarnings();
    }

    @Override
    public ProgressReporter getProgressMonitoring() {
        return this.progressReporter;
    }

    @Override
    public void runFrom(RReilAddr startPoint) {
        assert (startPoint.offset() == 0);
        D state = this.getPlatform().forwardAnalysisBootstrap().bootstrap(this.initialState, startPoint.base());
        state = this.introduceDataSegments(state);
        state = this.setAnalysisStartStackCanary(state, startPoint);
        ProgramCtx entry = new ProgramCtx(CallString.root(), startPoint);
        this.states.setInitial(entry, state);
        this.debugger.printWarnings(entry, this.getWarnings());
        this.processWorklist(entry);
        this.debugger.printSummary(this.states, this.getWarnings());
        if (this.DEBUGWARNINGS) {
            System.out.println(this.getWarnings());
        }
    }

    private void processWorklist(ProgramCtx entry) {
        Worklist<ProgramCtx> worklist = new Worklist<ProgramCtx>();
        worklist.enqueue(entry);
        while (!worklist.isEmpty()) {
            if (this.DEBUGOTHER) {
                System.out.println("\nOld:" + worklist);
            }
            ProgramCtx currentPoint = (ProgramCtx)worklist.dequeue();
            if (this.DEBUGOTHER) {
                System.out.println("CurrentElement: " + currentPoint);
            }
            List<ProgramCtx> successors = this.resolveSuccesorsWrapper(currentPoint);
            for (ProgramCtx successor : CollectionHelpers.reversedIterable(successors)) {
                worklist.enqueue(successor);
            }
            if (!this.DEBUGOTHER) continue;
            System.out.println("Successors: " + successors);
            System.out.println("New:" + worklist);
        }
    }

    private D setAnalysisStartStackCanary(D state, RReilAddr startAddress) {
        this.analysisStartCanary = startAddress.base();
        ABI abi = this.environment.getABI();
        if (abi == null) {
            return state;
        }
        return abi.writeAnalysisStartStackCanary(startAddress, this.analysisStartCanary, state);
    }

    private D introduceDataSegments(D state) {
        for (Segment segment : this.binaryCode.getBinary().getSegments()) {
            String name = segment.getNameOrAddress().replaceAll("\\.|-", "_");
            BigInt address = BigInt.of(segment.getAddress());
            long size = segment.getSize();
            ContentCtx segmentCtx = new ContentCtx(name, address, size, segment.getPermissions(), segment.getData(), segment.getEndianness());
            state = (RootDomain)state.introduceRegion(MemVar.fresh(segmentCtx.getName()), new RegionCtx(segmentCtx));
            state = (RootDomain)state.eval(String.format("prim fixAtConstantAddress (%s.%d)", segmentCtx.getName(), this.getPlatform().defaultArchitectureSize()));
        }
        return (D)state;
    }

    private List<ProgramCtx> resolveSuccesorsWrapper(ProgramCtx point) {
        try {
            if (Thread.interrupted()) {
                throw new InterruptedException("Analysis was stopped by user.");
            }
            return this.resolveSuccesors(point);
        }
        catch (CallStringAnalysisException cause) {
            try {
                this.debugger.printInstruction(point);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.DEBUGEVAL) {
                System.out.println();
            }
            throw cause;
        }
        catch (RuntimeException cause) {
            try {
                this.debugger.printInstruction(point);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.DEBUGEVAL) {
                System.out.println("\nBAM!\n" + cause + "\n");
            }
            this.states.putWarnings(point, ((RootDomain)this.states.get(point).get()).getContext().getWarningsChannel());
            this.debugger.printSummary(this.states, this.getWarnings());
            System.out.println(this.getWarnings());
            throw cause;
        }
        catch (Error cause) {
            try {
                this.debugger.printInstruction(point);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.DEBUGEVAL) {
                System.out.println("\nBAM!\n" + cause + "\n");
            }
            this.states.putWarnings(point, ((RootDomain)this.states.get(point).get()).getContext().getWarningsChannel());
            this.debugger.printSummary(this.states, this.getWarnings());
            System.out.println(this.getWarnings());
            throw cause;
        }
        catch (Throwable cause) {
            throw new CallStringAnalysisException(cause, this, point.getCallString(), point.getAddress());
        }
    }

    private List<ProgramCtx> resolveSuccesors(ProgramCtx currentProgramPoint) {
        RReilAddr currentAddress = currentProgramPoint.getAddress();
        P2<RReil, RReilAddr> pair = this.getInstruction(currentAddress);
        RReil currentRReilInstruction = pair._1();
        RReilAddr nextAddress = pair._2();
        RootDomain domainState = (RootDomain)this.states.get(currentProgramPoint).get();
        this.debugBeforeEval(currentRReilInstruction, currentProgramPoint, domainState);
        this.debugger.printInstruction(currentProgramPoint);
        this.progressReporter.evaluatingInstruction(currentRReilInstruction);
        FixpointAnalysisEvaluator<D> evaluator = this.getEvaluator();
        P3<RootDomain, ProgramCtx, RReilAddr> ctx = P3.tuple3(domainState, currentProgramPoint, nextAddress);
        Flows successors = (Flows)currentRReilInstruction.accept(evaluator, ctx);
        ArrayList loggedSuccessors = new ArrayList();
        ArrayList<ProgramCtx> queue = new ArrayList<ProgramCtx>();
        for (Flows.Successor successor : successors) {
            switch (successor.getType()) {
                case Call: 
                case Return: 
                case Next: 
                case Jump: {
                    boolean updated = this.updateWorklist(currentProgramPoint, successor, queue);
                    loggedSuccessors.add(new P2(successor, updated));
                    break;
                }
                case Halt: {
                    this.states.putWarnings(currentProgramPoint, successor.getState().getContext().getWarningsChannel());
                    break;
                }
                case Error: {
                    this.states.putWarnings(currentProgramPoint, successor.getState().getContext().getWarningsChannel());
                    throw new AnalysisException();
                }
            }
        }
        this.debugger.printSuccessors(loggedSuccessors);
        this.debugAfterEval(currentRReilInstruction, currentProgramPoint, successors);
        this.debugger.printWarnings(currentProgramPoint, this.getWarnings());
        this.debugger.printSeparator();
        if (successors.isEmpty()) {
            throw new DomainStateException.InvariantViolationException("No successors inferred after evaluating last instruction.");
        }
        return queue;
    }

    private P2<RReil, RReilAddr> getInstruction(RReilAddr address) {
        RReilAddr nextInstructionAddress;
        Option<RReilAddr> nextInstructionOption;
        if (!this.binaryCode.hasInstruction(address.base())) {
            this.disassemble(address);
        }
        if ((nextInstructionOption = this.rreilCode.getNextInstructionAddressWithSameBase(address)).isSome()) {
            nextInstructionAddress = nextInstructionOption.get();
        } else {
            long nextNativeAddress = this.binaryCode.getNextDisassemblyAddress(address.base());
            nextInstructionAddress = RReilAddr.valueOf(nextNativeAddress);
        }
        RReil rreilInsn = this.rreilCode.getInstruction(address);
        return P2.tuple2(rreilInsn, nextInstructionAddress);
    }

    private void disassemble(RReilAddr address) {
        if (this.DISASSEMBLEBLOCKS) {
            this.disassembleBlock(address);
        } else {
            this.disassembleOne(address);
        }
    }

    private void disassembleOne(RReilAddr address) {
        Instruction insn = this.binaryCode.decodeInstruction(address.base());
        for (LowLevelRReil stmt : insn.toRReilInstructions()) {
            this.rreilCode.addInstruction(stmt.toRReil());
        }
    }

    private void disassembleBlock(RReilAddr address) {
        BlockOfInstructions block = this.binaryCode.decodeBlock(address.base());
        for (LowLevelRReil stmt : block.toRReilInstructions()) {
            this.rreilCode.addInstruction(stmt.toRReil());
        }
    }

    protected boolean updateWorklist(ProgramCtx from, Flows.Successor<D> successor, List<ProgramCtx> queue) {
        ProgramCtx to = new ProgramCtx(from.getCallString(), successor.getAddress());
        boolean updated = this.states.update(from, successor.getType(), to, successor.getState(), true);
        if (updated) {
            queue.add(to);
            return true;
        }
        return false;
    }

    protected FixpointAnalysisEvaluator<D> getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = new FixpointAnalysisEvaluator(this.analysisStartCanary);
        }
        return this.evaluator;
    }

    private void debugBeforeEval(RReil stmt, ProgramPoint point, D domainState) {
        if (this.debugHooks != null) {
            this.debugHooks.beforeEval(stmt, point, domainState, this);
        }
    }

    private void debugAfterEval(RReil stmt, ProgramPoint point, Flows<D> flow) {
        if (this.debugHooks != null) {
            for (Flows.Successor<D> successor : flow) {
                this.debugHooks.afterEval(stmt, point, successor.getAddress(), successor.getState(), this);
            }
        }
    }
}

