/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.algorithms;

import bindead.analyses.Analysis;
import bindead.analyses.BinaryCodeCache;
import bindead.analyses.ProgressReporter;
import bindead.analyses.RReilCodeCache;
import bindead.analyses.algorithms.AnalysisProperties;
import bindead.analyses.algorithms.FixpointAnalysisEvaluator;
import bindead.analyses.algorithms.data.CallString;
import bindead.analyses.algorithms.data.Flows;
import bindead.analyses.algorithms.data.ProgramCtx;
import bindead.analyses.algorithms.data.StateSpace;
import bindead.analyses.algorithms.data.TransitionSystem;
import bindead.analyses.algorithms.data.Worklist;
import bindead.analyses.warnings.WarningsMap;
import bindead.debug.AnalysisDebugger;
import bindead.domainnetwork.interfaces.AnalysisCtx;
import bindead.domainnetwork.interfaces.ContentCtx;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.RegionCtx;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.environment.AnalysisEnvironment;
import bindead.environment.abi.ABI;
import bindead.exceptions.AnalysisException;
import bindead.exceptions.CallStringAnalysisException;
import bindead.exceptions.DomainStateException;
import binparse.Binary;
import binparse.Segment;
import java.util.ArrayList;
import java.util.List;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.data.products.P3;
import javalx.mutablecollections.CollectionHelpers;
import javalx.numeric.BigInt;
import rreil.disassembler.Instruction;
import rreil.lang.MemVar;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.lowlevel.LowLevelRReil;

public class CallStringAnalysis<D extends RootDomain<D>>
extends Analysis<D> {
    private final D initialState;
    protected final StateSpace<D> states;
    private final TransitionSystem transitions;
    private final BinaryCodeCache binaryCode;
    private final RReilCodeCache rreilCode;
    private FixpointAnalysisEvaluator<D> evaluator;
    private long analysisStartCanary;
    private final boolean DEBUGWARNINGS;
    private final boolean DEBUGEVAL;
    private final boolean DEBUGOTHER;
    private final AnalysisDebugger debugger;
    private final ProgressReporter progressReporter;

    public CallStringAnalysis(AnalysisEnvironment environment, Binary binary, D initialState) {
        super(environment);
        this.DEBUGWARNINGS = AnalysisProperties.INSTANCE.debugWarnings.isTrue();
        this.DEBUGEVAL = AnalysisProperties.INSTANCE.debugAssignments.isTrue();
        this.DEBUGOTHER = AnalysisProperties.INSTANCE.debugOther.isTrue();
        this.states = new StateSpace();
        this.transitions = new TransitionSystem();
        this.initialState = (RootDomain)initialState.setContext(new AnalysisCtx(environment));
        this.binaryCode = new BinaryCodeCache(binary, this.getPlatform().getDisassembler(), this.getWarnings());
        this.rreilCode = new RReilCodeCache(binary);
        this.debugger = new AnalysisDebugger(this.binaryCode, this.rreilCode);
        this.progressReporter = new ProgressReporter(this.getWarnings());
    }

    @Override
    public BinaryCodeCache getBinaryCode() {
        return this.binaryCode;
    }

    @Override
    public RReilCodeCache getRReilCode() {
        return this.rreilCode;
    }

    @Override
    public TransitionSystem getTransitionSystem() {
        return this.transitions;
    }

    @Override
    public Option<D> getState(CallString callString, RReilAddr address) {
        return this.states.get(new ProgramCtx(callString, address));
    }

    @Override
    public void runFrom(RReilAddr startPoint) {
        CallString rootCs = CallString.root();
        this.runFrom(startPoint, rootCs);
    }

    public void runFrom(RReilAddr startPoint, int callstringLength) {
        CallString rootCs = CallString.root(callstringLength);
        this.runFrom(startPoint, rootCs);
    }

    private void runFrom(RReilAddr startPoint, CallString root) {
        assert (startPoint.offset() == 0);
        D state = this.getPlatform().forwardAnalysisBootstrap().bootstrap(this.initialState, startPoint.base());
        state = this.introduceDataSegments(state);
        state = this.setAnalysisStartStackCanary(state, startPoint);
        RReilAddr artificialStartPoint = RReilAddr.ZERO;
        CallString.Transition callTransition = new CallString.Transition(artificialStartPoint, startPoint);
        ProgramCtx artificialEntry = new ProgramCtx(root, artificialStartPoint);
        ProgramCtx entry = new ProgramCtx(root.push(callTransition), startPoint);
        this.transitions.addCallTransition(artificialEntry, entry);
        this.states.setInitial(entry, state);
        this.debugger.printWarnings(entry, this.getWarnings());
        Worklist<ProgramCtx> queue = new Worklist<ProgramCtx>();
        queue.enqueue(entry);
        while (!queue.isEmpty()) {
            if (this.DEBUGOTHER) {
                System.out.println("\nOld:" + queue);
            }
            ProgramCtx currentPoint = (ProgramCtx)queue.dequeue();
            if (this.DEBUGOTHER) {
                System.out.println("CurrentElement: " + currentPoint);
            }
            List<ProgramCtx> successors = this.resolveSuccesorsWrapper(currentPoint);
            for (ProgramCtx successor : CollectionHelpers.reversedIterable(successors)) {
                queue.enqueue(successor);
            }
            if (!this.DEBUGOTHER) continue;
            System.out.println("Successors: " + successors);
            System.out.println("New:" + queue);
        }
        this.debugger.printSummary(this.states, this.getWarnings());
        if (this.DEBUGWARNINGS) {
            System.out.println(this.getWarnings());
        }
    }

    @Override
    public WarningsMap getWarnings() {
        return this.states.getWarnings();
    }

    @Override
    public ProgressReporter getProgressMonitoring() {
        return this.progressReporter;
    }

    private D setAnalysisStartStackCanary(D state, RReilAddr startAddress) {
        this.analysisStartCanary = startAddress.base();
        ABI abi = this.environment.getABI();
        if (abi == null) {
            return state;
        }
        return abi.writeAnalysisStartStackCanary(startAddress, this.analysisStartCanary, state);
    }

    private D introduceDataSegments(D state) {
        for (Segment segment : this.binaryCode.getBinary().getSegments()) {
            String name = segment.getNameOrAddress().replaceAll("\\.|-", "_");
            BigInt address = BigInt.of(segment.getAddress());
            long size = segment.getSize();
            ContentCtx segmentCtx = new ContentCtx(name, address, size, segment.getPermissions(), segment.getData(), segment.getEndianness());
            state = (RootDomain)state.introduceRegion(MemVar.fresh(segmentCtx.getName()), new RegionCtx(segmentCtx));
            state = (RootDomain)state.eval(String.format("prim fixAtConstantAddress (%s.%d)", segmentCtx.getName(), this.getPlatform().defaultArchitectureSize()));
        }
        return (D)state;
    }

    private List<ProgramCtx> resolveSuccesorsWrapper(ProgramCtx point) {
        try {
            if (Thread.interrupted()) {
                throw new InterruptedException("Analysis was stopped by user.");
            }
            return this.resolveSuccesors(point);
        }
        catch (CallStringAnalysisException cause) {
            this.debugger.printInstruction(point);
            if (this.DEBUGEVAL) {
                System.out.println();
            }
            throw cause;
        }
        catch (Throwable cause) {
            this.debugger.printInstruction(point);
            if (this.DEBUGEVAL) {
                System.out.println("\nBAM!\n");
            }
            this.states.putWarnings(point, ((RootDomain)this.states.get(point).get()).getContext().getWarningsChannel());
            this.debugger.printSummary(this.states, this.getWarnings());
            System.out.println(this.getWarnings());
            throw new CallStringAnalysisException(cause, this, point.getCallString(), point.getAddress());
        }
    }

    private List<ProgramCtx> resolveSuccesors(ProgramCtx currentProgramPoint) {
        RReilAddr currentAddress = currentProgramPoint.getAddress();
        this.disassemble(currentAddress);
        RReil stmt = this.rreilCode.getInstruction(currentAddress);
        RootDomain domainState = (RootDomain)this.states.get(currentProgramPoint).get();
        this.debugBeforeEval(stmt, currentProgramPoint, domainState);
        this.debugger.printInstruction(currentProgramPoint);
        this.progressReporter.evaluatingInstruction(stmt);
        FixpointAnalysisEvaluator<D> evaluator = this.getEvaluator();
        RReilAddr nextAddress = this.nextInstructionAddress(currentAddress);
        P3<RootDomain, ProgramCtx, RReilAddr> ctx = P3.tuple3(domainState, currentProgramPoint, nextAddress);
        Flows successors = (Flows)stmt.accept(evaluator, ctx);
        ArrayList loggedSuccessors = new ArrayList();
        ArrayList<ProgramCtx> queue = new ArrayList<ProgramCtx>();
        CallString currentCallString = currentProgramPoint.getCallString();
        for (Flows.Successor successor : successors) {
            switch (successor.getType()) {
                case Call: {
                    CallString.Transition callTransition = new CallString.Transition(currentAddress, successor.getAddress());
                    CallString calleeCallString = currentCallString.push(callTransition);
                    ProgramCtx to = new ProgramCtx(calleeCallString, successor.getAddress());
                    this.transitions.addCallTransition(currentProgramPoint, to, nextAddress);
                    boolean updated = this.updateWorklist(currentProgramPoint, to, successor, queue, false);
                    loggedSuccessors.add(new P2(successor, updated));
                    break;
                }
                case Return: {
                    if (currentCallString.isRoot()) break;
                    CallString callerCallString = currentCallString.unsafePop();
                    ProgramCtx to = new ProgramCtx(callerCallString, successor.getAddress());
                    this.transitions.addReturnTransition(currentProgramPoint, to);
                    boolean updated = this.updateWorklist(currentProgramPoint, to, successor, queue, false);
                    loggedSuccessors.add(new P2(successor, updated));
                    break;
                }
                case Next: 
                case Jump: {
                    ProgramCtx to = new ProgramCtx(currentCallString, successor.getAddress());
                    this.transitions.addLocalTransition(currentCallString, currentProgramPoint, to);
                    boolean updated = this.updateWorklist(currentProgramPoint, to, successor, queue, true);
                    loggedSuccessors.add(new P2(successor, updated));
                    break;
                }
                case Halt: {
                    this.states.putWarnings(currentProgramPoint, successor.getState().getContext().getWarningsChannel());
                    break;
                }
                case Error: {
                    this.states.putWarnings(currentProgramPoint, successor.getState().getContext().getWarningsChannel());
                    throw new AnalysisException();
                }
            }
        }
        this.debugger.printSuccessors(loggedSuccessors);
        this.debugAfterEval(stmt, currentProgramPoint, successors);
        this.debugger.printWarnings(currentProgramPoint, this.getWarnings());
        this.debugger.printSeparator();
        if (successors.isEmpty()) {
            throw new DomainStateException.InvariantViolationException("No successors inferred after evaluating last instruction.");
        }
        return queue;
    }

    private void disassemble(RReilAddr address) {
        if (this.binaryCode.hasInstruction(address.base())) {
            return;
        }
        Instruction insn = this.binaryCode.decodeInstruction(address.base());
        for (LowLevelRReil stmt : insn.toRReilInstructions()) {
            this.rreilCode.addInstruction(stmt.toRReil());
        }
    }

    private RReilAddr nextInstructionAddress(RReilAddr currentInstructionAddress) {
        RReilAddr nextInstructionAddress;
        Option<RReilAddr> nextInstructionOption = this.rreilCode.getNextInstructionAddressWithSameBase(currentInstructionAddress);
        if (nextInstructionOption.isSome()) {
            nextInstructionAddress = nextInstructionOption.get();
        } else {
            long nextNativeAddress = this.binaryCode.getNextDisassemblyAddress(currentInstructionAddress.base());
            nextInstructionAddress = RReilAddr.valueOf(nextNativeAddress);
        }
        return nextInstructionAddress;
    }

    protected boolean updateWorklist(ProgramCtx from, ProgramCtx to, Flows.Successor<D> successor, List<ProgramCtx> queue, boolean useWidening) {
        this.disassemble(to.getAddress());
        boolean updated = this.states.update(from, successor.getType(), to, successor.getState(), useWidening);
        if (updated) {
            queue.add(to);
            return true;
        }
        return false;
    }

    protected FixpointAnalysisEvaluator<D> getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = new FixpointAnalysisEvaluator(this.analysisStartCanary);
        }
        return this.evaluator;
    }

    private void debugBeforeEval(RReil stmt, ProgramPoint point, D domainState) {
        if (this.debugHooks != null) {
            this.debugHooks.beforeEval(stmt, point, domainState, this);
        }
    }

    private void debugAfterEval(RReil stmt, ProgramPoint point, Flows<D> flow) {
        if (this.debugHooks != null) {
            for (Flows.Successor<D> successor : flow) {
                this.debugHooks.afterEval(stmt, point, successor.getAddress(), successor.getState(), this);
            }
        }
    }
}

