/*
 * Decompiled with CFR 0.152.
 */
package bindead.abstractsyntax.zeno.util;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.analyses.algorithms.AnalysisProperties;
import bindead.data.Linear;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.exceptions.Unreachable;
import javalx.numeric.BigInt;
import javalx.numeric.Interval;
import javalx.persistentcollections.AVLSet;

public class ZenoTestHelper {
    public static boolean isTautology(Zeno.Test test) {
        try {
            return ZenoTestHelper.isTautologyReportUnreachable(test);
        }
        catch (Unreachable e) {
            return true;
        }
    }

    public static boolean isTautologyReportUnreachable(Zeno.Test test) throws Unreachable {
        if (test.getExpr().isConstantOnly()) {
            BigInt exprValue = test.getExpr().getConstant();
            switch (test.getOperator()) {
                case EqualToZero: {
                    if (exprValue.isZero()) {
                        return true;
                    }
                    if (AnalysisProperties.INSTANCE.debugTests.isTrue().booleanValue()) {
                        System.out.println("Tautology unreachable: " + test);
                    }
                    throw new Unreachable();
                }
                case NotEqualToZero: {
                    if (!exprValue.isZero()) {
                        return true;
                    }
                    if (AnalysisProperties.INSTANCE.debugTests.isTrue().booleanValue()) {
                        System.out.println("Tautology unreachable: " + test);
                    }
                    throw new Unreachable();
                }
                case LessThanOrEqualToZero: {
                    if (!exprValue.isPositive()) {
                        return true;
                    }
                    if (AnalysisProperties.INSTANCE.debugTests.isTrue().booleanValue()) {
                        System.out.println("Tautology unreachable: " + test);
                    }
                    throw new Unreachable();
                }
            }
        }
        return false;
    }

    public static <D extends ZenoDomain<D>> boolean isAlwaysSatisfiable(Zeno.Test test, D state) {
        return ZenoTestHelper.satisfiabilityWithQuery(test, state);
    }

    private static <D extends ZenoDomain<D>> boolean satisfiabilityWithNegatedEval(Zeno.Test test, D state) {
        Zeno.Test opposingTest = test.not();
        try {
            state.eval(opposingTest);
        }
        catch (Unreachable _) {
            return true;
        }
        return false;
    }

    private static <D extends ZenoDomain<D>> boolean satisfiabilityWithEval(Zeno.Test test, D state) {
        try {
            D newState = state.eval(test);
            boolean redundant = state.subsetOrEqual(newState);
            return redundant;
        }
        catch (Unreachable _) {
            return false;
        }
    }

    private static <D extends ZenoDomain<D>> boolean satisfiabilityWithQuery(Zeno.Test test, D state) {
        Linear expr = test.getExpr();
        Interval exprValue = state.queryRange(expr).convexHull();
        switch (test.getOperator()) {
            case EqualToZero: {
                return exprValue.isEqualTo(Interval.ZERO);
            }
            case LessThanOrEqualToZero: {
                return exprValue.isLessThanZero() || exprValue.isEqualTo(Interval.ZERO);
            }
            case NotEqualToZero: {
                return !exprValue.isEqualTo(Interval.ZERO);
            }
        }
        throw new IllegalStateException();
    }

    public static AVLSet<Zeno.Test> negateTests(AVLSet<Zeno.Test> tests) {
        AVLSet<Zeno.Test> result = AVLSet.empty();
        for (Zeno.Test test : tests) {
            result = result.add(test.not());
        }
        return result;
    }

    public static boolean isSyntacticallyEntailedBy(Zeno.Test test, Zeno.Test byTest) {
        if (byTest.equals(test)) {
            return true;
        }
        Linear testLinear = test.getExpr();
        if (!testLinear.isSingleTerm()) {
            return false;
        }
        Linear byTestLinear = byTest.getExpr();
        if (!byTestLinear.isSingleTerm()) {
            return false;
        }
        if (!testLinear.dropConstant().equals(byTestLinear.dropConstant())) {
            return false;
        }
        BigInt testConstant = testLinear.getConstant().negate();
        BigInt byTestConstant = byTestLinear.getConstant().negate();
        switch (test.getOperator()) {
            case EqualToZero: {
                return false;
            }
            case NotEqualToZero: {
                if (ZenoTestHelper.isEqual(byTest.getOperator()) && !byTestConstant.isEqualTo(testConstant)) {
                    return true;
                }
                return ZenoTestHelper.isLessThanOrEqual(byTest.getOperator()) && byTestConstant.isLessThan(testConstant);
            }
            case LessThanOrEqualToZero: {
                if (ZenoTestHelper.isEqual(byTest.getOperator()) && byTestConstant.isLessThanOrEqualTo(testConstant)) {
                    return true;
                }
                return ZenoTestHelper.isLessThanOrEqual(byTest.getOperator()) && byTestConstant.isLessThanOrEqualTo(testConstant);
            }
        }
        return false;
    }

    private static boolean isEqual(Zeno.ZenoTestOp operator) {
        return operator.equals((Object)Zeno.ZenoTestOp.EqualToZero);
    }

    private static boolean isLessThanOrEqual(Zeno.ZenoTestOp operator) {
        return operator.equals((Object)Zeno.ZenoTestOp.LessThanOrEqualToZero);
    }
}

