/*
 * Decompiled with CFR 0.152.
 */
package apron;

import apron.Coeff;
import apron.Environment;
import apron.Linexpr1;
import apron.Linterm1;
import apron.Texpr0Node;
import apron.Texpr1BinNode;
import apron.Texpr1CstNode;
import apron.Texpr1VarNode;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;

public abstract class Texpr1Node
implements Cloneable,
Serializable {
    public static final int RTYPE_REAL = 0;
    public static final int RTYPE_INT = 1;
    public static final int RTYPE_SINGLE = 2;
    public static final int RTYPE_DOUBLE = 3;
    public static final int RTYPE_EXTENDED = 4;
    public static final int RTYPE_QUAD = 5;
    public static final int RDIR_NEAREST = 0;
    public static final int RDIR_ZERO = 1;
    public static final int RDIR_UP = 2;
    public static final int RDIR_DOWN = 3;
    public static final int RDIR_RND = 4;

    public abstract Texpr1Node shallowCopy();

    public abstract Texpr1Node deepCopy();

    protected Texpr1Node() {
    }

    public static Texpr1Node fromLinexpr1(Linexpr1 linexpr1) {
        Texpr1Node texpr1Node = null;
        Coeff coeff = linexpr1.getCst();
        if (!coeff.isZero()) {
            texpr1Node = new Texpr1CstNode(coeff.copy());
        }
        Linterm1[] linterm1Array = linexpr1.getLinterms();
        for (int i = 0; i < linterm1Array.length; ++i) {
            if (linterm1Array[i].coeff.isZero()) continue;
            Texpr1BinNode texpr1BinNode = new Texpr1BinNode(2, new Texpr1CstNode(linterm1Array[i].coeff.copy()), new Texpr1VarNode(linterm1Array[i].var));
            texpr1Node = texpr1Node == null ? texpr1BinNode : new Texpr1BinNode(0, texpr1Node, texpr1BinNode);
        }
        if (texpr1Node == null) {
            return new Texpr1CstNode();
        }
        return texpr1Node;
    }

    public abstract Texpr0Node toTexpr0Node(Environment var1);

    public abstract String toString();

    public abstract int getDepth();

    public abstract int getSize();

    public abstract boolean hasVar(String var1);

    protected abstract void fillVars(HashSet<String> var1);

    public String[] getVars() {
        HashSet<String> hashSet = new HashSet<String>();
        this.fillVars(hashSet);
        String[] stringArray = new String[hashSet.size()];
        Iterator<String> iterator = hashSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = iterator.next();
            ++n;
        }
        return stringArray;
    }

    public abstract boolean isIntervalCst();

    public abstract boolean isIntervalLinear();

    public abstract boolean isIntervalPolynomial();

    public abstract boolean isIntervalPolyfrac();

    public abstract boolean isScalar();

    public abstract Texpr1Node substitute(String var1, Texpr1Node var2);

    public Texpr1Node substituteCopy(String string, Texpr1Node texpr1Node) {
        Texpr1Node texpr1Node2 = this.deepCopy();
        return texpr1Node2.substitute(string, texpr1Node);
    }

    public abstract int hashCode();

    public abstract boolean isEqual(Texpr1Node var1);

    public abstract int getPrecedence();

    public abstract boolean equals(Object var1);

    public Texpr1Node clone() throws CloneNotSupportedException {
        return this.deepCopy();
    }
}

