/*
 * Decompiled with CFR 0.152.
 */
package apron;

import apron.Environment;
import apron.Linexpr1;
import apron.Texpr0Intern;
import apron.Texpr1Node;
import java.io.Serializable;

public class Texpr1Intern
implements Cloneable,
Serializable {
    protected Texpr0Intern expr;
    protected Environment env;

    private Texpr1Intern() {
    }

    public static Texpr1Intern make(Environment environment, Texpr0Intern texpr0Intern) {
        Texpr1Intern texpr1Intern = new Texpr1Intern();
        texpr1Intern.expr = texpr0Intern;
        texpr1Intern.env = environment;
        return texpr1Intern;
    }

    public Texpr1Intern(Environment environment, Texpr1Node texpr1Node) {
        this.expr = new Texpr0Intern(texpr1Node.toTexpr0Node(environment));
        this.env = environment;
    }

    public Texpr1Intern(Linexpr1 linexpr1) {
        this.expr = new Texpr0Intern(linexpr1.getLinexpr0Ref());
        this.env = linexpr1.getEnvironment();
    }

    public Texpr1Intern(Texpr1Intern texpr1Intern) {
        this.expr = new Texpr0Intern(texpr1Intern.expr);
        this.env = texpr1Intern.env;
    }

    public Texpr1Intern(Environment environment, Texpr0Intern texpr0Intern) {
        if (environment.getSize() < texpr0Intern.maxDim()) {
            throw new IllegalArgumentException("environment is too small");
        }
        this.expr = new Texpr0Intern(texpr0Intern);
        this.env = environment;
    }

    public Texpr1Node toTexpr1Node() {
        return this.expr.toTexpr0Node().toTexpr1Node(this.env);
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public Texpr0Intern getTexpr0Intern() {
        return new Texpr0Intern(this.expr);
    }

    public Texpr0Intern getTexpr0InternRef() {
        return this.expr;
    }

    public int getDepth() {
        return this.expr.getDepth();
    }

    public int getSize() {
        return this.expr.getSize();
    }

    public boolean hasVar(String string) {
        return this.env.hasVar(string) && this.expr.hasDim(this.env.dimOfVar(string));
    }

    public String[] getVars() {
        int[] nArray = this.expr.getDims();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = this.env.varOfDim(nArray[i]);
        }
        return stringArray;
    }

    public boolean isIntervalCst() {
        return this.expr.isIntervalCst();
    }

    public boolean isIntervalLinear() {
        return this.expr.isIntervalLinear();
    }

    public boolean isIntervalPolynomial() {
        return this.expr.isIntervalPolynomial();
    }

    public boolean isIntervalPolyfrac() {
        return this.expr.isIntervalPolyfrac();
    }

    public boolean isScalar() {
        return this.expr.isScalar();
    }

    public int hashCode() {
        return this.expr.hashCode() ^ this.env.hashCode();
    }

    public boolean isEqual(Texpr1Intern texpr1Intern) {
        return this.env.isEqual(texpr1Intern.env) && this.expr.isEqual(texpr1Intern.expr);
    }

    public String toString() {
        return this.expr.toString(this.env.getVars());
    }

    public void substitute(String string, Texpr1Intern texpr1Intern) {
        if (!this.env.isEqual(texpr1Intern.env)) {
            throw new IllegalArgumentException("incompatible environments");
        }
        this.expr.substitute(this.env.dimOfVar(string), texpr1Intern.expr);
    }

    public Texpr0Intern substituteCopy(String string, Texpr1Intern texpr1Intern) {
        if (!this.env.isEqual(texpr1Intern.env)) {
            throw new IllegalArgumentException("incompatible environments");
        }
        return this.expr.substituteCopy(this.env.dimOfVar(string), texpr1Intern.expr);
    }

    public void extendEnvironment(Environment environment) {
        this.expr.addDimensions(this.env.dimchange(environment));
        this.env = environment;
    }

    public Texpr1Intern extendEnvironmentCopy(Environment environment) {
        return Texpr1Intern.make(environment, this.expr.addDimensionsCopy(this.env.dimchange(environment)));
    }

    public Texpr1Intern clone() throws CloneNotSupportedException {
        return new Texpr1Intern(this);
    }

    public boolean equals(Object object) {
        return object instanceof Texpr1Intern && this.isEqual((Texpr1Intern)object);
    }
}

