/*
 * Decompiled with CFR 0.152.
 */
package apron;

import apron.MpfrScalar;
import apron.MpqScalar;
import apron.Scalar;
import gmp.Mpfr;
import gmp.Mpq;
import java.io.Serializable;

public class DoubleScalar
extends Scalar
implements Cloneable,
Serializable {
    public double val;

    public DoubleScalar() {
        this.val = 0.0;
    }

    public DoubleScalar(DoubleScalar doubleScalar) {
        this.val = doubleScalar.val;
    }

    public DoubleScalar(double d) {
        this.val = d;
    }

    @Override
    public DoubleScalar copy() {
        return new DoubleScalar(this);
    }

    public void set(DoubleScalar doubleScalar) {
        this.val = doubleScalar.val;
    }

    public void set(double d) {
        this.val = d;
    }

    @Override
    public void set(int n) {
        this.val = n;
    }

    @Override
    public void setInfty(int n) {
        this.val = n > 0 ? Double.POSITIVE_INFINITY : (n < 0 ? Double.NEGATIVE_INFINITY : 0.0);
    }

    public double get() {
        return this.val;
    }

    @Override
    public int toMpq(Mpq mpq, int n) {
        if (Double.isNaN(this.val)) {
            mpq.set(0);
            return 1;
        }
        if (this.val == Double.POSITIVE_INFINITY) {
            mpq.set(1, 0);
        } else if (this.val == Double.NEGATIVE_INFINITY) {
            mpq.set(-1, 0);
        } else {
            mpq.set(this.val);
        }
        return 0;
    }

    @Override
    public int toMpfr(Mpfr mpfr, int n) {
        return mpfr.set(this.val, n);
    }

    @Override
    public int toDouble(double[] dArray, int n) {
        dArray[0] = this.val;
        return 0;
    }

    @Override
    public String toString() {
        return Double.toString(this.val);
    }

    @Override
    public int hashCode() {
        return new Double(this.val).hashCode();
    }

    @Override
    public int isInfty() {
        if (Double.isInfinite(this.val)) {
            return this.val > 0.0 ? 1 : -1;
        }
        return 0;
    }

    @Override
    public boolean isZero() {
        return this.val == 0.0;
    }

    public int cmp(DoubleScalar doubleScalar) {
        return this.val == doubleScalar.val ? 0 : (this.val < doubleScalar.val ? -1 : 1);
    }

    @Override
    public int cmp(int n) {
        return this.val == (double)n ? 0 : (this.val < (double)n ? -1 : 1);
    }

    @Override
    public int cmp(Scalar scalar) {
        if (scalar instanceof DoubleScalar) {
            double d = ((DoubleScalar)scalar).val;
            return this.val == d ? 0 : (this.val < d ? -1 : 1);
        }
        if (scalar instanceof MpfrScalar) {
            Mpfr mpfr = ((MpfrScalar)scalar).val;
            return -mpfr.cmp(this.val);
        }
        if (scalar instanceof MpqScalar) {
            int n;
            int n2 = this.isInfty();
            if (n2 > (n = scalar.isInfty())) {
                return 1;
            }
            if (n2 < n) {
                return -1;
            }
            if (n2 != 0) {
                return 0;
            }
            Mpq mpq = new Mpq(this.val);
            return mpq.cmp(((MpqScalar)scalar).val);
        }
        throw new IllegalArgumentException("unknown Scalar subtype");
    }

    public boolean isEqual(DoubleScalar doubleScalar) {
        return this.val == doubleScalar.val;
    }

    @Override
    public boolean isEqual(int n) {
        return this.val == (double)n;
    }

    @Override
    public boolean isEqual(Scalar scalar) {
        if (scalar instanceof DoubleScalar) {
            return this.val == ((DoubleScalar)scalar).val;
        }
        if (scalar instanceof MpfrScalar) {
            Mpfr mpfr = ((MpfrScalar)scalar).val;
            return mpfr.cmp(this.val) == 0;
        }
        if (scalar instanceof MpqScalar) {
            int n;
            int n2 = this.isInfty();
            if (n2 != (n = scalar.isInfty())) {
                return false;
            }
            if (n2 != 0) {
                return true;
            }
            Mpq mpq = new Mpq(this.val);
            return mpq.isEqual(((MpqScalar)scalar).val);
        }
        throw new IllegalArgumentException("unknown Scalar subtype");
    }

    @Override
    public int sgn() {
        return this.val > 0.0 ? 1 : (this.val < 0.0 ? -1 : 0);
    }

    @Override
    public void neg() {
        this.val = -this.val;
    }

    @Override
    public void inv() {
        this.val = 1.0 / this.val;
    }

    public DoubleScalar clone() throws CloneNotSupportedException {
        return this.copy();
    }
}

