/*
 * Decompiled with CFR 0.152.
 */
package tree;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class SimpleTreeNode
implements TreeNode {
    protected TreeNode parent;
    protected Object data;
    protected List children = new LinkedList();
    protected Set marked = null;
    protected TreeModel model;

    public SimpleTreeNode(TreeModel model, TreeNode parent, Object data) {
        this.model = model;
        this.parent = parent;
        this.data = data;
    }

    public void setModel(TreeModel model) {
        this.model = model;
    }

    public SimpleTreeNode(TreeNode parent, Object data) {
        this.parent = parent;
        this.data = data;
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    public void add(final TreeNode node) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._add(node);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleTreeNode.this._add(node);
                }
            });
        }
    }

    public TreeNode findChild(Object o) {
        for (SimpleTreeNode node : this.children) {
            if (!o.equals(node.getData())) continue;
            return node;
        }
        System.err.println("Child not found: " + o + " vs. " + this.children);
        return null;
    }

    public Object getData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark() {
        SimpleTreeNode simpleTreeNode = this;
        synchronized (simpleTreeNode) {
            this.marked = new HashSet();
        }
    }

    public void reset() {
        if (SwingUtilities.isEventDispatchThread()) {
            this._reset();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleTreeNode.this._reset();
                }
            });
        }
    }

    public void _reset() {
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            Object node = i.next();
            if (this.marked.contains(node)) continue;
            i.remove();
        }
        if (this.model instanceof DefaultTreeModel) {
            ((DefaultTreeModel)this.model).nodeStructureChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _add(TreeNode node) {
        ListIterator<TreeNode> i = this.children.listIterator();
        String represent = node.toString().toLowerCase();
        while (i.hasNext()) {
            Object next = i.next();
            if (next.toString().toLowerCase().equals(represent)) {
                SimpleTreeNode simpleTreeNode = this;
                synchronized (simpleTreeNode) {
                    this.marked.add(next);
                }
                return;
            }
            if (represent.compareTo(next.toString().toLowerCase()) >= 0) continue;
            SimpleTreeNode simpleTreeNode = this;
            synchronized (simpleTreeNode) {
                i.add(node);
                this.marked.add(node);
            }
            return;
        }
        this.children.add(node);
        SimpleTreeNode simpleTreeNode = this;
        synchronized (simpleTreeNode) {
            this.marked.add(node);
        }
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int index) {
        return (TreeNode)this.children.get(index);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public String toString() {
        return this.data.toString();
    }
}

