/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.types;

import sleep.engine.Block;
import sleep.interfaces.Variable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;

public class LazyContainer {
    protected Block code;
    protected Variable localVariables;
    protected Variable closureVariables;
    protected ScriptEnvironment env;
    protected Scalar value;
    protected Class check;

    public LazyContainer(Block block, ScriptEnvironment scriptEnvironment, Class clazz) {
        this.code = block;
        this.env = scriptEnvironment;
        this.localVariables = scriptEnvironment.getScriptVariables().getLocalVariables();
        this.closureVariables = scriptEnvironment.getScriptVariables().getClosureVariables();
        this.check = clazz;
    }

    public boolean isResolved() {
        return this.value != null;
    }

    public Scalar resolveValue() {
        if (this.value == null) {
            this.env.CreateFrame();
            this.env.getScriptVariables().pushLocalLevel(this.localVariables);
            this.env.getScriptVariables().pushClosureLevel(this.closureVariables);
            this.value = this.code.evaluate(this.env);
            if (!this.env.getCurrentFrame().isEmpty()) {
                this.value = (Scalar)this.env.getCurrentFrame().pop();
            }
            this.env.getScriptVariables().popLocalLevel();
            this.env.getScriptVariables().popClosureLevel();
            this.env.KillFrame();
        }
        return this.value;
    }
}

