/*
 * Decompiled with CFR 0.152.
 */
package cortana.data;

import cortana.core.EventManager;
import cortana.core.FilterManager;
import cortana.data.DataUtils;
import cortana.data.Host;
import cortana.data.Hosts;
import cortana.data.ManagedData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import msf.RpcConnection;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;

public class Sessions
extends ManagedData {
    protected RpcConnection client;
    protected EventManager manager;
    protected Hosts hosts;
    protected Set nonsync = new HashSet();
    protected Map sessions = new HashMap();

    public Sessions(Hosts hosts, RpcConnection client, EventManager manager) {
        this.client = client;
        this.manager = manager;
        this.hosts = hosts;
    }

    public Map getSession(String id) {
        return (Map)this.sessions.get(id);
    }

    public Map getSessions() {
        return this.sessions;
    }

    @Override
    public Scalar getScalar() {
        if (this.cache == null) {
            this.cache = FilterManager.convertAll(this.getSessions());
        }
        return this.cache;
    }

    protected void fireSessionEvents(String name, Iterator sids, Map argumentData) {
        if (this.initial) {
            return;
        }
        while (sids.hasNext()) {
            String sid = sids.next() + "";
            Stack<Scalar> args = new Stack<Scalar>();
            args.push(FilterManager.convertAll((Map)argumentData.get(sid)));
            args.push(SleepUtils.getScalar(sid));
            this.manager.fireEventAsync(name, args);
        }
    }

    private static final void fixIPv6(Map data, String key) {
        if (!data.containsKey(key)) {
            return;
        }
        String value = data.get(key) + "";
        if (value.contains("%") && value.contains(":") && !value.startsWith("%")) {
            value = value.split("%")[0];
            data.put(key, value);
        }
    }

    public void processSessions(Map results) {
        if (this.hosts.isInitial()) {
            return;
        }
        this.cache = null;
        this.hosts.cache = null;
        this.sessions = results;
        HashSet before = new HashSet();
        HashSet after = new HashSet();
        HashMap dataz = new HashMap();
        HashSet<String> syncz = new HashSet<String>();
        for (Host host : this.hosts.getHosts().values()) {
            before.addAll(host.getSessions().keySet());
            dataz.putAll(host.getSessions());
            host.getSessions().clear();
        }
        after.addAll(results.keySet());
        dataz.putAll(results);
        for (Map.Entry temp : results.entrySet()) {
            String sid = temp.getKey() + "";
            Map session = (Map)temp.getValue();
            Sessions.fixIPv6(session, "session_host");
            Sessions.fixIPv6(session, "target_host");
            Sessions.fixIPv6(session, "tunnel_peer");
            String address = session.get("session_host") + "";
            if ("".equals(address)) {
                address = session.get("target_host") + "";
            }
            if ("".equals(address)) {
                address = ((String)session.get("tunnel_peer")).split(":")[0];
            }
            if (this.hosts.getHosts().containsKey(address)) {
                Host host = (Host)this.hosts.getHosts().get(address);
                host.getSessions().put(sid, session);
                session.put("host", address);
            } else {
                before.remove(sid);
                after.remove(sid);
            }
            if ("".equals(session.get("info"))) {
                this.nonsync.add(sid);
                continue;
            }
            syncz.add(sid);
        }
        Set newSessions = DataUtils.difference(after, before);
        this.fireSessionEvents("session_open", newSessions.iterator(), dataz);
        Set newsync = DataUtils.intersection(syncz, this.nonsync);
        this.fireSessionEvents("session_sync", newsync.iterator(), dataz);
        this.nonsync.removeAll(syncz);
        newSessions.removeAll(newsync);
        newSessions.retainAll(syncz);
        this.fireSessionEvents("session_sync", newSessions.iterator(), dataz);
        Set droppedSessions = DataUtils.difference(before, after);
        this.fireSessionEvents("session_close", droppedSessions.iterator(), dataz);
        Stack<Scalar> args = new Stack<Scalar>();
        args.push(FilterManager.convertAll(results));
        this.manager.fireEventAsync("sessions", args);
        this.initial = false;
    }
}

