import "pe"

rule RomeoHotel
{
	meta:
		copyright = "2015 Novetta Solutions"
		author = "Novetta Threat Research & Interdiction Group - trig@novetta.com"
		Source_64 = "440cb3f6dd07e2f9e3d3614fd23d3863ecfc08b463b0b327eedf08504f838c90"
		Source_diskSpace = "1b1496f8f35d32a93c7f16ebff6e9b560a158cc6fce061491f91bc9f43ef5be4"

	strings:
	/*
		E8 D3 C7 00 00  call    rand
		44 8B ED        mov     r13d, ebp
		44 8B E0        mov     r12d, eax
		B8 1F 85 EB 51  mov     eax, 51EB851Fh
		48 8B FD        mov     rdi, rbp
		41 F7 EC        imul    r12d
		C1 FA 05        sar     edx, 5
		8B CA           mov     ecx, edx
		C1 E9 1F        shr     ecx, 1Fh
		03 D1           add     edx, ecx
		6B D2 64        imul    edx, 64h
		44 2B E2        sub     r12d, edx
		41 83 C4 3C     add     r12d, 3Ch
	*/

	$randBuff64 = {E8 [4] 44 [2] 44 [2] B? 1F 85 EB 51 48 [2] 41 [2] C1 ?? 05 8B ?? C1 ?? 1F 03 ??	6B ?? 64 44 [2]	41 [2] 3C}
		
	/*
		FF 15 40 70 01 10     call    ds:GetDiskFreeSpaceExA
		85 C0                 test    eax, eax
		74 34                 jz      short loc_10005072
		8B 84 24 20 01 00 00  mov     eax, [esp+11Ch+arg_0]
		6A 00                 push    0
		99                    cdq
		68 00 00 10 00        push    100000h
		52                    push    edx
		50                    push    eax
		E8 4C 7C 00 00        call    __allmul
	*/

	$diskSpace = {FF 15 [4] 85 C0 74 ?? 8B [6] 6A 00 99 68 00 00 10 00 5? 5? E8}
		
	$winst = "winsta0\\default" wide		// this limits the overlap with RomeoGolf

	condition:
		$randBuff64 in ((pe.sections[pe.section_index(".text")].raw_data_offset)..(pe.sections[pe.section_index(".text")].raw_data_offset + pe.sections[pe.section_index(".text")].raw_data_size))
		or ($diskSpace in ((pe.sections[pe.section_index(".text")].raw_data_offset)..(pe.sections[pe.section_index(".text")].raw_data_offset + pe.sections[pe.section_index(".text")].raw_data_size))
		and $winst)
}
